"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_quicksight_1 = require("monocdk/aws-quicksight");
/**
 * Quicksight uses SSL when connecting to a data source
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_quicksight_1.CfnDataSource) {
        const sslProperties = monocdk_1.Stack.of(node).resolve(node.sslProperties);
        if (sslProperties != undefined) {
            const disableSsl = monocdk_1.Stack.of(node).resolve(sslProperties.disableSsl);
            if (disableSsl != undefined && disableSsl) {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUVMxLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0F3c1NvbHV0aW9ucy9ydWxlcy9hbmFseXRpY3MvUVMxLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7OztFQUdFO0FBQ0YscUNBQTRDO0FBQzVDLDJEQUF1RDtBQUV2RDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBZ0I7SUFDdkMsSUFBSSxJQUFJLFlBQVksOEJBQWEsRUFBRTtRQUNqQyxNQUFNLGFBQWEsR0FBRyxlQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDakUsSUFBSSxhQUFhLElBQUksU0FBUyxFQUFFO1lBQzlCLE1BQU0sVUFBVSxHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLGFBQWEsQ0FBQyxVQUFVLENBQUMsQ0FBQztZQUNwRSxJQUFJLFVBQVUsSUFBSSxTQUFTLElBQUksVUFBVSxFQUFFO2dCQUN6QyxPQUFPLEtBQUssQ0FBQzthQUNkO1NBQ0Y7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQVhELDRCQVdDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBJQ29uc3RydWN0LCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuRGF0YVNvdXJjZSB9IGZyb20gJ21vbm9jZGsvYXdzLXF1aWNrc2lnaHQnO1xuXG4vKipcbiAqIFF1aWNrc2lnaHQgdXNlcyBTU0wgd2hlbiBjb25uZWN0aW5nIHRvIGEgZGF0YSBzb3VyY2VcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogSUNvbnN0cnVjdCk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkRhdGFTb3VyY2UpIHtcbiAgICBjb25zdCBzc2xQcm9wZXJ0aWVzID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShub2RlLnNzbFByb3BlcnRpZXMpO1xuICAgIGlmIChzc2xQcm9wZXJ0aWVzICE9IHVuZGVmaW5lZCkge1xuICAgICAgY29uc3QgZGlzYWJsZVNzbCA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUoc3NsUHJvcGVydGllcy5kaXNhYmxlU3NsKTtcbiAgICAgIGlmIChkaXNhYmxlU3NsICE9IHVuZGVmaW5lZCAmJiBkaXNhYmxlU3NsKSB7XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgIH1cbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=