"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_msk_1 = require("monocdk/aws-msk");
/**
 * MSK clusters only uses TLS communication between clients and brokers
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_msk_1.CfnCluster) {
        const encryptionInfo = monocdk_1.Stack.of(node).resolve(node.encryptionInfo);
        if (encryptionInfo != undefined) {
            const encryptionInTransit = monocdk_1.Stack.of(node).resolve(encryptionInfo.encryptionInTransit);
            if (encryptionInTransit != undefined) {
                const clientBroker = monocdk_1.Stack.of(node).resolve(encryptionInTransit.clientBroker);
                if (clientBroker != undefined &&
                    clientBroker != aws_msk_1.ClientBrokerEncryption.TLS) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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