"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_athena_1 = require("monocdk/aws-athena");
/**
 * Athena workgroups encrypt query results
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_athena_1.CfnWorkGroup) {
        const workGroupConfiguration = monocdk_1.Stack.of(node).resolve(node.workGroupConfiguration);
        if (workGroupConfiguration == undefined) {
            const workGroupConfigurationUpdates = monocdk_1.Stack.of(node).resolve(node.workGroupConfigurationUpdates);
            if (workGroupConfigurationUpdates == undefined) {
                return false;
            }
            const resultConfigurationUpdates = monocdk_1.Stack.of(node).resolve(workGroupConfigurationUpdates.resultConfigurationUpdates);
            if (resultConfigurationUpdates != undefined) {
                const removeEncryptionConfiguration = monocdk_1.Stack.of(node).resolve(resultConfigurationUpdates.removeEncryptionConfiguration);
                const encryptionConfiguration = monocdk_1.Stack.of(node).resolve(resultConfigurationUpdates.encryptionConfiguration);
                const enforceWorkGroupConfiguration = monocdk_1.Stack.of(node).resolve(workGroupConfigurationUpdates.enforceWorkGroupConfiguration);
                if (removeEncryptionConfiguration &&
                    encryptionConfiguration == undefined) {
                    return false;
                }
                else if (encryptionConfiguration != undefined &&
                    !enforceWorkGroupConfiguration) {
                    return false;
                }
            }
        }
        else {
            const enforceWorkGroupConfiguration = monocdk_1.Stack.of(node).resolve(workGroupConfiguration.enforceWorkGroupConfiguration);
            if (!enforceWorkGroupConfiguration) {
                return false;
            }
            const resultConfiguration = monocdk_1.Stack.of(node).resolve(workGroupConfiguration.resultConfiguration);
            if (resultConfiguration == undefined) {
                return false;
            }
            const encryptionConfiguration = monocdk_1.Stack.of(node).resolve(resultConfiguration.encryptionConfiguration);
            if (encryptionConfiguration == undefined) {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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