"""
    WhyLabs API client

    WhyLabs API that enables end-to-end AI observability  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: support@whylabs.ai
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from whylabs_client.api_client import ApiClient, Endpoint as _Endpoint
from whylabs_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from whylabs_client.model.response import Response


class MonitorApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.delete_analyzer_endpoint = _Endpoint(
            settings={
                'response_type': (Response,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/monitor-config/analyzer/{analyzer_id}',
                'operation_id': 'delete_analyzer',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'analyzer_id',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'analyzer_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'analyzer_id':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                    'analyzer_id': 'analyzer_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'analyzer_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_monitor_endpoint = _Endpoint(
            settings={
                'response_type': (Response,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/monitor-config/monitor/{monitor_id}',
                'operation_id': 'delete_monitor',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'monitor_id',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'monitor_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'monitor_id':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                    'monitor_id': 'monitor_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'monitor_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_analyzer_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/monitor-config/analyzer/{analyzer_id}',
                'operation_id': 'get_analyzer',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'analyzer_id',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'analyzer_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'analyzer_id':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                    'analyzer_id': 'analyzer_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'analyzer_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_monitor_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/monitor-config/monitor/{monitor_id}',
                'operation_id': 'get_monitor',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'monitor_id',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'monitor_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'monitor_id':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                    'monitor_id': 'monitor_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'monitor_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_monitor_config_v3_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/monitor-config/v3',
                'operation_id': 'get_monitor_config_v3',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'include_entity_schema',
                    'include_entity_weights',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                ],
                'nullable': [
                    'include_entity_schema',
                    'include_entity_weights',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'include_entity_schema':
                        (bool, none_type,),
                    'include_entity_weights':
                        (bool, none_type,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                    'include_entity_schema': 'include_entity_schema',
                    'include_entity_weights': 'include_entity_weights',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'include_entity_schema': 'query',
                    'include_entity_weights': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.patch_monitor_config_v3_endpoint = _Endpoint(
            settings={
                'response_type': (Response,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/monitor-config/v3',
                'operation_id': 'patch_monitor_config_v3',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'body',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.put_analyzer_endpoint = _Endpoint(
            settings={
                'response_type': (Response,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/monitor-config/analyzer/{analyzer_id}',
                'operation_id': 'put_analyzer',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'analyzer_id',
                    'body',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'analyzer_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'analyzer_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                    'analyzer_id': 'analyzer_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'analyzer_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.put_monitor_endpoint = _Endpoint(
            settings={
                'response_type': (Response,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/monitor-config/monitor/{monitor_id}',
                'operation_id': 'put_monitor',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'monitor_id',
                    'body',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'monitor_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'monitor_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                    'monitor_id': 'monitor_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'monitor_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.put_monitor_config_v3_endpoint = _Endpoint(
            settings={
                'response_type': (Response,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/monitor-config/v3',
                'operation_id': 'put_monitor_config_v3',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'body',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.validate_monitor_config_v3_endpoint = _Endpoint(
            settings={
                'response_type': (Response,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/monitor-config/v3/validate',
                'operation_id': 'validate_monitor_config_v3',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'body',
                    'verbose',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'body',
                ],
                'nullable': [
                    'verbose',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'body':
                        (str,),
                    'verbose':
                        (bool, none_type,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                    'verbose': 'verbose',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'body': 'body',
                    'verbose': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def delete_analyzer(
        self,
        org_id,
        dataset_id,
        analyzer_id,
        **kwargs
    ):
        """Delete the analyzer config for a given dataset.  # noqa: E501

        Delete the analyzer config for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_analyzer(org_id, dataset_id, analyzer_id, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            analyzer_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['analyzer_id'] = \
            analyzer_id
        return self.delete_analyzer_endpoint.call_with_http_info(**kwargs)

    def delete_monitor(
        self,
        org_id,
        dataset_id,
        monitor_id,
        **kwargs
    ):
        """Delete the monitor for a given dataset.  # noqa: E501

        Delete the monitor for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_monitor(org_id, dataset_id, monitor_id, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            monitor_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['monitor_id'] = \
            monitor_id
        return self.delete_monitor_endpoint.call_with_http_info(**kwargs)

    def get_analyzer(
        self,
        org_id,
        dataset_id,
        analyzer_id,
        **kwargs
    ):
        """Get the analyzer config for a given dataset.  # noqa: E501

        Get the analyzer config for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_analyzer(org_id, dataset_id, analyzer_id, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            analyzer_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['analyzer_id'] = \
            analyzer_id
        return self.get_analyzer_endpoint.call_with_http_info(**kwargs)

    def get_monitor(
        self,
        org_id,
        dataset_id,
        monitor_id,
        **kwargs
    ):
        """Get the monitor config for a given dataset.  # noqa: E501

        Get the monitor config for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_monitor(org_id, dataset_id, monitor_id, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            monitor_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['monitor_id'] = \
            monitor_id
        return self.get_monitor_endpoint.call_with_http_info(**kwargs)

    def get_monitor_config_v3(
        self,
        org_id,
        dataset_id,
        **kwargs
    ):
        """Get the monitor config document for a given dataset.  # noqa: E501

        Get the monitor config document for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_monitor_config_v3(org_id, dataset_id, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):

        Keyword Args:
            include_entity_schema (bool, none_type): [optional]
            include_entity_weights (bool, none_type): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        return self.get_monitor_config_v3_endpoint.call_with_http_info(**kwargs)

    def patch_monitor_config_v3(
        self,
        org_id,
        dataset_id,
        body,
        **kwargs
    ):
        """Patch an updated monitor config document for a given dataset.  # noqa: E501

        Save an updated monitor config document for a given dataset.  Monitors and analyzers matching an existing ID are replaced.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_monitor_config_v3(org_id, dataset_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            body (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['body'] = \
            body
        return self.patch_monitor_config_v3_endpoint.call_with_http_info(**kwargs)

    def put_analyzer(
        self,
        org_id,
        dataset_id,
        analyzer_id,
        body,
        **kwargs
    ):
        """Save the analyzer config for a given dataset.  # noqa: E501

        Save the analyzer config for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_analyzer(org_id, dataset_id, analyzer_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            analyzer_id (str):
            body (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['analyzer_id'] = \
            analyzer_id
        kwargs['body'] = \
            body
        return self.put_analyzer_endpoint.call_with_http_info(**kwargs)

    def put_monitor(
        self,
        org_id,
        dataset_id,
        monitor_id,
        body,
        **kwargs
    ):
        """Save the monitor for a given dataset.  # noqa: E501

        Save the monitor for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_monitor(org_id, dataset_id, monitor_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            monitor_id (str):
            body (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['monitor_id'] = \
            monitor_id
        kwargs['body'] = \
            body
        return self.put_monitor_endpoint.call_with_http_info(**kwargs)

    def put_monitor_config_v3(
        self,
        org_id,
        dataset_id,
        body,
        **kwargs
    ):
        """Save the monitor config document for a given dataset.  # noqa: E501

        Save the monitor config document for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_monitor_config_v3(org_id, dataset_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            body (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['body'] = \
            body
        return self.put_monitor_config_v3_endpoint.call_with_http_info(**kwargs)

    def validate_monitor_config_v3(
        self,
        org_id,
        dataset_id,
        body,
        **kwargs
    ):
        """Validate the monitor config document for a given dataset.  # noqa: E501

        Validate the monitor config document for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.validate_monitor_config_v3(org_id, dataset_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            body (str):

        Keyword Args:
            verbose (bool, none_type): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['body'] = \
            body
        return self.validate_monitor_config_v3_endpoint.call_with_http_info(**kwargs)

