"""
    WhyLabs API client

    WhyLabs API that enables end-to-end AI observability  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: support@whylabs.ai
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from whylabs_client.api_client import ApiClient, Endpoint as _Endpoint
from whylabs_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from whylabs_client.model.async_log_response import AsyncLogResponse
from whylabs_client.model.log_async_request import LogAsyncRequest
from whylabs_client.model.log_reference_request import LogReferenceRequest
from whylabs_client.model.log_reference_response import LogReferenceResponse


class LogApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.log_async_endpoint = _Endpoint(
            settings={
                'response_type': (AsyncLogResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/log/async/{dataset_id}',
                'operation_id': 'log_async',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'log_async_request',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'log_async_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'log_async_request':
                        (LogAsyncRequest,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'log_async_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.log_reference_endpoint = _Endpoint(
            settings={
                'response_type': (LogReferenceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/log/reference/{model_id}',
                'operation_id': 'log_reference',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'model_id',
                    'log_reference_request',
                ],
                'required': [
                    'org_id',
                    'model_id',
                    'log_reference_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'model_id':
                        (str,),
                    'log_reference_request':
                        (LogReferenceRequest,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'model_id': 'model_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'model_id': 'path',
                    'log_reference_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def log_async(
        self,
        org_id,
        dataset_id,
        log_async_request,
        **kwargs
    ):
        """Like /log, except this api doesn't take the actual profile content. It returns an upload link that can be used to upload the profile to.  # noqa: E501

        Like /log, except this api doesn't take the actual profile content. It returns an upload link that can be used to upload the profile to.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.log_async(org_id, dataset_id, log_async_request, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            log_async_request (LogAsyncRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AsyncLogResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['log_async_request'] = \
            log_async_request
        return self.log_async_endpoint.call_with_http_info(**kwargs)

    def log_reference(
        self,
        org_id,
        model_id,
        log_reference_request,
        **kwargs
    ):
        """Returns a presigned URL for uploading the reference profile to.  # noqa: E501

        Reference profiles can be used for.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.log_reference(org_id, model_id, log_reference_request, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            model_id (str):
            log_reference_request (LogReferenceRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            LogReferenceResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['model_id'] = \
            model_id
        kwargs['log_reference_request'] = \
            log_reference_request
        return self.log_reference_endpoint.call_with_http_info(**kwargs)

