# whylabs-client
WhyLabs API that enables end-to-end AI observability

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1
- Package version: 0.4.4
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://whylabs.ai](https://whylabs.ai)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import whylabs_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import whylabs_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import whylabs_client
from pprint import pprint
from whylabs_client.api import dataset_profile_api
from whylabs_client.model.delete_analyzer_results_response import DeleteAnalyzerResultsResponse
from whylabs_client.model.delete_dataset_profiles_response import DeleteDatasetProfilesResponse
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = whylabs_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with whylabs_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = dataset_profile_api.DatasetProfileApi(api_client)
    org_id = "org-123" # str | Your company's unique organization ID
dataset_id = "model-123" # str | The unique dataset ID in your company.
start_timestamp = 1577836800000 # int, none_type | Optional, scope deleting analyzer results more recent than the timestamp (optional)
end_timestamp = 1893456000000 # int, none_type | Optional, scope deleting analyzer results older than the timestamp (optional)

    try:
        # Deletes a set of analyzer results
        api_response = api_instance.delete_analyzer_results(org_id, dataset_id, start_timestamp=start_timestamp, end_timestamp=end_timestamp)
        pprint(api_response)
    except whylabs_client.ApiException as e:
        print("Exception when calling DatasetProfileApi->delete_analyzer_results: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DatasetProfileApi* | [**delete_analyzer_results**](docs/DatasetProfileApi.md#delete_analyzer_results) | **DELETE** /v0/organizations/{org_id}/dataset-profiles/models/{dataset_id}/analyzer-results | Deletes a set of analyzer results
*DatasetProfileApi* | [**delete_dataset_profiles**](docs/DatasetProfileApi.md#delete_dataset_profiles) | **DELETE** /v0/organizations/{org_id}/dataset-profiles/models/{dataset_id} | Deletes a set of dataset profiles
*DatasetMetadataApi* | [**delete_dataset_metadata**](docs/DatasetMetadataApi.md#delete_dataset_metadata) | **DELETE** /v0/organizations/{org_id}/dataset/{dataset_id}/metadata | Delete dataset metadata for the specified dataset
*DatasetMetadataApi* | [**get_dataset_metadata**](docs/DatasetMetadataApi.md#get_dataset_metadata) | **GET** /v0/organizations/{org_id}/dataset/{dataset_id}/metadata | Get dataset metadata for the specified dataset
*DatasetMetadataApi* | [**put_dataset_metadata**](docs/DatasetMetadataApi.md#put_dataset_metadata) | **PUT** /v0/organizations/{org_id}/dataset/{dataset_id}/metadata | Put dataset metadata for the specified dataset
*FeatureWeightsApi* | [**get_column_weights**](docs/FeatureWeightsApi.md#get_column_weights) | **GET** /v0/organizations/{org_id}/dataset/{dataset_id}/weights | Get column weights for the specified dataset
*FeatureWeightsApi* | [**put_column_weights**](docs/FeatureWeightsApi.md#put_column_weights) | **PUT** /v0/organizations/{org_id}/dataset/{dataset_id}/weights | Put column weights for the specified dataset
*LogApi* | [**log_async**](docs/LogApi.md#log_async) | **POST** /v0/organizations/{org_id}/log/async/{dataset_id} | Like /log, except this api doesn&#39;t take the actual profile content. It returns an upload link that can be used to upload the profile to.
*LogApi* | [**log_reference**](docs/LogApi.md#log_reference) | **POST** /v0/organizations/{org_id}/log/reference/{model_id} | Returns a presigned URL for uploading the reference profile to.
*MembershipApi* | [**create_organization_membership**](docs/MembershipApi.md#create_organization_membership) | **POST** /v0/organizations/{org_id}/membership | Create a membership for a user, making them apart of an organization. Uses the user&#39;s current email address.
*MembershipApi* | [**list_organization_memberships**](docs/MembershipApi.md#list_organization_memberships) | **GET** /v0/organizations/{org_id}/membership | List organization memberships
*MembershipApi* | [**remove_organization_membership**](docs/MembershipApi.md#remove_organization_membership) | **DELETE** /v0/organizations/{org_id}/membership | Removes membership in a given org from a user, using the user&#39;s email address.
*MembershipApi* | [**update_organization_membership**](docs/MembershipApi.md#update_organization_membership) | **PUT** /v0/organizations/{org_id}/membership | Updates the role in an membership
*ModelsApi* | [**create_model**](docs/ModelsApi.md#create_model) | **POST** /v0/organizations/{org_id}/models | Create a model with a given name and a time period
*ModelsApi* | [**deactivate_model**](docs/ModelsApi.md#deactivate_model) | **DELETE** /v0/organizations/{org_id}/models/{model_id} | Mark a model as inactive
*ModelsApi* | [**delete_entity_schema_column**](docs/ModelsApi.md#delete_entity_schema_column) | **DELETE** /v0/organizations/{org_id}/models/{dataset_id}/schema/column/{column_id} | Delete the entity schema of a single column for a given dataset.
*ModelsApi* | [**get_entity_schema**](docs/ModelsApi.md#get_entity_schema) | **GET** /v0/organizations/{org_id}/models/{dataset_id}/schema | Get the entity schema config for a given dataset.
*ModelsApi* | [**get_entity_schema_column**](docs/ModelsApi.md#get_entity_schema_column) | **GET** /v0/organizations/{org_id}/models/{dataset_id}/schema/column/{column_id} | Get the entity schema of a single column for a given dataset.
*ModelsApi* | [**get_model**](docs/ModelsApi.md#get_model) | **GET** /v0/organizations/{org_id}/models/{model_id} | Get a model metadata
*ModelsApi* | [**list_models**](docs/ModelsApi.md#list_models) | **GET** /v0/organizations/{org_id}/models | Get a list of all of the model ids for an organization.
*ModelsApi* | [**put_entity_schema**](docs/ModelsApi.md#put_entity_schema) | **PUT** /v0/organizations/{org_id}/models/{dataset_id}/schema | Save the entity schema config for a given dataset.
*ModelsApi* | [**put_entity_schema_column**](docs/ModelsApi.md#put_entity_schema_column) | **PUT** /v0/organizations/{org_id}/models/{dataset_id}/schema/column/{column_id} | Save the entity schema of a single column for a given dataset.
*ModelsApi* | [**update_model**](docs/ModelsApi.md#update_model) | **PUT** /v0/organizations/{org_id}/models/{model_id} | Update a model&#39;s metadata
*MonitorApi* | [**delete_analyzer**](docs/MonitorApi.md#delete_analyzer) | **DELETE** /v0/organizations/{org_id}/models/{dataset_id}/monitor-config/analyzer/{analyzer_id} | Delete the analyzer config for a given dataset.
*MonitorApi* | [**delete_monitor**](docs/MonitorApi.md#delete_monitor) | **DELETE** /v0/organizations/{org_id}/models/{dataset_id}/monitor-config/monitor/{monitor_id} | Delete the monitor for a given dataset.
*MonitorApi* | [**get_analyzer**](docs/MonitorApi.md#get_analyzer) | **GET** /v0/organizations/{org_id}/models/{dataset_id}/monitor-config/analyzer/{analyzer_id} | Get the analyzer config for a given dataset.
*MonitorApi* | [**get_monitor**](docs/MonitorApi.md#get_monitor) | **GET** /v0/organizations/{org_id}/models/{dataset_id}/monitor-config/monitor/{monitor_id} | Get the monitor config for a given dataset.
*MonitorApi* | [**get_monitor_config_v3**](docs/MonitorApi.md#get_monitor_config_v3) | **GET** /v0/organizations/{org_id}/models/{dataset_id}/monitor-config/v3 | Get the monitor config document for a given dataset.
*MonitorApi* | [**patch_monitor_config_v3**](docs/MonitorApi.md#patch_monitor_config_v3) | **PATCH** /v0/organizations/{org_id}/models/{dataset_id}/monitor-config/v3 | Patch an updated monitor config document for a given dataset.
*MonitorApi* | [**put_analyzer**](docs/MonitorApi.md#put_analyzer) | **PUT** /v0/organizations/{org_id}/models/{dataset_id}/monitor-config/analyzer/{analyzer_id} | Save the analyzer config for a given dataset.
*MonitorApi* | [**put_monitor**](docs/MonitorApi.md#put_monitor) | **PUT** /v0/organizations/{org_id}/models/{dataset_id}/monitor-config/monitor/{monitor_id} | Save the monitor for a given dataset.
*MonitorApi* | [**put_monitor_config_v3**](docs/MonitorApi.md#put_monitor_config_v3) | **PUT** /v0/organizations/{org_id}/models/{dataset_id}/monitor-config/v3 | Save the monitor config document for a given dataset.
*MonitorApi* | [**validate_monitor_config_v3**](docs/MonitorApi.md#validate_monitor_config_v3) | **PUT** /v0/organizations/{org_id}/models/{dataset_id}/monitor-config/v3/validate | Validate the monitor config document for a given dataset.
*NotificationSettingsApi* | [**delete_notification_action**](docs/NotificationSettingsApi.md#delete_notification_action) | **DELETE** /v0/notification-settings/{org_id}/actions/{action_id} | Delete notification action
*NotificationSettingsApi* | [**get_email_notification_action_payload**](docs/NotificationSettingsApi.md#get_email_notification_action_payload) | **GET** /v0/notification-settings/actions/email/payload | Get dummy notification action payload
*NotificationSettingsApi* | [**get_notification_action**](docs/NotificationSettingsApi.md#get_notification_action) | **GET** /v0/notification-settings/{org_id}/actions/{action_id} | Get notification action for id
*NotificationSettingsApi* | [**get_pager_duty_notification_action_payload**](docs/NotificationSettingsApi.md#get_pager_duty_notification_action_payload) | **GET** /v0/notification-settings/actions/pagerduty/payload | Get dummy notification action payload
*NotificationSettingsApi* | [**get_slack_notification_action_payload**](docs/NotificationSettingsApi.md#get_slack_notification_action_payload) | **GET** /v0/notification-settings/actions/slack/payload | Get dummy notification action payload
*NotificationSettingsApi* | [**list_notification_actions**](docs/NotificationSettingsApi.md#list_notification_actions) | **GET** /v0/notification-settings/{org_id}/actions | List notification actions for an org
*NotificationSettingsApi* | [**put_notification_action**](docs/NotificationSettingsApi.md#put_notification_action) | **PUT** /v0/notification-settings/{org_id}/actions/{type}/{action_id} | Add new notification action
*NotificationSettingsApi* | [**test_notification_action**](docs/NotificationSettingsApi.md#test_notification_action) | **POST** /v0/notification-settings/{org_id}/actions/{action_id}/test | Test a notification action
*NotificationSettingsApi* | [**update_notification_action**](docs/NotificationSettingsApi.md#update_notification_action) | **PATCH** /v0/notification-settings/{org_id}/actions/{type}/{action_id} | Update notification action
*SchemaApi* | [**get_monitor_config_schema**](docs/SchemaApi.md#get_monitor_config_schema) | **GET** /v0/organizations/{org_id}/schema/monitor-config | Get the current supported schema of the monitor configuration
*SessionsApi* | [**create_dataset_profile_upload**](docs/SessionsApi.md#create_dataset_profile_upload) | **POST** /v0/sessions/{session_id}/upload | Create an upload for a given session.
*SessionsApi* | [**create_session**](docs/SessionsApi.md#create_session) | **POST** /v0/sessions | Create a new session that can be used to upload dataset profiles from whylogs for display in whylabs.
*SessionsApi* | [**get_session**](docs/SessionsApi.md#get_session) | **GET** /v0/sessions/{session_id} | Get information about a session.


## Documentation For Models

 - [AWSMarketplaceMetadata](docs/AWSMarketplaceMetadata.md)
 - [ActionType](docs/ActionType.md)
 - [AddMembershipRequest](docs/AddMembershipRequest.md)
 - [AsyncLogResponse](docs/AsyncLogResponse.md)
 - [ColumnSchema](docs/ColumnSchema.md)
 - [CreateSessionRequest](docs/CreateSessionRequest.md)
 - [CreateSessionResponse](docs/CreateSessionResponse.md)
 - [CreateUserRequest](docs/CreateUserRequest.md)
 - [DTOAutoScaleDTO](docs/DTOAutoScaleDTO.md)
 - [DTOAwsAttributesDTO](docs/DTOAwsAttributesDTO.md)
 - [DTOAwsAvailabilityDTO](docs/DTOAwsAvailabilityDTO.md)
 - [DTOClusterLogConfDTO](docs/DTOClusterLogConfDTO.md)
 - [DTOCronScheduleDTO](docs/DTOCronScheduleDTO.md)
 - [DTODbfsStorageInfoDTO](docs/DTODbfsStorageInfoDTO.md)
 - [DTOEbsVolumeTypeDTO](docs/DTOEbsVolumeTypeDTO.md)
 - [DTOJobDTO](docs/DTOJobDTO.md)
 - [DTOJobEmailNotificationsDTO](docs/DTOJobEmailNotificationsDTO.md)
 - [DTOJobSettingsDTO](docs/DTOJobSettingsDTO.md)
 - [DTONewClusterDTO](docs/DTONewClusterDTO.md)
 - [DTONotebookTaskDTO](docs/DTONotebookTaskDTO.md)
 - [DTOS3StorageInfoDTO](docs/DTOS3StorageInfoDTO.md)
 - [DTOSparkJarTaskDTO](docs/DTOSparkJarTaskDTO.md)
 - [DTOSparkPythonTaskDTO](docs/DTOSparkPythonTaskDTO.md)
 - [DTOSparkSubmitTaskDTO](docs/DTOSparkSubmitTaskDTO.md)
 - [DatabricksConnection](docs/DatabricksConnection.md)
 - [DatasetRequestMonitorConfig](docs/DatasetRequestMonitorConfig.md)
 - [DatatypeMonitorRequestConfig](docs/DatatypeMonitorRequestConfig.md)
 - [DeleteAnalyzerResultsResponse](docs/DeleteAnalyzerResultsResponse.md)
 - [DeleteDatasetProfilesResponse](docs/DeleteDatasetProfilesResponse.md)
 - [DistributionMonitorRequestConfig](docs/DistributionMonitorRequestConfig.md)
 - [EmailNotificationAction](docs/EmailNotificationAction.md)
 - [EntitySchema](docs/EntitySchema.md)
 - [EntityWeightRecord](docs/EntityWeightRecord.md)
 - [EntityWeightRecordMetadata](docs/EntityWeightRecordMetadata.md)
 - [FeatureFlags](docs/FeatureFlags.md)
 - [GetConnectionRequest](docs/GetConnectionRequest.md)
 - [GetConnectionResponse](docs/GetConnectionResponse.md)
 - [GetDatasetMetadataResponse](docs/GetDatasetMetadataResponse.md)
 - [GetDefaultMembershipResponse](docs/GetDefaultMembershipResponse.md)
 - [GetMarketplaceMetadataResponse](docs/GetMarketplaceMetadataResponse.md)
 - [GetMembershipsResponse](docs/GetMembershipsResponse.md)
 - [GetMonitorConfigV2Response](docs/GetMonitorConfigV2Response.md)
 - [GetNotificationSettingsResponse](docs/GetNotificationSettingsResponse.md)
 - [GetSessionResponse](docs/GetSessionResponse.md)
 - [ListJobsRequest](docs/ListJobsRequest.md)
 - [ListJobsResponse](docs/ListJobsResponse.md)
 - [ListModelsResponse](docs/ListModelsResponse.md)
 - [ListOrganizationMembershipsResponse](docs/ListOrganizationMembershipsResponse.md)
 - [ListUserApiKeys](docs/ListUserApiKeys.md)
 - [LogAsyncRequest](docs/LogAsyncRequest.md)
 - [LogReferenceRequest](docs/LogReferenceRequest.md)
 - [LogReferenceResponse](docs/LogReferenceResponse.md)
 - [LogResponse](docs/LogResponse.md)
 - [MarketplaceDimensions](docs/MarketplaceDimensions.md)
 - [Membership](docs/Membership.md)
 - [MembershipMetadata](docs/MembershipMetadata.md)
 - [MissingRecentDataRequestConfig](docs/MissingRecentDataRequestConfig.md)
 - [MissingRecentProfilesRequestConfig](docs/MissingRecentProfilesRequestConfig.md)
 - [MissingValuesMonitorRequestConfig](docs/MissingValuesMonitorRequestConfig.md)
 - [ModelMetadataResponse](docs/ModelMetadataResponse.md)
 - [ModelType](docs/ModelType.md)
 - [MonitorConfig](docs/MonitorConfig.md)
 - [MonitorConfigVersion](docs/MonitorConfigVersion.md)
 - [MonitorRequestReference](docs/MonitorRequestReference.md)
 - [MonitorRequestReferenceType](docs/MonitorRequestReferenceType.md)
 - [NotificationAction](docs/NotificationAction.md)
 - [NotificationSettings](docs/NotificationSettings.md)
 - [NotificationSettingsDay](docs/NotificationSettingsDay.md)
 - [NotificationSqsMessageCadence](docs/NotificationSqsMessageCadence.md)
 - [OrganizationMetadata](docs/OrganizationMetadata.md)
 - [OrganizationSummary](docs/OrganizationSummary.md)
 - [PagerDutyNotificationAction](docs/PagerDutyNotificationAction.md)
 - [ProvidedConfig](docs/ProvidedConfig.md)
 - [ProvisionDatabricksConnectionRequest](docs/ProvisionDatabricksConnectionRequest.md)
 - [ProvisionDatabricksConnectionResponse](docs/ProvisionDatabricksConnectionResponse.md)
 - [ProvisionNewAWSMarketplaceUserResponse](docs/ProvisionNewAWSMarketplaceUserResponse.md)
 - [ProvisionNewMarketplaceUserRequest](docs/ProvisionNewMarketplaceUserRequest.md)
 - [ProvisionNewUserRequest](docs/ProvisionNewUserRequest.md)
 - [ProvisionNewUserResponse](docs/ProvisionNewUserResponse.md)
 - [ReferenceProfileItemResponse](docs/ReferenceProfileItemResponse.md)
 - [RefreshAccessTokenRequest](docs/RefreshAccessTokenRequest.md)
 - [RefreshConnectionByOrgIdResponse](docs/RefreshConnectionByOrgIdResponse.md)
 - [RefreshConnectionRequest](docs/RefreshConnectionRequest.md)
 - [RegisterDatabricksConnectionRequest](docs/RegisterDatabricksConnectionRequest.md)
 - [RegisterDatabricksConnectionResponse](docs/RegisterDatabricksConnectionResponse.md)
 - [RemoveMembershipRequest](docs/RemoveMembershipRequest.md)
 - [RequestFeatureMonitorConfig](docs/RequestFeatureMonitorConfig.md)
 - [RequestMonitorConfig](docs/RequestMonitorConfig.md)
 - [Response](docs/Response.md)
 - [Role](docs/Role.md)
 - [RunJobRequest](docs/RunJobRequest.md)
 - [RunJobResponse](docs/RunJobResponse.md)
 - [SchemaMetadata](docs/SchemaMetadata.md)
 - [SeasonalARIMARequestConfig](docs/SeasonalARIMARequestConfig.md)
 - [Segment](docs/Segment.md)
 - [SegmentTag](docs/SegmentTag.md)
 - [SegmentWeight](docs/SegmentWeight.md)
 - [SessionMetadata](docs/SessionMetadata.md)
 - [SetDefaultMembershipRequest](docs/SetDefaultMembershipRequest.md)
 - [SlackNotificationAction](docs/SlackNotificationAction.md)
 - [SubscriptionTier](docs/SubscriptionTier.md)
 - [TimePeriod](docs/TimePeriod.md)
 - [UberNotificationSchedule](docs/UberNotificationSchedule.md)
 - [UniqueValuesMonitorRequestConfig](docs/UniqueValuesMonitorRequestConfig.md)
 - [UpdateConnectionChanges](docs/UpdateConnectionChanges.md)
 - [UpdateConnectionRequest](docs/UpdateConnectionRequest.md)
 - [UpdateMembershipRequest](docs/UpdateMembershipRequest.md)
 - [User](docs/User.md)
 - [UserApiKey](docs/UserApiKey.md)
 - [UserApiKeyResponse](docs/UserApiKeyResponse.md)
 - [WhyLogsMetric](docs/WhyLogsMetric.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: X-API-Key
- **Location**: HTTP header


## Author

support@whylabs.ai


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in whylabs_client.apis and whylabs_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from whylabs_client.api.default_api import DefaultApi`
- `from whylabs_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import whylabs_client
from whylabs_client.apis import *
from whylabs_client.models import *
```

