from ctypes import c_int

HttpHeader = c_int

# Authentication
HTTP_HEADER_AUTHENTICATE = 0
HTTP_HEADER_AUTHORIZATION = 1
HTTP_HEADER_PROXY_AUTHENTICATE = 2
HTTP_HEADER_PROXY_AUTHORIZATION = 3

# Caching
HTTP_HEADER_AGE = 4
HTTP_HEADER_CACHE_CONTROL = 5
HTTP_HEADER_CLEAR_SITE_DATA = 6
HTTP_HEADER_EXPIRES = 7
HTTP_HEADER_WARNING = 8

# Connection management
HTTP_HEADER_CONNECTION = 9
HTTP_HEADER_KEEP_ALIVE = 10

# Content negotiation
HTTP_HEADER_ACCEPT = 11
HTTP_HEADER_ACCEPT_CHARSET = 12
HTTP_HEADER_ACCEPT_ENCODING = 13
HTTP_HEADER_ACCEPT_LANGUAGE = 14

# Controls
HTTP_HEADER_EXPECT = 15

# Cookies
HTTP_HEADER_COOKIE = 16
HTTP_HEADER_SET_COOKIE = 17

# CORS
HTTP_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN = 18
HTTP_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS = 19
HTTP_HEADER_ACCESS_CONTROL_ALLOW_HEADERS = 20
HTTP_HEADER_ACCESS_CONTROL_ALLOW_METHODS = 21
HTTP_HEADER_ACCESS_CONTROL_EXPOSE_HEADER = 22
HTTP_HEADER_ACCESS_CONTROL_MAX_AGE = 23
HTTP_HEADER_ACCESS_CONTROL_REQUEST_HEADERS = 24
HTTP_HEADER_ACCESS_CONTROL_REQUEST_METHOD = 25
HTTP_HEADER_ORIGIN = 26
HTTP_HEADER_TIMING_ALLOW_ORIGIN = 27

# Downloads
HTTP_HEADER_CONTENT_DISPOSITION = 28

# Message body information
HTTP_HEADER_CONTENT_LENGTH = 29
HTTP_HEADER_CONTENT_TYPE = 30
HTTP_HEADER_CONTENT_ENCODING = 31
HTTP_HEADER_CONTENT_LANGUAGE = 32
HTTP_HEADER_CONTENT_LOCATION = 33

# Proxies
HTTP_HEADER_FORWARDED = 34
HTTP_HEADER_VIA = 35

# Redirects
HTTP_HEADER_LOCATION = 36

# Request context
HTTP_HEADER_FROM = 37
HTTP_HEADER_HOST = 38
HTTP_HEADER_REFERER = 39
HTTP_HEADER_REFERRER_POLICY = 40
HTTP_HEADER_USER_AGENT = 41

# Response context
HTTP_HEADER_ALLOW = 42
HTTP_HEADER_SERVER = 43

# Range requests
HTTP_HEADER_ACCEPT_RANGES = 44
HTTP_HEADER_RANGE = 45
HTTP_HEADER_IF_RANGE = 46
HTTP_HEADER_CONTENT_RANGE = 47

# WebSockets
HTTP_HEADER_SEC_WEBSOCKET_KEY = 48
HTTP_HEADER_SEC_WEBSOCKET_EXTENSIONS = 49
HTTP_HEADER_SEC_WEBSOCKET_ACCEPT = 50
HTTP_HEADER_SEC_WEBSOCKET_PROTOCOL = 51
HTTP_HEADER_SEC_WEBSOCKET_VERSION = 52

# Other
HTTP_HEADER_DATE = 53
HTTP_HEADER_UPGRADE = 54

HTTP_HEADER_INVALID = 53
