# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class SetupToolsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_spreadsheet(self, job_type, **kwargs):  # noqa: E501
        """Gets the template spreadsheet for the given job type  # noqa: E501

        Required Permissions: SaaS / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_spreadsheet(job_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_type: The job type to get the template for (required)
        :param str location_id: The location to get the template for
        :param str filter_id:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_spreadsheet_with_http_info(job_type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_spreadsheet_with_http_info(job_type, **kwargs)  # noqa: E501
            return data

    def get_spreadsheet_with_http_info(self, job_type, **kwargs):  # noqa: E501
        """Gets the template spreadsheet for the given job type  # noqa: E501

        Required Permissions: SaaS / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_spreadsheet_with_http_info(job_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_type: The job type to get the template for (required)
        :param str location_id: The location to get the template for
        :param str filter_id:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_type', 'location_id', 'filter_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_spreadsheet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_type' is set
        if ('job_type' not in params or
                params['job_type'] is None):
            raise ValueError("Missing the required parameter `job_type` when calling `get_spreadsheet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_type' in params:
            path_params['jobType'] = params['job_type']  # noqa: E501

        query_params = []
        if 'location_id' in params:
            query_params.append(('locationId', params['location_id']))  # noqa: E501
        if 'filter_id' in params:
            query_params.append(('filterId', params['filter_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/SetupTools/{jobType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def run_setup_tool_job(self, job_type, **kwargs):  # noqa: E501
        """Enqueues a job of the given type to be run  # noqa: E501

        Required Permissions: SaaS / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.run_setup_tool_job(job_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_type: The type of job to run (required)
        :param str location_id:
        :param str file:
        :return: JobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.run_setup_tool_job_with_http_info(job_type, **kwargs)  # noqa: E501
        else:
            (data) = self.run_setup_tool_job_with_http_info(job_type, **kwargs)  # noqa: E501
            return data

    def run_setup_tool_job_with_http_info(self, job_type, **kwargs):  # noqa: E501
        """Enqueues a job of the given type to be run  # noqa: E501

        Required Permissions: SaaS / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.run_setup_tool_job_with_http_info(job_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_type: The type of job to run (required)
        :param str location_id:
        :param str file:
        :return: JobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_type', 'location_id', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_setup_tool_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_type' is set
        if ('job_type' not in params or
                params['job_type'] is None):
            raise ValueError("Missing the required parameter `job_type` when calling `run_setup_tool_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_type' in params:
            path_params['jobType'] = params['job_type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'location_id' in params:
            form_params.append(('locationId', params['location_id']))  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/SetupTools/{jobType}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
