# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class ReportsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def request_base_station_report(self, **kwargs):  # noqa: E501
        """This will download a base station and repeater hardware report for the locations provided in the details model  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_base_station_report(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] ids: A list of Locations Guids whose hardware should appear in the report
        :param str file_name: The Name of the File
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.request_base_station_report_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.request_base_station_report_with_http_info(**kwargs)  # noqa: E501
            return data

    def request_base_station_report_with_http_info(self, **kwargs):  # noqa: E501
        """This will download a base station and repeater hardware report for the locations provided in the details model  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_base_station_report_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] ids: A list of Locations Guids whose hardware should appear in the report
        :param str file_name: The Name of the File
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ids', 'file_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_base_station_report" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ids' in params:
            query_params.append(('Ids', params['ids']))  # noqa: E501
            collection_formats['Ids'] = 'multi'  # noqa: E501
        if 'file_name' in params:
            query_params.append(('FileName', params['file_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Reports/hardware/basestation', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def request_heatmap_report(self, group_id, **kwargs):  # noqa: E501
        """Enqueues a job to run and later email a heatmap report for the group provided using the options provided  # noqa: E501

        Required Permissions: SaaS / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_heatmap_report(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: Id of the group to run the report on (required)
        :param HeatmapReportRequest body: Contains the options for the report
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.request_heatmap_report_with_http_info(group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.request_heatmap_report_with_http_info(group_id, **kwargs)  # noqa: E501
            return data

    def request_heatmap_report_with_http_info(self, group_id, **kwargs):  # noqa: E501
        """Enqueues a job to run and later email a heatmap report for the group provided using the options provided  # noqa: E501

        Required Permissions: SaaS / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_heatmap_report_with_http_info(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: Id of the group to run the report on (required)
        :param HeatmapReportRequest body: Contains the options for the report
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_heatmap_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params or
                params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `request_heatmap_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Reports/heatmap/group/{groupId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def request_low_battery_report(self, location_id, **kwargs):  # noqa: E501
        """This will download a low battery report for the location provided in the details model  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_low_battery_report(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: Id of the location whose nodes will appear in the report (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.request_low_battery_report_with_http_info(location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.request_low_battery_report_with_http_info(location_id, **kwargs)  # noqa: E501
            return data

    def request_low_battery_report_with_http_info(self, location_id, **kwargs):  # noqa: E501
        """This will download a low battery report for the location provided in the details model  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_low_battery_report_with_http_info(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: Id of the location whose nodes will appear in the report (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['location_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_low_battery_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `request_low_battery_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'location_id' in params:
            query_params.append(('LocationId', params['location_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Reports/hardware/lowBattery', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def request_statistics_report(self, group_id, **kwargs):  # noqa: E501
        """Emails a statistics report for the group provided using the options provided  # noqa: E501

        Required Permissions: SaaS / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_statistics_report(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: Id of the group to run the report on (required)
        :param StatisticsReportRequest body: Contains the options for the report
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.request_statistics_report_with_http_info(group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.request_statistics_report_with_http_info(group_id, **kwargs)  # noqa: E501
            return data

    def request_statistics_report_with_http_info(self, group_id, **kwargs):  # noqa: E501
        """Emails a statistics report for the group provided using the options provided  # noqa: E501

        Required Permissions: SaaS / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_statistics_report_with_http_info(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: Id of the group to run the report on (required)
        :param StatisticsReportRequest body: Contains the options for the report
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_statistics_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params or
                params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `request_statistics_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Reports/statistics/group/{groupId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
