# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class ReceiversApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_receiver(self, receiver_id, **kwargs):  # noqa: E501
        """Gets a receiver  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_receiver(receiver_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int receiver_id: (required)
        :return: ReceiverResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_receiver_with_http_info(receiver_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_receiver_with_http_info(receiver_id, **kwargs)  # noqa: E501
            return data

    def get_receiver_with_http_info(self, receiver_id, **kwargs):  # noqa: E501
        """Gets a receiver  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_receiver_with_http_info(receiver_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int receiver_id: (required)
        :return: ReceiverResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['receiver_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_receiver" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'receiver_id' is set
        if ('receiver_id' not in params or
                params['receiver_id'] is None):
            raise ValueError("Missing the required parameter `receiver_id` when calling `get_receiver`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'receiver_id' in params:
            path_params['receiverId'] = params['receiver_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Receivers/{receiverId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReceiverResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_receivers(self, **kwargs):  # noqa: E501
        """Gets receivers  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_receivers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `FirmwareVersion` | String | `eq, neq, like, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `MacAddress` | String | `eq, neq, like, in` | | `Name` | String | `eq, neq, like, in` | | `NetworkId` | String | `eq, neq, like, in` | | `PendingRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `RadioMacAddress` | String | `eq, neq, like, in` | | `ReceiverType` | ReceiverType | `eq, neq, in` | | `RfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `SerialNumber` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CorporationName` | String | | `FirmwareVersion` | String | | `LocationName` | String | | `MacAddress` | String | | `Name` | String | | `NetworkId` | String | | `PendingRfChannel` | Int32? | | `RadioMacAddress` | String | | `ReceiverType` | ReceiverType | | `RfChannel` | Int32? | | `SerialNumber` | String |
        :return: PagedResultsModelReceiverResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_receivers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_receivers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_receivers_with_http_info(self, **kwargs):  # noqa: E501
        """Gets receivers  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_receivers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `FirmwareVersion` | String | `eq, neq, like, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `MacAddress` | String | `eq, neq, like, in` | | `Name` | String | `eq, neq, like, in` | | `NetworkId` | String | `eq, neq, like, in` | | `PendingRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `RadioMacAddress` | String | `eq, neq, like, in` | | `ReceiverType` | ReceiverType | `eq, neq, in` | | `RfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `SerialNumber` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CorporationName` | String | | `FirmwareVersion` | String | | `LocationName` | String | | `MacAddress` | String | | `Name` | String | | `NetworkId` | String | | `PendingRfChannel` | Int32? | | `RadioMacAddress` | String | | `ReceiverType` | ReceiverType | | `RfChannel` | Int32? | | `SerialNumber` | String |
        :return: PagedResultsModelReceiverResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_receivers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Receivers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelReceiverResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
