# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class AssetsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_asset(self, **kwargs):  # noqa: E501
        """Creates an asset  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_asset(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetCreateRequest body:
        :return: AssetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_asset_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_asset_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_asset_with_http_info(self, **kwargs):  # noqa: E501
        """Creates an asset  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_asset_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetCreateRequest body:
        :return: AssetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_asset" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Assets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_asset(self, asset_id, **kwargs):  # noqa: E501
        """Deletes an asset  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def delete_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Deletes an asset  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `delete_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Assets/{assetId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset(self, asset_id, **kwargs):  # noqa: E501
        """Gets an Asset  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_id: (required)
        :param bool include_analytics_models: Determines whether to include the Analytics Model with the asset
        :return: AssetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Gets an Asset  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_id: (required)
        :param bool include_analytics_models: Determines whether to include the Analytics Model with the asset
        :return: AssetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'include_analytics_models']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'include_analytics_models' in params:
            query_params.append(('includeAnalyticsModels', params['include_analytics_models']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Assets/{assetId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_markers(self, asset_id, **kwargs):  # noqa: E501
        """Gets all markers on an asset  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_markers(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_id: Id of asset (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `MarkerType` | MarkerType | `eq, neq, in` | | `Name` | String | `eq, neq, like, in` | | `Value` | Double | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Name` | String | | `Order` | Int32 | | `Value` | Double |
        :return: PagedResultsModelMarkerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_markers_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_markers_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_asset_markers_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Gets all markers on an asset  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_markers_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_id: Id of asset (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `MarkerType` | MarkerType | `eq, neq, in` | | `Name` | String | `eq, neq, like, in` | | `Value` | Double | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Name` | String | | `Order` | Int32 | | `Value` | Double |
        :return: PagedResultsModelMarkerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_markers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_asset_markers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Assets/{assetId}/markers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelMarkerResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_status(self, asset_id, **kwargs):  # noqa: E501
        """Gets an asset's status  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_status(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_id: (required)
        :return: GroupStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_status_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_status_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_asset_status_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Gets an asset's status  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_status_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_id: (required)
        :return: GroupStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_asset_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Assets/{assetId}/Status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_statuses(self, **kwargs):  # noqa: E501
        """Gets Asset Statuses  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_statuses(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `AlarmCount` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `DamageScore` | Double? | `eq, neq, in, lt, gt, leq, geq` | | `Id` | Guid | `eq, neq, in` | | `IsPaused` | Boolean | `eq, neq` | | `IsSnoozed` | Boolean | `eq, neq` | | `ModelCount` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `Name` | String | `eq, neq, like, in` | | `WarningCount` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `AlarmCount` | Int32 | | `DamageScore` | Double? | | `Name` | String | | `WarningCount` | Int32 |
        :return: PagedResultsModelGroupStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_statuses_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_statuses_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_asset_statuses_with_http_info(self, **kwargs):  # noqa: E501
        """Gets Asset Statuses  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_statuses_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `AlarmCount` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `DamageScore` | Double? | `eq, neq, in, lt, gt, leq, geq` | | `Id` | Guid | `eq, neq, in` | | `IsPaused` | Boolean | `eq, neq` | | `IsSnoozed` | Boolean | `eq, neq` | | `ModelCount` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `Name` | String | `eq, neq, like, in` | | `WarningCount` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `AlarmCount` | Int32 | | `DamageScore` | Double? | | `Name` | String | | `WarningCount` | Int32 |
        :return: PagedResultsModelGroupStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_ids', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_statuses" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'group_ids' in params:
            query_params.append(('groupIds', params['group_ids']))  # noqa: E501
            collection_formats['groupIds'] = 'multi'  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Assets/Status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelGroupStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_types(self, **kwargs):  # noqa: E501
        """Gets Asset Types  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_types(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CategoryCode` | String | `eq, neq, like, in` | | `CategoryId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `CategoryName` | String | `eq, neq, like, in` | | `Code` | String | `eq, neq, like, in` | | `Name` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Code` | String | | `Name` | String |
        :return: PagedResultsModelAssetTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_types_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_types_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_asset_types_with_http_info(self, **kwargs):  # noqa: E501
        """Gets Asset Types  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_types_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CategoryCode` | String | `eq, neq, like, in` | | `CategoryId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `CategoryName` | String | `eq, neq, like, in` | | `Code` | String | `eq, neq, like, in` | | `Name` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Code` | String | | `Name` | String |
        :return: PagedResultsModelAssetTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_types" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Assets/Types', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelAssetTypeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_assets(self, **kwargs):  # noqa: E501
        """Gets Assets  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids: The groupIds to grab assets from under
        :param bool include_analytics_models: Determines whether to include the Analytics Model with the asset
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Abbreviation` | String | `eq, neq, like, in` | | `Active` | Boolean | `eq, neq` | | `AnalyticsModelCount` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `AnalyticsModelId` | Guid | `eq, neq, in` | | `AnalyticsModelName` | String | `eq, neq, like, in` | | `CategoryCode` | String | `eq, neq, like, in` | | `CategoryId` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `CategoryName` | String | `eq, neq, like, in` | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `CriticalityId` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `CriticalityName` | String | `eq, neq, like, in` | | `IsOperatorView` | Boolean | `eq, neq` | | `IsPaused` | Boolean | `eq, neq` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `Manufacturer` | String | `eq, neq, like, in` | | `ModelName` | String | `eq, neq, like, in` | | `Name` | String | `eq, neq, like, in` | | `NodeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `NodeSerialNumber` | String | `eq, neq, like, in` | | `SizeCode` | String | `eq, neq, like, in` | | `SizeId` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `SizeName` | String | `eq, neq, like, in` | | `Supplier` | String | `eq, neq, like, in` | | `TagId` | Guid | `eq, neq, in` | | `TagName` | String | `eq, neq, like, in` | | `TypeCode` | String | `eq, neq, like, in` | | `TypeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `TypeName` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Abbreviation` | String | | `CategoryCode` | String | | `CategoryName` | String | | `CorporationName` | String | | `Created` | DateTime | | `CriticalityId` | Int32? | | `CriticalityName` | String | | `LocationName` | String | | `Name` | String | | `SizeCode` | String | | `SizeName` | String | | `TypeCode` | String | | `TypeName` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Abbreviation`, `Name`.
        :return: PagedResultsModelAssetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_assets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_assets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_assets_with_http_info(self, **kwargs):  # noqa: E501
        """Gets Assets  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids: The groupIds to grab assets from under
        :param bool include_analytics_models: Determines whether to include the Analytics Model with the asset
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Abbreviation` | String | `eq, neq, like, in` | | `Active` | Boolean | `eq, neq` | | `AnalyticsModelCount` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `AnalyticsModelId` | Guid | `eq, neq, in` | | `AnalyticsModelName` | String | `eq, neq, like, in` | | `CategoryCode` | String | `eq, neq, like, in` | | `CategoryId` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `CategoryName` | String | `eq, neq, like, in` | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `CriticalityId` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `CriticalityName` | String | `eq, neq, like, in` | | `IsOperatorView` | Boolean | `eq, neq` | | `IsPaused` | Boolean | `eq, neq` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `Manufacturer` | String | `eq, neq, like, in` | | `ModelName` | String | `eq, neq, like, in` | | `Name` | String | `eq, neq, like, in` | | `NodeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `NodeSerialNumber` | String | `eq, neq, like, in` | | `SizeCode` | String | `eq, neq, like, in` | | `SizeId` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `SizeName` | String | `eq, neq, like, in` | | `Supplier` | String | `eq, neq, like, in` | | `TagId` | Guid | `eq, neq, in` | | `TagName` | String | `eq, neq, like, in` | | `TypeCode` | String | `eq, neq, like, in` | | `TypeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `TypeName` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Abbreviation` | String | | `CategoryCode` | String | | `CategoryName` | String | | `CorporationName` | String | | `Created` | DateTime | | `CriticalityId` | Int32? | | `CriticalityName` | String | | `LocationName` | String | | `Name` | String | | `SizeCode` | String | | `SizeName` | String | | `TypeCode` | String | | `TypeName` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Abbreviation`, `Name`.
        :return: PagedResultsModelAssetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_ids', 'include_analytics_models', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'group_ids' in params:
            query_params.append(('groupIds', params['group_ids']))  # noqa: E501
            collection_formats['groupIds'] = 'multi'  # noqa: E501
        if 'include_analytics_models' in params:
            query_params.append(('includeAnalyticsModels', params['include_analytics_models']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Assets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelAssetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def move_asset(self, asset_id, **kwargs):  # noqa: E501
        """Moves an asset  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_id: (required)
        :param GroupMoveRequest body:
        :return: AssetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.move_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.move_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def move_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Moves an asset  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_id: (required)
        :param GroupMoveRequest body:
        :return: AssetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `move_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Assets/{assetId}/Move', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_asset_markers(self, asset_id, **kwargs):  # noqa: E501
        """Replaces all the existing markers on the asset with new ones  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_asset_markers(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_id: Id of the asset (required)
        :param list[MarkerUpdateRequest] body: Request containing marker information
        :return: list[MarkerResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_asset_markers_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_asset_markers_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def replace_asset_markers_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Replaces all the existing markers on the asset with new ones  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_asset_markers_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_id: Id of the asset (required)
        :param list[MarkerUpdateRequest] body: Request containing marker information
        :return: list[MarkerResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_asset_markers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `replace_asset_markers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Assets/{assetId}/markers', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MarkerResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_asset(self, asset_id, **kwargs):  # noqa: E501
        """Updates an asset  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_id: (required)
        :param AssetUpdateRequest body:
        :return: AssetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def update_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Updates an asset  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str asset_id: (required)
        :param AssetUpdateRequest body:
        :return: AssetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `update_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Assets/{assetId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
