# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository   # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mailslurp_client.api_client import ApiClient
from mailslurp_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AliasControllerApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_alias(self, create_alias_options, **kwargs):  # noqa: E501
        """Create an email alias. Must be verified by clicking link inside verification email that will be sent to the address. Once verified the alias will be active.  # noqa: E501

        Email aliases use a MailSlurp randomly generated email address (or a custom domain inbox that you provide) to mask or proxy a real email address. Emails sent to the alias address will be forwarded to the hidden email address it was created for. If you want to send a reply use the threadId attached  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_alias(create_alias_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateAliasOptions create_alias_options: createAliasOptions (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AliasDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_alias_with_http_info(create_alias_options, **kwargs)  # noqa: E501

    def create_alias_with_http_info(self, create_alias_options, **kwargs):  # noqa: E501
        """Create an email alias. Must be verified by clicking link inside verification email that will be sent to the address. Once verified the alias will be active.  # noqa: E501

        Email aliases use a MailSlurp randomly generated email address (or a custom domain inbox that you provide) to mask or proxy a real email address. Emails sent to the alias address will be forwarded to the hidden email address it was created for. If you want to send a reply use the threadId attached  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_alias_with_http_info(create_alias_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateAliasOptions create_alias_options: createAliasOptions (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AliasDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_alias_options'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_alias" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_alias_options' is set
        if self.api_client.client_side_validation and ('create_alias_options' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_alias_options'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_alias_options` when calling `create_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_alias_options' in local_var_params:
            body_params = local_var_params['create_alias_options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/aliases', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AliasDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_alias(self, alias_id, **kwargs):  # noqa: E501
        """Delete an email alias  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_alias(alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias_id: aliasId (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_alias_with_http_info(alias_id, **kwargs)  # noqa: E501

    def delete_alias_with_http_info(self, alias_id, **kwargs):  # noqa: E501
        """Delete an email alias  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_alias_with_http_info(alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias_id: aliasId (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'alias_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_alias" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'alias_id' is set
        if self.api_client.client_side_validation and ('alias_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['alias_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `alias_id` when calling `delete_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'alias_id' in local_var_params:
            path_params['aliasId'] = local_var_params['alias_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/aliases/{aliasId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alias(self, alias_id, **kwargs):  # noqa: E501
        """Get an email alias  # noqa: E501

        Get an email alias by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alias(alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias_id: aliasId (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AliasDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_alias_with_http_info(alias_id, **kwargs)  # noqa: E501

    def get_alias_with_http_info(self, alias_id, **kwargs):  # noqa: E501
        """Get an email alias  # noqa: E501

        Get an email alias by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alias_with_http_info(alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias_id: aliasId (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AliasDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'alias_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alias" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'alias_id' is set
        if self.api_client.client_side_validation and ('alias_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['alias_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `alias_id` when calling `get_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'alias_id' in local_var_params:
            path_params['aliasId'] = local_var_params['alias_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/aliases/{aliasId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AliasDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alias_emails(self, alias_id, **kwargs):  # noqa: E501
        """Get emails for an alias  # noqa: E501

        Get paginated emails for an alias by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alias_emails(alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias_id: aliasId (required)
        :param int page: Optional page index alias email list pagination
        :param int size: Optional page size alias email list pagination
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PageEmailProjection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_alias_emails_with_http_info(alias_id, **kwargs)  # noqa: E501

    def get_alias_emails_with_http_info(self, alias_id, **kwargs):  # noqa: E501
        """Get emails for an alias  # noqa: E501

        Get paginated emails for an alias by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alias_emails_with_http_info(alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias_id: aliasId (required)
        :param int page: Optional page index alias email list pagination
        :param int size: Optional page size alias email list pagination
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PageEmailProjection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'alias_id',
            'page',
            'size',
            'sort'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alias_emails" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'alias_id' is set
        if self.api_client.client_side_validation and ('alias_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['alias_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `alias_id` when calling `get_alias_emails`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'alias_id' in local_var_params:
            path_params['aliasId'] = local_var_params['alias_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/aliases/{aliasId}/emails', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageEmailProjection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alias_threads(self, alias_id, **kwargs):  # noqa: E501
        """Get threads created for an alias  # noqa: E501

        Returns threads created for an email alias in paginated form  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alias_threads(alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias_id: aliasId (required)
        :param int page: Optional page index in thread list pagination
        :param int size: Optional page size in thread list pagination
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PageThreadProjection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_alias_threads_with_http_info(alias_id, **kwargs)  # noqa: E501

    def get_alias_threads_with_http_info(self, alias_id, **kwargs):  # noqa: E501
        """Get threads created for an alias  # noqa: E501

        Returns threads created for an email alias in paginated form  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alias_threads_with_http_info(alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias_id: aliasId (required)
        :param int page: Optional page index in thread list pagination
        :param int size: Optional page size in thread list pagination
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PageThreadProjection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'alias_id',
            'page',
            'size',
            'sort'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alias_threads" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'alias_id' is set
        if self.api_client.client_side_validation and ('alias_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['alias_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `alias_id` when calling `get_alias_threads`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'alias_id' in local_var_params:
            path_params['aliasId'] = local_var_params['alias_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/aliases/{aliasId}/threads', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageThreadProjection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_aliases(self, **kwargs):  # noqa: E501
        """Get all email aliases you have created  # noqa: E501

        Get all email aliases in paginated form  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_aliases(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int page: Optional page index in alias list pagination
        :param int size: Optional page size in alias list pagination
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PageAlias
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_aliases_with_http_info(**kwargs)  # noqa: E501

    def get_aliases_with_http_info(self, **kwargs):  # noqa: E501
        """Get all email aliases you have created  # noqa: E501

        Get all email aliases in paginated form  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_aliases_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int page: Optional page index in alias list pagination
        :param int size: Optional page size in alias list pagination
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PageAlias, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'page',
            'size',
            'sort'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_aliases" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/aliases', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageAlias',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reply_to_alias_email(self, alias_id, email_id, reply_to_alias_email_options, **kwargs):  # noqa: E501
        """Reply to an email  # noqa: E501

        Send the reply to the email sender or reply-to and include same subject cc bcc etc. Reply to an email and the contents will be sent with the existing subject to the emails `to`, `cc`, and `bcc`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reply_to_alias_email(alias_id, email_id, reply_to_alias_email_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias_id: ID of the alias that email belongs to (required)
        :param str email_id: ID of the email that should be replied to (required)
        :param ReplyToAliasEmailOptions reply_to_alias_email_options: replyToAliasEmailOptions (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SentEmailDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.reply_to_alias_email_with_http_info(alias_id, email_id, reply_to_alias_email_options, **kwargs)  # noqa: E501

    def reply_to_alias_email_with_http_info(self, alias_id, email_id, reply_to_alias_email_options, **kwargs):  # noqa: E501
        """Reply to an email  # noqa: E501

        Send the reply to the email sender or reply-to and include same subject cc bcc etc. Reply to an email and the contents will be sent with the existing subject to the emails `to`, `cc`, and `bcc`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reply_to_alias_email_with_http_info(alias_id, email_id, reply_to_alias_email_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias_id: ID of the alias that email belongs to (required)
        :param str email_id: ID of the email that should be replied to (required)
        :param ReplyToAliasEmailOptions reply_to_alias_email_options: replyToAliasEmailOptions (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SentEmailDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'alias_id',
            'email_id',
            'reply_to_alias_email_options'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reply_to_alias_email" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'alias_id' is set
        if self.api_client.client_side_validation and ('alias_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['alias_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `alias_id` when calling `reply_to_alias_email`")  # noqa: E501
        # verify the required parameter 'email_id' is set
        if self.api_client.client_side_validation and ('email_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['email_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `email_id` when calling `reply_to_alias_email`")  # noqa: E501
        # verify the required parameter 'reply_to_alias_email_options' is set
        if self.api_client.client_side_validation and ('reply_to_alias_email_options' not in local_var_params or  # noqa: E501
                                                        local_var_params['reply_to_alias_email_options'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `reply_to_alias_email_options` when calling `reply_to_alias_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'alias_id' in local_var_params:
            path_params['aliasId'] = local_var_params['alias_id']  # noqa: E501
        if 'email_id' in local_var_params:
            path_params['emailId'] = local_var_params['email_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'reply_to_alias_email_options' in local_var_params:
            body_params = local_var_params['reply_to_alias_email_options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/aliases/{aliasId}/emails/{emailId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SentEmailDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_alias_email(self, alias_id, **kwargs):  # noqa: E501
        """Send an email from an alias inbox  # noqa: E501

        Send an email from an alias. Replies to the email will be forwarded to the alias masked email address  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_alias_email(alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias_id: aliasId (required)
        :param SendEmailOptions send_email_options: Options for the email to be sent
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SentEmailDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.send_alias_email_with_http_info(alias_id, **kwargs)  # noqa: E501

    def send_alias_email_with_http_info(self, alias_id, **kwargs):  # noqa: E501
        """Send an email from an alias inbox  # noqa: E501

        Send an email from an alias. Replies to the email will be forwarded to the alias masked email address  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_alias_email_with_http_info(alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias_id: aliasId (required)
        :param SendEmailOptions send_email_options: Options for the email to be sent
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SentEmailDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'alias_id',
            'send_email_options'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_alias_email" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'alias_id' is set
        if self.api_client.client_side_validation and ('alias_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['alias_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `alias_id` when calling `send_alias_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'alias_id' in local_var_params:
            path_params['aliasId'] = local_var_params['alias_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'send_email_options' in local_var_params:
            body_params = local_var_params['send_email_options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/aliases/{aliasId}/emails', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SentEmailDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_alias(self, alias_id, update_alias_options, **kwargs):  # noqa: E501
        """Update an email alias  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_alias(alias_id, update_alias_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias_id: aliasId (required)
        :param UpdateAliasOptions update_alias_options: updateAliasOptions (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_alias_with_http_info(alias_id, update_alias_options, **kwargs)  # noqa: E501

    def update_alias_with_http_info(self, alias_id, update_alias_options, **kwargs):  # noqa: E501
        """Update an email alias  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_alias_with_http_info(alias_id, update_alias_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias_id: aliasId (required)
        :param UpdateAliasOptions update_alias_options: updateAliasOptions (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'alias_id',
            'update_alias_options'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_alias" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'alias_id' is set
        if self.api_client.client_side_validation and ('alias_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['alias_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `alias_id` when calling `update_alias`")  # noqa: E501
        # verify the required parameter 'update_alias_options' is set
        if self.api_client.client_side_validation and ('update_alias_options' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_alias_options'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_alias_options` when calling `update_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'alias_id' in local_var_params:
            path_params['aliasId'] = local_var_params['alias_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_alias_options' in local_var_params:
            body_params = local_var_params['update_alias_options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/aliases/{aliasId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
