"""
Python Character Mapping Codec for 'petscii_vic1001jp_kk' generated by gen-codec.
"""

#    Name:		PETSCII VIC-1001 Japanese katakana to Unicode Table
#    Unicode version:	3.0
#    Table version:	1.00
#    Table format:	Format A
#    Date:		13/04/21
#    Authors:		Simon Rowe <srowe@mose.org.uk>, Linus Walleij <triad@df.lth.se>
#    General notes:	Licensed under the GNU GPL, version 2

import codecs

# Codec APIs


class Codec(codecs.Codec):  # pylint: disable=missing-class-docstring
    def encode(self, _input, errors='strict'):
        return codecs.charmap_encode(_input, errors, encoding_table)

    def decode(self, _input, errors='strict'):
        return codecs.charmap_decode(_input, errors, decoding_table)


class IncrementalEncoder(codecs.IncrementalEncoder):  # pylint: disable=missing-class-docstring
    def encode(self, _input, final=False):
        return codecs.charmap_encode(_input, self.errors, encoding_table)[0]


class IncrementalDecoder(codecs.IncrementalDecoder):  # pylint: disable=missing-class-docstring
    def decode(self, _input, final=False):
        return codecs.charmap_decode(_input, self.errors, decoding_table)[0]


class StreamWriter(Codec, codecs.StreamWriter):  # pylint: disable=missing-class-docstring
    pass


class StreamReader(Codec, codecs.StreamReader):  # pylint: disable=missing-class-docstring
    pass


# encodings module API

def getregentry():  # pylint: disable=missing-function-docstring
    return codecs.CodecInfo(
        name='petscii_vic1001jp_kk',
        encode=Codec().encode,
        decode=Codec().decode,
        incrementalencoder=IncrementalEncoder,
        incrementaldecoder=IncrementalDecoder,
        streamreader=StreamReader,
        streamwriter=StreamWriter,
    )


decoding_table = {
    0x05:	'\uf100',	  # WHITE COLOR SWITCH (CUS)
    0x0d:	'\r',    	  # CARRIAGE RETURN
    0x0e:	'\x0e',  	  # SHIFT OUT
    0x11:	'\uf11c',	  # CURSOR DOWN (CUS)
    0x12:	'\uf11a',	  # REVERSE VIDEO ON (CUS)
    0x13:	'\uf120',	  # HOME (CUS)
    0x14:	'\x7f',  	  # DELETE
    0x1c:	'\uf101',	  # RED COLOR SWITCH (CUS)
    0x1d:	'\uf11d',	  # CURSOR RIGHT (CUS)
    0x1e:	'\uf102',	  # GREEN COLOR SWITCH (CUS)
    0x1f:	'\uf103',	  # BLUE COLOR SWITCH (CUS)
    0x20:	' ',     	  # SPACE
    0x21:	'!',     	  # EXCLAMATION MARK
    0x22:	'"',     	  # QUOTATION MARK
    0x23:	'#',     	  # NUMBER SIGN
    0x24:	'$',     	  # DOLLAR SIGN
    0x25:	'%',     	  # PERCENT SIGN
    0x26:	'&',     	  # AMPERSAND
    0x27:	"'",     	  # APOSTROPHE
    0x28:	'(',     	  # LEFT PARENTHESIS
    0x29:	')',     	  # RIGHT PARENTHESIS
    0x2a:	'*',     	  # ASTERISK
    0x2b:	'+',     	  # PLUS SIGN
    0x2c:	',',     	  # COMMA
    0x2d:	'-',     	  # HYPHEN-MINUS
    0x2e:	'.',     	  # FULL STOP
    0x2f:	'/',     	  # SOLIDUS
    0x30:	'0',     	  # DIGIT ZERO
    0x31:	'1',     	  # DIGIT ONE
    0x32:	'2',     	  # DIGIT TWO
    0x33:	'3',     	  # DIGIT THREE
    0x34:	'4',     	  # DIGIT FOUR
    0x35:	'5',     	  # DIGIT FIVE
    0x36:	'6',     	  # DIGIT SIX
    0x37:	'7',     	  # DIGIT SEVEN
    0x38:	'8',     	  # DIGIT EIGHT
    0x39:	'9',     	  # DIGIT NINE
    0x3a:	':',     	  # COLON
    0x3b:	';',     	  # SEMICOLON
    0x3c:	'<',     	  # LESS-THAN SIGN
    0x3d:	'=',     	  # EQUALS SIGN
    0x3e:	'>',     	  # GREATER-THAN SIGN
    0x3f:	'?',     	  # QUESTION MARK
    0x40:	'@',     	  # COMMERCIAL AT
    0x41:	'A',     	  # LATIN CAPITAL LETTER A
    0x42:	'B',     	  # LATIN CAPITAL LETTER B
    0x43:	'C',     	  # LATIN CAPITAL LETTER C
    0x44:	'D',     	  # LATIN CAPITAL LETTER D
    0x45:	'E',     	  # LATIN CAPITAL LETTER E
    0x46:	'F',     	  # LATIN CAPITAL LETTER F
    0x47:	'G',     	  # LATIN CAPITAL LETTER G
    0x48:	'H',     	  # LATIN CAPITAL LETTER H
    0x49:	'I',     	  # LATIN CAPITAL LETTER I
    0x4a:	'J',     	  # LATIN CAPITAL LETTER J
    0x4b:	'K',     	  # LATIN CAPITAL LETTER K
    0x4c:	'L',     	  # LATIN CAPITAL LETTER L
    0x4d:	'M',     	  # LATIN CAPITAL LETTER M
    0x4e:	'N',     	  # LATIN CAPITAL LETTER N
    0x4f:	'O',     	  # LATIN CAPITAL LETTER O
    0x50:	'P',     	  # LATIN CAPITAL LETTER P
    0x51:	'Q',     	  # LATIN CAPITAL LETTER Q
    0x52:	'R',     	  # LATIN CAPITAL LETTER R
    0x53:	'S',     	  # LATIN CAPITAL LETTER S
    0x54:	'T',     	  # LATIN CAPITAL LETTER T
    0x55:	'U',     	  # LATIN CAPITAL LETTER U
    0x56:	'V',     	  # LATIN CAPITAL LETTER V
    0x57:	'W',     	  # LATIN CAPITAL LETTER W
    0x58:	'X',     	  # LATIN CAPITAL LETTER X
    0x59:	'Y',     	  # LATIN CAPITAL LETTER Y
    0x5a:	'Z',     	  # LATIN CAPITAL LETTER Z
    0x5b:	'[',     	  # LEFT SQUARE BRACKET
    0x5c:	'\xa5',  	  # YEN SIGN
    0x5d:	']',     	  # RIGHT SQUARE BRACKET
    0x5e:	'\u2191',	  # UPWARDS ARROW
    0x5f:	'\u2190',	  # LEFTWARDS ARROW
    0x60:	'\u2500',	  # BOX DRAWINGS LIGHT HORIZONTAL
    0x61:	'\u30c1',	  # KATAKANA LETTER TI
    0x62:	'\u30c4',	  # KATAKANA LETTER TU
    0x63:	'\u30c6',	  # KATAKANA LETTER TE
    0x64:	'\u30c8',	  # KATAKANA LETTER TO
    0x65:	'\u30ca',	  # KATAKANA LETTER NA
    0x66:	'\u30cb',	  # KATAKANA LETTER NI
    0x67:	'\u30cc',	  # KATAKANA LETTER NU
    0x68:	'\u30cd',	  # KATAKANA LETTER NE
    0x69:	'\u30ce',	  # KATAKANA LETTER NO
    0x6a:	'\u30cf',	  # KATAKANA LETTER HA
    0x6b:	'\u30d2',	  # KATAKANA LETTER HI
    0x6c:	'\u30d5',	  # KATAKANA LETTER HU
    0x6d:	'\u30d8',	  # KATAKANA LETTER HE
    0x6e:	'\u30db',	  # KATAKANA LETTER HO
    0x6f:	'\u30de',	  # KATAKANA LETTER MA
    0x70:	'\u30df',	  # KATAKANA LETTER MI
    0x71:	'\u30e0',	  # KATAKANA LETTER MU
    0x72:	'\u30e1',	  # KATAKANA LETTER ME
    0x73:	'\u30e2',	  # KATAKANA LETTER MO
    0x74:	'\u30e4',	  # KATAKANA LETTER YA
    0x75:	'\u30e6',	  # KATAKANA LETTER YU
    0x76:	'\u30e8',	  # KATAKANA LETTER YO
    0x77:	'\u30e9',	  # KATAKANA LETTER RA
    0x78:	'\u30ea',	  # KATAKANA LETTER RI
    0x79:	'\u30eb',	  # KATAKANA LETTER RU
    0x7a:	'\u30ec',	  # KATAKANA LETTER RE
    0x7b:	'\u253c',	  # BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    0x7c:	'\u30ef',	  # KATAKANA LETTER WA
    0x7d:	'\u2502',	  # BOX DRAWINGS LIGHT VERTICAL
    0x7e:	'\u03c0',	  # GREEK SMALL LETTER PI
    0x7f:	'\u30f2',	  # KATAKANA LETTER WO
    0x85:	'\uf110',	  # FUNCTION KEY 1 (CUS)
    0x86:	'\uf112',	  # FUNCTION KEY 3 (CUS)
    0x87:	'\uf114',	  # FUNCTION KEY 5 (CUS)
    0x88:	'\uf116',	  # FUNCTION KEY 7 (CUS)
    0x89:	'\uf111',	  # FUNCTION KEY 2 (CUS)
    0x8a:	'\uf113',	  # FUNCTION KEY 4 (CUS)
    0x8b:	'\uf115',	  # FUNCTION KEY 6 (CUS)
    0x8c:	'\uf117',	  # FUNCTION KEY 8 (CUS)
    0x8d:	'\n',    	  # LINE FEED
    0x8e:	'\x0f',  	  # SHIFT IN
    0x90:	'\uf105',	  # BLACK COLOR SWITCH (CUS)
    0x91:	'\uf11e',	  # CURSOR UP (CUS)
    0x92:	'\uf11b',	  # REVERSE VIDEO OFF (CUS)
    0x93:	'\x0c',  	  # FORM FEED
    0x94:	'\uf121',	  # INSERT (CUS)
    0x9c:	'\uf10d',	  # PURPLE COLOR SWITCH (CUS)
    0x9d:	'\uf11f',	  # CURSOR LEFT (CUS)
    0x9e:	'\uf10e',	  # YELLOW COLOR SWITCH (CUS)
    0x9f:	'\uf10f',	  # CYAN COLOR SWITCH (CUS)
    0xa0:	'\xa0',  	  # NO-BREAK SPACE
    0xa1:	'\u309c',	  # SEMI-VOICED SOUND MARK
    0xa2:	'\u30a4',	  # KATAKANA LETTER I
    0xa3:	'\u30a6',	  # KATAKANA LETTER U
    0xa4:	'\u30a8',	  # KATAKANA LETTER E
    0xa5:	'\u30aa',	  # KATAKANA LETTER O
    0xa6:	'\u30f2',	  # KATAKANA LETTER WO
    0xa7:	'\u30ad',	  # KATAKANA LETTER KI
    0xa8:	'\u30af',	  # KATAKANA LETTER KU
    0xa9:	'\u30b1',	  # KATAKANA LETTER KE
    0xaa:	'\u309b',	  # VOICED SOUND MARK
    0xab:	'\u251c',	  # BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    0xac:	'\u30b9',	  # KATAKANA LETTER SU
    0xad:	'\u2514',	  # BOX DRAWINGS LIGHT UP AND RIGHT
    0xae:	'\u2510',	  # BOX DRAWINGS LIGHT DOWN AND LEFT
    0xaf:	'\u309c',	  # SEMI-VOICED SOUND MARK
    0xb0:	'\u250c',	  # BOX DRAWINGS LIGHT DOWN AND RIGHT
    0xb1:	'\u30a2',	  # KATAKANA LETTER A
    0xb2:	'\u30a4',	  # KATAKANA LETTER I
    0xb3:	'\u30a6',	  # KATAKANA LETTER U
    0xb4:	'\u30a8',	  # KATAKANA LETTER E
    0xb5:	'\u30aa',	  # KATAKANA LETTER O
    0xb6:	'\u30ab',	  # KATAKANA LETTER KA
    0xb7:	'\u30ad',	  # KATAKANA LETTER KI
    0xb8:	'\u30af',	  # KATAKANA LETTER KU
    0xb9:	'\u30b1',	  # KATAKANA LETTER KE
    0xba:	'\u30b3',	  # KATAKANA LETTER KO
    0xbb:	'\u30b5',	  # KATAKANA LETTER SA
    0xbc:	'\u30b7',	  # KATAKANA LETTER SI
    0xbd:	'\u30b9',	  # KATAKANA LETTER SU
    0xbe:	'\u30bb',	  # KATAKANA LETTER SE
    0xbf:	'\u30bd',	  # KATAKANA LETTER SO
    0xc0:	'\u30bf',	  # KATAKANA LETTER TA
    0xc1:	'\u30c1',	  # KATAKANA LETTER TI
    0xc2:	'\u30c4',	  # KATAKANA LETTER TU
    0xc3:	'\u30c6',	  # KATAKANA LETTER TE
    0xc4:	'\u30c8',	  # KATAKANA LETTER TO
    0xc5:	'\u30ca',	  # KATAKANA LETTER NA
    0xc6:	'\u30cb',	  # KATAKANA LETTER NI
    0xc7:	'\u30cc',	  # KATAKANA LETTER NU
    0xc8:	'\u30cd',	  # KATAKANA LETTER NE
    0xc9:	'\u30ce',	  # KATAKANA LETTER NO
    0xca:	'\u30cf',	  # KATAKANA LETTER HA
    0xcb:	'\u30d2',	  # KATAKANA LETTER HI
    0xcc:	'\u30d5',	  # KATAKANA LETTER HU
    0xcd:	'\u30d8',	  # KATAKANA LETTER HE
    0xce:	'\u30db',	  # KATAKANA LETTER HO
    0xcf:	'\u30de',	  # KATAKANA LETTER MA
    0xd0:	'\u30df',	  # KATAKANA LETTER MI
    0xd1:	'\u30e0',	  # KATAKANA LETTER MU
    0xd2:	'\u30e1',	  # KATAKANA LETTER ME
    0xd3:	'\u30e2',	  # KATAKANA LETTER MO
    0xd4:	'\u30e4',	  # KATAKANA LETTER YA
    0xd5:	'\u30e6',	  # KATAKANA LETTER YU
    0xd6:	'\u30e8',	  # KATAKANA LETTER YO
    0xd7:	'\u30e9',	  # KATAKANA LETTER RA
    0xd8:	'\u30ea',	  # KATAKANA LETTER RI
    0xd9:	'\u30eb',	  # KATAKANA LETTER RU
    0xda:	'\u30ec',	  # KATAKANA LETTER RE
    0xdb:	'\u30ed',	  # KATAKANA LETTER RO
    0xdc:	'\u305c',	  # KATAKANA LETTER WA
    0xdd:	'\u30f3',	  # KATAKANA LETTER N
    0xde:	'\u309b',	  # VOICED SOUND MARK
    0xdf:	'\u30f2',	  # KATAKANA LETTER WO
    0xe0:	'\u30c0',	  # GREEK SMALL LETTER PI
    0xe1:	'\u253c',	  # BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    0xe2:	'\u2502',	  # BOX DRAWINGS LIGHT VERTICAL
    0xe3:	'\u30a6',	  # KATAKANA LETTER U
    0xe4:	'\u30a8',	  # KATAKANA LETTER E
    0xe5:	'\u30aa',	  # KATAKANA LETTER O
    0xe6:	'\u30f2',	  # KATAKANA LETTER WO
    0xe7:	'\u30ad',	  # KATAKANA LETTER KI
    0xe8:	'\u30af',	  # KATAKANA LETTER KU
    0xe9:	'\u30b1',	  # KATAKANA LETTER KE
    0xea:	'\u309b',	  # VOICED SOUND MARK
    0xeb:	'\u251c',	  # BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    0xec:	'\u30b9',	  # KATAKANA LETTER SU
    0xed:	'\u2514',	  # BOX DRAWINGS LIGHT UP AND RIGHT
    0xee:	'\u2510',	  # BOX DRAWINGS LIGHT DOWN AND LEFT
    0xef:	'\u309c',	  # SEMI-VOICED SOUND MARK
    0xf0:	'\u250c',	  # BOX DRAWINGS LIGHT DOWN AND RIGHT
    0xf1:	'\u2534',	  # BOX DRAWINGS LIGHT UP AND HORIZONTAL
    0xf2:	'\u252c',	  # BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    0xf3:	'\u2524',	  # BOX DRAWINGS LIGHT VERTICAL AND LEFT
    0xf4:	'\u5e74',	  # YEAR, PERSON'S AGE
    0xf5:	'\u6708',	  # MONTH
    0xf6:	'\u65e5',	  # DAY, DAYTIME
    0xf7:	'\u30bf',	  # KATAKANA LETTER TA
    0xf8:	'\u30ed',	  # KATAKANA LETTER RO
    0xf9:	'\u30f3',	  # KATAKANA LETTER N
    0xfa:	'\u30b3',	  # KATAKANA LETTER KO
    0xfb:	'\u30b5',	  # KATAKANA LETTER SA
    0xfc:	'\u30b7',	  # KATAKANA LETTER SI
    0xfd:	'\u2518',	  # BOX DRAWINGS LIGHT UP AND LEFT
    0xfe:	'\u30bb',	  # KATAKANA LETTER SE
    0xff:	'\u03c0',	  # GREEK SMALL LETTER PI
}

encoding_table = {
    0x0a:	b'\x8d',  	  # LINE FEED
    0x0c:	b'\x93',  	  # FORM FEED
    0x0d:	b'\r',    	  # CARRIAGE RETURN
    0x0e:	b'\x0e',  	  # SHIFT OUT
    0x0f:	b'\x8e',  	  # SHIFT IN
    0x20:	b' ',     	  # SPACE
    0x21:	b'!',     	  # EXCLAMATION MARK
    0x22:	b'"',     	  # QUOTATION MARK
    0x23:	b'#',     	  # NUMBER SIGN
    0x24:	b'$',     	  # DOLLAR SIGN
    0x25:	b'%',     	  # PERCENT SIGN
    0x26:	b'&',     	  # AMPERSAND
    0x27:	b"'",     	  # APOSTROPHE
    0x28:	b'(',     	  # LEFT PARENTHESIS
    0x29:	b')',     	  # RIGHT PARENTHESIS
    0x2a:	b'*',     	  # ASTERISK
    0x2b:	b'+',     	  # PLUS SIGN
    0x2c:	b',',     	  # COMMA
    0x2d:	b'-',     	  # HYPHEN-MINUS
    0x2e:	b'.',     	  # FULL STOP
    0x2f:	b'/',     	  # SOLIDUS
    0x30:	b'0',     	  # DIGIT ZERO
    0x31:	b'1',     	  # DIGIT ONE
    0x32:	b'2',     	  # DIGIT TWO
    0x33:	b'3',     	  # DIGIT THREE
    0x34:	b'4',     	  # DIGIT FOUR
    0x35:	b'5',     	  # DIGIT FIVE
    0x36:	b'6',     	  # DIGIT SIX
    0x37:	b'7',     	  # DIGIT SEVEN
    0x38:	b'8',     	  # DIGIT EIGHT
    0x39:	b'9',     	  # DIGIT NINE
    0x3a:	b':',     	  # COLON
    0x3b:	b';',     	  # SEMICOLON
    0x3c:	b'<',     	  # LESS-THAN SIGN
    0x3d:	b'=',     	  # EQUALS SIGN
    0x3e:	b'>',     	  # GREATER-THAN SIGN
    0x3f:	b'?',     	  # QUESTION MARK
    0x40:	b'@',     	  # COMMERCIAL AT
    0x41:	b'A',     	  # LATIN CAPITAL LETTER A
    0x42:	b'B',     	  # LATIN CAPITAL LETTER B
    0x43:	b'C',     	  # LATIN CAPITAL LETTER C
    0x44:	b'D',     	  # LATIN CAPITAL LETTER D
    0x45:	b'E',     	  # LATIN CAPITAL LETTER E
    0x46:	b'F',     	  # LATIN CAPITAL LETTER F
    0x47:	b'G',     	  # LATIN CAPITAL LETTER G
    0x48:	b'H',     	  # LATIN CAPITAL LETTER H
    0x49:	b'I',     	  # LATIN CAPITAL LETTER I
    0x4a:	b'J',     	  # LATIN CAPITAL LETTER J
    0x4b:	b'K',     	  # LATIN CAPITAL LETTER K
    0x4c:	b'L',     	  # LATIN CAPITAL LETTER L
    0x4d:	b'M',     	  # LATIN CAPITAL LETTER M
    0x4e:	b'N',     	  # LATIN CAPITAL LETTER N
    0x4f:	b'O',     	  # LATIN CAPITAL LETTER O
    0x50:	b'P',     	  # LATIN CAPITAL LETTER P
    0x51:	b'Q',     	  # LATIN CAPITAL LETTER Q
    0x52:	b'R',     	  # LATIN CAPITAL LETTER R
    0x53:	b'S',     	  # LATIN CAPITAL LETTER S
    0x54:	b'T',     	  # LATIN CAPITAL LETTER T
    0x55:	b'U',     	  # LATIN CAPITAL LETTER U
    0x56:	b'V',     	  # LATIN CAPITAL LETTER V
    0x57:	b'W',     	  # LATIN CAPITAL LETTER W
    0x58:	b'X',     	  # LATIN CAPITAL LETTER X
    0x59:	b'Y',     	  # LATIN CAPITAL LETTER Y
    0x5a:	b'Z',     	  # LATIN CAPITAL LETTER Z
    0x5b:	b'[',     	  # LEFT SQUARE BRACKET
    0x5d:	b']',     	  # RIGHT SQUARE BRACKET
    0x7f:	b'\x14',  	  # DELETE
    0xa0:	b'\xa0',  	  # NO-BREAK SPACE
    0xa5:	b'\\',    	  # YEN SIGN
    0x03c0:	b'\xff',  	  # GREEK SMALL LETTER PI
    0x2190:	b'_',     	  # LEFTWARDS ARROW
    0x2191:	b'^',     	  # UPWARDS ARROW
    0x2500:	b'`',     	  # BOX DRAWINGS LIGHT HORIZONTAL
    0x2502:	b'\xe2',  	  # BOX DRAWINGS LIGHT VERTICAL
    0x250c:	b'\xf0',  	  # BOX DRAWINGS LIGHT DOWN AND RIGHT
    0x2510:	b'\xee',  	  # BOX DRAWINGS LIGHT DOWN AND LEFT
    0x2514:	b'\xed',  	  # BOX DRAWINGS LIGHT UP AND RIGHT
    0x2518:	b'\xfd',  	  # BOX DRAWINGS LIGHT UP AND LEFT
    0x251c:	b'\xeb',  	  # BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    0x2524:	b'\xf3',  	  # BOX DRAWINGS LIGHT VERTICAL AND LEFT
    0x252c:	b'\xf2',  	  # BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    0x2534:	b'\xf1',  	  # BOX DRAWINGS LIGHT UP AND HORIZONTAL
    0x253c:	b'\xe1',  	  # BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    0x305c:	b'\xdc',  	  # KATAKANA LETTER WA
    0x309b:	b'\xea',  	  # VOICED SOUND MARK
    0x309c:	b'\xef',  	  # SEMI-VOICED SOUND MARK
    0x30a2:	b'\xb1',  	  # KATAKANA LETTER A
    0x30a4:	b'\xb2',  	  # KATAKANA LETTER I
    0x30a6:	b'\xe3',  	  # KATAKANA LETTER U
    0x30a8:	b'\xe4',  	  # KATAKANA LETTER E
    0x30aa:	b'\xe5',  	  # KATAKANA LETTER O
    0x30ab:	b'\xb6',  	  # KATAKANA LETTER KA
    0x30ad:	b'\xe7',  	  # KATAKANA LETTER KI
    0x30af:	b'\xe8',  	  # KATAKANA LETTER KU
    0x30b1:	b'\xe9',  	  # KATAKANA LETTER KE
    0x30b3:	b'\xfa',  	  # KATAKANA LETTER KO
    0x30b5:	b'\xfb',  	  # KATAKANA LETTER SA
    0x30b7:	b'\xfc',  	  # KATAKANA LETTER SI
    0x30b9:	b'\xec',  	  # KATAKANA LETTER SU
    0x30bb:	b'\xfe',  	  # KATAKANA LETTER SE
    0x30bd:	b'\xbf',  	  # KATAKANA LETTER SO
    0x30bf:	b'\xf7',  	  # KATAKANA LETTER TA
    0x30c0:	b'\xe0',  	  # GREEK SMALL LETTER PI
    0x30c1:	b'\xc1',  	  # KATAKANA LETTER TI
    0x30c4:	b'\xc2',  	  # KATAKANA LETTER TU
    0x30c6:	b'\xc3',  	  # KATAKANA LETTER TE
    0x30c8:	b'\xc4',  	  # KATAKANA LETTER TO
    0x30ca:	b'\xc5',  	  # KATAKANA LETTER NA
    0x30cb:	b'\xc6',  	  # KATAKANA LETTER NI
    0x30cc:	b'\xc7',  	  # KATAKANA LETTER NU
    0x30cd:	b'\xc8',  	  # KATAKANA LETTER NE
    0x30ce:	b'\xc9',  	  # KATAKANA LETTER NO
    0x30cf:	b'\xca',  	  # KATAKANA LETTER HA
    0x30d2:	b'\xcb',  	  # KATAKANA LETTER HI
    0x30d5:	b'\xcc',  	  # KATAKANA LETTER HU
    0x30d8:	b'\xcd',  	  # KATAKANA LETTER HE
    0x30db:	b'\xce',  	  # KATAKANA LETTER HO
    0x30de:	b'\xcf',  	  # KATAKANA LETTER MA
    0x30df:	b'\xd0',  	  # KATAKANA LETTER MI
    0x30e0:	b'\xd1',  	  # KATAKANA LETTER MU
    0x30e1:	b'\xd2',  	  # KATAKANA LETTER ME
    0x30e2:	b'\xd3',  	  # KATAKANA LETTER MO
    0x30e4:	b'\xd4',  	  # KATAKANA LETTER YA
    0x30e6:	b'\xd5',  	  # KATAKANA LETTER YU
    0x30e8:	b'\xd6',  	  # KATAKANA LETTER YO
    0x30e9:	b'\xd7',  	  # KATAKANA LETTER RA
    0x30ea:	b'\xd8',  	  # KATAKANA LETTER RI
    0x30eb:	b'\xd9',  	  # KATAKANA LETTER RU
    0x30ec:	b'\xda',  	  # KATAKANA LETTER RE
    0x30ed:	b'\xf8',  	  # KATAKANA LETTER RO
    0x30ef:	b'|',     	  # KATAKANA LETTER WA
    0x30f2:	b'\xe6',  	  # KATAKANA LETTER WO
    0x30f3:	b'\xf9',  	  # KATAKANA LETTER N
    0x5e74:	b'\xf4',  	  # YEAR, PERSON'S AGE
    0x65e5:	b'\xf6',  	  # DAY, DAYTIME
    0x6708:	b'\xf5',  	  # MONTH
    0xf100:	b'\x05',  	  # WHITE COLOR SWITCH (CUS)
    0xf101:	b'\x1c',  	  # RED COLOR SWITCH (CUS)
    0xf102:	b'\x1e',  	  # GREEN COLOR SWITCH (CUS)
    0xf103:	b'\x1f',  	  # BLUE COLOR SWITCH (CUS)
    0xf105:	b'\x90',  	  # BLACK COLOR SWITCH (CUS)
    0xf10d:	b'\x9c',  	  # PURPLE COLOR SWITCH (CUS)
    0xf10e:	b'\x9e',  	  # YELLOW COLOR SWITCH (CUS)
    0xf10f:	b'\x9f',  	  # CYAN COLOR SWITCH (CUS)
    0xf110:	b'\x85',  	  # FUNCTION KEY 1 (CUS)
    0xf111:	b'\x89',  	  # FUNCTION KEY 2 (CUS)
    0xf112:	b'\x86',  	  # FUNCTION KEY 3 (CUS)
    0xf113:	b'\x8a',  	  # FUNCTION KEY 4 (CUS)
    0xf114:	b'\x87',  	  # FUNCTION KEY 5 (CUS)
    0xf115:	b'\x8b',  	  # FUNCTION KEY 6 (CUS)
    0xf116:	b'\x88',  	  # FUNCTION KEY 7 (CUS)
    0xf117:	b'\x8c',  	  # FUNCTION KEY 8 (CUS)
    0xf11a:	b'\x12',  	  # REVERSE VIDEO ON (CUS)
    0xf11b:	b'\x92',  	  # REVERSE VIDEO OFF (CUS)
    0xf11c:	b'\x11',  	  # CURSOR DOWN (CUS)
    0xf11d:	b'\x1d',  	  # CURSOR RIGHT (CUS)
    0xf11e:	b'\x91',  	  # CURSOR UP (CUS)
    0xf11f:	b'\x9d',  	  # CURSOR LEFT (CUS)
    0xf120:	b'\x13',  	  # HOME (CUS)
    0xf121:	b'\x94',  	  # INSERT (CUS)
}

codecs.register(lambda e: getregentry() if e.replace('-', '_') == 'petscii_vic1001jp_kk' else None)
