# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/10b_agents.dqn.targets.ipynb (unless otherwise specified).

__all__ = ['supports', 'distribution_head', 'CategoricalDQN', 'DQNTargetTrainer']

# Cell
# Python native modules
import os
from collections import deque
from typing import *
# Third party libs
import torch
from torch.nn import *
from fastcore.all import *
from fastai.learner import *
from fastai.torch_basics import *
from fastai.torch_core import *
from fastai.callback.all import *
# Local modules
from ...data.block import *
from ...agent import *
from ...core import *
from .core import *

# Cell
def supports(n_atoms=51,v_min=-1,v_max=1)->Tuple[Tensor,float]:
    delta_z=v_max-v_min/n_atoms
    return (v_min+Tensor([i*delta_z for i in range(n_atoms)])),delta_z

# Cell
def distribution_head(t):
    denom=torch.exp(t).sum()
    return torch.exp(t)/denom

# Cell
class CategoricalDQN(Module):
    def __init__(self,state_sz:int,action_sz:int,hidden=512,n_atoms=51,
                 v_min=-1,v_max=1):
        store_attr()
        self.layers=Sequential(
            Linear(state_sz,hidden),
            ReLU(),
            Linear(hidden,action_sz),
        )
    def forward(self,x): return self.layers(x)

# Cell
class DQNTargetTrainer(Callback):

    def __init__(self,n_batch=0,target_sync=300,discount=0.99,n_steps=1):
        store_attr()
        self._yb=None

    def before_fit(self):
        self.learn.target_model=deepcopy(self.learn.model.model)
        self.n_batch=0

    def after_pred(self):
        self.learn.yb=self.yb[0]
        self._yb=({k:v.clone() for k,v in self.yb.items()},)
        self.learn.done_mask=self.yb['done'].reshape(-1,)
        self.learn.next_q=self.target_model(self.yb['next_state']).max(dim=1).values.reshape(-1,1)
        self.learn.next_q[self.done_mask]=0
        self.learn.targets=self.yb['reward']+self.learn.next_q*(self.discount**self.n_steps)
        self.learn.pred=self.learn.model.model(self.yb['state'])
        t_q=self.pred.clone()
        t_q.scatter_(1,self.yb['action'],self.targets)
        self.learn.yb=(t_q,)

    def before_backward(self): self.learn.yb=self._yb

    def after_batch(self):
        if self.n_batch%self.target_sync==0:
            self.target_model.load_state_dict(self.learn.model.state_dict())
        self.n_batch+=1