from enum import Enum


class ScoreType(str, Enum):
    UNKNOWN = "UNKNOWN"
    F1_WEIGHTED_AVG = "F1_WEIGHTED_AVG"
    ACCURACY = "ACCURACY"
    ROC_AUC = "ROC_AUC"
    RMSE = "RMSE"
    EXPLAINED_VARIANCE = "EXPLAINED_VARIANCE"
    PREDICT_TIME = "PREDICT_TIME"
    TEST_TIME = "TEST_TIME"
    TRAIN_TIME = "TRAIN_TIME"
    PRECISION = "PRECISION"
    RECALL = "RECALL"
    ABSOLUTE_ERROR = "ABSOLUTE_ERROR"
    R2 = "R2"
    MEDIAN_ABSOLUTE_ERROR = "MEDIAN_ABSOLUTE_ERROR"
    LOG_LIKELIHOOD = "LOG_LIKELIHOOD"
    PERCENT_ERROR = "PERCENT_ERROR"
    BIC = "BIC"
    ROI = "ROI"
    CALINSKI_HARABASZ = "CALINSKI_HARABASZ"
    CLUSTERS = "CLUSTERS"
    SILHOUETTE_COEF = "SILHOUETTE_COEF"
    F1_SINGLE_CLASS = "F1_SINGLE_CLASS"
    RECALL_SINGLE_CLASS = "RECALL_SINGLE_CLASS"
    PRECISION_SINGLE_CLASS = "PRECISION_SINGLE_CLASS"
    F5_SINGLE_CLASS = "F5_SINGLE_CLASS"
    EXPECTED_REWARD = "EXPECTED_REWARD"
    GINI = "GINI"

    def __str__(self) -> str:
        return str(self.value)