CREATE TABLE project.tablename (
  account_id STRING,
  device_id STRING,
  playback_session_id STRING,
  content_id STRING,
  fguid STRING,
  user_session_id STRING,
  group_watch_id STRING,
  swid STRING,
  profile_id STRING,
  partner STRING,
  location_country_code STRING,
  location_zip_code STRING,
  location_dma STRING,
  location_city_name STRING,
  location_asn INT,
  location_isp STRING,
  location_normalized_isp STRING,
  location_state STRING,
  ip_address STRING,
  sdk_version STRING,
  sdk_platform STRING,
  sdk_device_platform STRING,
  device_os_version STRING,
  device_model STRING,
  device_model_family STRING,
  device_brand STRING,
  application_id STRING,
  application_name STRING,
  application_version STRING,
  browser STRING,
  browser_version STRING,
  platform STRING,
  qos_platform STRING,
  video_player_name STRING,
  video_player_version STRING,
  user_agent STRING,
  timestamp TIMESTAMP,
  start_timestamp BIGINT,
  another_time TIMESTAMP NOT NULL,
  end_timestamp BIGINT,
  video_startup_timestamp BIGINT,
  initiated_by STRING,
  video_range STRING,
  video_ranges ARRAY<STRING>,
  video_codec STRING,
  audio_language STRING,
  subtitle_name STRING,
  subtitle_language STRING,
  subtitle_visibility BOOLEAN,
  cdn_with_origin STRING,
  playback_url STRING,
  media_type STRING,
  playback_scenario STRING,
  product_type STRING,
  encoding_features STRING,
  encryption_type STRING,
  video_segment_types_array ARRAY<STRING>,
  percentage_complete DOUBLE,
  asset_name STRING,
  content_duration BIGINT,
  audio_codec STRING,
  video_frame_rate FLOAT,
  video_resolution STRING,
  ended_reason BIGINT,
  playback_state STRING,
  startup_time BIGINT,
  playing_time BIGINT,
  buffering_time BIGINT,
  seek_rebuffering_time BIGINT,
  ci_rebuffering_time BIGINT,
  interrupts BIGINT,
  ci_rebuffering_count INT,
  seek_count INT,
  pause_count INT,
  resume_count INT,
  resume_duration BIGINT,
  video_playback_failure_flag BOOLEAN,
  video_playback_failure_error_message_list ARRAY<STRING>,
  success_flag BOOLEAN,
  video_startup_failure_flag BOOLEAN,
  exit_before_video_start_flag BOOLEAN,
  has_fatal_error BOOLEAN,
  playback_started BOOLEAN,
  video_startup_time_existed BOOLEAN,
  network_type STRING,
  round_trip_time BIGINT,
  average_throughput BIGINT,
  offline BOOLEAN,
  experiment_keys ARRAY<STRING>,

  average_bitrate BIGINT,
  average_peak_bitrate BIGINT,
  bitrate_changed_count INT,
  bitrate_change_list ARRAY<BIGINT>,
  bitrate_change_timestamp_list ARRAY<BIGINT>,
  start_bitrate BIGINT,
  end_bitrate BIGINT,
  fetch_payload_duration BIGINT,
  fetch_payload_start_timestamp BIGINT,
  fetch_playlist_duration BIGINT,
  fetch_playlist_start_timestamp BIGINT,
  fetch_license_duration BIGINT,
  fetch_license_start_timestamp BIGINT,
  fetch_and_render_media_segment_duration BIGINT,
  fetch_and_render_media_segment_start_timestamp BIGINT,
  re_buffer_start_timestamp_list ARRAY<BIGINT>,
  re_buffer_duration_list ARRAY<BIGINT>,
  rebuffer_type_list ARRAY<STRING>,
  yr INT,
  mo INT,
  dy INT,
  hr INT,
  location_asn_with_owner STRING,
  ended_by STRING,
  live_type STRING,
  stream_type STRING,
  media_id STRING,
  stream_url STRING,
  audio_channels BIGINT,
  audio_change_count BIGINT,
  channel_id STRING,
  starting_playhead BIGINT,
  last_known_playhead BIGINT,
  event_source STRING,
  server_group_ids STRING,
  presentation_type STRING,
  playback_state_change_list ARRAY<STRING>,
  playback_state_change_timestamp_list ARRAY<BIGINT>,
  average_lpeel BIGINT,
  startup_event_timestamp_list ARRAY<BIGINT>,
  startup_event_type_list ARRAY<STRING>,
  cdn_vendor STRING,
  cdn_name STRING,
  cdn_requested_trail ARRAY<STRING>,
  cdn_failed_trail ARRAY<STRING>,
  cdn_fallback_count INT,
  is_cdn_fallback BOOLEAN,
  fatal_error_name STRING,
  fatal_error_message STRING,
  app_version STRING,
  audio_name STRING,
  is_filterable STRING,
  capabilities STRING,
  is_live_edge BOOLEAN,
  cdn_change_list ARRAY<STRING>,
  cdn_change_timestamp_list ARRAY<BIGINT>,
  tags STRING,
  seeking_time BIGINT,
  `vsf-t` BOOLEAN,
  `vsf-b` BOOLEAN,
  `vpf-t` BOOLEAN,
  `vpf-b` BOOLEAN,
  collection_id STRING,
  program_id STRING,
  encoded_family_id STRING,
  encoded_series_id STRING,
  event_id STRING,
  super_event_id STRING,
  sport_id STRING,
  league_id STRING,
  team_id STRING,
  cp_session_id STRING,
  cp_video_index INT,
  page_view_id STRING,
  activity_session_id STRING,
  subscription_id STRING,
  client_group_ids STRING,
  max_allowed_video_bitrate BIGINT,
  video_bitrate BIGINT,
  audio_bitrate BIGINT,
  peak_bitrate_playing_time BIGINT,
  live_latency_amount BIGINT,
  segment_position BIGINT,
  total_media_bytes_downloaded BIGINT,
  media_download_total_count BIGINT,
  media_download_total_time BIGINT,
  buffer_segment_duration BIGINT,
  location_carrier STRING,
  ad_session_id STRING,
  subscription_type STRING,
  ad_insertion_type STRING,
  ad_planned_length BIGINT,
  ad_pod_planned_count BIGINT,
  ad_slot_planned_count BIGINT,
  ad_pod_attempted_count BIGINT,
  ad_slot_attempted_count BIGINT,
  ad_pod_played_count BIGINT,
  ad_slot_played_count BIGINT,
  content_playing_time BIGINT,
  ad_playing_time BIGINT,
  has_preroll_requested BOOLEAN,
  has_slugs BOOLEAN,
  ad_pod_start_timestamp_list ARRAY<BIGINT>,
  ad_pod_end_timestamp_list ARRAY<BIGINT>,
  ad_pod_postion_list ARRAY<STRING>,
  ad_pod_index_list ARRAY<STRING>,
  ad_pod_length_list ARRAY<BIGINT>,
  ad_pod_startup_error_list ARRAY<STRING>,
  ad_startup_time_list ARRAY<BIGINT>,
  ad_video_playback_failure_flag BOOLEAN,
  ad_video_startup_failure_flag BOOLEAN,
  ad_video_playback_failure_ad_media_id STRING,
  ad_video_startup_failure_ad_media_id STRING,
  ad_ci_rebuffering_time BIGINT,
  ad_ci_rebuffering_count BIGINT,
  rebuffer_presentation_type_list ARRAY<STRING>,
  rebuffer_ad_media_id_list ARRAY<STRING>,
  presentation_type_change_list ARRAY<STRING>,
  presentation_type_change_timestamp_list ARRAY<BIGINT>,
  ad_present BOOLEAN,
  bumper_present BOOLEAN,
  ad_average_bitrate BIGINT,
  ad_average_peak_bitrate BIGINT,
  ad_slot_startup_error_count BIGINT,
  ad_slot_playback_error_count BIGINT,
  exit_before_ad_start_flag BOOLEAN,
  exit_during_ad_flag BOOLEAN,
  ingest_utc_hour INT,
  ingest_utc_date DATE)
USING delta

PARTITIONED BY (ingest_utc_date, ingest_utc_hour)
LOCATION 's3://dataeng-data-prod/prod/data/fed/qos_knowhere/v1/qos_knowhere_playback_session_summary_f'
TBLPROPERTIES ('delta.minReaderVersion' = '1',
              'delta.minWriterVersion' = '2');
