<a id="mypy-boto3-pinpoint-email"></a>

# mypy-boto3-pinpoint-email

[![PyPI - mypy-boto3-pinpoint-email](https://img.shields.io/pypi/v/mypy-boto3-pinpoint-email.svg?color=blue)](https://pypi.org/project/mypy-boto3-pinpoint-email)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-pinpoint-email.svg?color=blue)](https://pypi.org/project/mypy-boto3-pinpoint-email)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-pinpoint-email?color=blue)](https://pypistats.org/packages/mypy-boto3-pinpoint-email)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.PinpointEmail 1.18.1](https://boto3.amazonaws.com/v1/documentation/api/1.18.1/reference/services/pinpoint-email.html#PinpointEmail)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 5.0.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-pinpoint-email docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_pinpoint_email/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-pinpoint-email](#mypy-boto3-pinpoint-email)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `PinpointEmail` service.

```bash
python -m pip install boto3-stubs[pinpoint-email]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[pinpoint-email]` in your environment:
  `python -m pip install 'boto3-stubs[pinpoint-email]'`

Both type checking and auto-complete should work for `PinpointEmail` service.
No explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[pinpoint-email]` in your environment:
  `python -m pip install 'boto3-stubs[pinpoint-email]'`

Both type checking and auto-complete should work for `PinpointEmail` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[pinpoint-email]` in your environment:
  `python -m pip install 'boto3-stubs[pinpoint-email]'`
- Run `mypy` as usual

Type checking should work for `PinpointEmail` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[pinpoint-email]` in your environment:
  `python -m pip install 'boto3-stubs[pinpoint-email]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `PinpointEmail` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`PinpointEmailClient` provides annotations for
`boto3.client("pinpoint-email")`.

```python
import boto3

from mypy_boto3_pinpoint_email import PinpointEmailClient

client: PinpointEmailClient = boto3.client("pinpoint-email")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: PinpointEmailClient = session.client("pinpoint-email")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_pinpoint_email.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_pinpoint_email import PinpointEmailClient
from mypy_boto3_pinpoint_email.paginator import (
    GetDedicatedIpsPaginator,
    ListConfigurationSetsPaginator,
    ListDedicatedIpPoolsPaginator,
    ListDeliverabilityTestReportsPaginator,
    ListEmailIdentitiesPaginator,
)

client: PinpointEmailClient = boto3.client("pinpoint-email")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_dedicated_ips_paginator: GetDedicatedIpsPaginator = client.get_paginator("get_dedicated_ips")
list_configuration_sets_paginator: ListConfigurationSetsPaginator = client.get_paginator("list_configuration_sets")
list_dedicated_ip_pools_paginator: ListDedicatedIpPoolsPaginator = client.get_paginator("list_dedicated_ip_pools")
list_deliverability_test_reports_paginator: ListDeliverabilityTestReportsPaginator = client.get_paginator("list_deliverability_test_reports")
list_email_identities_paginator: ListEmailIdentitiesPaginator = client.get_paginator("list_email_identities")
```

<a id="literals"></a>

### Literals

`mypy_boto3_pinpoint_email.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_pinpoint_email.literals import (
    BehaviorOnMxFailureType,
    DeliverabilityDashboardAccountStatusType,
    DeliverabilityTestStatusType,
    DimensionValueSourceType,
    DkimStatusType,
    EventTypeType,
    GetDedicatedIpsPaginatorName,
    IdentityTypeType,
    ListConfigurationSetsPaginatorName,
    ListDedicatedIpPoolsPaginatorName,
    ListDeliverabilityTestReportsPaginatorName,
    ListEmailIdentitiesPaginatorName,
    MailFromDomainStatusType,
    TlsPolicyType,
    WarmupStatusType,
)

def check_value(value: BehaviorOnMxFailureType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_pinpoint_email.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_pinpoint_email.type_defs import (
    BlacklistEntryTypeDef,
    BodyTypeDef,
    CloudWatchDestinationTypeDef,
    CloudWatchDimensionConfigurationTypeDef,
    ContentTypeDef,
    CreateConfigurationSetEventDestinationRequestRequestTypeDef,
    CreateConfigurationSetRequestRequestTypeDef,
    CreateDedicatedIpPoolRequestRequestTypeDef,
    CreateDeliverabilityTestReportRequestRequestTypeDef,
    CreateDeliverabilityTestReportResponseTypeDef,
    CreateEmailIdentityRequestRequestTypeDef,
    CreateEmailIdentityResponseTypeDef,
    DailyVolumeTypeDef,
    DedicatedIpTypeDef,
    DeleteConfigurationSetEventDestinationRequestRequestTypeDef,
    DeleteConfigurationSetRequestRequestTypeDef,
    DeleteDedicatedIpPoolRequestRequestTypeDef,
    DeleteEmailIdentityRequestRequestTypeDef,
    DeliverabilityTestReportTypeDef,
    DeliveryOptionsTypeDef,
    DestinationTypeDef,
    DkimAttributesTypeDef,
    DomainDeliverabilityCampaignTypeDef,
    DomainDeliverabilityTrackingOptionTypeDef,
    DomainIspPlacementTypeDef,
    EmailContentTypeDef,
    EventDestinationDefinitionTypeDef,
    EventDestinationTypeDef,
    GetAccountResponseTypeDef,
    GetBlacklistReportsRequestRequestTypeDef,
    GetBlacklistReportsResponseTypeDef,
    GetConfigurationSetEventDestinationsRequestRequestTypeDef,
    GetConfigurationSetEventDestinationsResponseTypeDef,
    GetConfigurationSetRequestRequestTypeDef,
    GetConfigurationSetResponseTypeDef,
    GetDedicatedIpRequestRequestTypeDef,
    GetDedicatedIpResponseTypeDef,
    GetDedicatedIpsRequestRequestTypeDef,
    GetDedicatedIpsResponseTypeDef,
    GetDeliverabilityDashboardOptionsResponseTypeDef,
    GetDeliverabilityTestReportRequestRequestTypeDef,
    GetDeliverabilityTestReportResponseTypeDef,
    GetDomainDeliverabilityCampaignRequestRequestTypeDef,
    GetDomainDeliverabilityCampaignResponseTypeDef,
    GetDomainStatisticsReportRequestRequestTypeDef,
    GetDomainStatisticsReportResponseTypeDef,
    GetEmailIdentityRequestRequestTypeDef,
    GetEmailIdentityResponseTypeDef,
    IdentityInfoTypeDef,
    InboxPlacementTrackingOptionTypeDef,
    IspPlacementTypeDef,
    KinesisFirehoseDestinationTypeDef,
    ListConfigurationSetsRequestRequestTypeDef,
    ListConfigurationSetsResponseTypeDef,
    ListDedicatedIpPoolsRequestRequestTypeDef,
    ListDedicatedIpPoolsResponseTypeDef,
    ListDeliverabilityTestReportsRequestRequestTypeDef,
    ListDeliverabilityTestReportsResponseTypeDef,
    ListDomainDeliverabilityCampaignsRequestRequestTypeDef,
    ListDomainDeliverabilityCampaignsResponseTypeDef,
    ListEmailIdentitiesRequestRequestTypeDef,
    ListEmailIdentitiesResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    MailFromAttributesTypeDef,
    MessageTagTypeDef,
    MessageTypeDef,
    OverallVolumeTypeDef,
    PaginatorConfigTypeDef,
    PinpointDestinationTypeDef,
    PlacementStatisticsTypeDef,
    PutAccountDedicatedIpWarmupAttributesRequestRequestTypeDef,
    PutAccountSendingAttributesRequestRequestTypeDef,
    PutConfigurationSetDeliveryOptionsRequestRequestTypeDef,
    PutConfigurationSetReputationOptionsRequestRequestTypeDef,
    PutConfigurationSetSendingOptionsRequestRequestTypeDef,
    PutConfigurationSetTrackingOptionsRequestRequestTypeDef,
    PutDedicatedIpInPoolRequestRequestTypeDef,
    PutDedicatedIpWarmupAttributesRequestRequestTypeDef,
    PutDeliverabilityDashboardOptionRequestRequestTypeDef,
    PutEmailIdentityDkimAttributesRequestRequestTypeDef,
    PutEmailIdentityFeedbackAttributesRequestRequestTypeDef,
    PutEmailIdentityMailFromAttributesRequestRequestTypeDef,
    RawMessageTypeDef,
    ReputationOptionsTypeDef,
    ResponseMetadataTypeDef,
    SendEmailRequestRequestTypeDef,
    SendEmailResponseTypeDef,
    SendQuotaTypeDef,
    SendingOptionsTypeDef,
    SnsDestinationTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    TemplateTypeDef,
    TrackingOptionsTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateConfigurationSetEventDestinationRequestRequestTypeDef,
    VolumeStatisticsTypeDef,
)

def get_structure() -> BlacklistEntryTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-pinpoint-email` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-pinpoint-email docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_pinpoint_email/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
