# This should be consistent with common_proc.sh and config.py

# Point COLLECT_ROOT to the location you want to use as
# the root directory for all collections/indices.

if [ "$COLLECT_ROOT" = "" ] ; then
  echo "Specify the collection root location using the environment variable COLLECT_ROOT!"
  exit 1
fi
echo "Using collection root: $COLLECT_ROOT"

# Setting path for Java-binary-calling scripts
# These scripts should be copied to ./bin by either
# a build or an installation script.
export PATH=./bin/:$PATH

# The structure of sub-directories is outlined below

#
# We organize collections/datasets into sub-directories with a common root.
#
# See a description/location of sub-directories below, which are assumed
# to exist (by many scripts).
#
# $COLLECT_ROOT
#     <Collection sub-directory>
#         $INPUT_RAW_SUBDIR (optional)
#         $INPUT_DATA_SUBDIR
#             $DEFAULT_TRAIN_SUBDIR (can be overridden)
#             $DEV_SUBDIR (optional)
#             $DEV1_SUBDIR (optional)
#             $DEV2_SUBDIR (optional)
#             $BITEXT_SUBDIR (optional)
#
#         $DERIVED_DATA_SUBDIR
#             $IR_MODELS_SUBDIR (optional)
#             $BITEXT_SUBDIR (optional)
#             $MODEL1_SUBDIR (optional)
#             $EMBED_SUBDIR (optional)
#
#         $EXPER_SUBDIR
#
#         $FWD_INDEX_SUBDIR (default location)
#         $LUCENE_INDEX_SUBDIR (default location)
#

# Original input data directory
INPUT_RAW_SUBDIR="input_raw"

# Processed multi-field input data (possibly compressed question and/or answer JSONs)
INPUT_DATA_SUBDIR="input_data"
# Derived data subdirectory
DERIVED_DATA_SUBDIR="derived_data"

# This keeps data generated by experiments (results, models, etc)
EXPER_SUBDIR="results"

# Index directories.
FWD_INDEX_SUBDIR="forward_index"
LUCENE_INDEX_SUBDIR="lucene_index"

# Word embeddings are (historically) stored within the derived-data sub-directory
EMBED_SUBDIR="embeddings"

# This is a bunch of sub-directories for input data
DEFAULT_TRAIN_SUBDIR="train_fusion" # This only a default that can be overriden
# The dev* directories can be optional, there can be, e.g., dev1, dev2 or just a single dev
DEV_SUBDIR="dev"
DEV1_SUBDIR="dev1"
DEV2_SUBDIR="dev2"

# A directory to store trained models
IR_MODELS_SUBDIR="ir_models"

# Parallel corpora sub-directory
BITEXT_SUBDIR="bitext"
# Parameters to train Model 1
MODEL1_SUBDIR="giza"
GIZA_ITER_QTY=5

# Coordinate ascent (LETOR algorithm) training parameters
DEFAULT_METRIC_TYPE="NDCG@20"
DEFAULT_NUM_RAND_RESTART=10
DEFAULT_NUM_TREES=100

# QREL file name
QREL_FILE="qrels.txt"
# The default run id for TREC-like run files
FAKE_RUN_ID="fake_run"

# This value should match Lucene's query field
DEFAULT_QUERY_FIELD_NAME=text

DEFAULT_CAND_PROV_QTY=1000
DEFAULT_TRAIN_CAND_QTY=20
DEFAULT_TEST_CAND_QTY_LIST=10,50,100,250,500,1000

# Report/trec_run sub-dirs and files
LETOR_SUBDIR="letor"
TRECRUNS_SUBDIR="trec_runs"
REP_SUBDIR="rep"

STAT_FILE="stat_file"

SEP_DEBUG_LINE="================================================================================"

TEST_PART_PARAM="testPart"
TRAIN_PART_PARAM="trainPart"
EXPER_SUBDIR_PARAM="experSubdir"
TEST_ONLY_PARAM="testOnly"
TRAIN_ONLY_PARAM="trainOnly"


