"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToElasticachememcached = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("../../core");
const core_1 = require("@aws-cdk/core");
const core_2 = require("../../core");
const defaultEnvironmentVariableName = "CACHE_ENDPOINT";
/**
 * @summary The LambdaToElasticachememcached class.
 */
class LambdaToElasticachememcached extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToElasticachememcached class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {LambdaToElasticachememcachedProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        if ((props.existingCache || props.existingLambdaObj) && (!props.existingVpc)) {
            throw Error('If providing an existing Cache or Lambda Function, you must also supply the associated existingVpc');
        }
        if (props.cacheProps &&
            props.cacheProps.engine &&
            props.cacheProps.engine !== "memcached") {
            throw Error("This construct can only launch memcached clusters");
        }
        if (props.cacheProps && props.existingCache) {
            throw Error("Cannot specify existingCache and cacheProps");
        }
        const cachePort = core_2.getCachePort(props.cacheProps, props.existingCache);
        this.vpc = defaults.buildVpc(scope, {
            defaultVpcProps: defaults.DefaultIsolatedVpcProps(),
            existingVpc: props.existingVpc,
            userVpcProps: props.vpcProps,
        });
        const lambdaToCacheSecurityGroup = core_2.CreateSelfReferencingSecurityGroup(this, id, this.vpc, cachePort);
        this.cache = core_2.obtainMemcachedCluster(this, id, {
            cacheSecurityGroupId: lambdaToCacheSecurityGroup.securityGroupId,
            cacheProps: props.cacheProps,
            existingCache: props.existingCache,
            vpc: this.vpc,
            cachePort,
        });
        // Add the self-referencing security group to the Lambda function props
        const lambdaFunctionProps = defaults.consolidateProps({}, props.lambdaFunctionProps, { securityGroups: [lambdaToCacheSecurityGroup] }, true);
        // Setup the Lambda function
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps,
            vpc: this.vpc,
        });
        AddLambdaEnvironmentVariable(this.lambdaFunction, `${this.cache.attrConfigurationEndpointAddress}:${this.cache.attrConfigurationEndpointPort}`, defaultEnvironmentVariableName, props.cacheEndpointEnvironmentVariableName);
    }
}
exports.LambdaToElasticachememcached = LambdaToElasticachememcached;
_a = JSII_RTTI_SYMBOL_1;
LambdaToElasticachememcached[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-elasticachememcached.LambdaToElasticachememcached", version: "1.169.0" };
function AddLambdaEnvironmentVariable(targetFunction, value, defaultName, clientName) {
    const variableName = clientName || defaultName;
    targetFunction.addEnvironment(variableName, value);
}
//# sourceMappingURL=data:application/json;base64,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