import { StatefulSetV1Metadata, StatefulSetV1MetadataOutputReference, StatefulSetV1Spec, StatefulSetV1SpecOutputReference, StatefulSetV1Timeouts, StatefulSetV1TimeoutsOutputReference } from './index-structs';
export * from './index-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StatefulSetV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#id StatefulSetV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Wait for the rollout of the stateful set to complete. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#wait_for_rollout StatefulSetV1#wait_for_rollout}
    */
    readonly waitForRollout?: boolean | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#metadata StatefulSetV1#metadata}
    */
    readonly metadata: StatefulSetV1Metadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#spec StatefulSetV1#spec}
    */
    readonly spec: StatefulSetV1Spec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#timeouts StatefulSetV1#timeouts}
    */
    readonly timeouts?: StatefulSetV1Timeouts;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1 kubernetes_stateful_set_v1}
*/
export declare class StatefulSetV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_stateful_set_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1 kubernetes_stateful_set_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StatefulSetV1Config
    */
    constructor(scope: Construct, id: string, config: StatefulSetV1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _waitForRollout?;
    get waitForRollout(): boolean | cdktf.IResolvable;
    set waitForRollout(value: boolean | cdktf.IResolvable);
    resetWaitForRollout(): void;
    get waitForRolloutInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata;
    get metadata(): StatefulSetV1MetadataOutputReference;
    putMetadata(value: StatefulSetV1Metadata): void;
    get metadataInput(): StatefulSetV1Metadata | undefined;
    private _spec;
    get spec(): StatefulSetV1SpecOutputReference;
    putSpec(value: StatefulSetV1Spec): void;
    get specInput(): StatefulSetV1Spec | undefined;
    private _timeouts;
    get timeouts(): StatefulSetV1TimeoutsOutputReference;
    putTimeouts(value: StatefulSetV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StatefulSetV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
