import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * A map of the secret data in base64 encoding. Use this for binary data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/secret#binary_data Secret#binary_data}
    */
    readonly binaryData?: {
        [key: string]: string;
    };
    /**
    * A map of the secret data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/secret#data Secret#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/secret#id Secret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Ensures that data stored in the Secret cannot be updated (only object metadata can be modified).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/secret#immutable Secret#immutable}
    */
    readonly immutable?: boolean | cdktf.IResolvable;
    /**
    * Type of secret
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/secret#type Secret#type}
    */
    readonly type?: string;
    /**
    * Terraform will wait for the service account token to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/secret#wait_for_service_account_token Secret#wait_for_service_account_token}
    */
    readonly waitForServiceAccountToken?: boolean | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/secret#metadata Secret#metadata}
    */
    readonly metadata: SecretMetadata;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/secret#timeouts Secret#timeouts}
    */
    readonly timeouts?: SecretTimeouts;
}
export interface SecretMetadata {
    /**
    * An unstructured key value map stored with the secret that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/secret#annotations Secret#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/secret#generate_name Secret#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the secret. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/secret#labels Secret#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the secret, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/secret#name Secret#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the secret must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/secret#namespace Secret#namespace}
    */
    readonly namespace?: string;
}
export declare function secretMetadataToTerraform(struct?: SecretMetadataOutputReference | SecretMetadata): any;
export declare class SecretMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecretMetadata | undefined;
    set internalValue(value: SecretMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface SecretTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/secret#create Secret#create}
    */
    readonly create?: string;
}
export declare function secretTimeoutsToTerraform(struct?: SecretTimeoutsOutputReference | SecretTimeouts | cdktf.IResolvable): any;
export declare class SecretTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecretTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SecretTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/secret kubernetes_secret}
*/
export declare class Secret extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_secret";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/secret kubernetes_secret} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecretConfig
    */
    constructor(scope: Construct, id: string, config: SecretConfig);
    private _binaryData?;
    get binaryData(): {
        [key: string]: string;
    };
    set binaryData(value: {
        [key: string]: string;
    });
    resetBinaryData(): void;
    get binaryDataInput(): {
        [key: string]: string;
    } | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _immutable?;
    get immutable(): boolean | cdktf.IResolvable;
    set immutable(value: boolean | cdktf.IResolvable);
    resetImmutable(): void;
    get immutableInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _waitForServiceAccountToken?;
    get waitForServiceAccountToken(): boolean | cdktf.IResolvable;
    set waitForServiceAccountToken(value: boolean | cdktf.IResolvable);
    resetWaitForServiceAccountToken(): void;
    get waitForServiceAccountTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata;
    get metadata(): SecretMetadataOutputReference;
    putMetadata(value: SecretMetadata): void;
    get metadataInput(): SecretMetadata | undefined;
    private _timeouts;
    get timeouts(): SecretTimeoutsOutputReference;
    putTimeouts(value: SecretTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SecretTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
