import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#id RoleBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#metadata RoleBinding#metadata}
    */
    readonly metadata: RoleBindingMetadata;
    /**
    * role_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#role_ref RoleBinding#role_ref}
    */
    readonly roleRef: RoleBindingRoleRef;
    /**
    * subject block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#subject RoleBinding#subject}
    */
    readonly subject: RoleBindingSubject[] | cdktf.IResolvable;
}
export interface RoleBindingMetadata {
    /**
    * An unstructured key value map stored with the roleBinding that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#annotations RoleBinding#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#generate_name RoleBinding#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the roleBinding. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#labels RoleBinding#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the roleBinding, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#name RoleBinding#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the roleBinding must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#namespace RoleBinding#namespace}
    */
    readonly namespace?: string;
}
export declare function roleBindingMetadataToTerraform(struct?: RoleBindingMetadataOutputReference | RoleBindingMetadata): any;
export declare class RoleBindingMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleBindingMetadata | undefined;
    set internalValue(value: RoleBindingMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface RoleBindingRoleRef {
    /**
    * The API group of the user. The only value possible at the moment is `rbac.authorization.k8s.io`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#api_group RoleBinding#api_group}
    */
    readonly apiGroup: string;
    /**
    * The kind of resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#kind RoleBinding#kind}
    */
    readonly kind: string;
    /**
    * The name of the User to bind to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#name RoleBinding#name}
    */
    readonly name: string;
}
export declare function roleBindingRoleRefToTerraform(struct?: RoleBindingRoleRefOutputReference | RoleBindingRoleRef): any;
export declare class RoleBindingRoleRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleBindingRoleRef | undefined;
    set internalValue(value: RoleBindingRoleRef | undefined);
    private _apiGroup?;
    get apiGroup(): string;
    set apiGroup(value: string);
    get apiGroupInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface RoleBindingSubject {
    /**
    * The API group of the subject resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#api_group RoleBinding#api_group}
    */
    readonly apiGroup?: string;
    /**
    * The kind of resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#kind RoleBinding#kind}
    */
    readonly kind: string;
    /**
    * The name of the resource to bind to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#name RoleBinding#name}
    */
    readonly name: string;
    /**
    * The Namespace of the subject resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding#namespace RoleBinding#namespace}
    */
    readonly namespace?: string;
}
export declare function roleBindingSubjectToTerraform(struct?: RoleBindingSubject | cdktf.IResolvable): any;
export declare class RoleBindingSubjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RoleBindingSubject | cdktf.IResolvable | undefined;
    set internalValue(value: RoleBindingSubject | cdktf.IResolvable | undefined);
    private _apiGroup?;
    get apiGroup(): string;
    set apiGroup(value: string);
    resetApiGroup(): void;
    get apiGroupInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export declare class RoleBindingSubjectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RoleBindingSubject[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RoleBindingSubjectOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding kubernetes_role_binding}
*/
export declare class RoleBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_role_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/role_binding kubernetes_role_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleBindingConfig
    */
    constructor(scope: Construct, id: string, config: RoleBindingConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): RoleBindingMetadataOutputReference;
    putMetadata(value: RoleBindingMetadata): void;
    get metadataInput(): RoleBindingMetadata | undefined;
    private _roleRef;
    get roleRef(): RoleBindingRoleRefOutputReference;
    putRoleRef(value: RoleBindingRoleRef): void;
    get roleRefInput(): RoleBindingRoleRef | undefined;
    private _subject;
    get subject(): RoleBindingSubjectList;
    putSubject(value: RoleBindingSubject[] | cdktf.IResolvable): void;
    get subjectInput(): cdktf.IResolvable | RoleBindingSubject[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
