import * as cdktf from 'cdktf';
export interface ReplicationControllerMetadata {
    /**
    * An unstructured key value map stored with the replication controller that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#annotations ReplicationController#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#generate_name ReplicationController#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the replication controller. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#labels ReplicationController#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the replication controller, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the replication controller must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#namespace ReplicationController#namespace}
    */
    readonly namespace?: string;
}
export declare function replicationControllerMetadataToTerraform(struct?: ReplicationControllerMetadataOutputReference | ReplicationControllerMetadata): any;
export declare class ReplicationControllerMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerMetadata | undefined;
    set internalValue(value: ReplicationControllerMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface ReplicationControllerSpecTemplateMetadata {
    /**
    * An unstructured key value map stored with the replication controller's template that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#annotations ReplicationController#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#generate_name ReplicationController#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the replication controller's template. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#labels ReplicationController#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the replication controller's template, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the replication controller's template must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#namespace ReplicationController#namespace}
    */
    readonly namespace?: string;
}
export declare function replicationControllerSpecTemplateMetadataToTerraform(struct?: ReplicationControllerSpecTemplateMetadataOutputReference | ReplicationControllerSpecTemplateMetadata): any;
export declare class ReplicationControllerSpecTemplateMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateMetadata | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#key ReplicationController#key}
    */
    readonly key?: string;
    /**
    * Operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#operator ReplicationController#operator}
    */
    readonly operator?: string;
    /**
    * Values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#values ReplicationController#values}
    */
    readonly values?: string[];
}
export declare function replicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressionsToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressionsOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference {
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#match_expressions ReplicationController#match_expressions}
    */
    readonly matchExpressions?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceOutputReference | ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined);
    private _matchExpressions;
    get matchExpressions(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressionsList;
    putMatchExpressions(value: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
    * weight is in the range 1-100
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#weight ReplicationController#weight}
    */
    readonly weight: number;
    /**
    * preference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#preference ReplicationController#preference}
    */
    readonly preference: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference;
}
export declare function replicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined);
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _preference;
    get preference(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceOutputReference;
    putPreference(value: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference): void;
    get preferenceInput(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#key ReplicationController#key}
    */
    readonly key?: string;
    /**
    * Operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#operator ReplicationController#operator}
    */
    readonly operator?: string;
    /**
    * Values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#values ReplicationController#values}
    */
    readonly values?: string[];
}
export declare function replicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressionsToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressionsOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm {
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#match_expressions ReplicationController#match_expressions}
    */
    readonly matchExpressions?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm | cdktf.IResolvable | undefined);
    private _matchExpressions;
    get matchExpressions(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressionsList;
    putMatchExpressions(value: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
    * node_selector_term block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#node_selector_term ReplicationController#node_selector_term}
    */
    readonly nodeSelectorTerm?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference | ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined);
    private _nodeSelectorTerm;
    get nodeSelectorTerm(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermList;
    putNodeSelectorTerm(value: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm[] | cdktf.IResolvable): void;
    resetNodeSelectorTerm(): void;
    get nodeSelectorTermInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecAffinityNodeAffinity {
    /**
    * preferred_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#preferred_during_scheduling_ignored_during_execution ReplicationController#preferred_during_scheduling_ignored_during_execution}
    */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * required_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#required_during_scheduling_ignored_during_execution ReplicationController#required_during_scheduling_ignored_during_execution}
    */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution;
}
export declare function replicationControllerSpecTemplateSpecAffinityNodeAffinityToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityOutputReference | ReplicationControllerSpecTemplateSpecAffinityNodeAffinity): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityNodeAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinity | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityNodeAffinity | undefined);
    private _preferredDuringSchedulingIgnoredDuringExecution;
    get preferredDuringSchedulingIgnoredDuringExecution(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionList;
    putPreferredDuringSchedulingIgnoredDuringExecution(value: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable): void;
    resetPreferredDuringSchedulingIgnoredDuringExecution(): void;
    get preferredDuringSchedulingIgnoredDuringExecutionInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | undefined;
    private _requiredDuringSchedulingIgnoredDuringExecution;
    get requiredDuringSchedulingIgnoredDuringExecution(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference;
    putRequiredDuringSchedulingIgnoredDuringExecution(value: ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution): void;
    resetRequiredDuringSchedulingIgnoredDuringExecution(): void;
    get requiredDuringSchedulingIgnoredDuringExecutionInput(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#key ReplicationController#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#operator ReplicationController#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#values ReplicationController#values}
    */
    readonly values?: string[];
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#match_labels ReplicationController#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#match_expressions ReplicationController#match_expressions}
    */
    readonly matchExpressions?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
    * namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means 'this pod's namespace'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#namespaces ReplicationController#namespaces}
    */
    readonly namespaces?: string[];
    /**
    * empty topology key is interpreted by the scheduler as 'all topologies'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#topology_key ReplicationController#topology_key}
    */
    readonly topologyKey: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#label_selector ReplicationController#label_selector}
    */
    readonly labelSelector?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference | ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined);
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    resetNamespaces(): void;
    get namespacesInput(): string[] | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    get topologyKeyInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorList;
    putLabelSelector(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
    * weight associated with matching the corresponding podAffinityTerm, in the range 1-100
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#weight ReplicationController#weight}
    */
    readonly weight: number;
    /**
    * pod_affinity_term block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#pod_affinity_term ReplicationController#pod_affinity_term}
    */
    readonly podAffinityTerm: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined);
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _podAffinityTerm;
    get podAffinityTerm(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference;
    putPodAffinityTerm(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm): void;
    get podAffinityTermInput(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#key ReplicationController#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#operator ReplicationController#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#values ReplicationController#values}
    */
    readonly values?: string[];
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#match_labels ReplicationController#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#match_expressions ReplicationController#match_expressions}
    */
    readonly matchExpressions?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
    * namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means 'this pod's namespace'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#namespaces ReplicationController#namespaces}
    */
    readonly namespaces?: string[];
    /**
    * empty topology key is interpreted by the scheduler as 'all topologies'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#topology_key ReplicationController#topology_key}
    */
    readonly topologyKey: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#label_selector ReplicationController#label_selector}
    */
    readonly labelSelector?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined);
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    resetNamespaces(): void;
    get namespacesInput(): string[] | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    get topologyKeyInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorList;
    putLabelSelector(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAffinity {
    /**
    * preferred_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#preferred_during_scheduling_ignored_during_execution ReplicationController#preferred_during_scheduling_ignored_during_execution}
    */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * required_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#required_during_scheduling_ignored_during_execution ReplicationController#required_during_scheduling_ignored_during_execution}
    */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAffinityToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAffinityOutputReference | ReplicationControllerSpecTemplateSpecAffinityPodAffinity): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAffinity | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinity | undefined);
    private _preferredDuringSchedulingIgnoredDuringExecution;
    get preferredDuringSchedulingIgnoredDuringExecution(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionList;
    putPreferredDuringSchedulingIgnoredDuringExecution(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable): void;
    resetPreferredDuringSchedulingIgnoredDuringExecution(): void;
    get preferredDuringSchedulingIgnoredDuringExecutionInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | undefined;
    private _requiredDuringSchedulingIgnoredDuringExecution;
    get requiredDuringSchedulingIgnoredDuringExecution(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionList;
    putRequiredDuringSchedulingIgnoredDuringExecution(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable): void;
    resetRequiredDuringSchedulingIgnoredDuringExecution(): void;
    get requiredDuringSchedulingIgnoredDuringExecutionInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#key ReplicationController#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#operator ReplicationController#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#values ReplicationController#values}
    */
    readonly values?: string[];
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#match_labels ReplicationController#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#match_expressions ReplicationController#match_expressions}
    */
    readonly matchExpressions?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
    * namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means 'this pod's namespace'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#namespaces ReplicationController#namespaces}
    */
    readonly namespaces?: string[];
    /**
    * empty topology key is interpreted by the scheduler as 'all topologies'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#topology_key ReplicationController#topology_key}
    */
    readonly topologyKey: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#label_selector ReplicationController#label_selector}
    */
    readonly labelSelector?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference | ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined);
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    resetNamespaces(): void;
    get namespacesInput(): string[] | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    get topologyKeyInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorList;
    putLabelSelector(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
    * weight associated with matching the corresponding podAffinityTerm, in the range 1-100
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#weight ReplicationController#weight}
    */
    readonly weight: number;
    /**
    * pod_affinity_term block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#pod_affinity_term ReplicationController#pod_affinity_term}
    */
    readonly podAffinityTerm: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined);
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _podAffinityTerm;
    get podAffinityTerm(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference;
    putPodAffinityTerm(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm): void;
    get podAffinityTermInput(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#key ReplicationController#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#operator ReplicationController#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#values ReplicationController#values}
    */
    readonly values?: string[];
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#match_labels ReplicationController#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#match_expressions ReplicationController#match_expressions}
    */
    readonly matchExpressions?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
    * namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means 'this pod's namespace'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#namespaces ReplicationController#namespaces}
    */
    readonly namespaces?: string[];
    /**
    * empty topology key is interpreted by the scheduler as 'all topologies'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#topology_key ReplicationController#topology_key}
    */
    readonly topologyKey: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#label_selector ReplicationController#label_selector}
    */
    readonly labelSelector?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined);
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    resetNamespaces(): void;
    get namespacesInput(): string[] | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    get topologyKeyInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorList;
    putLabelSelector(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinity {
    /**
    * preferred_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#preferred_during_scheduling_ignored_during_execution ReplicationController#preferred_during_scheduling_ignored_during_execution}
    */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * required_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#required_during_scheduling_ignored_during_execution ReplicationController#required_during_scheduling_ignored_during_execution}
    */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecAffinityPodAntiAffinityToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityOutputReference | ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinity): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinity | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinity | undefined);
    private _preferredDuringSchedulingIgnoredDuringExecution;
    get preferredDuringSchedulingIgnoredDuringExecution(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionList;
    putPreferredDuringSchedulingIgnoredDuringExecution(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable): void;
    resetPreferredDuringSchedulingIgnoredDuringExecution(): void;
    get preferredDuringSchedulingIgnoredDuringExecutionInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | undefined;
    private _requiredDuringSchedulingIgnoredDuringExecution;
    get requiredDuringSchedulingIgnoredDuringExecution(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionList;
    putRequiredDuringSchedulingIgnoredDuringExecution(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable): void;
    resetRequiredDuringSchedulingIgnoredDuringExecution(): void;
    get requiredDuringSchedulingIgnoredDuringExecutionInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecAffinity {
    /**
    * node_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#node_affinity ReplicationController#node_affinity}
    */
    readonly nodeAffinity?: ReplicationControllerSpecTemplateSpecAffinityNodeAffinity;
    /**
    * pod_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#pod_affinity ReplicationController#pod_affinity}
    */
    readonly podAffinity?: ReplicationControllerSpecTemplateSpecAffinityPodAffinity;
    /**
    * pod_anti_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#pod_anti_affinity ReplicationController#pod_anti_affinity}
    */
    readonly podAntiAffinity?: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinity;
}
export declare function replicationControllerSpecTemplateSpecAffinityToTerraform(struct?: ReplicationControllerSpecTemplateSpecAffinityOutputReference | ReplicationControllerSpecTemplateSpecAffinity): any;
export declare class ReplicationControllerSpecTemplateSpecAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecAffinity | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecAffinity | undefined);
    private _nodeAffinity;
    get nodeAffinity(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinityOutputReference;
    putNodeAffinity(value: ReplicationControllerSpecTemplateSpecAffinityNodeAffinity): void;
    resetNodeAffinity(): void;
    get nodeAffinityInput(): ReplicationControllerSpecTemplateSpecAffinityNodeAffinity | undefined;
    private _podAffinity;
    get podAffinity(): ReplicationControllerSpecTemplateSpecAffinityPodAffinityOutputReference;
    putPodAffinity(value: ReplicationControllerSpecTemplateSpecAffinityPodAffinity): void;
    resetPodAffinity(): void;
    get podAffinityInput(): ReplicationControllerSpecTemplateSpecAffinityPodAffinity | undefined;
    private _podAntiAffinity;
    get podAntiAffinity(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinityOutputReference;
    putPodAntiAffinity(value: ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinity): void;
    resetPodAntiAffinity(): void;
    get podAntiAffinityInput(): ReplicationControllerSpecTemplateSpecAffinityPodAntiAffinity | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerEnvValueFromConfigMapKeyRef {
    /**
    * The key to select.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#key ReplicationController#key}
    */
    readonly key?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * Specify whether the ConfigMap or its key must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#optional ReplicationController#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerEnvValueFromConfigMapKeyRefToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerEnvValueFromConfigMapKeyRefOutputReference | ReplicationControllerSpecTemplateSpecContainerEnvValueFromConfigMapKeyRef): any;
export declare class ReplicationControllerSpecTemplateSpecContainerEnvValueFromConfigMapKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerEnvValueFromConfigMapKeyRef | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerEnvValueFromConfigMapKeyRef | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerEnvValueFromFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to "v1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#api_version ReplicationController#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#field_path ReplicationController#field_path}
    */
    readonly fieldPath?: string;
}
export declare function replicationControllerSpecTemplateSpecContainerEnvValueFromFieldRefToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerEnvValueFromFieldRefOutputReference | ReplicationControllerSpecTemplateSpecContainerEnvValueFromFieldRef): any;
export declare class ReplicationControllerSpecTemplateSpecContainerEnvValueFromFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerEnvValueFromFieldRef | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerEnvValueFromFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerEnvValueFromResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#container_name ReplicationController#container_name}
    */
    readonly containerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#divisor ReplicationController#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#resource ReplicationController#resource}
    */
    readonly resource: string;
}
export declare function replicationControllerSpecTemplateSpecContainerEnvValueFromResourceFieldRefToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerEnvValueFromResourceFieldRefOutputReference | ReplicationControllerSpecTemplateSpecContainerEnvValueFromResourceFieldRef): any;
export declare class ReplicationControllerSpecTemplateSpecContainerEnvValueFromResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerEnvValueFromResourceFieldRef | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerEnvValueFromResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    resetContainerName(): void;
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerEnvValueFromSecretKeyRef {
    /**
    * The key of the secret to select from. Must be a valid secret key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#key ReplicationController#key}
    */
    readonly key?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * Specify whether the Secret or its key must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#optional ReplicationController#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerEnvValueFromSecretKeyRefToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerEnvValueFromSecretKeyRefOutputReference | ReplicationControllerSpecTemplateSpecContainerEnvValueFromSecretKeyRef): any;
export declare class ReplicationControllerSpecTemplateSpecContainerEnvValueFromSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerEnvValueFromSecretKeyRef | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerEnvValueFromSecretKeyRef | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerEnvValueFrom {
    /**
    * config_map_key_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#config_map_key_ref ReplicationController#config_map_key_ref}
    */
    readonly configMapKeyRef?: ReplicationControllerSpecTemplateSpecContainerEnvValueFromConfigMapKeyRef;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#field_ref ReplicationController#field_ref}
    */
    readonly fieldRef?: ReplicationControllerSpecTemplateSpecContainerEnvValueFromFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#resource_field_ref ReplicationController#resource_field_ref}
    */
    readonly resourceFieldRef?: ReplicationControllerSpecTemplateSpecContainerEnvValueFromResourceFieldRef;
    /**
    * secret_key_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#secret_key_ref ReplicationController#secret_key_ref}
    */
    readonly secretKeyRef?: ReplicationControllerSpecTemplateSpecContainerEnvValueFromSecretKeyRef;
}
export declare function replicationControllerSpecTemplateSpecContainerEnvValueFromToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerEnvValueFromOutputReference | ReplicationControllerSpecTemplateSpecContainerEnvValueFrom): any;
export declare class ReplicationControllerSpecTemplateSpecContainerEnvValueFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerEnvValueFrom | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerEnvValueFrom | undefined);
    private _configMapKeyRef;
    get configMapKeyRef(): ReplicationControllerSpecTemplateSpecContainerEnvValueFromConfigMapKeyRefOutputReference;
    putConfigMapKeyRef(value: ReplicationControllerSpecTemplateSpecContainerEnvValueFromConfigMapKeyRef): void;
    resetConfigMapKeyRef(): void;
    get configMapKeyRefInput(): ReplicationControllerSpecTemplateSpecContainerEnvValueFromConfigMapKeyRef | undefined;
    private _fieldRef;
    get fieldRef(): ReplicationControllerSpecTemplateSpecContainerEnvValueFromFieldRefOutputReference;
    putFieldRef(value: ReplicationControllerSpecTemplateSpecContainerEnvValueFromFieldRef): void;
    resetFieldRef(): void;
    get fieldRefInput(): ReplicationControllerSpecTemplateSpecContainerEnvValueFromFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): ReplicationControllerSpecTemplateSpecContainerEnvValueFromResourceFieldRefOutputReference;
    putResourceFieldRef(value: ReplicationControllerSpecTemplateSpecContainerEnvValueFromResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): ReplicationControllerSpecTemplateSpecContainerEnvValueFromResourceFieldRef | undefined;
    private _secretKeyRef;
    get secretKeyRef(): ReplicationControllerSpecTemplateSpecContainerEnvValueFromSecretKeyRefOutputReference;
    putSecretKeyRef(value: ReplicationControllerSpecTemplateSpecContainerEnvValueFromSecretKeyRef): void;
    resetSecretKeyRef(): void;
    get secretKeyRefInput(): ReplicationControllerSpecTemplateSpecContainerEnvValueFromSecretKeyRef | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerEnv {
    /**
    * Name of the environment variable. Must be a C_IDENTIFIER
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name: string;
    /**
    * Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#value ReplicationController#value}
    */
    readonly value?: string;
    /**
    * value_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#value_from ReplicationController#value_from}
    */
    readonly valueFrom?: ReplicationControllerSpecTemplateSpecContainerEnvValueFrom;
}
export declare function replicationControllerSpecTemplateSpecContainerEnvToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerEnv | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerEnv | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerEnv | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _valueFrom;
    get valueFrom(): ReplicationControllerSpecTemplateSpecContainerEnvValueFromOutputReference;
    putValueFrom(value: ReplicationControllerSpecTemplateSpecContainerEnvValueFrom): void;
    resetValueFrom(): void;
    get valueFromInput(): ReplicationControllerSpecTemplateSpecContainerEnvValueFrom | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerEnvOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerEnvFromConfigMapRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name: string;
    /**
    * Specify whether the ConfigMap must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#optional ReplicationController#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerEnvFromConfigMapRefToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerEnvFromConfigMapRefOutputReference | ReplicationControllerSpecTemplateSpecContainerEnvFromConfigMapRef): any;
export declare class ReplicationControllerSpecTemplateSpecContainerEnvFromConfigMapRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerEnvFromConfigMapRef | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerEnvFromConfigMapRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerEnvFromSecretRef {
    /**
    * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name: string;
    /**
    * Specify whether the Secret must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#optional ReplicationController#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerEnvFromSecretRefToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerEnvFromSecretRefOutputReference | ReplicationControllerSpecTemplateSpecContainerEnvFromSecretRef): any;
export declare class ReplicationControllerSpecTemplateSpecContainerEnvFromSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerEnvFromSecretRef | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerEnvFromSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerEnvFrom {
    /**
    * An optional identifer to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#prefix ReplicationController#prefix}
    */
    readonly prefix?: string;
    /**
    * config_map_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#config_map_ref ReplicationController#config_map_ref}
    */
    readonly configMapRef?: ReplicationControllerSpecTemplateSpecContainerEnvFromConfigMapRef;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#secret_ref ReplicationController#secret_ref}
    */
    readonly secretRef?: ReplicationControllerSpecTemplateSpecContainerEnvFromSecretRef;
}
export declare function replicationControllerSpecTemplateSpecContainerEnvFromToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerEnvFrom | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerEnvFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerEnvFrom | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerEnvFrom | cdktf.IResolvable | undefined);
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    private _configMapRef;
    get configMapRef(): ReplicationControllerSpecTemplateSpecContainerEnvFromConfigMapRefOutputReference;
    putConfigMapRef(value: ReplicationControllerSpecTemplateSpecContainerEnvFromConfigMapRef): void;
    resetConfigMapRef(): void;
    get configMapRefInput(): ReplicationControllerSpecTemplateSpecContainerEnvFromConfigMapRef | undefined;
    private _secretRef;
    get secretRef(): ReplicationControllerSpecTemplateSpecContainerEnvFromSecretRefOutputReference;
    putSecretRef(value: ReplicationControllerSpecTemplateSpecContainerEnvFromSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): ReplicationControllerSpecTemplateSpecContainerEnvFromSecretRef | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerEnvFromList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerEnvFrom[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerEnvFromOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#command ReplicationController#command}
    */
    readonly command?: string[];
}
export declare function replicationControllerSpecTemplateSpecContainerLifecyclePostStartExecToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartExecOutputReference | ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartExec): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartExec | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#value ReplicationController#value}
    */
    readonly value?: string;
}
export declare function replicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeaderToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeaderOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#host ReplicationController#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#path ReplicationController#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#scheme ReplicationController#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_header ReplicationController#http_header}
    */
    readonly httpHeader?: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetOutputReference | ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGet): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGet | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeaderList;
    putHttpHeader(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port: string;
}
export declare function replicationControllerSpecTemplateSpecContainerLifecyclePostStartTcpSocketToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartTcpSocket | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartTcpSocketOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerLifecyclePostStart {
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#exec ReplicationController#exec}
    */
    readonly exec?: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_get ReplicationController#http_get}
    */
    readonly httpGet?: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#tcp_socket ReplicationController#tcp_socket}
    */
    readonly tcpSocket?: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerLifecyclePostStartToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStart | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLifecyclePostStart | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStart | cdktf.IResolvable | undefined);
    private _exec;
    get exec(): ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartExecOutputReference;
    putExec(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartExec): void;
    resetExec(): void;
    get execInput(): ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartExec | undefined;
    private _httpGet;
    get httpGet(): ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGetOutputReference;
    putHttpGet(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartTcpSocketList;
    putTcpSocket(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartTcpSocket[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStart[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#command ReplicationController#command}
    */
    readonly command?: string[];
}
export declare function replicationControllerSpecTemplateSpecContainerLifecyclePreStopExecToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopExecOutputReference | ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopExec): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopExec | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#value ReplicationController#value}
    */
    readonly value?: string;
}
export declare function replicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeaderToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeaderOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#host ReplicationController#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#path ReplicationController#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#scheme ReplicationController#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_header ReplicationController#http_header}
    */
    readonly httpHeader?: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetOutputReference | ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGet): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGet | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeaderList;
    putHttpHeader(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port: string;
}
export declare function replicationControllerSpecTemplateSpecContainerLifecyclePreStopTcpSocketToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopTcpSocket | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopTcpSocketOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerLifecyclePreStop {
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#exec ReplicationController#exec}
    */
    readonly exec?: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_get ReplicationController#http_get}
    */
    readonly httpGet?: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#tcp_socket ReplicationController#tcp_socket}
    */
    readonly tcpSocket?: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerLifecyclePreStopToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStop | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLifecyclePreStop | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStop | cdktf.IResolvable | undefined);
    private _exec;
    get exec(): ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopExecOutputReference;
    putExec(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopExec): void;
    resetExec(): void;
    get execInput(): ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopExec | undefined;
    private _httpGet;
    get httpGet(): ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGetOutputReference;
    putHttpGet(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopTcpSocketList;
    putTcpSocket(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopTcpSocket[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStop[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerLifecycle {
    /**
    * post_start block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#post_start ReplicationController#post_start}
    */
    readonly postStart?: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStart[] | cdktf.IResolvable;
    /**
    * pre_stop block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#pre_stop ReplicationController#pre_stop}
    */
    readonly preStop?: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStop[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerLifecycleToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLifecycleOutputReference | ReplicationControllerSpecTemplateSpecContainerLifecycle): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLifecycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLifecycle | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLifecycle | undefined);
    private _postStart;
    get postStart(): ReplicationControllerSpecTemplateSpecContainerLifecyclePostStartList;
    putPostStart(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePostStart[] | cdktf.IResolvable): void;
    resetPostStart(): void;
    get postStartInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerLifecyclePostStart[] | undefined;
    private _preStop;
    get preStop(): ReplicationControllerSpecTemplateSpecContainerLifecyclePreStopList;
    putPreStop(value: ReplicationControllerSpecTemplateSpecContainerLifecyclePreStop[] | cdktf.IResolvable): void;
    resetPreStop(): void;
    get preStopInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerLifecyclePreStop[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerLivenessProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#command ReplicationController#command}
    */
    readonly command?: string[];
}
export declare function replicationControllerSpecTemplateSpecContainerLivenessProbeExecToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLivenessProbeExecOutputReference | ReplicationControllerSpecTemplateSpecContainerLivenessProbeExec): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLivenessProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLivenessProbeExec | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLivenessProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerLivenessProbeGrpc {
    /**
    * Number of the port to access on the container. Number must be in the range 1 to 65535.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port: number;
    /**
    * Name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md). If this is not specified, the default behavior is defined by gRPC.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#service ReplicationController#service}
    */
    readonly service?: string;
}
export declare function replicationControllerSpecTemplateSpecContainerLivenessProbeGrpcToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLivenessProbeGrpc | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLivenessProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLivenessProbeGrpc | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLivenessProbeGrpc | cdktf.IResolvable | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerLivenessProbeGrpcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerLivenessProbeGrpc[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerLivenessProbeGrpcOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#value ReplicationController#value}
    */
    readonly value?: string;
}
export declare function replicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeaderToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeaderOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#host ReplicationController#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#path ReplicationController#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#scheme ReplicationController#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_header ReplicationController#http_header}
    */
    readonly httpHeader?: ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetOutputReference | ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGet): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGet | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeaderList;
    putHttpHeader(value: ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerLivenessProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port: string;
}
export declare function replicationControllerSpecTemplateSpecContainerLivenessProbeTcpSocketToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLivenessProbeTcpSocket | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLivenessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLivenessProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLivenessProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerLivenessProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerLivenessProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerLivenessProbeTcpSocketOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerLivenessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#failure_threshold ReplicationController#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#initial_delay_seconds ReplicationController#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#period_seconds ReplicationController#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#success_threshold ReplicationController#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#timeout_seconds ReplicationController#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#exec ReplicationController#exec}
    */
    readonly exec?: ReplicationControllerSpecTemplateSpecContainerLivenessProbeExec;
    /**
    * grpc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#grpc ReplicationController#grpc}
    */
    readonly grpc?: ReplicationControllerSpecTemplateSpecContainerLivenessProbeGrpc[] | cdktf.IResolvable;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_get ReplicationController#http_get}
    */
    readonly httpGet?: ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#tcp_socket ReplicationController#tcp_socket}
    */
    readonly tcpSocket?: ReplicationControllerSpecTemplateSpecContainerLivenessProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerLivenessProbeToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerLivenessProbeOutputReference | ReplicationControllerSpecTemplateSpecContainerLivenessProbe): any;
export declare class ReplicationControllerSpecTemplateSpecContainerLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerLivenessProbe | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerLivenessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): ReplicationControllerSpecTemplateSpecContainerLivenessProbeExecOutputReference;
    putExec(value: ReplicationControllerSpecTemplateSpecContainerLivenessProbeExec): void;
    resetExec(): void;
    get execInput(): ReplicationControllerSpecTemplateSpecContainerLivenessProbeExec | undefined;
    private _grpc;
    get grpc(): ReplicationControllerSpecTemplateSpecContainerLivenessProbeGrpcList;
    putGrpc(value: ReplicationControllerSpecTemplateSpecContainerLivenessProbeGrpc[] | cdktf.IResolvable): void;
    resetGrpc(): void;
    get grpcInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerLivenessProbeGrpc[] | undefined;
    private _httpGet;
    get httpGet(): ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGetOutputReference;
    putHttpGet(value: ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): ReplicationControllerSpecTemplateSpecContainerLivenessProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): ReplicationControllerSpecTemplateSpecContainerLivenessProbeTcpSocketList;
    putTcpSocket(value: ReplicationControllerSpecTemplateSpecContainerLivenessProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerLivenessProbeTcpSocket[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerPort {
    /**
    * Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#container_port ReplicationController#container_port}
    */
    readonly containerPort: number;
    /**
    * What host IP to bind the external port to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#host_ip ReplicationController#host_ip}
    */
    readonly hostIp?: string;
    /**
    * Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#host_port ReplicationController#host_port}
    */
    readonly hostPort?: number;
    /**
    * If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * Protocol for port. Must be UDP or TCP. Defaults to "TCP".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#protocol ReplicationController#protocol}
    */
    readonly protocol?: string;
}
export declare function replicationControllerSpecTemplateSpecContainerPortToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerPort | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerPortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerPort | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerPort | cdktf.IResolvable | undefined);
    private _containerPort?;
    get containerPort(): number;
    set containerPort(value: number);
    get containerPortInput(): number | undefined;
    private _hostIp?;
    get hostIp(): string;
    set hostIp(value: string);
    resetHostIp(): void;
    get hostIpInput(): string | undefined;
    private _hostPort?;
    get hostPort(): number;
    set hostPort(value: number);
    resetHostPort(): void;
    get hostPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerPortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerPort[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerPortOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerReadinessProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#command ReplicationController#command}
    */
    readonly command?: string[];
}
export declare function replicationControllerSpecTemplateSpecContainerReadinessProbeExecToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerReadinessProbeExecOutputReference | ReplicationControllerSpecTemplateSpecContainerReadinessProbeExec): any;
export declare class ReplicationControllerSpecTemplateSpecContainerReadinessProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerReadinessProbeExec | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerReadinessProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerReadinessProbeGrpc {
    /**
    * Number of the port to access on the container. Number must be in the range 1 to 65535.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port: number;
    /**
    * Name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md). If this is not specified, the default behavior is defined by gRPC.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#service ReplicationController#service}
    */
    readonly service?: string;
}
export declare function replicationControllerSpecTemplateSpecContainerReadinessProbeGrpcToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerReadinessProbeGrpc | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerReadinessProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerReadinessProbeGrpc | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerReadinessProbeGrpc | cdktf.IResolvable | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerReadinessProbeGrpcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerReadinessProbeGrpc[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerReadinessProbeGrpcOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#value ReplicationController#value}
    */
    readonly value?: string;
}
export declare function replicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeaderToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeaderOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#host ReplicationController#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#path ReplicationController#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#scheme ReplicationController#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_header ReplicationController#http_header}
    */
    readonly httpHeader?: ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetOutputReference | ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGet): any;
export declare class ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGet | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeaderList;
    putHttpHeader(value: ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerReadinessProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port: string;
}
export declare function replicationControllerSpecTemplateSpecContainerReadinessProbeTcpSocketToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerReadinessProbeTcpSocket | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerReadinessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerReadinessProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerReadinessProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerReadinessProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerReadinessProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerReadinessProbeTcpSocketOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerReadinessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#failure_threshold ReplicationController#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#initial_delay_seconds ReplicationController#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#period_seconds ReplicationController#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#success_threshold ReplicationController#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#timeout_seconds ReplicationController#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#exec ReplicationController#exec}
    */
    readonly exec?: ReplicationControllerSpecTemplateSpecContainerReadinessProbeExec;
    /**
    * grpc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#grpc ReplicationController#grpc}
    */
    readonly grpc?: ReplicationControllerSpecTemplateSpecContainerReadinessProbeGrpc[] | cdktf.IResolvable;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_get ReplicationController#http_get}
    */
    readonly httpGet?: ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#tcp_socket ReplicationController#tcp_socket}
    */
    readonly tcpSocket?: ReplicationControllerSpecTemplateSpecContainerReadinessProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerReadinessProbeToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerReadinessProbeOutputReference | ReplicationControllerSpecTemplateSpecContainerReadinessProbe): any;
export declare class ReplicationControllerSpecTemplateSpecContainerReadinessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerReadinessProbe | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerReadinessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): ReplicationControllerSpecTemplateSpecContainerReadinessProbeExecOutputReference;
    putExec(value: ReplicationControllerSpecTemplateSpecContainerReadinessProbeExec): void;
    resetExec(): void;
    get execInput(): ReplicationControllerSpecTemplateSpecContainerReadinessProbeExec | undefined;
    private _grpc;
    get grpc(): ReplicationControllerSpecTemplateSpecContainerReadinessProbeGrpcList;
    putGrpc(value: ReplicationControllerSpecTemplateSpecContainerReadinessProbeGrpc[] | cdktf.IResolvable): void;
    resetGrpc(): void;
    get grpcInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerReadinessProbeGrpc[] | undefined;
    private _httpGet;
    get httpGet(): ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGetOutputReference;
    putHttpGet(value: ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): ReplicationControllerSpecTemplateSpecContainerReadinessProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): ReplicationControllerSpecTemplateSpecContainerReadinessProbeTcpSocketList;
    putTcpSocket(value: ReplicationControllerSpecTemplateSpecContainerReadinessProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerReadinessProbeTcpSocket[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerResources {
    /**
    * Describes the maximum amount of compute resources allowed. More info: http://kubernetes.io/docs/user-guide/compute-resources/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#limits ReplicationController#limits}
    */
    readonly limits?: {
        [key: string]: string;
    };
    /**
    * Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#requests ReplicationController#requests}
    */
    readonly requests?: {
        [key: string]: string;
    };
}
export declare function replicationControllerSpecTemplateSpecContainerResourcesToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerResourcesOutputReference | ReplicationControllerSpecTemplateSpecContainerResources): any;
export declare class ReplicationControllerSpecTemplateSpecContainerResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerResources | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerResources | undefined);
    private _limits?;
    get limits(): {
        [key: string]: string;
    };
    set limits(value: {
        [key: string]: string;
    });
    resetLimits(): void;
    get limitsInput(): {
        [key: string]: string;
    } | undefined;
    private _requests?;
    get requests(): {
        [key: string]: string;
    };
    set requests(value: {
        [key: string]: string;
    });
    resetRequests(): void;
    get requestsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerSecurityContextCapabilities {
    /**
    * Added capabilities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#add ReplicationController#add}
    */
    readonly add?: string[];
    /**
    * Removed capabilities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#drop ReplicationController#drop}
    */
    readonly drop?: string[];
}
export declare function replicationControllerSpecTemplateSpecContainerSecurityContextCapabilitiesToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerSecurityContextCapabilitiesOutputReference | ReplicationControllerSpecTemplateSpecContainerSecurityContextCapabilities): any;
export declare class ReplicationControllerSpecTemplateSpecContainerSecurityContextCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerSecurityContextCapabilities | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerSecurityContextCapabilities | undefined);
    private _add?;
    get add(): string[];
    set add(value: string[]);
    resetAdd(): void;
    get addInput(): string[] | undefined;
    private _drop?;
    get drop(): string[];
    set drop(value: string[]);
    resetDrop(): void;
    get dropInput(): string[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerSecurityContextSeLinuxOptions {
    /**
    * Level is SELinux level label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#level ReplicationController#level}
    */
    readonly level?: string;
    /**
    * Role is a SELinux role label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#role ReplicationController#role}
    */
    readonly role?: string;
    /**
    * Type is a SELinux type label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#type ReplicationController#type}
    */
    readonly type?: string;
    /**
    * User is a SELinux user label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#user ReplicationController#user}
    */
    readonly user?: string;
}
export declare function replicationControllerSpecTemplateSpecContainerSecurityContextSeLinuxOptionsToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerSecurityContextSeLinuxOptionsOutputReference | ReplicationControllerSpecTemplateSpecContainerSecurityContextSeLinuxOptions): any;
export declare class ReplicationControllerSpecTemplateSpecContainerSecurityContextSeLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerSecurityContextSeLinuxOptions | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerSecurityContextSeLinuxOptions | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerSecurityContextSeccompProfile {
    /**
    * Localhost Profile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#localhost_profile ReplicationController#localhost_profile}
    */
    readonly localhostProfile?: string;
    /**
    * Type indicates which kind of seccomp profile will be applied. Valid options are: Localhost, RuntimeDefault, Unconfined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#type ReplicationController#type}
    */
    readonly type?: string;
}
export declare function replicationControllerSpecTemplateSpecContainerSecurityContextSeccompProfileToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerSecurityContextSeccompProfileOutputReference | ReplicationControllerSpecTemplateSpecContainerSecurityContextSeccompProfile): any;
export declare class ReplicationControllerSpecTemplateSpecContainerSecurityContextSeccompProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerSecurityContextSeccompProfile | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerSecurityContextSeccompProfile | undefined);
    private _localhostProfile?;
    get localhostProfile(): string;
    set localhostProfile(value: string);
    resetLocalhostProfile(): void;
    get localhostProfileInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerSecurityContext {
    /**
    * AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#allow_privilege_escalation ReplicationController#allow_privilege_escalation}
    */
    readonly allowPrivilegeEscalation?: boolean | cdktf.IResolvable;
    /**
    * Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#privileged ReplicationController#privileged}
    */
    readonly privileged?: boolean | cdktf.IResolvable;
    /**
    * Whether this container has a read-only root filesystem. Default is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#read_only_root_filesystem ReplicationController#read_only_root_filesystem}
    */
    readonly readOnlyRootFilesystem?: boolean | cdktf.IResolvable;
    /**
    * The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#run_as_group ReplicationController#run_as_group}
    */
    readonly runAsGroup?: string;
    /**
    * Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#run_as_non_root ReplicationController#run_as_non_root}
    */
    readonly runAsNonRoot?: boolean | cdktf.IResolvable;
    /**
    * The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#run_as_user ReplicationController#run_as_user}
    */
    readonly runAsUser?: string;
    /**
    * capabilities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#capabilities ReplicationController#capabilities}
    */
    readonly capabilities?: ReplicationControllerSpecTemplateSpecContainerSecurityContextCapabilities;
    /**
    * se_linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#se_linux_options ReplicationController#se_linux_options}
    */
    readonly seLinuxOptions?: ReplicationControllerSpecTemplateSpecContainerSecurityContextSeLinuxOptions;
    /**
    * seccomp_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#seccomp_profile ReplicationController#seccomp_profile}
    */
    readonly seccompProfile?: ReplicationControllerSpecTemplateSpecContainerSecurityContextSeccompProfile;
}
export declare function replicationControllerSpecTemplateSpecContainerSecurityContextToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerSecurityContextOutputReference | ReplicationControllerSpecTemplateSpecContainerSecurityContext): any;
export declare class ReplicationControllerSpecTemplateSpecContainerSecurityContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerSecurityContext | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerSecurityContext | undefined);
    private _allowPrivilegeEscalation?;
    get allowPrivilegeEscalation(): boolean | cdktf.IResolvable;
    set allowPrivilegeEscalation(value: boolean | cdktf.IResolvable);
    resetAllowPrivilegeEscalation(): void;
    get allowPrivilegeEscalationInput(): boolean | cdktf.IResolvable | undefined;
    private _privileged?;
    get privileged(): boolean | cdktf.IResolvable;
    set privileged(value: boolean | cdktf.IResolvable);
    resetPrivileged(): void;
    get privilegedInput(): boolean | cdktf.IResolvable | undefined;
    private _readOnlyRootFilesystem?;
    get readOnlyRootFilesystem(): boolean | cdktf.IResolvable;
    set readOnlyRootFilesystem(value: boolean | cdktf.IResolvable);
    resetReadOnlyRootFilesystem(): void;
    get readOnlyRootFilesystemInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsGroup?;
    get runAsGroup(): string;
    set runAsGroup(value: string);
    resetRunAsGroup(): void;
    get runAsGroupInput(): string | undefined;
    private _runAsNonRoot?;
    get runAsNonRoot(): boolean | cdktf.IResolvable;
    set runAsNonRoot(value: boolean | cdktf.IResolvable);
    resetRunAsNonRoot(): void;
    get runAsNonRootInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsUser?;
    get runAsUser(): string;
    set runAsUser(value: string);
    resetRunAsUser(): void;
    get runAsUserInput(): string | undefined;
    private _capabilities;
    get capabilities(): ReplicationControllerSpecTemplateSpecContainerSecurityContextCapabilitiesOutputReference;
    putCapabilities(value: ReplicationControllerSpecTemplateSpecContainerSecurityContextCapabilities): void;
    resetCapabilities(): void;
    get capabilitiesInput(): ReplicationControllerSpecTemplateSpecContainerSecurityContextCapabilities | undefined;
    private _seLinuxOptions;
    get seLinuxOptions(): ReplicationControllerSpecTemplateSpecContainerSecurityContextSeLinuxOptionsOutputReference;
    putSeLinuxOptions(value: ReplicationControllerSpecTemplateSpecContainerSecurityContextSeLinuxOptions): void;
    resetSeLinuxOptions(): void;
    get seLinuxOptionsInput(): ReplicationControllerSpecTemplateSpecContainerSecurityContextSeLinuxOptions | undefined;
    private _seccompProfile;
    get seccompProfile(): ReplicationControllerSpecTemplateSpecContainerSecurityContextSeccompProfileOutputReference;
    putSeccompProfile(value: ReplicationControllerSpecTemplateSpecContainerSecurityContextSeccompProfile): void;
    resetSeccompProfile(): void;
    get seccompProfileInput(): ReplicationControllerSpecTemplateSpecContainerSecurityContextSeccompProfile | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerStartupProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#command ReplicationController#command}
    */
    readonly command?: string[];
}
export declare function replicationControllerSpecTemplateSpecContainerStartupProbeExecToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerStartupProbeExecOutputReference | ReplicationControllerSpecTemplateSpecContainerStartupProbeExec): any;
export declare class ReplicationControllerSpecTemplateSpecContainerStartupProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerStartupProbeExec | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerStartupProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerStartupProbeGrpc {
    /**
    * Number of the port to access on the container. Number must be in the range 1 to 65535.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port: number;
    /**
    * Name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md). If this is not specified, the default behavior is defined by gRPC.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#service ReplicationController#service}
    */
    readonly service?: string;
}
export declare function replicationControllerSpecTemplateSpecContainerStartupProbeGrpcToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerStartupProbeGrpc | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerStartupProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerStartupProbeGrpc | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerStartupProbeGrpc | cdktf.IResolvable | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerStartupProbeGrpcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerStartupProbeGrpc[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerStartupProbeGrpcOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#value ReplicationController#value}
    */
    readonly value?: string;
}
export declare function replicationControllerSpecTemplateSpecContainerStartupProbeHttpGetHttpHeaderToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGetHttpHeaderOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#host ReplicationController#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#path ReplicationController#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#scheme ReplicationController#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_header ReplicationController#http_header}
    */
    readonly httpHeader?: ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerStartupProbeHttpGetToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGetOutputReference | ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGet): any;
export declare class ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGet | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGetHttpHeaderList;
    putHttpHeader(value: ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerStartupProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port: string;
}
export declare function replicationControllerSpecTemplateSpecContainerStartupProbeTcpSocketToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerStartupProbeTcpSocket | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerStartupProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerStartupProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerStartupProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerStartupProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerStartupProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerStartupProbeTcpSocketOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainerStartupProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#failure_threshold ReplicationController#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#initial_delay_seconds ReplicationController#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#period_seconds ReplicationController#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#success_threshold ReplicationController#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#timeout_seconds ReplicationController#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#exec ReplicationController#exec}
    */
    readonly exec?: ReplicationControllerSpecTemplateSpecContainerStartupProbeExec;
    /**
    * grpc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#grpc ReplicationController#grpc}
    */
    readonly grpc?: ReplicationControllerSpecTemplateSpecContainerStartupProbeGrpc[] | cdktf.IResolvable;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_get ReplicationController#http_get}
    */
    readonly httpGet?: ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#tcp_socket ReplicationController#tcp_socket}
    */
    readonly tcpSocket?: ReplicationControllerSpecTemplateSpecContainerStartupProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerStartupProbeToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerStartupProbeOutputReference | ReplicationControllerSpecTemplateSpecContainerStartupProbe): any;
export declare class ReplicationControllerSpecTemplateSpecContainerStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerStartupProbe | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerStartupProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): ReplicationControllerSpecTemplateSpecContainerStartupProbeExecOutputReference;
    putExec(value: ReplicationControllerSpecTemplateSpecContainerStartupProbeExec): void;
    resetExec(): void;
    get execInput(): ReplicationControllerSpecTemplateSpecContainerStartupProbeExec | undefined;
    private _grpc;
    get grpc(): ReplicationControllerSpecTemplateSpecContainerStartupProbeGrpcList;
    putGrpc(value: ReplicationControllerSpecTemplateSpecContainerStartupProbeGrpc[] | cdktf.IResolvable): void;
    resetGrpc(): void;
    get grpcInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerStartupProbeGrpc[] | undefined;
    private _httpGet;
    get httpGet(): ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGetOutputReference;
    putHttpGet(value: ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): ReplicationControllerSpecTemplateSpecContainerStartupProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): ReplicationControllerSpecTemplateSpecContainerStartupProbeTcpSocketList;
    putTcpSocket(value: ReplicationControllerSpecTemplateSpecContainerStartupProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerStartupProbeTcpSocket[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecContainerVolumeMount {
    /**
    * Path within the container at which the volume should be mounted. Must not contain ':'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#mount_path ReplicationController#mount_path}
    */
    readonly mountPath: string;
    /**
    * Mount propagation mode. mount_propagation determines how mounts are propagated from the host to container and the other way around. Valid values are None (default), HostToContainer and Bidirectional.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#mount_propagation ReplicationController#mount_propagation}
    */
    readonly mountPropagation?: string;
    /**
    * This must match the Name of a Volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name: string;
    /**
    * Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#read_only ReplicationController#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#sub_path ReplicationController#sub_path}
    */
    readonly subPath?: string;
}
export declare function replicationControllerSpecTemplateSpecContainerVolumeMountToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainerVolumeMount | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerVolumeMountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainerVolumeMount | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainerVolumeMount | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _mountPropagation?;
    get mountPropagation(): string;
    set mountPropagation(value: string);
    resetMountPropagation(): void;
    get mountPropagationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _subPath?;
    get subPath(): string;
    set subPath(value: string);
    resetSubPath(): void;
    get subPathInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerVolumeMountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainerVolumeMount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerVolumeMountOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecContainer {
    /**
    * Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#args ReplicationController#args}
    */
    readonly args?: string[];
    /**
    * Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#command ReplicationController#command}
    */
    readonly command?: string[];
    /**
    * Docker image name. More info: http://kubernetes.io/docs/user-guide/images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#image ReplicationController#image}
    */
    readonly image?: string;
    /**
    * Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/images#updating-images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#image_pull_policy ReplicationController#image_pull_policy}
    */
    readonly imagePullPolicy?: string;
    /**
    * Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name: string;
    /**
    * Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#stdin ReplicationController#stdin}
    */
    readonly stdin?: boolean | cdktf.IResolvable;
    /**
    * Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#stdin_once ReplicationController#stdin_once}
    */
    readonly stdinOnce?: boolean | cdktf.IResolvable;
    /**
    * Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Defaults to /dev/termination-log. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#termination_message_path ReplicationController#termination_message_path}
    */
    readonly terminationMessagePath?: string;
    /**
    * Optional: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#termination_message_policy ReplicationController#termination_message_policy}
    */
    readonly terminationMessagePolicy?: string;
    /**
    * Whether this container should allocate a TTY for itself
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#tty ReplicationController#tty}
    */
    readonly tty?: boolean | cdktf.IResolvable;
    /**
    * Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#working_dir ReplicationController#working_dir}
    */
    readonly workingDir?: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#env ReplicationController#env}
    */
    readonly env?: ReplicationControllerSpecTemplateSpecContainerEnv[] | cdktf.IResolvable;
    /**
    * env_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#env_from ReplicationController#env_from}
    */
    readonly envFrom?: ReplicationControllerSpecTemplateSpecContainerEnvFrom[] | cdktf.IResolvable;
    /**
    * lifecycle block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#lifecycle ReplicationController#lifecycle}
    */
    readonly lifecycle?: ReplicationControllerSpecTemplateSpecContainerLifecycle;
    /**
    * liveness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#liveness_probe ReplicationController#liveness_probe}
    */
    readonly livenessProbe?: ReplicationControllerSpecTemplateSpecContainerLivenessProbe;
    /**
    * port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port?: ReplicationControllerSpecTemplateSpecContainerPort[] | cdktf.IResolvable;
    /**
    * readiness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#readiness_probe ReplicationController#readiness_probe}
    */
    readonly readinessProbe?: ReplicationControllerSpecTemplateSpecContainerReadinessProbe;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#resources ReplicationController#resources}
    */
    readonly resources?: ReplicationControllerSpecTemplateSpecContainerResources;
    /**
    * security_context block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#security_context ReplicationController#security_context}
    */
    readonly securityContext?: ReplicationControllerSpecTemplateSpecContainerSecurityContext;
    /**
    * startup_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#startup_probe ReplicationController#startup_probe}
    */
    readonly startupProbe?: ReplicationControllerSpecTemplateSpecContainerStartupProbe;
    /**
    * volume_mount block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#volume_mount ReplicationController#volume_mount}
    */
    readonly volumeMount?: ReplicationControllerSpecTemplateSpecContainerVolumeMount[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecContainerToTerraform(struct?: ReplicationControllerSpecTemplateSpecContainer | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecContainer | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecContainer | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _imagePullPolicy?;
    get imagePullPolicy(): string;
    set imagePullPolicy(value: string);
    resetImagePullPolicy(): void;
    get imagePullPolicyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _stdin?;
    get stdin(): boolean | cdktf.IResolvable;
    set stdin(value: boolean | cdktf.IResolvable);
    resetStdin(): void;
    get stdinInput(): boolean | cdktf.IResolvable | undefined;
    private _stdinOnce?;
    get stdinOnce(): boolean | cdktf.IResolvable;
    set stdinOnce(value: boolean | cdktf.IResolvable);
    resetStdinOnce(): void;
    get stdinOnceInput(): boolean | cdktf.IResolvable | undefined;
    private _terminationMessagePath?;
    get terminationMessagePath(): string;
    set terminationMessagePath(value: string);
    resetTerminationMessagePath(): void;
    get terminationMessagePathInput(): string | undefined;
    private _terminationMessagePolicy?;
    get terminationMessagePolicy(): string;
    set terminationMessagePolicy(value: string);
    resetTerminationMessagePolicy(): void;
    get terminationMessagePolicyInput(): string | undefined;
    private _tty?;
    get tty(): boolean | cdktf.IResolvable;
    set tty(value: boolean | cdktf.IResolvable);
    resetTty(): void;
    get ttyInput(): boolean | cdktf.IResolvable | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
    private _env;
    get env(): ReplicationControllerSpecTemplateSpecContainerEnvList;
    putEnv(value: ReplicationControllerSpecTemplateSpecContainerEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerEnv[] | undefined;
    private _envFrom;
    get envFrom(): ReplicationControllerSpecTemplateSpecContainerEnvFromList;
    putEnvFrom(value: ReplicationControllerSpecTemplateSpecContainerEnvFrom[] | cdktf.IResolvable): void;
    resetEnvFrom(): void;
    get envFromInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerEnvFrom[] | undefined;
    private _lifecycle;
    get lifecycle(): ReplicationControllerSpecTemplateSpecContainerLifecycleOutputReference;
    putLifecycle(value: ReplicationControllerSpecTemplateSpecContainerLifecycle): void;
    resetLifecycle(): void;
    get lifecycleInput(): ReplicationControllerSpecTemplateSpecContainerLifecycle | undefined;
    private _livenessProbe;
    get livenessProbe(): ReplicationControllerSpecTemplateSpecContainerLivenessProbeOutputReference;
    putLivenessProbe(value: ReplicationControllerSpecTemplateSpecContainerLivenessProbe): void;
    resetLivenessProbe(): void;
    get livenessProbeInput(): ReplicationControllerSpecTemplateSpecContainerLivenessProbe | undefined;
    private _port;
    get port(): ReplicationControllerSpecTemplateSpecContainerPortList;
    putPort(value: ReplicationControllerSpecTemplateSpecContainerPort[] | cdktf.IResolvable): void;
    resetPort(): void;
    get portInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerPort[] | undefined;
    private _readinessProbe;
    get readinessProbe(): ReplicationControllerSpecTemplateSpecContainerReadinessProbeOutputReference;
    putReadinessProbe(value: ReplicationControllerSpecTemplateSpecContainerReadinessProbe): void;
    resetReadinessProbe(): void;
    get readinessProbeInput(): ReplicationControllerSpecTemplateSpecContainerReadinessProbe | undefined;
    private _resources;
    get resources(): ReplicationControllerSpecTemplateSpecContainerResourcesOutputReference;
    putResources(value: ReplicationControllerSpecTemplateSpecContainerResources): void;
    resetResources(): void;
    get resourcesInput(): ReplicationControllerSpecTemplateSpecContainerResources | undefined;
    private _securityContext;
    get securityContext(): ReplicationControllerSpecTemplateSpecContainerSecurityContextOutputReference;
    putSecurityContext(value: ReplicationControllerSpecTemplateSpecContainerSecurityContext): void;
    resetSecurityContext(): void;
    get securityContextInput(): ReplicationControllerSpecTemplateSpecContainerSecurityContext | undefined;
    private _startupProbe;
    get startupProbe(): ReplicationControllerSpecTemplateSpecContainerStartupProbeOutputReference;
    putStartupProbe(value: ReplicationControllerSpecTemplateSpecContainerStartupProbe): void;
    resetStartupProbe(): void;
    get startupProbeInput(): ReplicationControllerSpecTemplateSpecContainerStartupProbe | undefined;
    private _volumeMount;
    get volumeMount(): ReplicationControllerSpecTemplateSpecContainerVolumeMountList;
    putVolumeMount(value: ReplicationControllerSpecTemplateSpecContainerVolumeMount[] | cdktf.IResolvable): void;
    resetVolumeMount(): void;
    get volumeMountInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecContainerVolumeMount[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecContainer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecContainerOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecDnsConfigOption {
    /**
    * Name of the option.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name: string;
    /**
    * Value of the option. Optional: Defaults to empty.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#value ReplicationController#value}
    */
    readonly value?: string;
}
export declare function replicationControllerSpecTemplateSpecDnsConfigOptionToTerraform(struct?: ReplicationControllerSpecTemplateSpecDnsConfigOption | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecDnsConfigOptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecDnsConfigOption | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecDnsConfigOption | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecDnsConfigOptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecDnsConfigOption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecDnsConfigOptionOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecDnsConfig {
    /**
    * A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#nameservers ReplicationController#nameservers}
    */
    readonly nameservers?: string[];
    /**
    * A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#searches ReplicationController#searches}
    */
    readonly searches?: string[];
    /**
    * option block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#option ReplicationController#option}
    */
    readonly option?: ReplicationControllerSpecTemplateSpecDnsConfigOption[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecDnsConfigToTerraform(struct?: ReplicationControllerSpecTemplateSpecDnsConfigOutputReference | ReplicationControllerSpecTemplateSpecDnsConfig): any;
export declare class ReplicationControllerSpecTemplateSpecDnsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecDnsConfig | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecDnsConfig | undefined);
    private _nameservers?;
    get nameservers(): string[];
    set nameservers(value: string[]);
    resetNameservers(): void;
    get nameserversInput(): string[] | undefined;
    private _searches?;
    get searches(): string[];
    set searches(value: string[]);
    resetSearches(): void;
    get searchesInput(): string[] | undefined;
    private _option;
    get option(): ReplicationControllerSpecTemplateSpecDnsConfigOptionList;
    putOption(value: ReplicationControllerSpecTemplateSpecDnsConfigOption[] | cdktf.IResolvable): void;
    resetOption(): void;
    get optionInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecDnsConfigOption[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecHostAliases {
    /**
    * Hostnames for the IP address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#hostnames ReplicationController#hostnames}
    */
    readonly hostnames: string[];
    /**
    * IP address of the host file entry.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#ip ReplicationController#ip}
    */
    readonly ip: string;
}
export declare function replicationControllerSpecTemplateSpecHostAliasesToTerraform(struct?: ReplicationControllerSpecTemplateSpecHostAliases | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecHostAliasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecHostAliases | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecHostAliases | cdktf.IResolvable | undefined);
    private _hostnames?;
    get hostnames(): string[];
    set hostnames(value: string[]);
    get hostnamesInput(): string[] | undefined;
    private _ip?;
    get ip(): string;
    set ip(value: string);
    get ipInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecHostAliasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecHostAliases[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecHostAliasesOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecImagePullSecrets {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name: string;
}
export declare function replicationControllerSpecTemplateSpecImagePullSecretsToTerraform(struct?: ReplicationControllerSpecTemplateSpecImagePullSecrets | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecImagePullSecretsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecImagePullSecrets | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecImagePullSecrets | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecImagePullSecretsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecImagePullSecrets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecImagePullSecretsOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef {
    /**
    * The key to select.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#key ReplicationController#key}
    */
    readonly key?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * Specify whether the ConfigMap or its key must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#optional ReplicationController#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRefToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRefOutputReference | ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to "v1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#api_version ReplicationController#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#field_path ReplicationController#field_path}
    */
    readonly fieldPath?: string;
}
export declare function replicationControllerSpecTemplateSpecInitContainerEnvValueFromFieldRefToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromFieldRefOutputReference | ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromFieldRef): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromFieldRef | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#container_name ReplicationController#container_name}
    */
    readonly containerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#divisor ReplicationController#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#resource ReplicationController#resource}
    */
    readonly resource: string;
}
export declare function replicationControllerSpecTemplateSpecInitContainerEnvValueFromResourceFieldRefToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromResourceFieldRefOutputReference | ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromResourceFieldRef): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromResourceFieldRef | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    resetContainerName(): void;
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromSecretKeyRef {
    /**
    * The key of the secret to select from. Must be a valid secret key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#key ReplicationController#key}
    */
    readonly key?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * Specify whether the Secret or its key must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#optional ReplicationController#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecInitContainerEnvValueFromSecretKeyRefToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromSecretKeyRefOutputReference | ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromSecretKeyRef): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromSecretKeyRef | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromSecretKeyRef | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerEnvValueFrom {
    /**
    * config_map_key_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#config_map_key_ref ReplicationController#config_map_key_ref}
    */
    readonly configMapKeyRef?: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#field_ref ReplicationController#field_ref}
    */
    readonly fieldRef?: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#resource_field_ref ReplicationController#resource_field_ref}
    */
    readonly resourceFieldRef?: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromResourceFieldRef;
    /**
    * secret_key_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#secret_key_ref ReplicationController#secret_key_ref}
    */
    readonly secretKeyRef?: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromSecretKeyRef;
}
export declare function replicationControllerSpecTemplateSpecInitContainerEnvValueFromToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromOutputReference | ReplicationControllerSpecTemplateSpecInitContainerEnvValueFrom): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerEnvValueFrom | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFrom | undefined);
    private _configMapKeyRef;
    get configMapKeyRef(): ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRefOutputReference;
    putConfigMapKeyRef(value: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef): void;
    resetConfigMapKeyRef(): void;
    get configMapKeyRefInput(): ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef | undefined;
    private _fieldRef;
    get fieldRef(): ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromFieldRefOutputReference;
    putFieldRef(value: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromFieldRef): void;
    resetFieldRef(): void;
    get fieldRefInput(): ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromResourceFieldRefOutputReference;
    putResourceFieldRef(value: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromResourceFieldRef | undefined;
    private _secretKeyRef;
    get secretKeyRef(): ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromSecretKeyRefOutputReference;
    putSecretKeyRef(value: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromSecretKeyRef): void;
    resetSecretKeyRef(): void;
    get secretKeyRefInput(): ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromSecretKeyRef | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerEnv {
    /**
    * Name of the environment variable. Must be a C_IDENTIFIER
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name: string;
    /**
    * Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#value ReplicationController#value}
    */
    readonly value?: string;
    /**
    * value_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#value_from ReplicationController#value_from}
    */
    readonly valueFrom?: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFrom;
}
export declare function replicationControllerSpecTemplateSpecInitContainerEnvToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerEnv | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerEnv | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerEnv | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _valueFrom;
    get valueFrom(): ReplicationControllerSpecTemplateSpecInitContainerEnvValueFromOutputReference;
    putValueFrom(value: ReplicationControllerSpecTemplateSpecInitContainerEnvValueFrom): void;
    resetValueFrom(): void;
    get valueFromInput(): ReplicationControllerSpecTemplateSpecInitContainerEnvValueFrom | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecInitContainerEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecInitContainerEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecInitContainerEnvOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerEnvFromConfigMapRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name: string;
    /**
    * Specify whether the ConfigMap must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#optional ReplicationController#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecInitContainerEnvFromConfigMapRefToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerEnvFromConfigMapRefOutputReference | ReplicationControllerSpecTemplateSpecInitContainerEnvFromConfigMapRef): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerEnvFromConfigMapRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerEnvFromConfigMapRef | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerEnvFromConfigMapRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerEnvFromSecretRef {
    /**
    * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name: string;
    /**
    * Specify whether the Secret must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#optional ReplicationController#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecInitContainerEnvFromSecretRefToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerEnvFromSecretRefOutputReference | ReplicationControllerSpecTemplateSpecInitContainerEnvFromSecretRef): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerEnvFromSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerEnvFromSecretRef | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerEnvFromSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerEnvFrom {
    /**
    * An optional identifer to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#prefix ReplicationController#prefix}
    */
    readonly prefix?: string;
    /**
    * config_map_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#config_map_ref ReplicationController#config_map_ref}
    */
    readonly configMapRef?: ReplicationControllerSpecTemplateSpecInitContainerEnvFromConfigMapRef;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#secret_ref ReplicationController#secret_ref}
    */
    readonly secretRef?: ReplicationControllerSpecTemplateSpecInitContainerEnvFromSecretRef;
}
export declare function replicationControllerSpecTemplateSpecInitContainerEnvFromToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerEnvFrom | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerEnvFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerEnvFrom | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerEnvFrom | cdktf.IResolvable | undefined);
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    private _configMapRef;
    get configMapRef(): ReplicationControllerSpecTemplateSpecInitContainerEnvFromConfigMapRefOutputReference;
    putConfigMapRef(value: ReplicationControllerSpecTemplateSpecInitContainerEnvFromConfigMapRef): void;
    resetConfigMapRef(): void;
    get configMapRefInput(): ReplicationControllerSpecTemplateSpecInitContainerEnvFromConfigMapRef | undefined;
    private _secretRef;
    get secretRef(): ReplicationControllerSpecTemplateSpecInitContainerEnvFromSecretRefOutputReference;
    putSecretRef(value: ReplicationControllerSpecTemplateSpecInitContainerEnvFromSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): ReplicationControllerSpecTemplateSpecInitContainerEnvFromSecretRef | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecInitContainerEnvFromList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecInitContainerEnvFrom[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecInitContainerEnvFromOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#command ReplicationController#command}
    */
    readonly command?: string[];
}
export declare function replicationControllerSpecTemplateSpecInitContainerLifecyclePostStartExecToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartExecOutputReference | ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartExec): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartExec | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#value ReplicationController#value}
    */
    readonly value?: string;
}
export declare function replicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeaderToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeaderOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#host ReplicationController#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#path ReplicationController#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#scheme ReplicationController#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_header ReplicationController#http_header}
    */
    readonly httpHeader?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetOutputReference | ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGet): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGet | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeaderList;
    putHttpHeader(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port: string;
}
export declare function replicationControllerSpecTemplateSpecInitContainerLifecyclePostStartTcpSocketToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartTcpSocketOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStart {
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#exec ReplicationController#exec}
    */
    readonly exec?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_get ReplicationController#http_get}
    */
    readonly httpGet?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#tcp_socket ReplicationController#tcp_socket}
    */
    readonly tcpSocket?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecInitContainerLifecyclePostStartToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStart | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStart | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStart | cdktf.IResolvable | undefined);
    private _exec;
    get exec(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartExecOutputReference;
    putExec(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartExec): void;
    resetExec(): void;
    get execInput(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartExec | undefined;
    private _httpGet;
    get httpGet(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGetOutputReference;
    putHttpGet(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartTcpSocketList;
    putTcpSocket(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStart[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#command ReplicationController#command}
    */
    readonly command?: string[];
}
export declare function replicationControllerSpecTemplateSpecInitContainerLifecyclePreStopExecToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopExecOutputReference | ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopExec): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopExec | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#value ReplicationController#value}
    */
    readonly value?: string;
}
export declare function replicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeaderToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeaderOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#host ReplicationController#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#path ReplicationController#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#scheme ReplicationController#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_header ReplicationController#http_header}
    */
    readonly httpHeader?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetOutputReference | ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGet): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGet | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeaderList;
    putHttpHeader(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port: string;
}
export declare function replicationControllerSpecTemplateSpecInitContainerLifecyclePreStopTcpSocketToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopTcpSocketOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStop {
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#exec ReplicationController#exec}
    */
    readonly exec?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_get ReplicationController#http_get}
    */
    readonly httpGet?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#tcp_socket ReplicationController#tcp_socket}
    */
    readonly tcpSocket?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecInitContainerLifecyclePreStopToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStop | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStop | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStop | cdktf.IResolvable | undefined);
    private _exec;
    get exec(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopExecOutputReference;
    putExec(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopExec): void;
    resetExec(): void;
    get execInput(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopExec | undefined;
    private _httpGet;
    get httpGet(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGetOutputReference;
    putHttpGet(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopTcpSocketList;
    putTcpSocket(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket[] | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStop[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLifecycle {
    /**
    * post_start block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#post_start ReplicationController#post_start}
    */
    readonly postStart?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStart[] | cdktf.IResolvable;
    /**
    * pre_stop block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#pre_stop ReplicationController#pre_stop}
    */
    readonly preStop?: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStop[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecInitContainerLifecycleToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLifecycleOutputReference | ReplicationControllerSpecTemplateSpecInitContainerLifecycle): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLifecycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLifecycle | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLifecycle | undefined);
    private _postStart;
    get postStart(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStartList;
    putPostStart(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStart[] | cdktf.IResolvable): void;
    resetPostStart(): void;
    get postStartInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecInitContainerLifecyclePostStart[] | undefined;
    private _preStop;
    get preStop(): ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStopList;
    putPreStop(value: ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStop[] | cdktf.IResolvable): void;
    resetPreStop(): void;
    get preStopInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecInitContainerLifecyclePreStop[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#command ReplicationController#command}
    */
    readonly command?: string[];
}
export declare function replicationControllerSpecTemplateSpecInitContainerLivenessProbeExecToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeExecOutputReference | ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeExec): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeExec | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeGrpc {
    /**
    * Number of the port to access on the container. Number must be in the range 1 to 65535.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port: number;
    /**
    * Name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md). If this is not specified, the default behavior is defined by gRPC.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#service ReplicationController#service}
    */
    readonly service?: string;
}
export declare function replicationControllerSpecTemplateSpecInitContainerLivenessProbeGrpcToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeGrpc | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeGrpc | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeGrpc | cdktf.IResolvable | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeGrpcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeGrpc[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeGrpcOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#value ReplicationController#value}
    */
    readonly value?: string;
}
export declare function replicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeaderToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeaderOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#host ReplicationController#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#path ReplicationController#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#scheme ReplicationController#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_header ReplicationController#http_header}
    */
    readonly httpHeader?: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetOutputReference | ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGet): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGet | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeaderList;
    putHttpHeader(value: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port: string;
}
export declare function replicationControllerSpecTemplateSpecInitContainerLivenessProbeTcpSocketToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeTcpSocket | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeTcpSocketOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerLivenessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#failure_threshold ReplicationController#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#initial_delay_seconds ReplicationController#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#period_seconds ReplicationController#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#success_threshold ReplicationController#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#timeout_seconds ReplicationController#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#exec ReplicationController#exec}
    */
    readonly exec?: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeExec;
    /**
    * grpc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#grpc ReplicationController#grpc}
    */
    readonly grpc?: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeGrpc[] | cdktf.IResolvable;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_get ReplicationController#http_get}
    */
    readonly httpGet?: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#tcp_socket ReplicationController#tcp_socket}
    */
    readonly tcpSocket?: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecInitContainerLivenessProbeToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeOutputReference | ReplicationControllerSpecTemplateSpecInitContainerLivenessProbe): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbe | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeExecOutputReference;
    putExec(value: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeExec): void;
    resetExec(): void;
    get execInput(): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeExec | undefined;
    private _grpc;
    get grpc(): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeGrpcList;
    putGrpc(value: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeGrpc[] | cdktf.IResolvable): void;
    resetGrpc(): void;
    get grpcInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeGrpc[] | undefined;
    private _httpGet;
    get httpGet(): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGetOutputReference;
    putHttpGet(value: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeTcpSocketList;
    putTcpSocket(value: ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecInitContainerLivenessProbeTcpSocket[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerPort {
    /**
    * Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#container_port ReplicationController#container_port}
    */
    readonly containerPort: number;
    /**
    * What host IP to bind the external port to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#host_ip ReplicationController#host_ip}
    */
    readonly hostIp?: string;
    /**
    * Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#host_port ReplicationController#host_port}
    */
    readonly hostPort?: number;
    /**
    * If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * Protocol for port. Must be UDP or TCP. Defaults to "TCP".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#protocol ReplicationController#protocol}
    */
    readonly protocol?: string;
}
export declare function replicationControllerSpecTemplateSpecInitContainerPortToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerPort | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerPortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerPort | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerPort | cdktf.IResolvable | undefined);
    private _containerPort?;
    get containerPort(): number;
    set containerPort(value: number);
    get containerPortInput(): number | undefined;
    private _hostIp?;
    get hostIp(): string;
    set hostIp(value: string);
    resetHostIp(): void;
    get hostIpInput(): string | undefined;
    private _hostPort?;
    get hostPort(): number;
    set hostPort(value: number);
    resetHostPort(): void;
    get hostPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecInitContainerPortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecInitContainerPort[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecInitContainerPortOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#command ReplicationController#command}
    */
    readonly command?: string[];
}
export declare function replicationControllerSpecTemplateSpecInitContainerReadinessProbeExecToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeExecOutputReference | ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeExec): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeExec | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeGrpc {
    /**
    * Number of the port to access on the container. Number must be in the range 1 to 65535.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port: number;
    /**
    * Name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md). If this is not specified, the default behavior is defined by gRPC.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#service ReplicationController#service}
    */
    readonly service?: string;
}
export declare function replicationControllerSpecTemplateSpecInitContainerReadinessProbeGrpcToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeGrpc | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeGrpc | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeGrpc | cdktf.IResolvable | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeGrpcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeGrpc[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeGrpcOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#name ReplicationController#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#value ReplicationController#value}
    */
    readonly value?: string;
}
export declare function replicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeaderToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeaderOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#host ReplicationController#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#path ReplicationController#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#scheme ReplicationController#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_header ReplicationController#http_header}
    */
    readonly httpHeader?: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetOutputReference | ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGet): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGet | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeaderList;
    putHttpHeader(value: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#port ReplicationController#port}
    */
    readonly port: string;
}
export declare function replicationControllerSpecTemplateSpecInitContainerReadinessProbeTcpSocketToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeTcpSocket | cdktf.IResolvable): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeTcpSocketOutputReference;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerReadinessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#failure_threshold ReplicationController#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#initial_delay_seconds ReplicationController#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#period_seconds ReplicationController#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#success_threshold ReplicationController#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#timeout_seconds ReplicationController#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#exec ReplicationController#exec}
    */
    readonly exec?: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeExec;
    /**
    * grpc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#grpc ReplicationController#grpc}
    */
    readonly grpc?: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeGrpc[] | cdktf.IResolvable;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#http_get ReplicationController#http_get}
    */
    readonly httpGet?: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#tcp_socket ReplicationController#tcp_socket}
    */
    readonly tcpSocket?: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function replicationControllerSpecTemplateSpecInitContainerReadinessProbeToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeOutputReference | ReplicationControllerSpecTemplateSpecInitContainerReadinessProbe): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbe | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeExecOutputReference;
    putExec(value: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeExec): void;
    resetExec(): void;
    get execInput(): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeExec | undefined;
    private _grpc;
    get grpc(): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeGrpcList;
    putGrpc(value: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeGrpc[] | cdktf.IResolvable): void;
    resetGrpc(): void;
    get grpcInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeGrpc[] | undefined;
    private _httpGet;
    get httpGet(): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGetOutputReference;
    putHttpGet(value: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeTcpSocketList;
    putTcpSocket(value: ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | ReplicationControllerSpecTemplateSpecInitContainerReadinessProbeTcpSocket[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerResources {
    /**
    * Describes the maximum amount of compute resources allowed. More info: http://kubernetes.io/docs/user-guide/compute-resources/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#limits ReplicationController#limits}
    */
    readonly limits?: {
        [key: string]: string;
    };
    /**
    * Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#requests ReplicationController#requests}
    */
    readonly requests?: {
        [key: string]: string;
    };
}
export declare function replicationControllerSpecTemplateSpecInitContainerResourcesToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerResourcesOutputReference | ReplicationControllerSpecTemplateSpecInitContainerResources): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerResources | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerResources | undefined);
    private _limits?;
    get limits(): {
        [key: string]: string;
    };
    set limits(value: {
        [key: string]: string;
    });
    resetLimits(): void;
    get limitsInput(): {
        [key: string]: string;
    } | undefined;
    private _requests?;
    get requests(): {
        [key: string]: string;
    };
    set requests(value: {
        [key: string]: string;
    });
    resetRequests(): void;
    get requestsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerSecurityContextCapabilities {
    /**
    * Added capabilities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#add ReplicationController#add}
    */
    readonly add?: string[];
    /**
    * Removed capabilities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#drop ReplicationController#drop}
    */
    readonly drop?: string[];
}
export declare function replicationControllerSpecTemplateSpecInitContainerSecurityContextCapabilitiesToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerSecurityContextCapabilitiesOutputReference | ReplicationControllerSpecTemplateSpecInitContainerSecurityContextCapabilities): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerSecurityContextCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerSecurityContextCapabilities | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerSecurityContextCapabilities | undefined);
    private _add?;
    get add(): string[];
    set add(value: string[]);
    resetAdd(): void;
    get addInput(): string[] | undefined;
    private _drop?;
    get drop(): string[];
    set drop(value: string[]);
    resetDrop(): void;
    get dropInput(): string[] | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions {
    /**
    * Level is SELinux level label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#level ReplicationController#level}
    */
    readonly level?: string;
    /**
    * Role is a SELinux role label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#role ReplicationController#role}
    */
    readonly role?: string;
    /**
    * Type is a SELinux type label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#type ReplicationController#type}
    */
    readonly type?: string;
    /**
    * User is a SELinux user label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#user ReplicationController#user}
    */
    readonly user?: string;
}
export declare function replicationControllerSpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsOutputReference | ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeccompProfile {
    /**
    * Localhost Profile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#localhost_profile ReplicationController#localhost_profile}
    */
    readonly localhostProfile?: string;
    /**
    * Type indicates which kind of seccomp profile will be applied. Valid options are: Localhost, RuntimeDefault, Unconfined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#type ReplicationController#type}
    */
    readonly type?: string;
}
export declare function replicationControllerSpecTemplateSpecInitContainerSecurityContextSeccompProfileToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeccompProfileOutputReference | ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeccompProfile): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeccompProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeccompProfile | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeccompProfile | undefined);
    private _localhostProfile?;
    get localhostProfile(): string;
    set localhostProfile(value: string);
    resetLocalhostProfile(): void;
    get localhostProfileInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerSecurityContext {
    /**
    * AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#allow_privilege_escalation ReplicationController#allow_privilege_escalation}
    */
    readonly allowPrivilegeEscalation?: boolean | cdktf.IResolvable;
    /**
    * Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#privileged ReplicationController#privileged}
    */
    readonly privileged?: boolean | cdktf.IResolvable;
    /**
    * Whether this container has a read-only root filesystem. Default is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#read_only_root_filesystem ReplicationController#read_only_root_filesystem}
    */
    readonly readOnlyRootFilesystem?: boolean | cdktf.IResolvable;
    /**
    * The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#run_as_group ReplicationController#run_as_group}
    */
    readonly runAsGroup?: string;
    /**
    * Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#run_as_non_root ReplicationController#run_as_non_root}
    */
    readonly runAsNonRoot?: boolean | cdktf.IResolvable;
    /**
    * The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#run_as_user ReplicationController#run_as_user}
    */
    readonly runAsUser?: string;
    /**
    * capabilities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#capabilities ReplicationController#capabilities}
    */
    readonly capabilities?: ReplicationControllerSpecTemplateSpecInitContainerSecurityContextCapabilities;
    /**
    * se_linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#se_linux_options ReplicationController#se_linux_options}
    */
    readonly seLinuxOptions?: ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions;
    /**
    * seccomp_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#seccomp_profile ReplicationController#seccomp_profile}
    */
    readonly seccompProfile?: ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeccompProfile;
}
export declare function replicationControllerSpecTemplateSpecInitContainerSecurityContextToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerSecurityContextOutputReference | ReplicationControllerSpecTemplateSpecInitContainerSecurityContext): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerSecurityContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerSecurityContext | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerSecurityContext | undefined);
    private _allowPrivilegeEscalation?;
    get allowPrivilegeEscalation(): boolean | cdktf.IResolvable;
    set allowPrivilegeEscalation(value: boolean | cdktf.IResolvable);
    resetAllowPrivilegeEscalation(): void;
    get allowPrivilegeEscalationInput(): boolean | cdktf.IResolvable | undefined;
    private _privileged?;
    get privileged(): boolean | cdktf.IResolvable;
    set privileged(value: boolean | cdktf.IResolvable);
    resetPrivileged(): void;
    get privilegedInput(): boolean | cdktf.IResolvable | undefined;
    private _readOnlyRootFilesystem?;
    get readOnlyRootFilesystem(): boolean | cdktf.IResolvable;
    set readOnlyRootFilesystem(value: boolean | cdktf.IResolvable);
    resetReadOnlyRootFilesystem(): void;
    get readOnlyRootFilesystemInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsGroup?;
    get runAsGroup(): string;
    set runAsGroup(value: string);
    resetRunAsGroup(): void;
    get runAsGroupInput(): string | undefined;
    private _runAsNonRoot?;
    get runAsNonRoot(): boolean | cdktf.IResolvable;
    set runAsNonRoot(value: boolean | cdktf.IResolvable);
    resetRunAsNonRoot(): void;
    get runAsNonRootInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsUser?;
    get runAsUser(): string;
    set runAsUser(value: string);
    resetRunAsUser(): void;
    get runAsUserInput(): string | undefined;
    private _capabilities;
    get capabilities(): ReplicationControllerSpecTemplateSpecInitContainerSecurityContextCapabilitiesOutputReference;
    putCapabilities(value: ReplicationControllerSpecTemplateSpecInitContainerSecurityContextCapabilities): void;
    resetCapabilities(): void;
    get capabilitiesInput(): ReplicationControllerSpecTemplateSpecInitContainerSecurityContextCapabilities | undefined;
    private _seLinuxOptions;
    get seLinuxOptions(): ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsOutputReference;
    putSeLinuxOptions(value: ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions): void;
    resetSeLinuxOptions(): void;
    get seLinuxOptionsInput(): ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions | undefined;
    private _seccompProfile;
    get seccompProfile(): ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeccompProfileOutputReference;
    putSeccompProfile(value: ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeccompProfile): void;
    resetSeccompProfile(): void;
    get seccompProfileInput(): ReplicationControllerSpecTemplateSpecInitContainerSecurityContextSeccompProfile | undefined;
}
export interface ReplicationControllerSpecTemplateSpecInitContainerStartupProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#command ReplicationController#command}
    */
    readonly command?: string[];
}
export declare function replicationControllerSpecTemplateSpecInitContainerStartupProbeExecToTerraform(struct?: ReplicationControllerSpecTemplateSpecInitContainerStartupProbeExecOutputReference | ReplicationControllerSpecTemplateSpecInitContainerStartupProbeExec): any;
export declare class ReplicationControllerSpecTemplateSpecInitContainerStartupProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ReplicationControllerSpecTemplateSpecInitContainerStartupProbeExec | undefined;
    set internalValue(value: ReplicationControllerSpecTemplateSpecInitContainerStartupProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
