"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesProvider = exports.kubernetesProviderExperimentsToTerraform = exports.kubernetesProviderExecToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function kubernetesProviderExecToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        api_version: cdktf.stringToTerraform(struct.apiVersion),
        args: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.args),
        command: cdktf.stringToTerraform(struct.command),
        env: cdktf.hashMapper(cdktf.stringToTerraform)(struct.env),
    };
}
exports.kubernetesProviderExecToTerraform = kubernetesProviderExecToTerraform;
function kubernetesProviderExperimentsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        manifest_resource: cdktf.booleanToTerraform(struct.manifestResource),
    };
}
exports.kubernetesProviderExperimentsToTerraform = kubernetesProviderExperimentsToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes kubernetes}
*/
class KubernetesProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes kubernetes} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'kubernetes',
            terraformGeneratorMetadata: {
                providerName: 'kubernetes',
                providerVersion: '2.18.0',
                providerVersionConstraint: '~> 2.0'
            },
            terraformProviderSource: 'kubernetes'
        });
        this._clientCertificate = config.clientCertificate;
        this._clientKey = config.clientKey;
        this._clusterCaCertificate = config.clusterCaCertificate;
        this._configContext = config.configContext;
        this._configContextAuthInfo = config.configContextAuthInfo;
        this._configContextCluster = config.configContextCluster;
        this._configPath = config.configPath;
        this._configPaths = config.configPaths;
        this._host = config.host;
        this._ignoreAnnotations = config.ignoreAnnotations;
        this._ignoreLabels = config.ignoreLabels;
        this._insecure = config.insecure;
        this._password = config.password;
        this._proxyUrl = config.proxyUrl;
        this._token = config.token;
        this._username = config.username;
        this._alias = config.alias;
        this._exec = config.exec;
        this._experiments = config.experiments;
    }
    get clientCertificate() {
        return this._clientCertificate;
    }
    set clientCertificate(value) {
        this._clientCertificate = value;
    }
    resetClientCertificate() {
        this._clientCertificate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertificateInput() {
        return this._clientCertificate;
    }
    get clientKey() {
        return this._clientKey;
    }
    set clientKey(value) {
        this._clientKey = value;
    }
    resetClientKey() {
        this._clientKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientKeyInput() {
        return this._clientKey;
    }
    get clusterCaCertificate() {
        return this._clusterCaCertificate;
    }
    set clusterCaCertificate(value) {
        this._clusterCaCertificate = value;
    }
    resetClusterCaCertificate() {
        this._clusterCaCertificate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clusterCaCertificateInput() {
        return this._clusterCaCertificate;
    }
    get configContext() {
        return this._configContext;
    }
    set configContext(value) {
        this._configContext = value;
    }
    resetConfigContext() {
        this._configContext = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get configContextInput() {
        return this._configContext;
    }
    get configContextAuthInfo() {
        return this._configContextAuthInfo;
    }
    set configContextAuthInfo(value) {
        this._configContextAuthInfo = value;
    }
    resetConfigContextAuthInfo() {
        this._configContextAuthInfo = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get configContextAuthInfoInput() {
        return this._configContextAuthInfo;
    }
    get configContextCluster() {
        return this._configContextCluster;
    }
    set configContextCluster(value) {
        this._configContextCluster = value;
    }
    resetConfigContextCluster() {
        this._configContextCluster = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get configContextClusterInput() {
        return this._configContextCluster;
    }
    get configPath() {
        return this._configPath;
    }
    set configPath(value) {
        this._configPath = value;
    }
    resetConfigPath() {
        this._configPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get configPathInput() {
        return this._configPath;
    }
    get configPaths() {
        return this._configPaths;
    }
    set configPaths(value) {
        this._configPaths = value;
    }
    resetConfigPaths() {
        this._configPaths = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get configPathsInput() {
        return this._configPaths;
    }
    get host() {
        return this._host;
    }
    set host(value) {
        this._host = value;
    }
    resetHost() {
        this._host = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostInput() {
        return this._host;
    }
    get ignoreAnnotations() {
        return this._ignoreAnnotations;
    }
    set ignoreAnnotations(value) {
        this._ignoreAnnotations = value;
    }
    resetIgnoreAnnotations() {
        this._ignoreAnnotations = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreAnnotationsInput() {
        return this._ignoreAnnotations;
    }
    get ignoreLabels() {
        return this._ignoreLabels;
    }
    set ignoreLabels(value) {
        this._ignoreLabels = value;
    }
    resetIgnoreLabels() {
        this._ignoreLabels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreLabelsInput() {
        return this._ignoreLabels;
    }
    get insecure() {
        return this._insecure;
    }
    set insecure(value) {
        this._insecure = value;
    }
    resetInsecure() {
        this._insecure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insecureInput() {
        return this._insecure;
    }
    get password() {
        return this._password;
    }
    set password(value) {
        this._password = value;
    }
    resetPassword() {
        this._password = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get proxyUrl() {
        return this._proxyUrl;
    }
    set proxyUrl(value) {
        this._proxyUrl = value;
    }
    resetProxyUrl() {
        this._proxyUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proxyUrlInput() {
        return this._proxyUrl;
    }
    get token() {
        return this._token;
    }
    set token(value) {
        this._token = value;
    }
    resetToken() {
        this._token = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenInput() {
        return this._token;
    }
    get username() {
        return this._username;
    }
    set username(value) {
        this._username = value;
    }
    resetUsername() {
        this._username = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usernameInput() {
        return this._username;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get exec() {
        return this._exec;
    }
    set exec(value) {
        this._exec = value;
    }
    resetExec() {
        this._exec = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get execInput() {
        return this._exec;
    }
    get experiments() {
        return this._experiments;
    }
    set experiments(value) {
        this._experiments = value;
    }
    resetExperiments() {
        this._experiments = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get experimentsInput() {
        return this._experiments;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            client_certificate: cdktf.stringToTerraform(this._clientCertificate),
            client_key: cdktf.stringToTerraform(this._clientKey),
            cluster_ca_certificate: cdktf.stringToTerraform(this._clusterCaCertificate),
            config_context: cdktf.stringToTerraform(this._configContext),
            config_context_auth_info: cdktf.stringToTerraform(this._configContextAuthInfo),
            config_context_cluster: cdktf.stringToTerraform(this._configContextCluster),
            config_path: cdktf.stringToTerraform(this._configPath),
            config_paths: cdktf.listMapper(cdktf.stringToTerraform, false)(this._configPaths),
            host: cdktf.stringToTerraform(this._host),
            ignore_annotations: cdktf.listMapper(cdktf.stringToTerraform, false)(this._ignoreAnnotations),
            ignore_labels: cdktf.listMapper(cdktf.stringToTerraform, false)(this._ignoreLabels),
            insecure: cdktf.booleanToTerraform(this._insecure),
            password: cdktf.stringToTerraform(this._password),
            proxy_url: cdktf.stringToTerraform(this._proxyUrl),
            token: cdktf.stringToTerraform(this._token),
            username: cdktf.stringToTerraform(this._username),
            alias: cdktf.stringToTerraform(this._alias),
            exec: kubernetesProviderExecToTerraform(this._exec),
            experiments: kubernetesProviderExperimentsToTerraform(this._experiments),
        };
    }
}
exports.KubernetesProvider = KubernetesProvider;
_a = JSII_RTTI_SYMBOL_1;
KubernetesProvider[_a] = { fqn: "@cdktf/provider-kubernetes.provider.KubernetesProvider", version: "5.0.2" };
// =================
// STATIC PROPERTIES
// =================
KubernetesProvider.tfResourceType = "kubernetes";
//# sourceMappingURL=data:application/json;base64,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