import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PriorityClassConfig extends cdktf.TerraformMetaArguments {
    /**
    * An arbitrary string that usually provides guidelines on when this priority class should be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/priority_class#description PriorityClass#description}
    */
    readonly description?: string;
    /**
    * Specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class. Only one PriorityClass can be marked as `globalDefault`. However, if more than one PriorityClasses exists with their `globalDefault` field set to true, the smallest value of such global default PriorityClasses will be used as the default priority.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/priority_class#global_default PriorityClass#global_default}
    */
    readonly globalDefault?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/priority_class#id PriorityClass#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/priority_class#preemption_policy PriorityClass#preemption_policy}
    */
    readonly preemptionPolicy?: string;
    /**
    * The value of this priority class. This is the actual priority that pods receive when they have the name of this class in their pod spec.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/priority_class#value PriorityClass#value}
    */
    readonly value: number;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/priority_class#metadata PriorityClass#metadata}
    */
    readonly metadata: PriorityClassMetadata;
}
export interface PriorityClassMetadata {
    /**
    * An unstructured key value map stored with the priority class that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/priority_class#annotations PriorityClass#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/priority_class#generate_name PriorityClass#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the priority class. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/priority_class#labels PriorityClass#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the priority class, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/priority_class#name PriorityClass#name}
    */
    readonly name?: string;
}
export declare function priorityClassMetadataToTerraform(struct?: PriorityClassMetadataOutputReference | PriorityClassMetadata): any;
export declare class PriorityClassMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PriorityClassMetadata | undefined;
    set internalValue(value: PriorityClassMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/priority_class kubernetes_priority_class}
*/
export declare class PriorityClass extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_priority_class";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/priority_class kubernetes_priority_class} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PriorityClassConfig
    */
    constructor(scope: Construct, id: string, config: PriorityClassConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _globalDefault?;
    get globalDefault(): boolean | cdktf.IResolvable;
    set globalDefault(value: boolean | cdktf.IResolvable);
    resetGlobalDefault(): void;
    get globalDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _preemptionPolicy?;
    get preemptionPolicy(): string;
    set preemptionPolicy(value: string);
    resetPreemptionPolicy(): void;
    get preemptionPolicyInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
    private _metadata;
    get metadata(): PriorityClassMetadataOutputReference;
    putMetadata(value: PriorityClassMetadata): void;
    get metadataInput(): PriorityClassMetadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
