import * as cdktf from 'cdktf';
import { PodV1SpecInitContainerStartupProbeExec, PodV1SpecInitContainerStartupProbeExecOutputReference, PodV1SpecInitContainerStartupProbeGrpc, PodV1SpecInitContainerStartupProbeGrpcList, PodV1SpecInitContainerEnv, PodV1SpecInitContainerEnvList, PodV1SpecInitContainerEnvFrom, PodV1SpecInitContainerEnvFromList, PodV1SpecInitContainerLifecycle, PodV1SpecInitContainerLifecycleOutputReference, PodV1SpecInitContainerLivenessProbe, PodV1SpecInitContainerLivenessProbeOutputReference, PodV1SpecInitContainerPort, PodV1SpecInitContainerPortList, PodV1SpecInitContainerReadinessProbe, PodV1SpecInitContainerReadinessProbeOutputReference, PodV1SpecInitContainerResources, PodV1SpecInitContainerResourcesOutputReference, PodV1SpecInitContainerSecurityContext, PodV1SpecInitContainerSecurityContextOutputReference, PodV1SpecAffinity, PodV1SpecAffinityOutputReference, PodV1SpecContainer, PodV1SpecContainerList, PodV1SpecDnsConfig, PodV1SpecDnsConfigOutputReference, PodV1SpecHostAliases, PodV1SpecHostAliasesList, PodV1SpecImagePullSecrets, PodV1SpecImagePullSecretsList } from './structs0';
export interface PodV1SpecInitContainerStartupProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#name PodV1#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#value PodV1#value}
    */
    readonly value?: string;
}
export declare function podV1SpecInitContainerStartupProbeHttpGetHttpHeaderToTerraform(struct?: PodV1SpecInitContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class PodV1SpecInitContainerStartupProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecInitContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecInitContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class PodV1SpecInitContainerStartupProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecInitContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecInitContainerStartupProbeHttpGetHttpHeaderOutputReference;
}
export interface PodV1SpecInitContainerStartupProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#host PodV1#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#path PodV1#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#port PodV1#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#scheme PodV1#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#http_header PodV1#http_header}
    */
    readonly httpHeader?: PodV1SpecInitContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function podV1SpecInitContainerStartupProbeHttpGetToTerraform(struct?: PodV1SpecInitContainerStartupProbeHttpGetOutputReference | PodV1SpecInitContainerStartupProbeHttpGet): any;
export declare class PodV1SpecInitContainerStartupProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecInitContainerStartupProbeHttpGet | undefined;
    set internalValue(value: PodV1SpecInitContainerStartupProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): PodV1SpecInitContainerStartupProbeHttpGetHttpHeaderList;
    putHttpHeader(value: PodV1SpecInitContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | PodV1SpecInitContainerStartupProbeHttpGetHttpHeader[] | undefined;
}
export interface PodV1SpecInitContainerStartupProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#port PodV1#port}
    */
    readonly port: string;
}
export declare function podV1SpecInitContainerStartupProbeTcpSocketToTerraform(struct?: PodV1SpecInitContainerStartupProbeTcpSocket | cdktf.IResolvable): any;
export declare class PodV1SpecInitContainerStartupProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecInitContainerStartupProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecInitContainerStartupProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class PodV1SpecInitContainerStartupProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecInitContainerStartupProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecInitContainerStartupProbeTcpSocketOutputReference;
}
export interface PodV1SpecInitContainerStartupProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#failure_threshold PodV1#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#initial_delay_seconds PodV1#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#period_seconds PodV1#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#success_threshold PodV1#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#timeout_seconds PodV1#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#exec PodV1#exec}
    */
    readonly exec?: PodV1SpecInitContainerStartupProbeExec;
    /**
    * grpc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#grpc PodV1#grpc}
    */
    readonly grpc?: PodV1SpecInitContainerStartupProbeGrpc[] | cdktf.IResolvable;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#http_get PodV1#http_get}
    */
    readonly httpGet?: PodV1SpecInitContainerStartupProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#tcp_socket PodV1#tcp_socket}
    */
    readonly tcpSocket?: PodV1SpecInitContainerStartupProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function podV1SpecInitContainerStartupProbeToTerraform(struct?: PodV1SpecInitContainerStartupProbeOutputReference | PodV1SpecInitContainerStartupProbe): any;
export declare class PodV1SpecInitContainerStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecInitContainerStartupProbe | undefined;
    set internalValue(value: PodV1SpecInitContainerStartupProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): PodV1SpecInitContainerStartupProbeExecOutputReference;
    putExec(value: PodV1SpecInitContainerStartupProbeExec): void;
    resetExec(): void;
    get execInput(): PodV1SpecInitContainerStartupProbeExec | undefined;
    private _grpc;
    get grpc(): PodV1SpecInitContainerStartupProbeGrpcList;
    putGrpc(value: PodV1SpecInitContainerStartupProbeGrpc[] | cdktf.IResolvable): void;
    resetGrpc(): void;
    get grpcInput(): cdktf.IResolvable | PodV1SpecInitContainerStartupProbeGrpc[] | undefined;
    private _httpGet;
    get httpGet(): PodV1SpecInitContainerStartupProbeHttpGetOutputReference;
    putHttpGet(value: PodV1SpecInitContainerStartupProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): PodV1SpecInitContainerStartupProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): PodV1SpecInitContainerStartupProbeTcpSocketList;
    putTcpSocket(value: PodV1SpecInitContainerStartupProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | PodV1SpecInitContainerStartupProbeTcpSocket[] | undefined;
}
export interface PodV1SpecInitContainerVolumeMount {
    /**
    * Path within the container at which the volume should be mounted. Must not contain ':'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#mount_path PodV1#mount_path}
    */
    readonly mountPath: string;
    /**
    * Mount propagation mode. mount_propagation determines how mounts are propagated from the host to container and the other way around. Valid values are None (default), HostToContainer and Bidirectional.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#mount_propagation PodV1#mount_propagation}
    */
    readonly mountPropagation?: string;
    /**
    * This must match the Name of a Volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#name PodV1#name}
    */
    readonly name: string;
    /**
    * Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#sub_path PodV1#sub_path}
    */
    readonly subPath?: string;
}
export declare function podV1SpecInitContainerVolumeMountToTerraform(struct?: PodV1SpecInitContainerVolumeMount | cdktf.IResolvable): any;
export declare class PodV1SpecInitContainerVolumeMountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecInitContainerVolumeMount | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecInitContainerVolumeMount | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _mountPropagation?;
    get mountPropagation(): string;
    set mountPropagation(value: string);
    resetMountPropagation(): void;
    get mountPropagationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _subPath?;
    get subPath(): string;
    set subPath(value: string);
    resetSubPath(): void;
    get subPathInput(): string | undefined;
}
export declare class PodV1SpecInitContainerVolumeMountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecInitContainerVolumeMount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecInitContainerVolumeMountOutputReference;
}
export interface PodV1SpecInitContainer {
    /**
    * Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#args PodV1#args}
    */
    readonly args?: string[];
    /**
    * Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#command PodV1#command}
    */
    readonly command?: string[];
    /**
    * Docker image name. More info: http://kubernetes.io/docs/user-guide/images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#image PodV1#image}
    */
    readonly image?: string;
    /**
    * Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/images#updating-images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#image_pull_policy PodV1#image_pull_policy}
    */
    readonly imagePullPolicy?: string;
    /**
    * Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#name PodV1#name}
    */
    readonly name: string;
    /**
    * Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#stdin PodV1#stdin}
    */
    readonly stdin?: boolean | cdktf.IResolvable;
    /**
    * Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#stdin_once PodV1#stdin_once}
    */
    readonly stdinOnce?: boolean | cdktf.IResolvable;
    /**
    * Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Defaults to /dev/termination-log. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#termination_message_path PodV1#termination_message_path}
    */
    readonly terminationMessagePath?: string;
    /**
    * Optional: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#termination_message_policy PodV1#termination_message_policy}
    */
    readonly terminationMessagePolicy?: string;
    /**
    * Whether this container should allocate a TTY for itself
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#tty PodV1#tty}
    */
    readonly tty?: boolean | cdktf.IResolvable;
    /**
    * Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#working_dir PodV1#working_dir}
    */
    readonly workingDir?: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#env PodV1#env}
    */
    readonly env?: PodV1SpecInitContainerEnv[] | cdktf.IResolvable;
    /**
    * env_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#env_from PodV1#env_from}
    */
    readonly envFrom?: PodV1SpecInitContainerEnvFrom[] | cdktf.IResolvable;
    /**
    * lifecycle block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#lifecycle PodV1#lifecycle}
    */
    readonly lifecycle?: PodV1SpecInitContainerLifecycle;
    /**
    * liveness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#liveness_probe PodV1#liveness_probe}
    */
    readonly livenessProbe?: PodV1SpecInitContainerLivenessProbe;
    /**
    * port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#port PodV1#port}
    */
    readonly port?: PodV1SpecInitContainerPort[] | cdktf.IResolvable;
    /**
    * readiness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#readiness_probe PodV1#readiness_probe}
    */
    readonly readinessProbe?: PodV1SpecInitContainerReadinessProbe;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#resources PodV1#resources}
    */
    readonly resources?: PodV1SpecInitContainerResources;
    /**
    * security_context block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#security_context PodV1#security_context}
    */
    readonly securityContext?: PodV1SpecInitContainerSecurityContext;
    /**
    * startup_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#startup_probe PodV1#startup_probe}
    */
    readonly startupProbe?: PodV1SpecInitContainerStartupProbe;
    /**
    * volume_mount block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#volume_mount PodV1#volume_mount}
    */
    readonly volumeMount?: PodV1SpecInitContainerVolumeMount[] | cdktf.IResolvable;
}
export declare function podV1SpecInitContainerToTerraform(struct?: PodV1SpecInitContainer | cdktf.IResolvable): any;
export declare class PodV1SpecInitContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecInitContainer | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecInitContainer | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _imagePullPolicy?;
    get imagePullPolicy(): string;
    set imagePullPolicy(value: string);
    resetImagePullPolicy(): void;
    get imagePullPolicyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _stdin?;
    get stdin(): boolean | cdktf.IResolvable;
    set stdin(value: boolean | cdktf.IResolvable);
    resetStdin(): void;
    get stdinInput(): boolean | cdktf.IResolvable | undefined;
    private _stdinOnce?;
    get stdinOnce(): boolean | cdktf.IResolvable;
    set stdinOnce(value: boolean | cdktf.IResolvable);
    resetStdinOnce(): void;
    get stdinOnceInput(): boolean | cdktf.IResolvable | undefined;
    private _terminationMessagePath?;
    get terminationMessagePath(): string;
    set terminationMessagePath(value: string);
    resetTerminationMessagePath(): void;
    get terminationMessagePathInput(): string | undefined;
    private _terminationMessagePolicy?;
    get terminationMessagePolicy(): string;
    set terminationMessagePolicy(value: string);
    resetTerminationMessagePolicy(): void;
    get terminationMessagePolicyInput(): string | undefined;
    private _tty?;
    get tty(): boolean | cdktf.IResolvable;
    set tty(value: boolean | cdktf.IResolvable);
    resetTty(): void;
    get ttyInput(): boolean | cdktf.IResolvable | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
    private _env;
    get env(): PodV1SpecInitContainerEnvList;
    putEnv(value: PodV1SpecInitContainerEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | PodV1SpecInitContainerEnv[] | undefined;
    private _envFrom;
    get envFrom(): PodV1SpecInitContainerEnvFromList;
    putEnvFrom(value: PodV1SpecInitContainerEnvFrom[] | cdktf.IResolvable): void;
    resetEnvFrom(): void;
    get envFromInput(): cdktf.IResolvable | PodV1SpecInitContainerEnvFrom[] | undefined;
    private _lifecycle;
    get lifecycle(): PodV1SpecInitContainerLifecycleOutputReference;
    putLifecycle(value: PodV1SpecInitContainerLifecycle): void;
    resetLifecycle(): void;
    get lifecycleInput(): PodV1SpecInitContainerLifecycle | undefined;
    private _livenessProbe;
    get livenessProbe(): PodV1SpecInitContainerLivenessProbeOutputReference;
    putLivenessProbe(value: PodV1SpecInitContainerLivenessProbe): void;
    resetLivenessProbe(): void;
    get livenessProbeInput(): PodV1SpecInitContainerLivenessProbe | undefined;
    private _port;
    get port(): PodV1SpecInitContainerPortList;
    putPort(value: PodV1SpecInitContainerPort[] | cdktf.IResolvable): void;
    resetPort(): void;
    get portInput(): cdktf.IResolvable | PodV1SpecInitContainerPort[] | undefined;
    private _readinessProbe;
    get readinessProbe(): PodV1SpecInitContainerReadinessProbeOutputReference;
    putReadinessProbe(value: PodV1SpecInitContainerReadinessProbe): void;
    resetReadinessProbe(): void;
    get readinessProbeInput(): PodV1SpecInitContainerReadinessProbe | undefined;
    private _resources;
    get resources(): PodV1SpecInitContainerResourcesOutputReference;
    putResources(value: PodV1SpecInitContainerResources): void;
    resetResources(): void;
    get resourcesInput(): PodV1SpecInitContainerResources | undefined;
    private _securityContext;
    get securityContext(): PodV1SpecInitContainerSecurityContextOutputReference;
    putSecurityContext(value: PodV1SpecInitContainerSecurityContext): void;
    resetSecurityContext(): void;
    get securityContextInput(): PodV1SpecInitContainerSecurityContext | undefined;
    private _startupProbe;
    get startupProbe(): PodV1SpecInitContainerStartupProbeOutputReference;
    putStartupProbe(value: PodV1SpecInitContainerStartupProbe): void;
    resetStartupProbe(): void;
    get startupProbeInput(): PodV1SpecInitContainerStartupProbe | undefined;
    private _volumeMount;
    get volumeMount(): PodV1SpecInitContainerVolumeMountList;
    putVolumeMount(value: PodV1SpecInitContainerVolumeMount[] | cdktf.IResolvable): void;
    resetVolumeMount(): void;
    get volumeMountInput(): cdktf.IResolvable | PodV1SpecInitContainerVolumeMount[] | undefined;
}
export declare class PodV1SpecInitContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecInitContainer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecInitContainerOutputReference;
}
export interface PodV1SpecReadinessGate {
    /**
    * refers to a condition in the pod's condition list with matching type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#condition_type PodV1#condition_type}
    */
    readonly conditionType: string;
}
export declare function podV1SpecReadinessGateToTerraform(struct?: PodV1SpecReadinessGate | cdktf.IResolvable): any;
export declare class PodV1SpecReadinessGateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecReadinessGate | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecReadinessGate | cdktf.IResolvable | undefined);
    private _conditionType?;
    get conditionType(): string;
    set conditionType(value: string);
    get conditionTypeInput(): string | undefined;
}
export declare class PodV1SpecReadinessGateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecReadinessGate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecReadinessGateOutputReference;
}
export interface PodV1SpecSecurityContextSeLinuxOptions {
    /**
    * Level is SELinux level label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#level PodV1#level}
    */
    readonly level?: string;
    /**
    * Role is a SELinux role label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#role PodV1#role}
    */
    readonly role?: string;
    /**
    * Type is a SELinux type label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#type PodV1#type}
    */
    readonly type?: string;
    /**
    * User is a SELinux user label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#user PodV1#user}
    */
    readonly user?: string;
}
export declare function podV1SpecSecurityContextSeLinuxOptionsToTerraform(struct?: PodV1SpecSecurityContextSeLinuxOptionsOutputReference | PodV1SpecSecurityContextSeLinuxOptions): any;
export declare class PodV1SpecSecurityContextSeLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecSecurityContextSeLinuxOptions | undefined;
    set internalValue(value: PodV1SpecSecurityContextSeLinuxOptions | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface PodV1SpecSecurityContextSeccompProfile {
    /**
    * Localhost Profile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#localhost_profile PodV1#localhost_profile}
    */
    readonly localhostProfile?: string;
    /**
    * Type indicates which kind of seccomp profile will be applied. Valid options are: Localhost, RuntimeDefault, Unconfined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#type PodV1#type}
    */
    readonly type?: string;
}
export declare function podV1SpecSecurityContextSeccompProfileToTerraform(struct?: PodV1SpecSecurityContextSeccompProfileOutputReference | PodV1SpecSecurityContextSeccompProfile): any;
export declare class PodV1SpecSecurityContextSeccompProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecSecurityContextSeccompProfile | undefined;
    set internalValue(value: PodV1SpecSecurityContextSeccompProfile | undefined);
    private _localhostProfile?;
    get localhostProfile(): string;
    set localhostProfile(value: string);
    resetLocalhostProfile(): void;
    get localhostProfileInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface PodV1SpecSecurityContextSysctl {
    /**
    * Name of a property to set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#name PodV1#name}
    */
    readonly name: string;
    /**
    * Value of a property to set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#value PodV1#value}
    */
    readonly value: string;
}
export declare function podV1SpecSecurityContextSysctlToTerraform(struct?: PodV1SpecSecurityContextSysctl | cdktf.IResolvable): any;
export declare class PodV1SpecSecurityContextSysctlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecSecurityContextSysctl | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecSecurityContextSysctl | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class PodV1SpecSecurityContextSysctlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecSecurityContextSysctl[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecSecurityContextSysctlOutputReference;
}
export interface PodV1SpecSecurityContext {
    /**
    * A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod: 1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw---- If unset, the Kubelet will not modify the ownership and permissions of any volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#fs_group PodV1#fs_group}
    */
    readonly fsGroup?: string;
    /**
    * fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#fs_group_change_policy PodV1#fs_group_change_policy}
    */
    readonly fsGroupChangePolicy?: string;
    /**
    * The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#run_as_group PodV1#run_as_group}
    */
    readonly runAsGroup?: string;
    /**
    * Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#run_as_non_root PodV1#run_as_non_root}
    */
    readonly runAsNonRoot?: boolean | cdktf.IResolvable;
    /**
    * The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#run_as_user PodV1#run_as_user}
    */
    readonly runAsUser?: string;
    /**
    * A list of groups applied to the first process run in each container, in addition to the container's primary GID. If unspecified, no groups will be added to any container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#supplemental_groups PodV1#supplemental_groups}
    */
    readonly supplementalGroups?: number[];
    /**
    * se_linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#se_linux_options PodV1#se_linux_options}
    */
    readonly seLinuxOptions?: PodV1SpecSecurityContextSeLinuxOptions;
    /**
    * seccomp_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#seccomp_profile PodV1#seccomp_profile}
    */
    readonly seccompProfile?: PodV1SpecSecurityContextSeccompProfile;
    /**
    * sysctl block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#sysctl PodV1#sysctl}
    */
    readonly sysctl?: PodV1SpecSecurityContextSysctl[] | cdktf.IResolvable;
}
export declare function podV1SpecSecurityContextToTerraform(struct?: PodV1SpecSecurityContextOutputReference | PodV1SpecSecurityContext): any;
export declare class PodV1SpecSecurityContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecSecurityContext | undefined;
    set internalValue(value: PodV1SpecSecurityContext | undefined);
    private _fsGroup?;
    get fsGroup(): string;
    set fsGroup(value: string);
    resetFsGroup(): void;
    get fsGroupInput(): string | undefined;
    private _fsGroupChangePolicy?;
    get fsGroupChangePolicy(): string;
    set fsGroupChangePolicy(value: string);
    resetFsGroupChangePolicy(): void;
    get fsGroupChangePolicyInput(): string | undefined;
    private _runAsGroup?;
    get runAsGroup(): string;
    set runAsGroup(value: string);
    resetRunAsGroup(): void;
    get runAsGroupInput(): string | undefined;
    private _runAsNonRoot?;
    get runAsNonRoot(): boolean | cdktf.IResolvable;
    set runAsNonRoot(value: boolean | cdktf.IResolvable);
    resetRunAsNonRoot(): void;
    get runAsNonRootInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsUser?;
    get runAsUser(): string;
    set runAsUser(value: string);
    resetRunAsUser(): void;
    get runAsUserInput(): string | undefined;
    private _supplementalGroups?;
    get supplementalGroups(): number[];
    set supplementalGroups(value: number[]);
    resetSupplementalGroups(): void;
    get supplementalGroupsInput(): number[] | undefined;
    private _seLinuxOptions;
    get seLinuxOptions(): PodV1SpecSecurityContextSeLinuxOptionsOutputReference;
    putSeLinuxOptions(value: PodV1SpecSecurityContextSeLinuxOptions): void;
    resetSeLinuxOptions(): void;
    get seLinuxOptionsInput(): PodV1SpecSecurityContextSeLinuxOptions | undefined;
    private _seccompProfile;
    get seccompProfile(): PodV1SpecSecurityContextSeccompProfileOutputReference;
    putSeccompProfile(value: PodV1SpecSecurityContextSeccompProfile): void;
    resetSeccompProfile(): void;
    get seccompProfileInput(): PodV1SpecSecurityContextSeccompProfile | undefined;
    private _sysctl;
    get sysctl(): PodV1SpecSecurityContextSysctlList;
    putSysctl(value: PodV1SpecSecurityContextSysctl[] | cdktf.IResolvable): void;
    resetSysctl(): void;
    get sysctlInput(): cdktf.IResolvable | PodV1SpecSecurityContextSysctl[] | undefined;
}
export interface PodV1SpecToleration {
    /**
    * Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#effect PodV1#effect}
    */
    readonly effect?: string;
    /**
    * Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#key PodV1#key}
    */
    readonly key?: string;
    /**
    * Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#operator PodV1#operator}
    */
    readonly operator?: string;
    /**
    * TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#toleration_seconds PodV1#toleration_seconds}
    */
    readonly tolerationSeconds?: string;
    /**
    * Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#value PodV1#value}
    */
    readonly value?: string;
}
export declare function podV1SpecTolerationToTerraform(struct?: PodV1SpecToleration | cdktf.IResolvable): any;
export declare class PodV1SpecTolerationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecToleration | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecToleration | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _tolerationSeconds?;
    get tolerationSeconds(): string;
    set tolerationSeconds(value: string);
    resetTolerationSeconds(): void;
    get tolerationSecondsInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class PodV1SpecTolerationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecToleration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecTolerationOutputReference;
}
export interface PodV1SpecTopologySpreadConstraintLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#key PodV1#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#operator PodV1#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#values PodV1#values}
    */
    readonly values?: string[];
}
export declare function podV1SpecTopologySpreadConstraintLabelSelectorMatchExpressionsToTerraform(struct?: PodV1SpecTopologySpreadConstraintLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class PodV1SpecTopologySpreadConstraintLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecTopologySpreadConstraintLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecTopologySpreadConstraintLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class PodV1SpecTopologySpreadConstraintLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecTopologySpreadConstraintLabelSelectorMatchExpressionsOutputReference;
}
export interface PodV1SpecTopologySpreadConstraintLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#match_labels PodV1#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#match_expressions PodV1#match_expressions}
    */
    readonly matchExpressions?: PodV1SpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function podV1SpecTopologySpreadConstraintLabelSelectorToTerraform(struct?: PodV1SpecTopologySpreadConstraintLabelSelector | cdktf.IResolvable): any;
export declare class PodV1SpecTopologySpreadConstraintLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecTopologySpreadConstraintLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecTopologySpreadConstraintLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): PodV1SpecTopologySpreadConstraintLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: PodV1SpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | PodV1SpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | undefined;
}
export declare class PodV1SpecTopologySpreadConstraintLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecTopologySpreadConstraintLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecTopologySpreadConstraintLabelSelectorOutputReference;
}
export interface PodV1SpecTopologySpreadConstraint {
    /**
    * describes the degree to which pods may be unevenly distributed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#max_skew PodV1#max_skew}
    */
    readonly maxSkew?: number;
    /**
    * the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#topology_key PodV1#topology_key}
    */
    readonly topologyKey?: string;
    /**
    * indicates how to deal with a pod if it doesn't satisfy the spread constraint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#when_unsatisfiable PodV1#when_unsatisfiable}
    */
    readonly whenUnsatisfiable?: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#label_selector PodV1#label_selector}
    */
    readonly labelSelector?: PodV1SpecTopologySpreadConstraintLabelSelector[] | cdktf.IResolvable;
}
export declare function podV1SpecTopologySpreadConstraintToTerraform(struct?: PodV1SpecTopologySpreadConstraint | cdktf.IResolvable): any;
export declare class PodV1SpecTopologySpreadConstraintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecTopologySpreadConstraint | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecTopologySpreadConstraint | cdktf.IResolvable | undefined);
    private _maxSkew?;
    get maxSkew(): number;
    set maxSkew(value: number);
    resetMaxSkew(): void;
    get maxSkewInput(): number | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    resetTopologyKey(): void;
    get topologyKeyInput(): string | undefined;
    private _whenUnsatisfiable?;
    get whenUnsatisfiable(): string;
    set whenUnsatisfiable(value: string);
    resetWhenUnsatisfiable(): void;
    get whenUnsatisfiableInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): PodV1SpecTopologySpreadConstraintLabelSelectorList;
    putLabelSelector(value: PodV1SpecTopologySpreadConstraintLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | PodV1SpecTopologySpreadConstraintLabelSelector[] | undefined;
}
export declare class PodV1SpecTopologySpreadConstraintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecTopologySpreadConstraint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecTopologySpreadConstraintOutputReference;
}
export interface PodV1SpecVolumeAwsElasticBlockStore {
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#fs_type PodV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#partition PodV1#partition}
    */
    readonly partition?: number;
    /**
    * Whether to set the read-only property in VolumeMounts to "true". If omitted, the default is "false". More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#volume_id PodV1#volume_id}
    */
    readonly volumeId: string;
}
export declare function podV1SpecVolumeAwsElasticBlockStoreToTerraform(struct?: PodV1SpecVolumeAwsElasticBlockStoreOutputReference | PodV1SpecVolumeAwsElasticBlockStore): any;
export declare class PodV1SpecVolumeAwsElasticBlockStoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeAwsElasticBlockStore | undefined;
    set internalValue(value: PodV1SpecVolumeAwsElasticBlockStore | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _partition?;
    get partition(): number;
    set partition(value: number);
    resetPartition(): void;
    get partitionInput(): number | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
}
export interface PodV1SpecVolumeAzureDisk {
    /**
    * Host Caching mode: None, Read Only, Read Write.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#caching_mode PodV1#caching_mode}
    */
    readonly cachingMode: string;
    /**
    * The URI the data disk in the blob storage
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#data_disk_uri PodV1#data_disk_uri}
    */
    readonly dataDiskUri: string;
    /**
    * The Name of the data disk in the blob storage
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#disk_name PodV1#disk_name}
    */
    readonly diskName: string;
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#fs_type PodV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * The type for the data disk. Expected values: Shared, Dedicated, Managed. Defaults to Shared
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#kind PodV1#kind}
    */
    readonly kind?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function podV1SpecVolumeAzureDiskToTerraform(struct?: PodV1SpecVolumeAzureDiskOutputReference | PodV1SpecVolumeAzureDisk): any;
export declare class PodV1SpecVolumeAzureDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeAzureDisk | undefined;
    set internalValue(value: PodV1SpecVolumeAzureDisk | undefined);
    private _cachingMode?;
    get cachingMode(): string;
    set cachingMode(value: string);
    get cachingModeInput(): string | undefined;
    private _dataDiskUri?;
    get dataDiskUri(): string;
    set dataDiskUri(value: string);
    get dataDiskUriInput(): string | undefined;
    private _diskName?;
    get diskName(): string;
    set diskName(value: string);
    get diskNameInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PodV1SpecVolumeAzureFile {
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * The name of secret that contains Azure Storage Account Name and Key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#secret_name PodV1#secret_name}
    */
    readonly secretName: string;
    /**
    * The namespace of the secret that contains Azure Storage Account Name and Key. For Kubernetes up to 1.18.x the default is the same as the Pod. For Kubernetes 1.19.x and later the default is "default" namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#secret_namespace PodV1#secret_namespace}
    */
    readonly secretNamespace?: string;
    /**
    * Share Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#share_name PodV1#share_name}
    */
    readonly shareName: string;
}
export declare function podV1SpecVolumeAzureFileToTerraform(struct?: PodV1SpecVolumeAzureFileOutputReference | PodV1SpecVolumeAzureFile): any;
export declare class PodV1SpecVolumeAzureFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeAzureFile | undefined;
    set internalValue(value: PodV1SpecVolumeAzureFile | undefined);
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
    private _secretNamespace?;
    get secretNamespace(): string;
    set secretNamespace(value: string);
    resetSecretNamespace(): void;
    get secretNamespaceInput(): string | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
}
export interface PodV1SpecVolumeCephFsSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#name PodV1#name}
    */
    readonly name?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#namespace PodV1#namespace}
    */
    readonly namespace?: string;
}
export declare function podV1SpecVolumeCephFsSecretRefToTerraform(struct?: PodV1SpecVolumeCephFsSecretRefOutputReference | PodV1SpecVolumeCephFsSecretRef): any;
export declare class PodV1SpecVolumeCephFsSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeCephFsSecretRef | undefined;
    set internalValue(value: PodV1SpecVolumeCephFsSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface PodV1SpecVolumeCephFs {
    /**
    * Monitors is a collection of Ceph monitors More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#monitors PodV1#monitors}
    */
    readonly monitors: string[];
    /**
    * Used as the mounted root, rather than the full Ceph tree, default is /
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#path PodV1#path}
    */
    readonly path?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to `false` (read/write). More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * The path to key ring for User, default is /etc/ceph/user.secret More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#secret_file PodV1#secret_file}
    */
    readonly secretFile?: string;
    /**
    * User is the rados user name, default is admin. More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#user PodV1#user}
    */
    readonly user?: string;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#secret_ref PodV1#secret_ref}
    */
    readonly secretRef?: PodV1SpecVolumeCephFsSecretRef;
}
export declare function podV1SpecVolumeCephFsToTerraform(struct?: PodV1SpecVolumeCephFsOutputReference | PodV1SpecVolumeCephFs): any;
export declare class PodV1SpecVolumeCephFsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeCephFs | undefined;
    set internalValue(value: PodV1SpecVolumeCephFs | undefined);
    private _monitors?;
    get monitors(): string[];
    set monitors(value: string[]);
    get monitorsInput(): string[] | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretFile?;
    get secretFile(): string;
    set secretFile(value: string);
    resetSecretFile(): void;
    get secretFileInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
    private _secretRef;
    get secretRef(): PodV1SpecVolumeCephFsSecretRefOutputReference;
    putSecretRef(value: PodV1SpecVolumeCephFsSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): PodV1SpecVolumeCephFsSecretRef | undefined;
}
export interface PodV1SpecVolumeCinder {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#fs_type PodV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write). More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Volume ID used to identify the volume in Cinder. More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#volume_id PodV1#volume_id}
    */
    readonly volumeId: string;
}
export declare function podV1SpecVolumeCinderToTerraform(struct?: PodV1SpecVolumeCinderOutputReference | PodV1SpecVolumeCinder): any;
export declare class PodV1SpecVolumeCinderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeCinder | undefined;
    set internalValue(value: PodV1SpecVolumeCinder | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
}
export interface PodV1SpecVolumeConfigMapItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#key PodV1#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#mode PodV1#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#path PodV1#path}
    */
    readonly path?: string;
}
export declare function podV1SpecVolumeConfigMapItemsToTerraform(struct?: PodV1SpecVolumeConfigMapItems | cdktf.IResolvable): any;
export declare class PodV1SpecVolumeConfigMapItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecVolumeConfigMapItems | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecVolumeConfigMapItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class PodV1SpecVolumeConfigMapItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecVolumeConfigMapItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecVolumeConfigMapItemsOutputReference;
}
export interface PodV1SpecVolumeConfigMap {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#default_mode PodV1#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#name PodV1#name}
    */
    readonly name?: string;
    /**
    * Optional: Specify whether the ConfigMap or its keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#optional PodV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#items PodV1#items}
    */
    readonly items?: PodV1SpecVolumeConfigMapItems[] | cdktf.IResolvable;
}
export declare function podV1SpecVolumeConfigMapToTerraform(struct?: PodV1SpecVolumeConfigMapOutputReference | PodV1SpecVolumeConfigMap): any;
export declare class PodV1SpecVolumeConfigMapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeConfigMap | undefined;
    set internalValue(value: PodV1SpecVolumeConfigMap | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _items;
    get items(): PodV1SpecVolumeConfigMapItemsList;
    putItems(value: PodV1SpecVolumeConfigMapItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | PodV1SpecVolumeConfigMapItems[] | undefined;
}
export interface PodV1SpecVolumeCsiNodePublishSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#name PodV1#name}
    */
    readonly name?: string;
}
export declare function podV1SpecVolumeCsiNodePublishSecretRefToTerraform(struct?: PodV1SpecVolumeCsiNodePublishSecretRefOutputReference | PodV1SpecVolumeCsiNodePublishSecretRef): any;
export declare class PodV1SpecVolumeCsiNodePublishSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeCsiNodePublishSecretRef | undefined;
    set internalValue(value: PodV1SpecVolumeCsiNodePublishSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export interface PodV1SpecVolumeCsi {
    /**
    * the name of the volume driver to use. More info: https://kubernetes.io/docs/concepts/storage/volumes/#csi
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#driver PodV1#driver}
    */
    readonly driver: string;
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#fs_type PodV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * Whether to set the read-only property in VolumeMounts to "true". If omitted, the default is "false". More info: http://kubernetes.io/docs/user-guide/volumes#csi
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Attributes of the volume to publish.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#volume_attributes PodV1#volume_attributes}
    */
    readonly volumeAttributes?: {
        [key: string]: string;
    };
    /**
    * node_publish_secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#node_publish_secret_ref PodV1#node_publish_secret_ref}
    */
    readonly nodePublishSecretRef?: PodV1SpecVolumeCsiNodePublishSecretRef;
}
export declare function podV1SpecVolumeCsiToTerraform(struct?: PodV1SpecVolumeCsiOutputReference | PodV1SpecVolumeCsi): any;
export declare class PodV1SpecVolumeCsiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeCsi | undefined;
    set internalValue(value: PodV1SpecVolumeCsi | undefined);
    private _driver?;
    get driver(): string;
    set driver(value: string);
    get driverInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeAttributes?;
    get volumeAttributes(): {
        [key: string]: string;
    };
    set volumeAttributes(value: {
        [key: string]: string;
    });
    resetVolumeAttributes(): void;
    get volumeAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _nodePublishSecretRef;
    get nodePublishSecretRef(): PodV1SpecVolumeCsiNodePublishSecretRefOutputReference;
    putNodePublishSecretRef(value: PodV1SpecVolumeCsiNodePublishSecretRef): void;
    resetNodePublishSecretRef(): void;
    get nodePublishSecretRefInput(): PodV1SpecVolumeCsiNodePublishSecretRef | undefined;
}
export interface PodV1SpecVolumeDownwardApiItemsFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to "v1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#api_version PodV1#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#field_path PodV1#field_path}
    */
    readonly fieldPath?: string;
}
export declare function podV1SpecVolumeDownwardApiItemsFieldRefToTerraform(struct?: PodV1SpecVolumeDownwardApiItemsFieldRefOutputReference | PodV1SpecVolumeDownwardApiItemsFieldRef): any;
export declare class PodV1SpecVolumeDownwardApiItemsFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeDownwardApiItemsFieldRef | undefined;
    set internalValue(value: PodV1SpecVolumeDownwardApiItemsFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface PodV1SpecVolumeDownwardApiItemsResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#container_name PodV1#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#divisor PodV1#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#resource PodV1#resource}
    */
    readonly resource: string;
}
export declare function podV1SpecVolumeDownwardApiItemsResourceFieldRefToTerraform(struct?: PodV1SpecVolumeDownwardApiItemsResourceFieldRefOutputReference | PodV1SpecVolumeDownwardApiItemsResourceFieldRef): any;
export declare class PodV1SpecVolumeDownwardApiItemsResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeDownwardApiItemsResourceFieldRef | undefined;
    set internalValue(value: PodV1SpecVolumeDownwardApiItemsResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface PodV1SpecVolumeDownwardApiItems {
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#mode PodV1#mode}
    */
    readonly mode?: string;
    /**
    * Path is the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#path PodV1#path}
    */
    readonly path: string;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#field_ref PodV1#field_ref}
    */
    readonly fieldRef: PodV1SpecVolumeDownwardApiItemsFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#resource_field_ref PodV1#resource_field_ref}
    */
    readonly resourceFieldRef?: PodV1SpecVolumeDownwardApiItemsResourceFieldRef;
}
export declare function podV1SpecVolumeDownwardApiItemsToTerraform(struct?: PodV1SpecVolumeDownwardApiItems | cdktf.IResolvable): any;
export declare class PodV1SpecVolumeDownwardApiItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecVolumeDownwardApiItems | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecVolumeDownwardApiItems | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _fieldRef;
    get fieldRef(): PodV1SpecVolumeDownwardApiItemsFieldRefOutputReference;
    putFieldRef(value: PodV1SpecVolumeDownwardApiItemsFieldRef): void;
    get fieldRefInput(): PodV1SpecVolumeDownwardApiItemsFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): PodV1SpecVolumeDownwardApiItemsResourceFieldRefOutputReference;
    putResourceFieldRef(value: PodV1SpecVolumeDownwardApiItemsResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): PodV1SpecVolumeDownwardApiItemsResourceFieldRef | undefined;
}
export declare class PodV1SpecVolumeDownwardApiItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecVolumeDownwardApiItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecVolumeDownwardApiItemsOutputReference;
}
export interface PodV1SpecVolumeDownwardApi {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#default_mode PodV1#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#items PodV1#items}
    */
    readonly items?: PodV1SpecVolumeDownwardApiItems[] | cdktf.IResolvable;
}
export declare function podV1SpecVolumeDownwardApiToTerraform(struct?: PodV1SpecVolumeDownwardApiOutputReference | PodV1SpecVolumeDownwardApi): any;
export declare class PodV1SpecVolumeDownwardApiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeDownwardApi | undefined;
    set internalValue(value: PodV1SpecVolumeDownwardApi | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _items;
    get items(): PodV1SpecVolumeDownwardApiItemsList;
    putItems(value: PodV1SpecVolumeDownwardApiItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | PodV1SpecVolumeDownwardApiItems[] | undefined;
}
export interface PodV1SpecVolumeEmptyDir {
    /**
    * What type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#medium PodV1#medium}
    */
    readonly medium?: string;
    /**
    * Total amount of local storage required for this EmptyDir volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#size_limit PodV1#size_limit}
    */
    readonly sizeLimit?: string;
}
export declare function podV1SpecVolumeEmptyDirToTerraform(struct?: PodV1SpecVolumeEmptyDirOutputReference | PodV1SpecVolumeEmptyDir): any;
export declare class PodV1SpecVolumeEmptyDirOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeEmptyDir | undefined;
    set internalValue(value: PodV1SpecVolumeEmptyDir | undefined);
    private _medium?;
    get medium(): string;
    set medium(value: string);
    resetMedium(): void;
    get mediumInput(): string | undefined;
    private _sizeLimit?;
    get sizeLimit(): string;
    set sizeLimit(value: string);
    resetSizeLimit(): void;
    get sizeLimitInput(): string | undefined;
}
export interface PodV1SpecVolumeFc {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#fs_type PodV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * FC target lun number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#lun PodV1#lun}
    */
    readonly lun: number;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * FC target worldwide names (WWNs)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#target_ww_ns PodV1#target_ww_ns}
    */
    readonly targetWwNs: string[];
}
export declare function podV1SpecVolumeFcToTerraform(struct?: PodV1SpecVolumeFcOutputReference | PodV1SpecVolumeFc): any;
export declare class PodV1SpecVolumeFcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeFc | undefined;
    set internalValue(value: PodV1SpecVolumeFc | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    get lunInput(): number | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _targetWwNs?;
    get targetWwNs(): string[];
    set targetWwNs(value: string[]);
    get targetWwNsInput(): string[] | undefined;
}
export interface PodV1SpecVolumeFlexVolumeSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#name PodV1#name}
    */
    readonly name?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#namespace PodV1#namespace}
    */
    readonly namespace?: string;
}
export declare function podV1SpecVolumeFlexVolumeSecretRefToTerraform(struct?: PodV1SpecVolumeFlexVolumeSecretRefOutputReference | PodV1SpecVolumeFlexVolumeSecretRef): any;
export declare class PodV1SpecVolumeFlexVolumeSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeFlexVolumeSecretRef | undefined;
    set internalValue(value: PodV1SpecVolumeFlexVolumeSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface PodV1SpecVolumeFlexVolume {
    /**
    * Driver is the name of the driver to use for this volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#driver PodV1#driver}
    */
    readonly driver: string;
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#fs_type PodV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * Extra command options if any.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#options PodV1#options}
    */
    readonly options?: {
        [key: string]: string;
    };
    /**
    * Whether to force the ReadOnly setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#secret_ref PodV1#secret_ref}
    */
    readonly secretRef?: PodV1SpecVolumeFlexVolumeSecretRef;
}
export declare function podV1SpecVolumeFlexVolumeToTerraform(struct?: PodV1SpecVolumeFlexVolumeOutputReference | PodV1SpecVolumeFlexVolume): any;
export declare class PodV1SpecVolumeFlexVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeFlexVolume | undefined;
    set internalValue(value: PodV1SpecVolumeFlexVolume | undefined);
    private _driver?;
    get driver(): string;
    set driver(value: string);
    get driverInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    resetOptions(): void;
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretRef;
    get secretRef(): PodV1SpecVolumeFlexVolumeSecretRefOutputReference;
    putSecretRef(value: PodV1SpecVolumeFlexVolumeSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): PodV1SpecVolumeFlexVolumeSecretRef | undefined;
}
export interface PodV1SpecVolumeFlocker {
    /**
    * Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#dataset_name PodV1#dataset_name}
    */
    readonly datasetName?: string;
    /**
    * UUID of the dataset. This is unique identifier of a Flocker dataset
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#dataset_uuid PodV1#dataset_uuid}
    */
    readonly datasetUuid?: string;
}
export declare function podV1SpecVolumeFlockerToTerraform(struct?: PodV1SpecVolumeFlockerOutputReference | PodV1SpecVolumeFlocker): any;
export declare class PodV1SpecVolumeFlockerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeFlocker | undefined;
    set internalValue(value: PodV1SpecVolumeFlocker | undefined);
    private _datasetName?;
    get datasetName(): string;
    set datasetName(value: string);
    resetDatasetName(): void;
    get datasetNameInput(): string | undefined;
    private _datasetUuid?;
    get datasetUuid(): string;
    set datasetUuid(value: string);
    resetDatasetUuid(): void;
    get datasetUuidInput(): string | undefined;
}
export interface PodV1SpecVolumeGcePersistentDisk {
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#fs_type PodV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#partition PodV1#partition}
    */
    readonly partition?: number;
    /**
    * Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#pd_name PodV1#pd_name}
    */
    readonly pdName: string;
    /**
    * Whether to force the ReadOnly setting in VolumeMounts. Defaults to false. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function podV1SpecVolumeGcePersistentDiskToTerraform(struct?: PodV1SpecVolumeGcePersistentDiskOutputReference | PodV1SpecVolumeGcePersistentDisk): any;
export declare class PodV1SpecVolumeGcePersistentDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeGcePersistentDisk | undefined;
    set internalValue(value: PodV1SpecVolumeGcePersistentDisk | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _partition?;
    get partition(): number;
    set partition(value: number);
    resetPartition(): void;
    get partitionInput(): number | undefined;
    private _pdName?;
    get pdName(): string;
    set pdName(value: string);
    get pdNameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PodV1SpecVolumeGitRepo {
    /**
    * Target directory name. Must not contain or start with '..'. If '.' is supplied, the volume directory will be the git repository. Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#directory PodV1#directory}
    */
    readonly directory?: string;
    /**
    * Repository URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#repository PodV1#repository}
    */
    readonly repository?: string;
    /**
    * Commit hash for the specified revision.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#revision PodV1#revision}
    */
    readonly revision?: string;
}
export declare function podV1SpecVolumeGitRepoToTerraform(struct?: PodV1SpecVolumeGitRepoOutputReference | PodV1SpecVolumeGitRepo): any;
export declare class PodV1SpecVolumeGitRepoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeGitRepo | undefined;
    set internalValue(value: PodV1SpecVolumeGitRepo | undefined);
    private _directory?;
    get directory(): string;
    set directory(value: string);
    resetDirectory(): void;
    get directoryInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    resetRepository(): void;
    get repositoryInput(): string | undefined;
    private _revision?;
    get revision(): string;
    set revision(value: string);
    resetRevision(): void;
    get revisionInput(): string | undefined;
}
export interface PodV1SpecVolumeGlusterfs {
    /**
    * The endpoint name that details Glusterfs topology. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#endpoints_name PodV1#endpoints_name}
    */
    readonly endpointsName: string;
    /**
    * The Glusterfs volume path. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#path PodV1#path}
    */
    readonly path: string;
    /**
    * Whether to force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function podV1SpecVolumeGlusterfsToTerraform(struct?: PodV1SpecVolumeGlusterfsOutputReference | PodV1SpecVolumeGlusterfs): any;
export declare class PodV1SpecVolumeGlusterfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeGlusterfs | undefined;
    set internalValue(value: PodV1SpecVolumeGlusterfs | undefined);
    private _endpointsName?;
    get endpointsName(): string;
    set endpointsName(value: string);
    get endpointsNameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PodV1SpecVolumeHostPath {
    /**
    * Path of the directory on the host. More info: http://kubernetes.io/docs/user-guide/volumes#hostpath
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#path PodV1#path}
    */
    readonly path?: string;
    /**
    * Type for HostPath volume. Allowed values are "" (default), DirectoryOrCreate, Directory, FileOrCreate, File, Socket, CharDevice and BlockDevice
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#type PodV1#type}
    */
    readonly type?: string;
}
export declare function podV1SpecVolumeHostPathToTerraform(struct?: PodV1SpecVolumeHostPathOutputReference | PodV1SpecVolumeHostPath): any;
export declare class PodV1SpecVolumeHostPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeHostPath | undefined;
    set internalValue(value: PodV1SpecVolumeHostPath | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface PodV1SpecVolumeIscsi {
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#iscsi
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#fs_type PodV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * Target iSCSI Qualified Name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#iqn PodV1#iqn}
    */
    readonly iqn: string;
    /**
    * iSCSI interface name that uses an iSCSI transport. Defaults to 'default' (tcp).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#iscsi_interface PodV1#iscsi_interface}
    */
    readonly iscsiInterface?: string;
    /**
    * iSCSI target lun number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#lun PodV1#lun}
    */
    readonly lun?: number;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * iSCSI target portal. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#target_portal PodV1#target_portal}
    */
    readonly targetPortal: string;
}
export declare function podV1SpecVolumeIscsiToTerraform(struct?: PodV1SpecVolumeIscsiOutputReference | PodV1SpecVolumeIscsi): any;
export declare class PodV1SpecVolumeIscsiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeIscsi | undefined;
    set internalValue(value: PodV1SpecVolumeIscsi | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _iqn?;
    get iqn(): string;
    set iqn(value: string);
    get iqnInput(): string | undefined;
    private _iscsiInterface?;
    get iscsiInterface(): string;
    set iscsiInterface(value: string);
    resetIscsiInterface(): void;
    get iscsiInterfaceInput(): string | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    resetLun(): void;
    get lunInput(): number | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _targetPortal?;
    get targetPortal(): string;
    set targetPortal(value: string);
    get targetPortalInput(): string | undefined;
}
export interface PodV1SpecVolumeLocal {
    /**
    * Path of the directory on the host. More info: http://kubernetes.io/docs/user-guide/volumes#local
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#path PodV1#path}
    */
    readonly path?: string;
}
export declare function podV1SpecVolumeLocalToTerraform(struct?: PodV1SpecVolumeLocalOutputReference | PodV1SpecVolumeLocal): any;
export declare class PodV1SpecVolumeLocalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeLocal | undefined;
    set internalValue(value: PodV1SpecVolumeLocal | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export interface PodV1SpecVolumeNfs {
    /**
    * Path that is exported by the NFS server. More info: http://kubernetes.io/docs/user-guide/volumes#nfs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#path PodV1#path}
    */
    readonly path: string;
    /**
    * Whether to force the NFS export to be mounted with read-only permissions. Defaults to false. More info: http://kubernetes.io/docs/user-guide/volumes#nfs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Server is the hostname or IP address of the NFS server. More info: http://kubernetes.io/docs/user-guide/volumes#nfs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#server PodV1#server}
    */
    readonly server: string;
}
export declare function podV1SpecVolumeNfsToTerraform(struct?: PodV1SpecVolumeNfsOutputReference | PodV1SpecVolumeNfs): any;
export declare class PodV1SpecVolumeNfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeNfs | undefined;
    set internalValue(value: PodV1SpecVolumeNfs | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
}
export interface PodV1SpecVolumePersistentVolumeClaim {
    /**
    * ClaimName is the name of a PersistentVolumeClaim in the same
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#claim_name PodV1#claim_name}
    */
    readonly claimName?: string;
    /**
    * Will force the ReadOnly setting in VolumeMounts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function podV1SpecVolumePersistentVolumeClaimToTerraform(struct?: PodV1SpecVolumePersistentVolumeClaimOutputReference | PodV1SpecVolumePersistentVolumeClaim): any;
export declare class PodV1SpecVolumePersistentVolumeClaimOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumePersistentVolumeClaim | undefined;
    set internalValue(value: PodV1SpecVolumePersistentVolumeClaim | undefined);
    private _claimName?;
    get claimName(): string;
    set claimName(value: string);
    resetClaimName(): void;
    get claimNameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PodV1SpecVolumePhotonPersistentDisk {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#fs_type PodV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * ID that identifies Photon Controller persistent disk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#pd_id PodV1#pd_id}
    */
    readonly pdId: string;
}
export declare function podV1SpecVolumePhotonPersistentDiskToTerraform(struct?: PodV1SpecVolumePhotonPersistentDiskOutputReference | PodV1SpecVolumePhotonPersistentDisk): any;
export declare class PodV1SpecVolumePhotonPersistentDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumePhotonPersistentDisk | undefined;
    set internalValue(value: PodV1SpecVolumePhotonPersistentDisk | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _pdId?;
    get pdId(): string;
    set pdId(value: string);
    get pdIdInput(): string | undefined;
}
export interface PodV1SpecVolumeProjectedSourcesConfigMapItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#key PodV1#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#mode PodV1#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#path PodV1#path}
    */
    readonly path?: string;
}
export declare function podV1SpecVolumeProjectedSourcesConfigMapItemsToTerraform(struct?: PodV1SpecVolumeProjectedSourcesConfigMapItems | cdktf.IResolvable): any;
export declare class PodV1SpecVolumeProjectedSourcesConfigMapItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecVolumeProjectedSourcesConfigMapItems | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecVolumeProjectedSourcesConfigMapItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class PodV1SpecVolumeProjectedSourcesConfigMapItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecVolumeProjectedSourcesConfigMapItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecVolumeProjectedSourcesConfigMapItemsOutputReference;
}
export interface PodV1SpecVolumeProjectedSourcesConfigMap {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#name PodV1#name}
    */
    readonly name?: string;
    /**
    * Optional: Specify whether the ConfigMap or it's keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#optional PodV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#items PodV1#items}
    */
    readonly items?: PodV1SpecVolumeProjectedSourcesConfigMapItems[] | cdktf.IResolvable;
}
export declare function podV1SpecVolumeProjectedSourcesConfigMapToTerraform(struct?: PodV1SpecVolumeProjectedSourcesConfigMap | cdktf.IResolvable): any;
export declare class PodV1SpecVolumeProjectedSourcesConfigMapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecVolumeProjectedSourcesConfigMap | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecVolumeProjectedSourcesConfigMap | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _items;
    get items(): PodV1SpecVolumeProjectedSourcesConfigMapItemsList;
    putItems(value: PodV1SpecVolumeProjectedSourcesConfigMapItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | PodV1SpecVolumeProjectedSourcesConfigMapItems[] | undefined;
}
export declare class PodV1SpecVolumeProjectedSourcesConfigMapList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecVolumeProjectedSourcesConfigMap[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecVolumeProjectedSourcesConfigMapOutputReference;
}
export interface PodV1SpecVolumeProjectedSourcesDownwardApiItemsFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to 'v1'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#api_version PodV1#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#field_path PodV1#field_path}
    */
    readonly fieldPath?: string;
}
export declare function podV1SpecVolumeProjectedSourcesDownwardApiItemsFieldRefToTerraform(struct?: PodV1SpecVolumeProjectedSourcesDownwardApiItemsFieldRefOutputReference | PodV1SpecVolumeProjectedSourcesDownwardApiItemsFieldRef): any;
export declare class PodV1SpecVolumeProjectedSourcesDownwardApiItemsFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeProjectedSourcesDownwardApiItemsFieldRef | undefined;
    set internalValue(value: PodV1SpecVolumeProjectedSourcesDownwardApiItemsFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface PodV1SpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#container_name PodV1#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#divisor PodV1#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#resource PodV1#resource}
    */
    readonly resource: string;
}
export declare function podV1SpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefToTerraform(struct?: PodV1SpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefOutputReference | PodV1SpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef): any;
export declare class PodV1SpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef | undefined;
    set internalValue(value: PodV1SpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface PodV1SpecVolumeProjectedSourcesDownwardApiItems {
    /**
    * Mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#mode PodV1#mode}
    */
    readonly mode?: string;
    /**
    * Path is the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#path PodV1#path}
    */
    readonly path: string;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#field_ref PodV1#field_ref}
    */
    readonly fieldRef?: PodV1SpecVolumeProjectedSourcesDownwardApiItemsFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#resource_field_ref PodV1#resource_field_ref}
    */
    readonly resourceFieldRef?: PodV1SpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef;
}
export declare function podV1SpecVolumeProjectedSourcesDownwardApiItemsToTerraform(struct?: PodV1SpecVolumeProjectedSourcesDownwardApiItems | cdktf.IResolvable): any;
export declare class PodV1SpecVolumeProjectedSourcesDownwardApiItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecVolumeProjectedSourcesDownwardApiItems | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecVolumeProjectedSourcesDownwardApiItems | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _fieldRef;
    get fieldRef(): PodV1SpecVolumeProjectedSourcesDownwardApiItemsFieldRefOutputReference;
    putFieldRef(value: PodV1SpecVolumeProjectedSourcesDownwardApiItemsFieldRef): void;
    resetFieldRef(): void;
    get fieldRefInput(): PodV1SpecVolumeProjectedSourcesDownwardApiItemsFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): PodV1SpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefOutputReference;
    putResourceFieldRef(value: PodV1SpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): PodV1SpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef | undefined;
}
export declare class PodV1SpecVolumeProjectedSourcesDownwardApiItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecVolumeProjectedSourcesDownwardApiItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecVolumeProjectedSourcesDownwardApiItemsOutputReference;
}
export interface PodV1SpecVolumeProjectedSourcesDownwardApi {
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#items PodV1#items}
    */
    readonly items?: PodV1SpecVolumeProjectedSourcesDownwardApiItems[] | cdktf.IResolvable;
}
export declare function podV1SpecVolumeProjectedSourcesDownwardApiToTerraform(struct?: PodV1SpecVolumeProjectedSourcesDownwardApiOutputReference | PodV1SpecVolumeProjectedSourcesDownwardApi): any;
export declare class PodV1SpecVolumeProjectedSourcesDownwardApiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeProjectedSourcesDownwardApi | undefined;
    set internalValue(value: PodV1SpecVolumeProjectedSourcesDownwardApi | undefined);
    private _items;
    get items(): PodV1SpecVolumeProjectedSourcesDownwardApiItemsList;
    putItems(value: PodV1SpecVolumeProjectedSourcesDownwardApiItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | PodV1SpecVolumeProjectedSourcesDownwardApiItems[] | undefined;
}
export interface PodV1SpecVolumeProjectedSourcesSecretItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#key PodV1#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#mode PodV1#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#path PodV1#path}
    */
    readonly path?: string;
}
export declare function podV1SpecVolumeProjectedSourcesSecretItemsToTerraform(struct?: PodV1SpecVolumeProjectedSourcesSecretItems | cdktf.IResolvable): any;
export declare class PodV1SpecVolumeProjectedSourcesSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecVolumeProjectedSourcesSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecVolumeProjectedSourcesSecretItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class PodV1SpecVolumeProjectedSourcesSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecVolumeProjectedSourcesSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecVolumeProjectedSourcesSecretItemsOutputReference;
}
export interface PodV1SpecVolumeProjectedSourcesSecret {
    /**
    * Name of the secret in the pod's namespace to use. More info: http://kubernetes.io/docs/user-guide/volumes#secrets
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#name PodV1#name}
    */
    readonly name?: string;
    /**
    * Optional: Specify whether the Secret or it's keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#optional PodV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#items PodV1#items}
    */
    readonly items?: PodV1SpecVolumeProjectedSourcesSecretItems[] | cdktf.IResolvable;
}
export declare function podV1SpecVolumeProjectedSourcesSecretToTerraform(struct?: PodV1SpecVolumeProjectedSourcesSecret | cdktf.IResolvable): any;
export declare class PodV1SpecVolumeProjectedSourcesSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecVolumeProjectedSourcesSecret | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecVolumeProjectedSourcesSecret | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _items;
    get items(): PodV1SpecVolumeProjectedSourcesSecretItemsList;
    putItems(value: PodV1SpecVolumeProjectedSourcesSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | PodV1SpecVolumeProjectedSourcesSecretItems[] | undefined;
}
export declare class PodV1SpecVolumeProjectedSourcesSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecVolumeProjectedSourcesSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecVolumeProjectedSourcesSecretOutputReference;
}
export interface PodV1SpecVolumeProjectedSourcesServiceAccountToken {
    /**
    * Audience is the intended audience of the token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#audience PodV1#audience}
    */
    readonly audience?: string;
    /**
    * ExpirationSeconds is the expected duration of validity of the service account token. It defaults to 1 hour and must be at least 10 minutes (600 seconds).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#expiration_seconds PodV1#expiration_seconds}
    */
    readonly expirationSeconds?: number;
    /**
    * Path specifies a relative path to the mount point of the projected volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#path PodV1#path}
    */
    readonly path: string;
}
export declare function podV1SpecVolumeProjectedSourcesServiceAccountTokenToTerraform(struct?: PodV1SpecVolumeProjectedSourcesServiceAccountTokenOutputReference | PodV1SpecVolumeProjectedSourcesServiceAccountToken): any;
export declare class PodV1SpecVolumeProjectedSourcesServiceAccountTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeProjectedSourcesServiceAccountToken | undefined;
    set internalValue(value: PodV1SpecVolumeProjectedSourcesServiceAccountToken | undefined);
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _expirationSeconds?;
    get expirationSeconds(): number;
    set expirationSeconds(value: number);
    resetExpirationSeconds(): void;
    get expirationSecondsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface PodV1SpecVolumeProjectedSources {
    /**
    * config_map block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#config_map PodV1#config_map}
    */
    readonly configMap?: PodV1SpecVolumeProjectedSourcesConfigMap[] | cdktf.IResolvable;
    /**
    * downward_api block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#downward_api PodV1#downward_api}
    */
    readonly downwardApi?: PodV1SpecVolumeProjectedSourcesDownwardApi;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#secret PodV1#secret}
    */
    readonly secret?: PodV1SpecVolumeProjectedSourcesSecret[] | cdktf.IResolvable;
    /**
    * service_account_token block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#service_account_token PodV1#service_account_token}
    */
    readonly serviceAccountToken?: PodV1SpecVolumeProjectedSourcesServiceAccountToken;
}
export declare function podV1SpecVolumeProjectedSourcesToTerraform(struct?: PodV1SpecVolumeProjectedSources | cdktf.IResolvable): any;
export declare class PodV1SpecVolumeProjectedSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecVolumeProjectedSources | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecVolumeProjectedSources | cdktf.IResolvable | undefined);
    private _configMap;
    get configMap(): PodV1SpecVolumeProjectedSourcesConfigMapList;
    putConfigMap(value: PodV1SpecVolumeProjectedSourcesConfigMap[] | cdktf.IResolvable): void;
    resetConfigMap(): void;
    get configMapInput(): cdktf.IResolvable | PodV1SpecVolumeProjectedSourcesConfigMap[] | undefined;
    private _downwardApi;
    get downwardApi(): PodV1SpecVolumeProjectedSourcesDownwardApiOutputReference;
    putDownwardApi(value: PodV1SpecVolumeProjectedSourcesDownwardApi): void;
    resetDownwardApi(): void;
    get downwardApiInput(): PodV1SpecVolumeProjectedSourcesDownwardApi | undefined;
    private _secret;
    get secret(): PodV1SpecVolumeProjectedSourcesSecretList;
    putSecret(value: PodV1SpecVolumeProjectedSourcesSecret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | PodV1SpecVolumeProjectedSourcesSecret[] | undefined;
    private _serviceAccountToken;
    get serviceAccountToken(): PodV1SpecVolumeProjectedSourcesServiceAccountTokenOutputReference;
    putServiceAccountToken(value: PodV1SpecVolumeProjectedSourcesServiceAccountToken): void;
    resetServiceAccountToken(): void;
    get serviceAccountTokenInput(): PodV1SpecVolumeProjectedSourcesServiceAccountToken | undefined;
}
export declare class PodV1SpecVolumeProjectedSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecVolumeProjectedSources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecVolumeProjectedSourcesOutputReference;
}
export interface PodV1SpecVolumeProjected {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#default_mode PodV1#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * sources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#sources PodV1#sources}
    */
    readonly sources: PodV1SpecVolumeProjectedSources[] | cdktf.IResolvable;
}
export declare function podV1SpecVolumeProjectedToTerraform(struct?: PodV1SpecVolumeProjected | cdktf.IResolvable): any;
export declare class PodV1SpecVolumeProjectedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecVolumeProjected | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecVolumeProjected | cdktf.IResolvable | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _sources;
    get sources(): PodV1SpecVolumeProjectedSourcesList;
    putSources(value: PodV1SpecVolumeProjectedSources[] | cdktf.IResolvable): void;
    get sourcesInput(): cdktf.IResolvable | PodV1SpecVolumeProjectedSources[] | undefined;
}
export declare class PodV1SpecVolumeProjectedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecVolumeProjected[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecVolumeProjectedOutputReference;
}
export interface PodV1SpecVolumeQuobyte {
    /**
    * Group to map volume access to Default is no group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#group PodV1#group}
    */
    readonly group?: string;
    /**
    * Whether to force the Quobyte volume to be mounted with read-only permissions. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#registry PodV1#registry}
    */
    readonly registry: string;
    /**
    * User to map volume access to Defaults to serivceaccount user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#user PodV1#user}
    */
    readonly user?: string;
    /**
    * Volume is a string that references an already created Quobyte volume by name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#volume PodV1#volume}
    */
    readonly volume: string;
}
export declare function podV1SpecVolumeQuobyteToTerraform(struct?: PodV1SpecVolumeQuobyteOutputReference | PodV1SpecVolumeQuobyte): any;
export declare class PodV1SpecVolumeQuobyteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeQuobyte | undefined;
    set internalValue(value: PodV1SpecVolumeQuobyte | undefined);
    private _group?;
    get group(): string;
    set group(value: string);
    resetGroup(): void;
    get groupInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _registry?;
    get registry(): string;
    set registry(value: string);
    get registryInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
    private _volume?;
    get volume(): string;
    set volume(value: string);
    get volumeInput(): string | undefined;
}
export interface PodV1SpecVolumeRbdSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#name PodV1#name}
    */
    readonly name?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#namespace PodV1#namespace}
    */
    readonly namespace?: string;
}
export declare function podV1SpecVolumeRbdSecretRefToTerraform(struct?: PodV1SpecVolumeRbdSecretRefOutputReference | PodV1SpecVolumeRbdSecretRef): any;
export declare class PodV1SpecVolumeRbdSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeRbdSecretRef | undefined;
    set internalValue(value: PodV1SpecVolumeRbdSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface PodV1SpecVolumeRbd {
    /**
    * A collection of Ceph monitors. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#ceph_monitors PodV1#ceph_monitors}
    */
    readonly cephMonitors: string[];
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#rbd
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#fs_type PodV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#keyring PodV1#keyring}
    */
    readonly keyring?: string;
    /**
    * The rados user name. Default is admin. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#rados_user PodV1#rados_user}
    */
    readonly radosUser?: string;
    /**
    * The rados image name. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#rbd_image PodV1#rbd_image}
    */
    readonly rbdImage: string;
    /**
    * The rados pool name. Default is rbd. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#rbd_pool PodV1#rbd_pool}
    */
    readonly rbdPool?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#read_only PodV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#secret_ref PodV1#secret_ref}
    */
    readonly secretRef?: PodV1SpecVolumeRbdSecretRef;
}
export declare function podV1SpecVolumeRbdToTerraform(struct?: PodV1SpecVolumeRbdOutputReference | PodV1SpecVolumeRbd): any;
export declare class PodV1SpecVolumeRbdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeRbd | undefined;
    set internalValue(value: PodV1SpecVolumeRbd | undefined);
    private _cephMonitors?;
    get cephMonitors(): string[];
    set cephMonitors(value: string[]);
    get cephMonitorsInput(): string[] | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _keyring?;
    get keyring(): string;
    set keyring(value: string);
    resetKeyring(): void;
    get keyringInput(): string | undefined;
    private _radosUser?;
    get radosUser(): string;
    set radosUser(value: string);
    resetRadosUser(): void;
    get radosUserInput(): string | undefined;
    private _rbdImage?;
    get rbdImage(): string;
    set rbdImage(value: string);
    get rbdImageInput(): string | undefined;
    private _rbdPool?;
    get rbdPool(): string;
    set rbdPool(value: string);
    resetRbdPool(): void;
    get rbdPoolInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretRef;
    get secretRef(): PodV1SpecVolumeRbdSecretRefOutputReference;
    putSecretRef(value: PodV1SpecVolumeRbdSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): PodV1SpecVolumeRbdSecretRef | undefined;
}
export interface PodV1SpecVolumeSecretItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#key PodV1#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#mode PodV1#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#path PodV1#path}
    */
    readonly path?: string;
}
export declare function podV1SpecVolumeSecretItemsToTerraform(struct?: PodV1SpecVolumeSecretItems | cdktf.IResolvable): any;
export declare class PodV1SpecVolumeSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecVolumeSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecVolumeSecretItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class PodV1SpecVolumeSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecVolumeSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecVolumeSecretItemsOutputReference;
}
export interface PodV1SpecVolumeSecret {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#default_mode PodV1#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * Optional: Specify whether the Secret or its keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#optional PodV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * Name of the secret in the pod's namespace to use. More info: http://kubernetes.io/docs/user-guide/volumes#secrets
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#secret_name PodV1#secret_name}
    */
    readonly secretName?: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#items PodV1#items}
    */
    readonly items?: PodV1SpecVolumeSecretItems[] | cdktf.IResolvable;
}
export declare function podV1SpecVolumeSecretToTerraform(struct?: PodV1SpecVolumeSecretOutputReference | PodV1SpecVolumeSecret): any;
export declare class PodV1SpecVolumeSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeSecret | undefined;
    set internalValue(value: PodV1SpecVolumeSecret | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    resetSecretName(): void;
    get secretNameInput(): string | undefined;
    private _items;
    get items(): PodV1SpecVolumeSecretItemsList;
    putItems(value: PodV1SpecVolumeSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | PodV1SpecVolumeSecretItems[] | undefined;
}
export interface PodV1SpecVolumeVsphereVolume {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#fs_type PodV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * Path that identifies vSphere volume vmdk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#volume_path PodV1#volume_path}
    */
    readonly volumePath: string;
}
export declare function podV1SpecVolumeVsphereVolumeToTerraform(struct?: PodV1SpecVolumeVsphereVolumeOutputReference | PodV1SpecVolumeVsphereVolume): any;
export declare class PodV1SpecVolumeVsphereVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1SpecVolumeVsphereVolume | undefined;
    set internalValue(value: PodV1SpecVolumeVsphereVolume | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _volumePath?;
    get volumePath(): string;
    set volumePath(value: string);
    get volumePathInput(): string | undefined;
}
export interface PodV1SpecVolume {
    /**
    * Volume's name. Must be a DNS_LABEL and unique within the pod. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#name PodV1#name}
    */
    readonly name?: string;
    /**
    * aws_elastic_block_store block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#aws_elastic_block_store PodV1#aws_elastic_block_store}
    */
    readonly awsElasticBlockStore?: PodV1SpecVolumeAwsElasticBlockStore;
    /**
    * azure_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#azure_disk PodV1#azure_disk}
    */
    readonly azureDisk?: PodV1SpecVolumeAzureDisk;
    /**
    * azure_file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#azure_file PodV1#azure_file}
    */
    readonly azureFile?: PodV1SpecVolumeAzureFile;
    /**
    * ceph_fs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#ceph_fs PodV1#ceph_fs}
    */
    readonly cephFs?: PodV1SpecVolumeCephFs;
    /**
    * cinder block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#cinder PodV1#cinder}
    */
    readonly cinder?: PodV1SpecVolumeCinder;
    /**
    * config_map block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#config_map PodV1#config_map}
    */
    readonly configMap?: PodV1SpecVolumeConfigMap;
    /**
    * csi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#csi PodV1#csi}
    */
    readonly csi?: PodV1SpecVolumeCsi;
    /**
    * downward_api block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#downward_api PodV1#downward_api}
    */
    readonly downwardApi?: PodV1SpecVolumeDownwardApi;
    /**
    * empty_dir block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#empty_dir PodV1#empty_dir}
    */
    readonly emptyDir?: PodV1SpecVolumeEmptyDir;
    /**
    * fc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#fc PodV1#fc}
    */
    readonly fc?: PodV1SpecVolumeFc;
    /**
    * flex_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#flex_volume PodV1#flex_volume}
    */
    readonly flexVolume?: PodV1SpecVolumeFlexVolume;
    /**
    * flocker block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#flocker PodV1#flocker}
    */
    readonly flocker?: PodV1SpecVolumeFlocker;
    /**
    * gce_persistent_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#gce_persistent_disk PodV1#gce_persistent_disk}
    */
    readonly gcePersistentDisk?: PodV1SpecVolumeGcePersistentDisk;
    /**
    * git_repo block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#git_repo PodV1#git_repo}
    */
    readonly gitRepo?: PodV1SpecVolumeGitRepo;
    /**
    * glusterfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#glusterfs PodV1#glusterfs}
    */
    readonly glusterfs?: PodV1SpecVolumeGlusterfs;
    /**
    * host_path block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#host_path PodV1#host_path}
    */
    readonly hostPath?: PodV1SpecVolumeHostPath;
    /**
    * iscsi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#iscsi PodV1#iscsi}
    */
    readonly iscsi?: PodV1SpecVolumeIscsi;
    /**
    * local block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#local PodV1#local}
    */
    readonly local?: PodV1SpecVolumeLocal;
    /**
    * nfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#nfs PodV1#nfs}
    */
    readonly nfs?: PodV1SpecVolumeNfs;
    /**
    * persistent_volume_claim block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#persistent_volume_claim PodV1#persistent_volume_claim}
    */
    readonly persistentVolumeClaim?: PodV1SpecVolumePersistentVolumeClaim;
    /**
    * photon_persistent_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#photon_persistent_disk PodV1#photon_persistent_disk}
    */
    readonly photonPersistentDisk?: PodV1SpecVolumePhotonPersistentDisk;
    /**
    * projected block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#projected PodV1#projected}
    */
    readonly projected?: PodV1SpecVolumeProjected[] | cdktf.IResolvable;
    /**
    * quobyte block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#quobyte PodV1#quobyte}
    */
    readonly quobyte?: PodV1SpecVolumeQuobyte;
    /**
    * rbd block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#rbd PodV1#rbd}
    */
    readonly rbd?: PodV1SpecVolumeRbd;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#secret PodV1#secret}
    */
    readonly secret?: PodV1SpecVolumeSecret;
    /**
    * vsphere_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#vsphere_volume PodV1#vsphere_volume}
    */
    readonly vsphereVolume?: PodV1SpecVolumeVsphereVolume;
}
export declare function podV1SpecVolumeToTerraform(struct?: PodV1SpecVolume | cdktf.IResolvable): any;
export declare class PodV1SpecVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodV1SpecVolume | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1SpecVolume | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _awsElasticBlockStore;
    get awsElasticBlockStore(): PodV1SpecVolumeAwsElasticBlockStoreOutputReference;
    putAwsElasticBlockStore(value: PodV1SpecVolumeAwsElasticBlockStore): void;
    resetAwsElasticBlockStore(): void;
    get awsElasticBlockStoreInput(): PodV1SpecVolumeAwsElasticBlockStore | undefined;
    private _azureDisk;
    get azureDisk(): PodV1SpecVolumeAzureDiskOutputReference;
    putAzureDisk(value: PodV1SpecVolumeAzureDisk): void;
    resetAzureDisk(): void;
    get azureDiskInput(): PodV1SpecVolumeAzureDisk | undefined;
    private _azureFile;
    get azureFile(): PodV1SpecVolumeAzureFileOutputReference;
    putAzureFile(value: PodV1SpecVolumeAzureFile): void;
    resetAzureFile(): void;
    get azureFileInput(): PodV1SpecVolumeAzureFile | undefined;
    private _cephFs;
    get cephFs(): PodV1SpecVolumeCephFsOutputReference;
    putCephFs(value: PodV1SpecVolumeCephFs): void;
    resetCephFs(): void;
    get cephFsInput(): PodV1SpecVolumeCephFs | undefined;
    private _cinder;
    get cinder(): PodV1SpecVolumeCinderOutputReference;
    putCinder(value: PodV1SpecVolumeCinder): void;
    resetCinder(): void;
    get cinderInput(): PodV1SpecVolumeCinder | undefined;
    private _configMap;
    get configMap(): PodV1SpecVolumeConfigMapOutputReference;
    putConfigMap(value: PodV1SpecVolumeConfigMap): void;
    resetConfigMap(): void;
    get configMapInput(): PodV1SpecVolumeConfigMap | undefined;
    private _csi;
    get csi(): PodV1SpecVolumeCsiOutputReference;
    putCsi(value: PodV1SpecVolumeCsi): void;
    resetCsi(): void;
    get csiInput(): PodV1SpecVolumeCsi | undefined;
    private _downwardApi;
    get downwardApi(): PodV1SpecVolumeDownwardApiOutputReference;
    putDownwardApi(value: PodV1SpecVolumeDownwardApi): void;
    resetDownwardApi(): void;
    get downwardApiInput(): PodV1SpecVolumeDownwardApi | undefined;
    private _emptyDir;
    get emptyDir(): PodV1SpecVolumeEmptyDirOutputReference;
    putEmptyDir(value: PodV1SpecVolumeEmptyDir): void;
    resetEmptyDir(): void;
    get emptyDirInput(): PodV1SpecVolumeEmptyDir | undefined;
    private _fc;
    get fc(): PodV1SpecVolumeFcOutputReference;
    putFc(value: PodV1SpecVolumeFc): void;
    resetFc(): void;
    get fcInput(): PodV1SpecVolumeFc | undefined;
    private _flexVolume;
    get flexVolume(): PodV1SpecVolumeFlexVolumeOutputReference;
    putFlexVolume(value: PodV1SpecVolumeFlexVolume): void;
    resetFlexVolume(): void;
    get flexVolumeInput(): PodV1SpecVolumeFlexVolume | undefined;
    private _flocker;
    get flocker(): PodV1SpecVolumeFlockerOutputReference;
    putFlocker(value: PodV1SpecVolumeFlocker): void;
    resetFlocker(): void;
    get flockerInput(): PodV1SpecVolumeFlocker | undefined;
    private _gcePersistentDisk;
    get gcePersistentDisk(): PodV1SpecVolumeGcePersistentDiskOutputReference;
    putGcePersistentDisk(value: PodV1SpecVolumeGcePersistentDisk): void;
    resetGcePersistentDisk(): void;
    get gcePersistentDiskInput(): PodV1SpecVolumeGcePersistentDisk | undefined;
    private _gitRepo;
    get gitRepo(): PodV1SpecVolumeGitRepoOutputReference;
    putGitRepo(value: PodV1SpecVolumeGitRepo): void;
    resetGitRepo(): void;
    get gitRepoInput(): PodV1SpecVolumeGitRepo | undefined;
    private _glusterfs;
    get glusterfs(): PodV1SpecVolumeGlusterfsOutputReference;
    putGlusterfs(value: PodV1SpecVolumeGlusterfs): void;
    resetGlusterfs(): void;
    get glusterfsInput(): PodV1SpecVolumeGlusterfs | undefined;
    private _hostPath;
    get hostPath(): PodV1SpecVolumeHostPathOutputReference;
    putHostPath(value: PodV1SpecVolumeHostPath): void;
    resetHostPath(): void;
    get hostPathInput(): PodV1SpecVolumeHostPath | undefined;
    private _iscsi;
    get iscsi(): PodV1SpecVolumeIscsiOutputReference;
    putIscsi(value: PodV1SpecVolumeIscsi): void;
    resetIscsi(): void;
    get iscsiInput(): PodV1SpecVolumeIscsi | undefined;
    private _local;
    get local(): PodV1SpecVolumeLocalOutputReference;
    putLocal(value: PodV1SpecVolumeLocal): void;
    resetLocal(): void;
    get localInput(): PodV1SpecVolumeLocal | undefined;
    private _nfs;
    get nfs(): PodV1SpecVolumeNfsOutputReference;
    putNfs(value: PodV1SpecVolumeNfs): void;
    resetNfs(): void;
    get nfsInput(): PodV1SpecVolumeNfs | undefined;
    private _persistentVolumeClaim;
    get persistentVolumeClaim(): PodV1SpecVolumePersistentVolumeClaimOutputReference;
    putPersistentVolumeClaim(value: PodV1SpecVolumePersistentVolumeClaim): void;
    resetPersistentVolumeClaim(): void;
    get persistentVolumeClaimInput(): PodV1SpecVolumePersistentVolumeClaim | undefined;
    private _photonPersistentDisk;
    get photonPersistentDisk(): PodV1SpecVolumePhotonPersistentDiskOutputReference;
    putPhotonPersistentDisk(value: PodV1SpecVolumePhotonPersistentDisk): void;
    resetPhotonPersistentDisk(): void;
    get photonPersistentDiskInput(): PodV1SpecVolumePhotonPersistentDisk | undefined;
    private _projected;
    get projected(): PodV1SpecVolumeProjectedList;
    putProjected(value: PodV1SpecVolumeProjected[] | cdktf.IResolvable): void;
    resetProjected(): void;
    get projectedInput(): cdktf.IResolvable | PodV1SpecVolumeProjected[] | undefined;
    private _quobyte;
    get quobyte(): PodV1SpecVolumeQuobyteOutputReference;
    putQuobyte(value: PodV1SpecVolumeQuobyte): void;
    resetQuobyte(): void;
    get quobyteInput(): PodV1SpecVolumeQuobyte | undefined;
    private _rbd;
    get rbd(): PodV1SpecVolumeRbdOutputReference;
    putRbd(value: PodV1SpecVolumeRbd): void;
    resetRbd(): void;
    get rbdInput(): PodV1SpecVolumeRbd | undefined;
    private _secret;
    get secret(): PodV1SpecVolumeSecretOutputReference;
    putSecret(value: PodV1SpecVolumeSecret): void;
    resetSecret(): void;
    get secretInput(): PodV1SpecVolumeSecret | undefined;
    private _vsphereVolume;
    get vsphereVolume(): PodV1SpecVolumeVsphereVolumeOutputReference;
    putVsphereVolume(value: PodV1SpecVolumeVsphereVolume): void;
    resetVsphereVolume(): void;
    get vsphereVolumeInput(): PodV1SpecVolumeVsphereVolume | undefined;
}
export declare class PodV1SpecVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodV1SpecVolume[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodV1SpecVolumeOutputReference;
}
export interface PodV1Spec {
    /**
    * Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#active_deadline_seconds PodV1#active_deadline_seconds}
    */
    readonly activeDeadlineSeconds?: number;
    /**
    * AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#automount_service_account_token PodV1#automount_service_account_token}
    */
    readonly automountServiceAccountToken?: boolean | cdktf.IResolvable;
    /**
    * Set DNS policy for containers within the pod. Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'. Optional: Defaults to 'ClusterFirst', see [Kubernetes reference](https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#dns_policy PodV1#dns_policy}
    */
    readonly dnsPolicy?: string;
    /**
    * Enables generating environment variables for service discovery. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#enable_service_links PodV1#enable_service_links}
    */
    readonly enableServiceLinks?: boolean | cdktf.IResolvable;
    /**
    * Use the host's ipc namespace. Optional: Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#host_ipc PodV1#host_ipc}
    */
    readonly hostIpc?: boolean | cdktf.IResolvable;
    /**
    * Host networking requested for this pod. Use the host's network namespace. If this option is set, the ports that will be used must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#host_network PodV1#host_network}
    */
    readonly hostNetwork?: boolean | cdktf.IResolvable;
    /**
    * Use the host's pid namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#host_pid PodV1#host_pid}
    */
    readonly hostPid?: boolean | cdktf.IResolvable;
    /**
    * Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#hostname PodV1#hostname}
    */
    readonly hostname?: string;
    /**
    * NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#node_name PodV1#node_name}
    */
    readonly nodeName?: string;
    /**
    * NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: http://kubernetes.io/docs/user-guide/node-selection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#node_selector PodV1#node_selector}
    */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
    * If specified, indicates the pod's priority. "system-node-critical" and "system-cluster-critical" are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#priority_class_name PodV1#priority_class_name}
    */
    readonly priorityClassName?: string;
    /**
    * Restart policy for all containers within the pod. One of Always, OnFailure, Never. More info: http://kubernetes.io/docs/user-guide/pod-states#restartpolicy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#restart_policy PodV1#restart_policy}
    */
    readonly restartPolicy?: string;
    /**
    * RuntimeClassName is a feature for selecting the container runtime configuration. The container runtime configuration is used to run a Pod's containers. More info: https://kubernetes.io/docs/concepts/containers/runtime-class
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#runtime_class_name PodV1#runtime_class_name}
    */
    readonly runtimeClassName?: string;
    /**
    * ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: http://releases.k8s.io/HEAD/docs/design/service_accounts.md.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#service_account_name PodV1#service_account_name}
    */
    readonly serviceAccountName?: string;
    /**
    * Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#share_process_namespace PodV1#share_process_namespace}
    */
    readonly shareProcessNamespace?: boolean | cdktf.IResolvable;
    /**
    * If specified, the fully qualified Pod hostname will be "...svc.". If not specified, the pod will not have a domainname at all..
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#subdomain PodV1#subdomain}
    */
    readonly subdomain?: string;
    /**
    * Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#termination_grace_period_seconds PodV1#termination_grace_period_seconds}
    */
    readonly terminationGracePeriodSeconds?: number;
    /**
    * affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#affinity PodV1#affinity}
    */
    readonly affinity?: PodV1SpecAffinity;
    /**
    * container block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#container PodV1#container}
    */
    readonly container?: PodV1SpecContainer[] | cdktf.IResolvable;
    /**
    * dns_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#dns_config PodV1#dns_config}
    */
    readonly dnsConfig?: PodV1SpecDnsConfig;
    /**
    * host_aliases block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#host_aliases PodV1#host_aliases}
    */
    readonly hostAliases?: PodV1SpecHostAliases[] | cdktf.IResolvable;
    /**
    * image_pull_secrets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#image_pull_secrets PodV1#image_pull_secrets}
    */
    readonly imagePullSecrets?: PodV1SpecImagePullSecrets[] | cdktf.IResolvable;
    /**
    * init_container block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#init_container PodV1#init_container}
    */
    readonly initContainer?: PodV1SpecInitContainer[] | cdktf.IResolvable;
    /**
    * readiness_gate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#readiness_gate PodV1#readiness_gate}
    */
    readonly readinessGate?: PodV1SpecReadinessGate[] | cdktf.IResolvable;
    /**
    * security_context block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#security_context PodV1#security_context}
    */
    readonly securityContext?: PodV1SpecSecurityContext;
    /**
    * toleration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#toleration PodV1#toleration}
    */
    readonly toleration?: PodV1SpecToleration[] | cdktf.IResolvable;
    /**
    * topology_spread_constraint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#topology_spread_constraint PodV1#topology_spread_constraint}
    */
    readonly topologySpreadConstraint?: PodV1SpecTopologySpreadConstraint[] | cdktf.IResolvable;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#volume PodV1#volume}
    */
    readonly volume?: PodV1SpecVolume[] | cdktf.IResolvable;
}
export declare function podV1SpecToTerraform(struct?: PodV1SpecOutputReference | PodV1Spec): any;
export declare class PodV1SpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1Spec | undefined;
    set internalValue(value: PodV1Spec | undefined);
    private _activeDeadlineSeconds?;
    get activeDeadlineSeconds(): number;
    set activeDeadlineSeconds(value: number);
    resetActiveDeadlineSeconds(): void;
    get activeDeadlineSecondsInput(): number | undefined;
    private _automountServiceAccountToken?;
    get automountServiceAccountToken(): boolean | cdktf.IResolvable;
    set automountServiceAccountToken(value: boolean | cdktf.IResolvable);
    resetAutomountServiceAccountToken(): void;
    get automountServiceAccountTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _dnsPolicy?;
    get dnsPolicy(): string;
    set dnsPolicy(value: string);
    resetDnsPolicy(): void;
    get dnsPolicyInput(): string | undefined;
    private _enableServiceLinks?;
    get enableServiceLinks(): boolean | cdktf.IResolvable;
    set enableServiceLinks(value: boolean | cdktf.IResolvable);
    resetEnableServiceLinks(): void;
    get enableServiceLinksInput(): boolean | cdktf.IResolvable | undefined;
    private _hostIpc?;
    get hostIpc(): boolean | cdktf.IResolvable;
    set hostIpc(value: boolean | cdktf.IResolvable);
    resetHostIpc(): void;
    get hostIpcInput(): boolean | cdktf.IResolvable | undefined;
    private _hostNetwork?;
    get hostNetwork(): boolean | cdktf.IResolvable;
    set hostNetwork(value: boolean | cdktf.IResolvable);
    resetHostNetwork(): void;
    get hostNetworkInput(): boolean | cdktf.IResolvable | undefined;
    private _hostPid?;
    get hostPid(): boolean | cdktf.IResolvable;
    set hostPid(value: boolean | cdktf.IResolvable);
    resetHostPid(): void;
    get hostPidInput(): boolean | cdktf.IResolvable | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _nodeName?;
    get nodeName(): string;
    set nodeName(value: string);
    resetNodeName(): void;
    get nodeNameInput(): string | undefined;
    private _nodeSelector?;
    get nodeSelector(): {
        [key: string]: string;
    };
    set nodeSelector(value: {
        [key: string]: string;
    });
    resetNodeSelector(): void;
    get nodeSelectorInput(): {
        [key: string]: string;
    } | undefined;
    private _priorityClassName?;
    get priorityClassName(): string;
    set priorityClassName(value: string);
    resetPriorityClassName(): void;
    get priorityClassNameInput(): string | undefined;
    private _restartPolicy?;
    get restartPolicy(): string;
    set restartPolicy(value: string);
    resetRestartPolicy(): void;
    get restartPolicyInput(): string | undefined;
    private _runtimeClassName?;
    get runtimeClassName(): string;
    set runtimeClassName(value: string);
    resetRuntimeClassName(): void;
    get runtimeClassNameInput(): string | undefined;
    private _serviceAccountName?;
    get serviceAccountName(): string;
    set serviceAccountName(value: string);
    resetServiceAccountName(): void;
    get serviceAccountNameInput(): string | undefined;
    private _shareProcessNamespace?;
    get shareProcessNamespace(): boolean | cdktf.IResolvable;
    set shareProcessNamespace(value: boolean | cdktf.IResolvable);
    resetShareProcessNamespace(): void;
    get shareProcessNamespaceInput(): boolean | cdktf.IResolvable | undefined;
    private _subdomain?;
    get subdomain(): string;
    set subdomain(value: string);
    resetSubdomain(): void;
    get subdomainInput(): string | undefined;
    private _terminationGracePeriodSeconds?;
    get terminationGracePeriodSeconds(): number;
    set terminationGracePeriodSeconds(value: number);
    resetTerminationGracePeriodSeconds(): void;
    get terminationGracePeriodSecondsInput(): number | undefined;
    private _affinity;
    get affinity(): PodV1SpecAffinityOutputReference;
    putAffinity(value: PodV1SpecAffinity): void;
    resetAffinity(): void;
    get affinityInput(): PodV1SpecAffinity | undefined;
    private _container;
    get container(): PodV1SpecContainerList;
    putContainer(value: PodV1SpecContainer[] | cdktf.IResolvable): void;
    resetContainer(): void;
    get containerInput(): cdktf.IResolvable | PodV1SpecContainer[] | undefined;
    private _dnsConfig;
    get dnsConfig(): PodV1SpecDnsConfigOutputReference;
    putDnsConfig(value: PodV1SpecDnsConfig): void;
    resetDnsConfig(): void;
    get dnsConfigInput(): PodV1SpecDnsConfig | undefined;
    private _hostAliases;
    get hostAliases(): PodV1SpecHostAliasesList;
    putHostAliases(value: PodV1SpecHostAliases[] | cdktf.IResolvable): void;
    resetHostAliases(): void;
    get hostAliasesInput(): cdktf.IResolvable | PodV1SpecHostAliases[] | undefined;
    private _imagePullSecrets;
    get imagePullSecrets(): PodV1SpecImagePullSecretsList;
    putImagePullSecrets(value: PodV1SpecImagePullSecrets[] | cdktf.IResolvable): void;
    resetImagePullSecrets(): void;
    get imagePullSecretsInput(): cdktf.IResolvable | PodV1SpecImagePullSecrets[] | undefined;
    private _initContainer;
    get initContainer(): PodV1SpecInitContainerList;
    putInitContainer(value: PodV1SpecInitContainer[] | cdktf.IResolvable): void;
    resetInitContainer(): void;
    get initContainerInput(): cdktf.IResolvable | PodV1SpecInitContainer[] | undefined;
    private _readinessGate;
    get readinessGate(): PodV1SpecReadinessGateList;
    putReadinessGate(value: PodV1SpecReadinessGate[] | cdktf.IResolvable): void;
    resetReadinessGate(): void;
    get readinessGateInput(): cdktf.IResolvable | PodV1SpecReadinessGate[] | undefined;
    private _securityContext;
    get securityContext(): PodV1SpecSecurityContextOutputReference;
    putSecurityContext(value: PodV1SpecSecurityContext): void;
    resetSecurityContext(): void;
    get securityContextInput(): PodV1SpecSecurityContext | undefined;
    private _toleration;
    get toleration(): PodV1SpecTolerationList;
    putToleration(value: PodV1SpecToleration[] | cdktf.IResolvable): void;
    resetToleration(): void;
    get tolerationInput(): cdktf.IResolvable | PodV1SpecToleration[] | undefined;
    private _topologySpreadConstraint;
    get topologySpreadConstraint(): PodV1SpecTopologySpreadConstraintList;
    putTopologySpreadConstraint(value: PodV1SpecTopologySpreadConstraint[] | cdktf.IResolvable): void;
    resetTopologySpreadConstraint(): void;
    get topologySpreadConstraintInput(): cdktf.IResolvable | PodV1SpecTopologySpreadConstraint[] | undefined;
    private _volume;
    get volume(): PodV1SpecVolumeList;
    putVolume(value: PodV1SpecVolume[] | cdktf.IResolvable): void;
    resetVolume(): void;
    get volumeInput(): cdktf.IResolvable | PodV1SpecVolume[] | undefined;
}
export interface PodV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#create PodV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#delete PodV1#delete}
    */
    readonly delete?: string;
}
export declare function podV1TimeoutsToTerraform(struct?: PodV1TimeoutsOutputReference | PodV1Timeouts | cdktf.IResolvable): any;
export declare class PodV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PodV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
