import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PodSecurityPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#id PodSecurityPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#metadata PodSecurityPolicy#metadata}
    */
    readonly metadata: PodSecurityPolicyMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#spec PodSecurityPolicy#spec}
    */
    readonly spec: PodSecurityPolicySpec;
}
export interface PodSecurityPolicyMetadata {
    /**
    * An unstructured key value map stored with the podsecuritypolicy that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#annotations PodSecurityPolicy#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the podsecuritypolicy. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#labels PodSecurityPolicy#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the podsecuritypolicy, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#name PodSecurityPolicy#name}
    */
    readonly name?: string;
}
export declare function podSecurityPolicyMetadataToTerraform(struct?: PodSecurityPolicyMetadataOutputReference | PodSecurityPolicyMetadata): any;
export declare class PodSecurityPolicyMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSecurityPolicyMetadata | undefined;
    set internalValue(value: PodSecurityPolicyMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface PodSecurityPolicySpecAllowedFlexVolumes {
    /**
    * driver is the name of the Flexvolume driver.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#driver PodSecurityPolicy#driver}
    */
    readonly driver: string;
}
export declare function podSecurityPolicySpecAllowedFlexVolumesToTerraform(struct?: PodSecurityPolicySpecAllowedFlexVolumes | cdktf.IResolvable): any;
export declare class PodSecurityPolicySpecAllowedFlexVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicySpecAllowedFlexVolumes | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicySpecAllowedFlexVolumes | cdktf.IResolvable | undefined);
    private _driver?;
    get driver(): string;
    set driver(value: string);
    get driverInput(): string | undefined;
}
export declare class PodSecurityPolicySpecAllowedFlexVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicySpecAllowedFlexVolumes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicySpecAllowedFlexVolumesOutputReference;
}
export interface PodSecurityPolicySpecAllowedHostPaths {
    /**
    * pathPrefix is the path prefix that the host volume must match. It does not support `*`. Trailing slashes are trimmed when validating the path prefix with a host path.
  
  Examples: `/foo` would allow `/foo`, `/foo/` and `/foo/bar` `/foo` would not allow `/food` or `/etc/foo`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#path_prefix PodSecurityPolicy#path_prefix}
    */
    readonly pathPrefix: string;
    /**
    * when set to true, will allow host volumes matching the pathPrefix only if all volume mounts are readOnly.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#read_only PodSecurityPolicy#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function podSecurityPolicySpecAllowedHostPathsToTerraform(struct?: PodSecurityPolicySpecAllowedHostPaths | cdktf.IResolvable): any;
export declare class PodSecurityPolicySpecAllowedHostPathsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicySpecAllowedHostPaths | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicySpecAllowedHostPaths | cdktf.IResolvable | undefined);
    private _pathPrefix?;
    get pathPrefix(): string;
    set pathPrefix(value: string);
    get pathPrefixInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class PodSecurityPolicySpecAllowedHostPathsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicySpecAllowedHostPaths[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicySpecAllowedHostPathsOutputReference;
}
export interface PodSecurityPolicySpecFsGroupRange {
    /**
    * max is the end of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#max PodSecurityPolicy#max}
    */
    readonly max: number;
    /**
    * min is the start of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#min PodSecurityPolicy#min}
    */
    readonly min: number;
}
export declare function podSecurityPolicySpecFsGroupRangeToTerraform(struct?: PodSecurityPolicySpecFsGroupRange | cdktf.IResolvable): any;
export declare class PodSecurityPolicySpecFsGroupRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicySpecFsGroupRange | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicySpecFsGroupRange | cdktf.IResolvable | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    get minInput(): number | undefined;
}
export declare class PodSecurityPolicySpecFsGroupRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicySpecFsGroupRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicySpecFsGroupRangeOutputReference;
}
export interface PodSecurityPolicySpecFsGroup {
    /**
    * rule is the strategy that will dictate what FSGroup is used in the SecurityContext.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#rule PodSecurityPolicy#rule}
    */
    readonly rule: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#range PodSecurityPolicy#range}
    */
    readonly range?: PodSecurityPolicySpecFsGroupRange[] | cdktf.IResolvable;
}
export declare function podSecurityPolicySpecFsGroupToTerraform(struct?: PodSecurityPolicySpecFsGroupOutputReference | PodSecurityPolicySpecFsGroup): any;
export declare class PodSecurityPolicySpecFsGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSecurityPolicySpecFsGroup | undefined;
    set internalValue(value: PodSecurityPolicySpecFsGroup | undefined);
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _range;
    get range(): PodSecurityPolicySpecFsGroupRangeList;
    putRange(value: PodSecurityPolicySpecFsGroupRange[] | cdktf.IResolvable): void;
    resetRange(): void;
    get rangeInput(): cdktf.IResolvable | PodSecurityPolicySpecFsGroupRange[] | undefined;
}
export interface PodSecurityPolicySpecHostPorts {
    /**
    * max is the end of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#max PodSecurityPolicy#max}
    */
    readonly max: number;
    /**
    * min is the start of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#min PodSecurityPolicy#min}
    */
    readonly min: number;
}
export declare function podSecurityPolicySpecHostPortsToTerraform(struct?: PodSecurityPolicySpecHostPorts | cdktf.IResolvable): any;
export declare class PodSecurityPolicySpecHostPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicySpecHostPorts | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicySpecHostPorts | cdktf.IResolvable | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    get minInput(): number | undefined;
}
export declare class PodSecurityPolicySpecHostPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicySpecHostPorts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicySpecHostPortsOutputReference;
}
export interface PodSecurityPolicySpecRunAsGroupRange {
    /**
    * max is the end of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#max PodSecurityPolicy#max}
    */
    readonly max: number;
    /**
    * min is the start of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#min PodSecurityPolicy#min}
    */
    readonly min: number;
}
export declare function podSecurityPolicySpecRunAsGroupRangeToTerraform(struct?: PodSecurityPolicySpecRunAsGroupRange | cdktf.IResolvable): any;
export declare class PodSecurityPolicySpecRunAsGroupRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicySpecRunAsGroupRange | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicySpecRunAsGroupRange | cdktf.IResolvable | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    get minInput(): number | undefined;
}
export declare class PodSecurityPolicySpecRunAsGroupRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicySpecRunAsGroupRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicySpecRunAsGroupRangeOutputReference;
}
export interface PodSecurityPolicySpecRunAsGroup {
    /**
    * rule is the strategy that will dictate the allowable RunAsGroup values that may be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#rule PodSecurityPolicy#rule}
    */
    readonly rule: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#range PodSecurityPolicy#range}
    */
    readonly range?: PodSecurityPolicySpecRunAsGroupRange[] | cdktf.IResolvable;
}
export declare function podSecurityPolicySpecRunAsGroupToTerraform(struct?: PodSecurityPolicySpecRunAsGroupOutputReference | PodSecurityPolicySpecRunAsGroup): any;
export declare class PodSecurityPolicySpecRunAsGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSecurityPolicySpecRunAsGroup | undefined;
    set internalValue(value: PodSecurityPolicySpecRunAsGroup | undefined);
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _range;
    get range(): PodSecurityPolicySpecRunAsGroupRangeList;
    putRange(value: PodSecurityPolicySpecRunAsGroupRange[] | cdktf.IResolvable): void;
    resetRange(): void;
    get rangeInput(): cdktf.IResolvable | PodSecurityPolicySpecRunAsGroupRange[] | undefined;
}
export interface PodSecurityPolicySpecRunAsUserRange {
    /**
    * max is the end of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#max PodSecurityPolicy#max}
    */
    readonly max: number;
    /**
    * min is the start of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#min PodSecurityPolicy#min}
    */
    readonly min: number;
}
export declare function podSecurityPolicySpecRunAsUserRangeToTerraform(struct?: PodSecurityPolicySpecRunAsUserRange | cdktf.IResolvable): any;
export declare class PodSecurityPolicySpecRunAsUserRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicySpecRunAsUserRange | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicySpecRunAsUserRange | cdktf.IResolvable | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    get minInput(): number | undefined;
}
export declare class PodSecurityPolicySpecRunAsUserRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicySpecRunAsUserRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicySpecRunAsUserRangeOutputReference;
}
export interface PodSecurityPolicySpecRunAsUser {
    /**
    * rule is the strategy that will dictate the allowable RunAsUser values that may be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#rule PodSecurityPolicy#rule}
    */
    readonly rule: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#range PodSecurityPolicy#range}
    */
    readonly range?: PodSecurityPolicySpecRunAsUserRange[] | cdktf.IResolvable;
}
export declare function podSecurityPolicySpecRunAsUserToTerraform(struct?: PodSecurityPolicySpecRunAsUserOutputReference | PodSecurityPolicySpecRunAsUser): any;
export declare class PodSecurityPolicySpecRunAsUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSecurityPolicySpecRunAsUser | undefined;
    set internalValue(value: PodSecurityPolicySpecRunAsUser | undefined);
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _range;
    get range(): PodSecurityPolicySpecRunAsUserRangeList;
    putRange(value: PodSecurityPolicySpecRunAsUserRange[] | cdktf.IResolvable): void;
    resetRange(): void;
    get rangeInput(): cdktf.IResolvable | PodSecurityPolicySpecRunAsUserRange[] | undefined;
}
export interface PodSecurityPolicySpecSeLinuxSeLinuxOptions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#level PodSecurityPolicy#level}
    */
    readonly level: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#role PodSecurityPolicy#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#type PodSecurityPolicy#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#user PodSecurityPolicy#user}
    */
    readonly user: string;
}
export declare function podSecurityPolicySpecSeLinuxSeLinuxOptionsToTerraform(struct?: PodSecurityPolicySpecSeLinuxSeLinuxOptions | cdktf.IResolvable): any;
export declare class PodSecurityPolicySpecSeLinuxSeLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicySpecSeLinuxSeLinuxOptions | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicySpecSeLinuxSeLinuxOptions | cdktf.IResolvable | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    get levelInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    get userInput(): string | undefined;
}
export declare class PodSecurityPolicySpecSeLinuxSeLinuxOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicySpecSeLinuxSeLinuxOptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicySpecSeLinuxSeLinuxOptionsOutputReference;
}
export interface PodSecurityPolicySpecSeLinux {
    /**
    * rule is the strategy that will dictate the allowable labels that may be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#rule PodSecurityPolicy#rule}
    */
    readonly rule: string;
    /**
    * se_linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#se_linux_options PodSecurityPolicy#se_linux_options}
    */
    readonly seLinuxOptions?: PodSecurityPolicySpecSeLinuxSeLinuxOptions[] | cdktf.IResolvable;
}
export declare function podSecurityPolicySpecSeLinuxToTerraform(struct?: PodSecurityPolicySpecSeLinuxOutputReference | PodSecurityPolicySpecSeLinux): any;
export declare class PodSecurityPolicySpecSeLinuxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSecurityPolicySpecSeLinux | undefined;
    set internalValue(value: PodSecurityPolicySpecSeLinux | undefined);
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _seLinuxOptions;
    get seLinuxOptions(): PodSecurityPolicySpecSeLinuxSeLinuxOptionsList;
    putSeLinuxOptions(value: PodSecurityPolicySpecSeLinuxSeLinuxOptions[] | cdktf.IResolvable): void;
    resetSeLinuxOptions(): void;
    get seLinuxOptionsInput(): cdktf.IResolvable | PodSecurityPolicySpecSeLinuxSeLinuxOptions[] | undefined;
}
export interface PodSecurityPolicySpecSupplementalGroupsRange {
    /**
    * max is the end of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#max PodSecurityPolicy#max}
    */
    readonly max: number;
    /**
    * min is the start of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#min PodSecurityPolicy#min}
    */
    readonly min: number;
}
export declare function podSecurityPolicySpecSupplementalGroupsRangeToTerraform(struct?: PodSecurityPolicySpecSupplementalGroupsRange | cdktf.IResolvable): any;
export declare class PodSecurityPolicySpecSupplementalGroupsRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicySpecSupplementalGroupsRange | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicySpecSupplementalGroupsRange | cdktf.IResolvable | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    get minInput(): number | undefined;
}
export declare class PodSecurityPolicySpecSupplementalGroupsRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicySpecSupplementalGroupsRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicySpecSupplementalGroupsRangeOutputReference;
}
export interface PodSecurityPolicySpecSupplementalGroups {
    /**
    * rule is the strategy that will dictate what supplemental groups is used in the SecurityContext.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#rule PodSecurityPolicy#rule}
    */
    readonly rule: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#range PodSecurityPolicy#range}
    */
    readonly range?: PodSecurityPolicySpecSupplementalGroupsRange[] | cdktf.IResolvable;
}
export declare function podSecurityPolicySpecSupplementalGroupsToTerraform(struct?: PodSecurityPolicySpecSupplementalGroupsOutputReference | PodSecurityPolicySpecSupplementalGroups): any;
export declare class PodSecurityPolicySpecSupplementalGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSecurityPolicySpecSupplementalGroups | undefined;
    set internalValue(value: PodSecurityPolicySpecSupplementalGroups | undefined);
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _range;
    get range(): PodSecurityPolicySpecSupplementalGroupsRangeList;
    putRange(value: PodSecurityPolicySpecSupplementalGroupsRange[] | cdktf.IResolvable): void;
    resetRange(): void;
    get rangeInput(): cdktf.IResolvable | PodSecurityPolicySpecSupplementalGroupsRange[] | undefined;
}
export interface PodSecurityPolicySpec {
    /**
    * allowPrivilegeEscalation determines if a pod can request to allow privilege escalation. If unspecified, defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#allow_privilege_escalation PodSecurityPolicy#allow_privilege_escalation}
    */
    readonly allowPrivilegeEscalation?: boolean | cdktf.IResolvable;
    /**
    * allowedCapabilities is a list of capabilities that can be requested to add to the container. Capabilities in this field may be added at the pod author's discretion. You must not list a capability in both allowedCapabilities and requiredDropCapabilities.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#allowed_capabilities PodSecurityPolicy#allowed_capabilities}
    */
    readonly allowedCapabilities?: string[];
    /**
    * AllowedProcMountTypes is an allowlist of allowed ProcMountTypes. Empty or nil indicates that only the DefaultProcMountType may be used. This requires the ProcMountType feature flag to be enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#allowed_proc_mount_types PodSecurityPolicy#allowed_proc_mount_types}
    */
    readonly allowedProcMountTypes?: string[];
    /**
    * allowedUnsafeSysctls is a list of explicitly allowed unsafe sysctls, defaults to none. Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of allowed sysctls. Single * means all unsafe sysctls are allowed. Kubelet has to allowlist all allowed unsafe sysctls explicitly to avoid rejection.
  
  Examples: e.g. "foo/*" allows "foo/bar", "foo/baz", etc. e.g. "foo.*" allows "foo.bar", "foo.baz", etc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#allowed_unsafe_sysctls PodSecurityPolicy#allowed_unsafe_sysctls}
    */
    readonly allowedUnsafeSysctls?: string[];
    /**
    * defaultAddCapabilities is the default set of capabilities that will be added to the container unless the pod spec specifically drops the capability.  You may not list a capability in both defaultAddCapabilities and requiredDropCapabilities. Capabilities added here are implicitly allowed, and need not be included in the allowedCapabilities list.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#default_add_capabilities PodSecurityPolicy#default_add_capabilities}
    */
    readonly defaultAddCapabilities?: string[];
    /**
    * defaultAllowPrivilegeEscalation controls the default setting for whether a process can gain more privileges than its parent process.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#default_allow_privilege_escalation PodSecurityPolicy#default_allow_privilege_escalation}
    */
    readonly defaultAllowPrivilegeEscalation?: boolean | cdktf.IResolvable;
    /**
    * forbiddenSysctls is a list of explicitly forbidden sysctls, defaults to none. Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of forbidden sysctls. Single * means all sysctls are forbidden.
  
  Examples: e.g. "foo/*" forbids "foo/bar", "foo/baz", etc. e.g. "foo.*" forbids "foo.bar", "foo.baz", etc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#forbidden_sysctls PodSecurityPolicy#forbidden_sysctls}
    */
    readonly forbiddenSysctls?: string[];
    /**
    * hostIPC determines if the policy allows the use of HostIPC in the pod spec.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#host_ipc PodSecurityPolicy#host_ipc}
    */
    readonly hostIpc?: boolean | cdktf.IResolvable;
    /**
    * hostNetwork determines if the policy allows the use of HostNetwork in the pod spec.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#host_network PodSecurityPolicy#host_network}
    */
    readonly hostNetwork?: boolean | cdktf.IResolvable;
    /**
    * hostPID determines if the policy allows the use of HostPID in the pod spec.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#host_pid PodSecurityPolicy#host_pid}
    */
    readonly hostPid?: boolean | cdktf.IResolvable;
    /**
    * privileged determines if a pod can request to be run as privileged.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#privileged PodSecurityPolicy#privileged}
    */
    readonly privileged?: boolean | cdktf.IResolvable;
    /**
    * readOnlyRootFilesystem when set to true will force containers to run with a read only root file system.  If the container specifically requests to run with a non-read only root file system the PSP should deny the pod. If set to false the container may run with a read only root file system if it wishes but it will not be forced to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#read_only_root_filesystem PodSecurityPolicy#read_only_root_filesystem}
    */
    readonly readOnlyRootFilesystem?: boolean | cdktf.IResolvable;
    /**
    * requiredDropCapabilities are the capabilities that will be dropped from the container.  These are required to be dropped and cannot be added.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#required_drop_capabilities PodSecurityPolicy#required_drop_capabilities}
    */
    readonly requiredDropCapabilities?: string[];
    /**
    * volumes is an allowlist of volume plugins. Empty indicates that no volumes may be used. To allow all volumes you may use '*'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#volumes PodSecurityPolicy#volumes}
    */
    readonly volumes?: string[];
    /**
    * allowed_flex_volumes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#allowed_flex_volumes PodSecurityPolicy#allowed_flex_volumes}
    */
    readonly allowedFlexVolumes?: PodSecurityPolicySpecAllowedFlexVolumes[] | cdktf.IResolvable;
    /**
    * allowed_host_paths block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#allowed_host_paths PodSecurityPolicy#allowed_host_paths}
    */
    readonly allowedHostPaths?: PodSecurityPolicySpecAllowedHostPaths[] | cdktf.IResolvable;
    /**
    * fs_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#fs_group PodSecurityPolicy#fs_group}
    */
    readonly fsGroup: PodSecurityPolicySpecFsGroup;
    /**
    * host_ports block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#host_ports PodSecurityPolicy#host_ports}
    */
    readonly hostPorts?: PodSecurityPolicySpecHostPorts[] | cdktf.IResolvable;
    /**
    * run_as_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#run_as_group PodSecurityPolicy#run_as_group}
    */
    readonly runAsGroup?: PodSecurityPolicySpecRunAsGroup;
    /**
    * run_as_user block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#run_as_user PodSecurityPolicy#run_as_user}
    */
    readonly runAsUser: PodSecurityPolicySpecRunAsUser;
    /**
    * se_linux block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#se_linux PodSecurityPolicy#se_linux}
    */
    readonly seLinux?: PodSecurityPolicySpecSeLinux;
    /**
    * supplemental_groups block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy#supplemental_groups PodSecurityPolicy#supplemental_groups}
    */
    readonly supplementalGroups: PodSecurityPolicySpecSupplementalGroups;
}
export declare function podSecurityPolicySpecToTerraform(struct?: PodSecurityPolicySpecOutputReference | PodSecurityPolicySpec): any;
export declare class PodSecurityPolicySpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSecurityPolicySpec | undefined;
    set internalValue(value: PodSecurityPolicySpec | undefined);
    private _allowPrivilegeEscalation?;
    get allowPrivilegeEscalation(): boolean | cdktf.IResolvable;
    set allowPrivilegeEscalation(value: boolean | cdktf.IResolvable);
    resetAllowPrivilegeEscalation(): void;
    get allowPrivilegeEscalationInput(): boolean | cdktf.IResolvable | undefined;
    private _allowedCapabilities?;
    get allowedCapabilities(): string[];
    set allowedCapabilities(value: string[]);
    resetAllowedCapabilities(): void;
    get allowedCapabilitiesInput(): string[] | undefined;
    private _allowedProcMountTypes?;
    get allowedProcMountTypes(): string[];
    set allowedProcMountTypes(value: string[]);
    resetAllowedProcMountTypes(): void;
    get allowedProcMountTypesInput(): string[] | undefined;
    private _allowedUnsafeSysctls?;
    get allowedUnsafeSysctls(): string[];
    set allowedUnsafeSysctls(value: string[]);
    resetAllowedUnsafeSysctls(): void;
    get allowedUnsafeSysctlsInput(): string[] | undefined;
    private _defaultAddCapabilities?;
    get defaultAddCapabilities(): string[];
    set defaultAddCapabilities(value: string[]);
    resetDefaultAddCapabilities(): void;
    get defaultAddCapabilitiesInput(): string[] | undefined;
    private _defaultAllowPrivilegeEscalation?;
    get defaultAllowPrivilegeEscalation(): boolean | cdktf.IResolvable;
    set defaultAllowPrivilegeEscalation(value: boolean | cdktf.IResolvable);
    resetDefaultAllowPrivilegeEscalation(): void;
    get defaultAllowPrivilegeEscalationInput(): boolean | cdktf.IResolvable | undefined;
    private _forbiddenSysctls?;
    get forbiddenSysctls(): string[];
    set forbiddenSysctls(value: string[]);
    resetForbiddenSysctls(): void;
    get forbiddenSysctlsInput(): string[] | undefined;
    private _hostIpc?;
    get hostIpc(): boolean | cdktf.IResolvable;
    set hostIpc(value: boolean | cdktf.IResolvable);
    resetHostIpc(): void;
    get hostIpcInput(): boolean | cdktf.IResolvable | undefined;
    private _hostNetwork?;
    get hostNetwork(): boolean | cdktf.IResolvable;
    set hostNetwork(value: boolean | cdktf.IResolvable);
    resetHostNetwork(): void;
    get hostNetworkInput(): boolean | cdktf.IResolvable | undefined;
    private _hostPid?;
    get hostPid(): boolean | cdktf.IResolvable;
    set hostPid(value: boolean | cdktf.IResolvable);
    resetHostPid(): void;
    get hostPidInput(): boolean | cdktf.IResolvable | undefined;
    private _privileged?;
    get privileged(): boolean | cdktf.IResolvable;
    set privileged(value: boolean | cdktf.IResolvable);
    resetPrivileged(): void;
    get privilegedInput(): boolean | cdktf.IResolvable | undefined;
    private _readOnlyRootFilesystem?;
    get readOnlyRootFilesystem(): boolean | cdktf.IResolvable;
    set readOnlyRootFilesystem(value: boolean | cdktf.IResolvable);
    resetReadOnlyRootFilesystem(): void;
    get readOnlyRootFilesystemInput(): boolean | cdktf.IResolvable | undefined;
    private _requiredDropCapabilities?;
    get requiredDropCapabilities(): string[];
    set requiredDropCapabilities(value: string[]);
    resetRequiredDropCapabilities(): void;
    get requiredDropCapabilitiesInput(): string[] | undefined;
    private _volumes?;
    get volumes(): string[];
    set volumes(value: string[]);
    resetVolumes(): void;
    get volumesInput(): string[] | undefined;
    private _allowedFlexVolumes;
    get allowedFlexVolumes(): PodSecurityPolicySpecAllowedFlexVolumesList;
    putAllowedFlexVolumes(value: PodSecurityPolicySpecAllowedFlexVolumes[] | cdktf.IResolvable): void;
    resetAllowedFlexVolumes(): void;
    get allowedFlexVolumesInput(): cdktf.IResolvable | PodSecurityPolicySpecAllowedFlexVolumes[] | undefined;
    private _allowedHostPaths;
    get allowedHostPaths(): PodSecurityPolicySpecAllowedHostPathsList;
    putAllowedHostPaths(value: PodSecurityPolicySpecAllowedHostPaths[] | cdktf.IResolvable): void;
    resetAllowedHostPaths(): void;
    get allowedHostPathsInput(): cdktf.IResolvable | PodSecurityPolicySpecAllowedHostPaths[] | undefined;
    private _fsGroup;
    get fsGroup(): PodSecurityPolicySpecFsGroupOutputReference;
    putFsGroup(value: PodSecurityPolicySpecFsGroup): void;
    get fsGroupInput(): PodSecurityPolicySpecFsGroup | undefined;
    private _hostPorts;
    get hostPorts(): PodSecurityPolicySpecHostPortsList;
    putHostPorts(value: PodSecurityPolicySpecHostPorts[] | cdktf.IResolvable): void;
    resetHostPorts(): void;
    get hostPortsInput(): cdktf.IResolvable | PodSecurityPolicySpecHostPorts[] | undefined;
    private _runAsGroup;
    get runAsGroup(): PodSecurityPolicySpecRunAsGroupOutputReference;
    putRunAsGroup(value: PodSecurityPolicySpecRunAsGroup): void;
    resetRunAsGroup(): void;
    get runAsGroupInput(): PodSecurityPolicySpecRunAsGroup | undefined;
    private _runAsUser;
    get runAsUser(): PodSecurityPolicySpecRunAsUserOutputReference;
    putRunAsUser(value: PodSecurityPolicySpecRunAsUser): void;
    get runAsUserInput(): PodSecurityPolicySpecRunAsUser | undefined;
    private _seLinux;
    get seLinux(): PodSecurityPolicySpecSeLinuxOutputReference;
    putSeLinux(value: PodSecurityPolicySpecSeLinux): void;
    resetSeLinux(): void;
    get seLinuxInput(): PodSecurityPolicySpecSeLinux | undefined;
    private _supplementalGroups;
    get supplementalGroups(): PodSecurityPolicySpecSupplementalGroupsOutputReference;
    putSupplementalGroups(value: PodSecurityPolicySpecSupplementalGroups): void;
    get supplementalGroupsInput(): PodSecurityPolicySpecSupplementalGroups | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy kubernetes_pod_security_policy}
*/
export declare class PodSecurityPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_pod_security_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy kubernetes_pod_security_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PodSecurityPolicyConfig
    */
    constructor(scope: Construct, id: string, config: PodSecurityPolicyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): PodSecurityPolicyMetadataOutputReference;
    putMetadata(value: PodSecurityPolicyMetadata): void;
    get metadataInput(): PodSecurityPolicyMetadata | undefined;
    private _spec;
    get spec(): PodSecurityPolicySpecOutputReference;
    putSpec(value: PodSecurityPolicySpec): void;
    get specInput(): PodSecurityPolicySpec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
