import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NodeTaintConfig extends cdktf.TerraformMetaArguments {
    /**
    * Set the name of the field manager for the node taint
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/node_taint#field_manager NodeTaint#field_manager}
    */
    readonly fieldManager?: string;
    /**
    * Force overwriting annotations that were created or edited outside of Terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/node_taint#force NodeTaint#force}
    */
    readonly force?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/node_taint#id NodeTaint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/node_taint#metadata NodeTaint#metadata}
    */
    readonly metadata: NodeTaintMetadata;
    /**
    * taint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/node_taint#taint NodeTaint#taint}
    */
    readonly taint: NodeTaintTaint;
}
export interface NodeTaintMetadata {
    /**
    * The name of the node
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/node_taint#name NodeTaint#name}
    */
    readonly name: string;
}
export declare function nodeTaintMetadataToTerraform(struct?: NodeTaintMetadataOutputReference | NodeTaintMetadata): any;
export declare class NodeTaintMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NodeTaintMetadata | undefined;
    set internalValue(value: NodeTaintMetadata | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface NodeTaintTaint {
    /**
    * The taint effect
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/node_taint#effect NodeTaint#effect}
    */
    readonly effect: string;
    /**
    * The taint key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/node_taint#key NodeTaint#key}
    */
    readonly key: string;
    /**
    * The taint value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/node_taint#value NodeTaint#value}
    */
    readonly value: string;
}
export declare function nodeTaintTaintToTerraform(struct?: NodeTaintTaintOutputReference | NodeTaintTaint): any;
export declare class NodeTaintTaintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NodeTaintTaint | undefined;
    set internalValue(value: NodeTaintTaint | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/node_taint kubernetes_node_taint}
*/
export declare class NodeTaint extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_node_taint";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/node_taint kubernetes_node_taint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NodeTaintConfig
    */
    constructor(scope: Construct, id: string, config: NodeTaintConfig);
    private _fieldManager?;
    get fieldManager(): string;
    set fieldManager(value: string);
    resetFieldManager(): void;
    get fieldManagerInput(): string | undefined;
    private _force?;
    get force(): boolean | cdktf.IResolvable;
    set force(value: boolean | cdktf.IResolvable);
    resetForce(): void;
    get forceInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): NodeTaintMetadataOutputReference;
    putMetadata(value: NodeTaintMetadata): void;
    get metadataInput(): NodeTaintMetadata | undefined;
    private _taint;
    get taint(): NodeTaintTaintOutputReference;
    putTaint(value: NodeTaintTaint): void;
    get taintInput(): NodeTaintTaint | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
