import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LimitRangeV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1#id LimitRangeV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1#metadata LimitRangeV1#metadata}
    */
    readonly metadata: LimitRangeV1Metadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1#spec LimitRangeV1#spec}
    */
    readonly spec?: LimitRangeV1Spec;
}
export interface LimitRangeV1Metadata {
    /**
    * An unstructured key value map stored with the limit range that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1#annotations LimitRangeV1#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1#generate_name LimitRangeV1#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the limit range. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1#labels LimitRangeV1#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the limit range, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1#name LimitRangeV1#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the limit range must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1#namespace LimitRangeV1#namespace}
    */
    readonly namespace?: string;
}
export declare function limitRangeV1MetadataToTerraform(struct?: LimitRangeV1MetadataOutputReference | LimitRangeV1Metadata): any;
export declare class LimitRangeV1MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LimitRangeV1Metadata | undefined;
    set internalValue(value: LimitRangeV1Metadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface LimitRangeV1SpecLimit {
    /**
    * Default resource requirement limit value by resource name if resource limit is omitted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1#default LimitRangeV1#default}
    */
    readonly default?: {
        [key: string]: string;
    };
    /**
    * The default resource requirement request value by resource name if resource request is omitted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1#default_request LimitRangeV1#default_request}
    */
    readonly defaultRequest?: {
        [key: string]: string;
    };
    /**
    * Max usage constraints on this kind by resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1#max LimitRangeV1#max}
    */
    readonly max?: {
        [key: string]: string;
    };
    /**
    * The named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1#max_limit_request_ratio LimitRangeV1#max_limit_request_ratio}
    */
    readonly maxLimitRequestRatio?: {
        [key: string]: string;
    };
    /**
    * Min usage constraints on this kind by resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1#min LimitRangeV1#min}
    */
    readonly min?: {
        [key: string]: string;
    };
    /**
    * Type of resource that this limit applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1#type LimitRangeV1#type}
    */
    readonly type?: string;
}
export declare function limitRangeV1SpecLimitToTerraform(struct?: LimitRangeV1SpecLimit | cdktf.IResolvable): any;
export declare class LimitRangeV1SpecLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LimitRangeV1SpecLimit | cdktf.IResolvable | undefined;
    set internalValue(value: LimitRangeV1SpecLimit | cdktf.IResolvable | undefined);
    private _default?;
    get default(): {
        [key: string]: string;
    };
    set default(value: {
        [key: string]: string;
    });
    resetDefault(): void;
    get defaultInput(): {
        [key: string]: string;
    } | undefined;
    private _defaultRequest?;
    get defaultRequest(): {
        [key: string]: string;
    };
    set defaultRequest(value: {
        [key: string]: string;
    });
    resetDefaultRequest(): void;
    get defaultRequestInput(): {
        [key: string]: string;
    } | undefined;
    private _max?;
    get max(): {
        [key: string]: string;
    };
    set max(value: {
        [key: string]: string;
    });
    resetMax(): void;
    get maxInput(): {
        [key: string]: string;
    } | undefined;
    private _maxLimitRequestRatio?;
    get maxLimitRequestRatio(): {
        [key: string]: string;
    };
    set maxLimitRequestRatio(value: {
        [key: string]: string;
    });
    resetMaxLimitRequestRatio(): void;
    get maxLimitRequestRatioInput(): {
        [key: string]: string;
    } | undefined;
    private _min?;
    get min(): {
        [key: string]: string;
    };
    set min(value: {
        [key: string]: string;
    });
    resetMin(): void;
    get minInput(): {
        [key: string]: string;
    } | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class LimitRangeV1SpecLimitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LimitRangeV1SpecLimit[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LimitRangeV1SpecLimitOutputReference;
}
export interface LimitRangeV1Spec {
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1#limit LimitRangeV1#limit}
    */
    readonly limit?: LimitRangeV1SpecLimit[] | cdktf.IResolvable;
}
export declare function limitRangeV1SpecToTerraform(struct?: LimitRangeV1SpecOutputReference | LimitRangeV1Spec): any;
export declare class LimitRangeV1SpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LimitRangeV1Spec | undefined;
    set internalValue(value: LimitRangeV1Spec | undefined);
    private _limit;
    get limit(): LimitRangeV1SpecLimitList;
    putLimit(value: LimitRangeV1SpecLimit[] | cdktf.IResolvable): void;
    resetLimit(): void;
    get limitInput(): cdktf.IResolvable | LimitRangeV1SpecLimit[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1 kubernetes_limit_range_v1}
*/
export declare class LimitRangeV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_limit_range_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range_v1 kubernetes_limit_range_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LimitRangeV1Config
    */
    constructor(scope: Construct, id: string, config: LimitRangeV1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): LimitRangeV1MetadataOutputReference;
    putMetadata(value: LimitRangeV1Metadata): void;
    get metadataInput(): LimitRangeV1Metadata | undefined;
    private _spec;
    get spec(): LimitRangeV1SpecOutputReference;
    putSpec(value: LimitRangeV1Spec): void;
    resetSpec(): void;
    get specInput(): LimitRangeV1Spec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
