import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LabelsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The apiVersion of the resource to label.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/labels#api_version Labels#api_version}
    */
    readonly apiVersion: string;
    /**
    * Set the name of the field manager for the specified labels.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/labels#field_manager Labels#field_manager}
    */
    readonly fieldManager?: string;
    /**
    * Force overwriting labels that were created or edited outside of Terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/labels#force Labels#force}
    */
    readonly force?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/labels#id Labels#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The kind of the resource to label.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/labels#kind Labels#kind}
    */
    readonly kind: string;
    /**
    * A map of labels to apply to the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/labels#labels Labels#labels}
    */
    readonly labels: {
        [key: string]: string;
    };
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/labels#metadata Labels#metadata}
    */
    readonly metadata: LabelsMetadata;
}
export interface LabelsMetadata {
    /**
    * The name of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/labels#name Labels#name}
    */
    readonly name: string;
    /**
    * The namespace of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/labels#namespace Labels#namespace}
    */
    readonly namespace?: string;
}
export declare function labelsMetadataToTerraform(struct?: LabelsMetadataOutputReference | LabelsMetadata): any;
export declare class LabelsMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabelsMetadata | undefined;
    set internalValue(value: LabelsMetadata | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/labels kubernetes_labels}
*/
export declare class Labels extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_labels";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/labels kubernetes_labels} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LabelsConfig
    */
    constructor(scope: Construct, id: string, config: LabelsConfig);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    get apiVersionInput(): string | undefined;
    private _fieldManager?;
    get fieldManager(): string;
    set fieldManager(value: string);
    resetFieldManager(): void;
    get fieldManagerInput(): string | undefined;
    private _force?;
    get force(): boolean | cdktf.IResolvable;
    set force(value: boolean | cdktf.IResolvable);
    resetForce(): void;
    get forceInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _metadata;
    get metadata(): LabelsMetadataOutputReference;
    putMetadata(value: LabelsMetadata): void;
    get metadataInput(): LabelsMetadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
