import { JobV1Metadata, JobV1MetadataOutputReference, JobV1Spec, JobV1SpecOutputReference, JobV1Timeouts, JobV1TimeoutsOutputReference } from './index-structs';
export * from './index-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface JobV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#id JobV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#wait_for_completion JobV1#wait_for_completion}
    */
    readonly waitForCompletion?: boolean | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#metadata JobV1#metadata}
    */
    readonly metadata: JobV1Metadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#spec JobV1#spec}
    */
    readonly spec: JobV1Spec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#timeouts JobV1#timeouts}
    */
    readonly timeouts?: JobV1Timeouts;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1 kubernetes_job_v1}
*/
export declare class JobV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_job_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1 kubernetes_job_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options JobV1Config
    */
    constructor(scope: Construct, id: string, config: JobV1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _waitForCompletion?;
    get waitForCompletion(): boolean | cdktf.IResolvable;
    set waitForCompletion(value: boolean | cdktf.IResolvable);
    resetWaitForCompletion(): void;
    get waitForCompletionInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata;
    get metadata(): JobV1MetadataOutputReference;
    putMetadata(value: JobV1Metadata): void;
    get metadataInput(): JobV1Metadata | undefined;
    private _spec;
    get spec(): JobV1SpecOutputReference;
    putSpec(value: JobV1Spec): void;
    get specInput(): JobV1Spec | undefined;
    private _timeouts;
    get timeouts(): JobV1TimeoutsOutputReference;
    putTimeouts(value: JobV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | JobV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
