import * as cdktf from 'cdktf';
import { JobV1SpecTemplateSpecInitContainerSecurityContextCapabilities, JobV1SpecTemplateSpecInitContainerSecurityContextCapabilitiesOutputReference, JobV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptions, JobV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsOutputReference, JobV1SpecTemplateSpecInitContainerSecurityContextSeccompProfile, JobV1SpecTemplateSpecInitContainerSecurityContextSeccompProfileOutputReference, JobV1SpecTemplateSpecInitContainerEnv, JobV1SpecTemplateSpecInitContainerEnvList, JobV1SpecTemplateSpecInitContainerEnvFrom, JobV1SpecTemplateSpecInitContainerEnvFromList, JobV1SpecTemplateSpecInitContainerLifecycle, JobV1SpecTemplateSpecInitContainerLifecycleOutputReference, JobV1SpecTemplateSpecInitContainerLivenessProbe, JobV1SpecTemplateSpecInitContainerLivenessProbeOutputReference, JobV1SpecTemplateSpecInitContainerPort, JobV1SpecTemplateSpecInitContainerPortList, JobV1SpecTemplateSpecInitContainerReadinessProbe, JobV1SpecTemplateSpecInitContainerReadinessProbeOutputReference, JobV1SpecTemplateSpecInitContainerResources, JobV1SpecTemplateSpecInitContainerResourcesOutputReference, JobV1SpecTemplateSpecAffinity, JobV1SpecTemplateSpecAffinityOutputReference, JobV1SpecTemplateSpecContainer, JobV1SpecTemplateSpecContainerList, JobV1SpecTemplateSpecDnsConfig, JobV1SpecTemplateSpecDnsConfigOutputReference, JobV1SpecTemplateSpecHostAliases, JobV1SpecTemplateSpecHostAliasesList, JobV1SpecTemplateSpecImagePullSecrets, JobV1SpecTemplateSpecImagePullSecretsList, JobV1SpecTemplateMetadata, JobV1SpecTemplateMetadataOutputReference, JobV1SpecSelector, JobV1SpecSelectorOutputReference } from './structs0';
export interface JobV1SpecTemplateSpecInitContainerSecurityContext {
    /**
    * AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#allow_privilege_escalation JobV1#allow_privilege_escalation}
    */
    readonly allowPrivilegeEscalation?: boolean | cdktf.IResolvable;
    /**
    * Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#privileged JobV1#privileged}
    */
    readonly privileged?: boolean | cdktf.IResolvable;
    /**
    * Whether this container has a read-only root filesystem. Default is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only_root_filesystem JobV1#read_only_root_filesystem}
    */
    readonly readOnlyRootFilesystem?: boolean | cdktf.IResolvable;
    /**
    * The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#run_as_group JobV1#run_as_group}
    */
    readonly runAsGroup?: string;
    /**
    * Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#run_as_non_root JobV1#run_as_non_root}
    */
    readonly runAsNonRoot?: boolean | cdktf.IResolvable;
    /**
    * The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#run_as_user JobV1#run_as_user}
    */
    readonly runAsUser?: string;
    /**
    * capabilities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#capabilities JobV1#capabilities}
    */
    readonly capabilities?: JobV1SpecTemplateSpecInitContainerSecurityContextCapabilities;
    /**
    * se_linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#se_linux_options JobV1#se_linux_options}
    */
    readonly seLinuxOptions?: JobV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptions;
    /**
    * seccomp_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#seccomp_profile JobV1#seccomp_profile}
    */
    readonly seccompProfile?: JobV1SpecTemplateSpecInitContainerSecurityContextSeccompProfile;
}
export declare function jobV1SpecTemplateSpecInitContainerSecurityContextToTerraform(struct?: JobV1SpecTemplateSpecInitContainerSecurityContextOutputReference | JobV1SpecTemplateSpecInitContainerSecurityContext): any;
export declare class JobV1SpecTemplateSpecInitContainerSecurityContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecInitContainerSecurityContext | undefined;
    set internalValue(value: JobV1SpecTemplateSpecInitContainerSecurityContext | undefined);
    private _allowPrivilegeEscalation?;
    get allowPrivilegeEscalation(): boolean | cdktf.IResolvable;
    set allowPrivilegeEscalation(value: boolean | cdktf.IResolvable);
    resetAllowPrivilegeEscalation(): void;
    get allowPrivilegeEscalationInput(): boolean | cdktf.IResolvable | undefined;
    private _privileged?;
    get privileged(): boolean | cdktf.IResolvable;
    set privileged(value: boolean | cdktf.IResolvable);
    resetPrivileged(): void;
    get privilegedInput(): boolean | cdktf.IResolvable | undefined;
    private _readOnlyRootFilesystem?;
    get readOnlyRootFilesystem(): boolean | cdktf.IResolvable;
    set readOnlyRootFilesystem(value: boolean | cdktf.IResolvable);
    resetReadOnlyRootFilesystem(): void;
    get readOnlyRootFilesystemInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsGroup?;
    get runAsGroup(): string;
    set runAsGroup(value: string);
    resetRunAsGroup(): void;
    get runAsGroupInput(): string | undefined;
    private _runAsNonRoot?;
    get runAsNonRoot(): boolean | cdktf.IResolvable;
    set runAsNonRoot(value: boolean | cdktf.IResolvable);
    resetRunAsNonRoot(): void;
    get runAsNonRootInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsUser?;
    get runAsUser(): string;
    set runAsUser(value: string);
    resetRunAsUser(): void;
    get runAsUserInput(): string | undefined;
    private _capabilities;
    get capabilities(): JobV1SpecTemplateSpecInitContainerSecurityContextCapabilitiesOutputReference;
    putCapabilities(value: JobV1SpecTemplateSpecInitContainerSecurityContextCapabilities): void;
    resetCapabilities(): void;
    get capabilitiesInput(): JobV1SpecTemplateSpecInitContainerSecurityContextCapabilities | undefined;
    private _seLinuxOptions;
    get seLinuxOptions(): JobV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsOutputReference;
    putSeLinuxOptions(value: JobV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptions): void;
    resetSeLinuxOptions(): void;
    get seLinuxOptionsInput(): JobV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptions | undefined;
    private _seccompProfile;
    get seccompProfile(): JobV1SpecTemplateSpecInitContainerSecurityContextSeccompProfileOutputReference;
    putSeccompProfile(value: JobV1SpecTemplateSpecInitContainerSecurityContextSeccompProfile): void;
    resetSeccompProfile(): void;
    get seccompProfileInput(): JobV1SpecTemplateSpecInitContainerSecurityContextSeccompProfile | undefined;
}
export interface JobV1SpecTemplateSpecInitContainerStartupProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#command JobV1#command}
    */
    readonly command?: string[];
}
export declare function jobV1SpecTemplateSpecInitContainerStartupProbeExecToTerraform(struct?: JobV1SpecTemplateSpecInitContainerStartupProbeExecOutputReference | JobV1SpecTemplateSpecInitContainerStartupProbeExec): any;
export declare class JobV1SpecTemplateSpecInitContainerStartupProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecInitContainerStartupProbeExec | undefined;
    set internalValue(value: JobV1SpecTemplateSpecInitContainerStartupProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface JobV1SpecTemplateSpecInitContainerStartupProbeGrpc {
    /**
    * Number of the port to access on the container. Number must be in the range 1 to 65535.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#port JobV1#port}
    */
    readonly port: number;
    /**
    * Name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md). If this is not specified, the default behavior is defined by gRPC.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#service JobV1#service}
    */
    readonly service?: string;
}
export declare function jobV1SpecTemplateSpecInitContainerStartupProbeGrpcToTerraform(struct?: JobV1SpecTemplateSpecInitContainerStartupProbeGrpc | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecInitContainerStartupProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecInitContainerStartupProbeGrpc | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecInitContainerStartupProbeGrpc | cdktf.IResolvable | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export declare class JobV1SpecTemplateSpecInitContainerStartupProbeGrpcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecInitContainerStartupProbeGrpc[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecInitContainerStartupProbeGrpcOutputReference;
}
export interface JobV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#name JobV1#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#value JobV1#value}
    */
    readonly value?: string;
}
export declare function jobV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderToTerraform(struct?: JobV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class JobV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderOutputReference;
}
export interface JobV1SpecTemplateSpecInitContainerStartupProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#host JobV1#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#path JobV1#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#port JobV1#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#scheme JobV1#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#http_header JobV1#http_header}
    */
    readonly httpHeader?: JobV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecInitContainerStartupProbeHttpGetToTerraform(struct?: JobV1SpecTemplateSpecInitContainerStartupProbeHttpGetOutputReference | JobV1SpecTemplateSpecInitContainerStartupProbeHttpGet): any;
export declare class JobV1SpecTemplateSpecInitContainerStartupProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecInitContainerStartupProbeHttpGet | undefined;
    set internalValue(value: JobV1SpecTemplateSpecInitContainerStartupProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): JobV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderList;
    putHttpHeader(value: JobV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | JobV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | undefined;
}
export interface JobV1SpecTemplateSpecInitContainerStartupProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#port JobV1#port}
    */
    readonly port: string;
}
export declare function jobV1SpecTemplateSpecInitContainerStartupProbeTcpSocketToTerraform(struct?: JobV1SpecTemplateSpecInitContainerStartupProbeTcpSocket | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecInitContainerStartupProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecInitContainerStartupProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecInitContainerStartupProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class JobV1SpecTemplateSpecInitContainerStartupProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecInitContainerStartupProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecInitContainerStartupProbeTcpSocketOutputReference;
}
export interface JobV1SpecTemplateSpecInitContainerStartupProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#failure_threshold JobV1#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#initial_delay_seconds JobV1#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#period_seconds JobV1#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#success_threshold JobV1#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#timeout_seconds JobV1#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#exec JobV1#exec}
    */
    readonly exec?: JobV1SpecTemplateSpecInitContainerStartupProbeExec;
    /**
    * grpc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#grpc JobV1#grpc}
    */
    readonly grpc?: JobV1SpecTemplateSpecInitContainerStartupProbeGrpc[] | cdktf.IResolvable;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#http_get JobV1#http_get}
    */
    readonly httpGet?: JobV1SpecTemplateSpecInitContainerStartupProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#tcp_socket JobV1#tcp_socket}
    */
    readonly tcpSocket?: JobV1SpecTemplateSpecInitContainerStartupProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecInitContainerStartupProbeToTerraform(struct?: JobV1SpecTemplateSpecInitContainerStartupProbeOutputReference | JobV1SpecTemplateSpecInitContainerStartupProbe): any;
export declare class JobV1SpecTemplateSpecInitContainerStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecInitContainerStartupProbe | undefined;
    set internalValue(value: JobV1SpecTemplateSpecInitContainerStartupProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): JobV1SpecTemplateSpecInitContainerStartupProbeExecOutputReference;
    putExec(value: JobV1SpecTemplateSpecInitContainerStartupProbeExec): void;
    resetExec(): void;
    get execInput(): JobV1SpecTemplateSpecInitContainerStartupProbeExec | undefined;
    private _grpc;
    get grpc(): JobV1SpecTemplateSpecInitContainerStartupProbeGrpcList;
    putGrpc(value: JobV1SpecTemplateSpecInitContainerStartupProbeGrpc[] | cdktf.IResolvable): void;
    resetGrpc(): void;
    get grpcInput(): cdktf.IResolvable | JobV1SpecTemplateSpecInitContainerStartupProbeGrpc[] | undefined;
    private _httpGet;
    get httpGet(): JobV1SpecTemplateSpecInitContainerStartupProbeHttpGetOutputReference;
    putHttpGet(value: JobV1SpecTemplateSpecInitContainerStartupProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): JobV1SpecTemplateSpecInitContainerStartupProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): JobV1SpecTemplateSpecInitContainerStartupProbeTcpSocketList;
    putTcpSocket(value: JobV1SpecTemplateSpecInitContainerStartupProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | JobV1SpecTemplateSpecInitContainerStartupProbeTcpSocket[] | undefined;
}
export interface JobV1SpecTemplateSpecInitContainerVolumeMount {
    /**
    * Path within the container at which the volume should be mounted. Must not contain ':'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#mount_path JobV1#mount_path}
    */
    readonly mountPath: string;
    /**
    * Mount propagation mode. mount_propagation determines how mounts are propagated from the host to container and the other way around. Valid values are None (default), HostToContainer and Bidirectional.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#mount_propagation JobV1#mount_propagation}
    */
    readonly mountPropagation?: string;
    /**
    * This must match the Name of a Volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#name JobV1#name}
    */
    readonly name: string;
    /**
    * Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#sub_path JobV1#sub_path}
    */
    readonly subPath?: string;
}
export declare function jobV1SpecTemplateSpecInitContainerVolumeMountToTerraform(struct?: JobV1SpecTemplateSpecInitContainerVolumeMount | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecInitContainerVolumeMountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecInitContainerVolumeMount | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecInitContainerVolumeMount | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _mountPropagation?;
    get mountPropagation(): string;
    set mountPropagation(value: string);
    resetMountPropagation(): void;
    get mountPropagationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _subPath?;
    get subPath(): string;
    set subPath(value: string);
    resetSubPath(): void;
    get subPathInput(): string | undefined;
}
export declare class JobV1SpecTemplateSpecInitContainerVolumeMountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecInitContainerVolumeMount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecInitContainerVolumeMountOutputReference;
}
export interface JobV1SpecTemplateSpecInitContainer {
    /**
    * Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#args JobV1#args}
    */
    readonly args?: string[];
    /**
    * Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#command JobV1#command}
    */
    readonly command?: string[];
    /**
    * Docker image name. More info: http://kubernetes.io/docs/user-guide/images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#image JobV1#image}
    */
    readonly image?: string;
    /**
    * Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/images#updating-images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#image_pull_policy JobV1#image_pull_policy}
    */
    readonly imagePullPolicy?: string;
    /**
    * Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#name JobV1#name}
    */
    readonly name: string;
    /**
    * Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#stdin JobV1#stdin}
    */
    readonly stdin?: boolean | cdktf.IResolvable;
    /**
    * Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#stdin_once JobV1#stdin_once}
    */
    readonly stdinOnce?: boolean | cdktf.IResolvable;
    /**
    * Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Defaults to /dev/termination-log. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#termination_message_path JobV1#termination_message_path}
    */
    readonly terminationMessagePath?: string;
    /**
    * Optional: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#termination_message_policy JobV1#termination_message_policy}
    */
    readonly terminationMessagePolicy?: string;
    /**
    * Whether this container should allocate a TTY for itself
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#tty JobV1#tty}
    */
    readonly tty?: boolean | cdktf.IResolvable;
    /**
    * Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#working_dir JobV1#working_dir}
    */
    readonly workingDir?: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#env JobV1#env}
    */
    readonly env?: JobV1SpecTemplateSpecInitContainerEnv[] | cdktf.IResolvable;
    /**
    * env_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#env_from JobV1#env_from}
    */
    readonly envFrom?: JobV1SpecTemplateSpecInitContainerEnvFrom[] | cdktf.IResolvable;
    /**
    * lifecycle block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#lifecycle JobV1#lifecycle}
    */
    readonly lifecycle?: JobV1SpecTemplateSpecInitContainerLifecycle;
    /**
    * liveness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#liveness_probe JobV1#liveness_probe}
    */
    readonly livenessProbe?: JobV1SpecTemplateSpecInitContainerLivenessProbe;
    /**
    * port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#port JobV1#port}
    */
    readonly port?: JobV1SpecTemplateSpecInitContainerPort[] | cdktf.IResolvable;
    /**
    * readiness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#readiness_probe JobV1#readiness_probe}
    */
    readonly readinessProbe?: JobV1SpecTemplateSpecInitContainerReadinessProbe;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#resources JobV1#resources}
    */
    readonly resources?: JobV1SpecTemplateSpecInitContainerResources;
    /**
    * security_context block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#security_context JobV1#security_context}
    */
    readonly securityContext?: JobV1SpecTemplateSpecInitContainerSecurityContext;
    /**
    * startup_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#startup_probe JobV1#startup_probe}
    */
    readonly startupProbe?: JobV1SpecTemplateSpecInitContainerStartupProbe;
    /**
    * volume_mount block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#volume_mount JobV1#volume_mount}
    */
    readonly volumeMount?: JobV1SpecTemplateSpecInitContainerVolumeMount[] | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecInitContainerToTerraform(struct?: JobV1SpecTemplateSpecInitContainer | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecInitContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecInitContainer | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecInitContainer | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _imagePullPolicy?;
    get imagePullPolicy(): string;
    set imagePullPolicy(value: string);
    resetImagePullPolicy(): void;
    get imagePullPolicyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _stdin?;
    get stdin(): boolean | cdktf.IResolvable;
    set stdin(value: boolean | cdktf.IResolvable);
    resetStdin(): void;
    get stdinInput(): boolean | cdktf.IResolvable | undefined;
    private _stdinOnce?;
    get stdinOnce(): boolean | cdktf.IResolvable;
    set stdinOnce(value: boolean | cdktf.IResolvable);
    resetStdinOnce(): void;
    get stdinOnceInput(): boolean | cdktf.IResolvable | undefined;
    private _terminationMessagePath?;
    get terminationMessagePath(): string;
    set terminationMessagePath(value: string);
    resetTerminationMessagePath(): void;
    get terminationMessagePathInput(): string | undefined;
    private _terminationMessagePolicy?;
    get terminationMessagePolicy(): string;
    set terminationMessagePolicy(value: string);
    resetTerminationMessagePolicy(): void;
    get terminationMessagePolicyInput(): string | undefined;
    private _tty?;
    get tty(): boolean | cdktf.IResolvable;
    set tty(value: boolean | cdktf.IResolvable);
    resetTty(): void;
    get ttyInput(): boolean | cdktf.IResolvable | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
    private _env;
    get env(): JobV1SpecTemplateSpecInitContainerEnvList;
    putEnv(value: JobV1SpecTemplateSpecInitContainerEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | JobV1SpecTemplateSpecInitContainerEnv[] | undefined;
    private _envFrom;
    get envFrom(): JobV1SpecTemplateSpecInitContainerEnvFromList;
    putEnvFrom(value: JobV1SpecTemplateSpecInitContainerEnvFrom[] | cdktf.IResolvable): void;
    resetEnvFrom(): void;
    get envFromInput(): cdktf.IResolvable | JobV1SpecTemplateSpecInitContainerEnvFrom[] | undefined;
    private _lifecycle;
    get lifecycle(): JobV1SpecTemplateSpecInitContainerLifecycleOutputReference;
    putLifecycle(value: JobV1SpecTemplateSpecInitContainerLifecycle): void;
    resetLifecycle(): void;
    get lifecycleInput(): JobV1SpecTemplateSpecInitContainerLifecycle | undefined;
    private _livenessProbe;
    get livenessProbe(): JobV1SpecTemplateSpecInitContainerLivenessProbeOutputReference;
    putLivenessProbe(value: JobV1SpecTemplateSpecInitContainerLivenessProbe): void;
    resetLivenessProbe(): void;
    get livenessProbeInput(): JobV1SpecTemplateSpecInitContainerLivenessProbe | undefined;
    private _port;
    get port(): JobV1SpecTemplateSpecInitContainerPortList;
    putPort(value: JobV1SpecTemplateSpecInitContainerPort[] | cdktf.IResolvable): void;
    resetPort(): void;
    get portInput(): cdktf.IResolvable | JobV1SpecTemplateSpecInitContainerPort[] | undefined;
    private _readinessProbe;
    get readinessProbe(): JobV1SpecTemplateSpecInitContainerReadinessProbeOutputReference;
    putReadinessProbe(value: JobV1SpecTemplateSpecInitContainerReadinessProbe): void;
    resetReadinessProbe(): void;
    get readinessProbeInput(): JobV1SpecTemplateSpecInitContainerReadinessProbe | undefined;
    private _resources;
    get resources(): JobV1SpecTemplateSpecInitContainerResourcesOutputReference;
    putResources(value: JobV1SpecTemplateSpecInitContainerResources): void;
    resetResources(): void;
    get resourcesInput(): JobV1SpecTemplateSpecInitContainerResources | undefined;
    private _securityContext;
    get securityContext(): JobV1SpecTemplateSpecInitContainerSecurityContextOutputReference;
    putSecurityContext(value: JobV1SpecTemplateSpecInitContainerSecurityContext): void;
    resetSecurityContext(): void;
    get securityContextInput(): JobV1SpecTemplateSpecInitContainerSecurityContext | undefined;
    private _startupProbe;
    get startupProbe(): JobV1SpecTemplateSpecInitContainerStartupProbeOutputReference;
    putStartupProbe(value: JobV1SpecTemplateSpecInitContainerStartupProbe): void;
    resetStartupProbe(): void;
    get startupProbeInput(): JobV1SpecTemplateSpecInitContainerStartupProbe | undefined;
    private _volumeMount;
    get volumeMount(): JobV1SpecTemplateSpecInitContainerVolumeMountList;
    putVolumeMount(value: JobV1SpecTemplateSpecInitContainerVolumeMount[] | cdktf.IResolvable): void;
    resetVolumeMount(): void;
    get volumeMountInput(): cdktf.IResolvable | JobV1SpecTemplateSpecInitContainerVolumeMount[] | undefined;
}
export declare class JobV1SpecTemplateSpecInitContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecInitContainer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecInitContainerOutputReference;
}
export interface JobV1SpecTemplateSpecReadinessGate {
    /**
    * refers to a condition in the pod's condition list with matching type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#condition_type JobV1#condition_type}
    */
    readonly conditionType: string;
}
export declare function jobV1SpecTemplateSpecReadinessGateToTerraform(struct?: JobV1SpecTemplateSpecReadinessGate | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecReadinessGateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecReadinessGate | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecReadinessGate | cdktf.IResolvable | undefined);
    private _conditionType?;
    get conditionType(): string;
    set conditionType(value: string);
    get conditionTypeInput(): string | undefined;
}
export declare class JobV1SpecTemplateSpecReadinessGateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecReadinessGate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecReadinessGateOutputReference;
}
export interface JobV1SpecTemplateSpecSecurityContextSeLinuxOptions {
    /**
    * Level is SELinux level label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#level JobV1#level}
    */
    readonly level?: string;
    /**
    * Role is a SELinux role label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#role JobV1#role}
    */
    readonly role?: string;
    /**
    * Type is a SELinux type label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#type JobV1#type}
    */
    readonly type?: string;
    /**
    * User is a SELinux user label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#user JobV1#user}
    */
    readonly user?: string;
}
export declare function jobV1SpecTemplateSpecSecurityContextSeLinuxOptionsToTerraform(struct?: JobV1SpecTemplateSpecSecurityContextSeLinuxOptionsOutputReference | JobV1SpecTemplateSpecSecurityContextSeLinuxOptions): any;
export declare class JobV1SpecTemplateSpecSecurityContextSeLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecSecurityContextSeLinuxOptions | undefined;
    set internalValue(value: JobV1SpecTemplateSpecSecurityContextSeLinuxOptions | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecSecurityContextSeccompProfile {
    /**
    * Localhost Profile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#localhost_profile JobV1#localhost_profile}
    */
    readonly localhostProfile?: string;
    /**
    * Type indicates which kind of seccomp profile will be applied. Valid options are: Localhost, RuntimeDefault, Unconfined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#type JobV1#type}
    */
    readonly type?: string;
}
export declare function jobV1SpecTemplateSpecSecurityContextSeccompProfileToTerraform(struct?: JobV1SpecTemplateSpecSecurityContextSeccompProfileOutputReference | JobV1SpecTemplateSpecSecurityContextSeccompProfile): any;
export declare class JobV1SpecTemplateSpecSecurityContextSeccompProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecSecurityContextSeccompProfile | undefined;
    set internalValue(value: JobV1SpecTemplateSpecSecurityContextSeccompProfile | undefined);
    private _localhostProfile?;
    get localhostProfile(): string;
    set localhostProfile(value: string);
    resetLocalhostProfile(): void;
    get localhostProfileInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecSecurityContextSysctl {
    /**
    * Name of a property to set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#name JobV1#name}
    */
    readonly name: string;
    /**
    * Value of a property to set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#value JobV1#value}
    */
    readonly value: string;
}
export declare function jobV1SpecTemplateSpecSecurityContextSysctlToTerraform(struct?: JobV1SpecTemplateSpecSecurityContextSysctl | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecSecurityContextSysctlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecSecurityContextSysctl | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecSecurityContextSysctl | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class JobV1SpecTemplateSpecSecurityContextSysctlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecSecurityContextSysctl[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecSecurityContextSysctlOutputReference;
}
export interface JobV1SpecTemplateSpecSecurityContext {
    /**
    * A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod: 1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw---- If unset, the Kubelet will not modify the ownership and permissions of any volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#fs_group JobV1#fs_group}
    */
    readonly fsGroup?: string;
    /**
    * fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#fs_group_change_policy JobV1#fs_group_change_policy}
    */
    readonly fsGroupChangePolicy?: string;
    /**
    * The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#run_as_group JobV1#run_as_group}
    */
    readonly runAsGroup?: string;
    /**
    * Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#run_as_non_root JobV1#run_as_non_root}
    */
    readonly runAsNonRoot?: boolean | cdktf.IResolvable;
    /**
    * The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#run_as_user JobV1#run_as_user}
    */
    readonly runAsUser?: string;
    /**
    * A list of groups applied to the first process run in each container, in addition to the container's primary GID. If unspecified, no groups will be added to any container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#supplemental_groups JobV1#supplemental_groups}
    */
    readonly supplementalGroups?: number[];
    /**
    * se_linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#se_linux_options JobV1#se_linux_options}
    */
    readonly seLinuxOptions?: JobV1SpecTemplateSpecSecurityContextSeLinuxOptions;
    /**
    * seccomp_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#seccomp_profile JobV1#seccomp_profile}
    */
    readonly seccompProfile?: JobV1SpecTemplateSpecSecurityContextSeccompProfile;
    /**
    * sysctl block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#sysctl JobV1#sysctl}
    */
    readonly sysctl?: JobV1SpecTemplateSpecSecurityContextSysctl[] | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecSecurityContextToTerraform(struct?: JobV1SpecTemplateSpecSecurityContextOutputReference | JobV1SpecTemplateSpecSecurityContext): any;
export declare class JobV1SpecTemplateSpecSecurityContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecSecurityContext | undefined;
    set internalValue(value: JobV1SpecTemplateSpecSecurityContext | undefined);
    private _fsGroup?;
    get fsGroup(): string;
    set fsGroup(value: string);
    resetFsGroup(): void;
    get fsGroupInput(): string | undefined;
    private _fsGroupChangePolicy?;
    get fsGroupChangePolicy(): string;
    set fsGroupChangePolicy(value: string);
    resetFsGroupChangePolicy(): void;
    get fsGroupChangePolicyInput(): string | undefined;
    private _runAsGroup?;
    get runAsGroup(): string;
    set runAsGroup(value: string);
    resetRunAsGroup(): void;
    get runAsGroupInput(): string | undefined;
    private _runAsNonRoot?;
    get runAsNonRoot(): boolean | cdktf.IResolvable;
    set runAsNonRoot(value: boolean | cdktf.IResolvable);
    resetRunAsNonRoot(): void;
    get runAsNonRootInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsUser?;
    get runAsUser(): string;
    set runAsUser(value: string);
    resetRunAsUser(): void;
    get runAsUserInput(): string | undefined;
    private _supplementalGroups?;
    get supplementalGroups(): number[];
    set supplementalGroups(value: number[]);
    resetSupplementalGroups(): void;
    get supplementalGroupsInput(): number[] | undefined;
    private _seLinuxOptions;
    get seLinuxOptions(): JobV1SpecTemplateSpecSecurityContextSeLinuxOptionsOutputReference;
    putSeLinuxOptions(value: JobV1SpecTemplateSpecSecurityContextSeLinuxOptions): void;
    resetSeLinuxOptions(): void;
    get seLinuxOptionsInput(): JobV1SpecTemplateSpecSecurityContextSeLinuxOptions | undefined;
    private _seccompProfile;
    get seccompProfile(): JobV1SpecTemplateSpecSecurityContextSeccompProfileOutputReference;
    putSeccompProfile(value: JobV1SpecTemplateSpecSecurityContextSeccompProfile): void;
    resetSeccompProfile(): void;
    get seccompProfileInput(): JobV1SpecTemplateSpecSecurityContextSeccompProfile | undefined;
    private _sysctl;
    get sysctl(): JobV1SpecTemplateSpecSecurityContextSysctlList;
    putSysctl(value: JobV1SpecTemplateSpecSecurityContextSysctl[] | cdktf.IResolvable): void;
    resetSysctl(): void;
    get sysctlInput(): cdktf.IResolvable | JobV1SpecTemplateSpecSecurityContextSysctl[] | undefined;
}
export interface JobV1SpecTemplateSpecToleration {
    /**
    * Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#effect JobV1#effect}
    */
    readonly effect?: string;
    /**
    * Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#key JobV1#key}
    */
    readonly key?: string;
    /**
    * Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#operator JobV1#operator}
    */
    readonly operator?: string;
    /**
    * TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#toleration_seconds JobV1#toleration_seconds}
    */
    readonly tolerationSeconds?: string;
    /**
    * Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#value JobV1#value}
    */
    readonly value?: string;
}
export declare function jobV1SpecTemplateSpecTolerationToTerraform(struct?: JobV1SpecTemplateSpecToleration | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecTolerationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecToleration | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecToleration | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _tolerationSeconds?;
    get tolerationSeconds(): string;
    set tolerationSeconds(value: string);
    resetTolerationSeconds(): void;
    get tolerationSecondsInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class JobV1SpecTemplateSpecTolerationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecToleration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecTolerationOutputReference;
}
export interface JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#key JobV1#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#operator JobV1#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#values JobV1#values}
    */
    readonly values?: string[];
}
export declare function jobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressionsToTerraform(struct?: JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressionsOutputReference;
}
export interface JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#match_labels JobV1#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#match_expressions JobV1#match_expressions}
    */
    readonly matchExpressions?: JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorToTerraform(struct?: JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelector | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | undefined;
}
export declare class JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorOutputReference;
}
export interface JobV1SpecTemplateSpecTopologySpreadConstraint {
    /**
    * describes the degree to which pods may be unevenly distributed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#max_skew JobV1#max_skew}
    */
    readonly maxSkew?: number;
    /**
    * the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#topology_key JobV1#topology_key}
    */
    readonly topologyKey?: string;
    /**
    * indicates how to deal with a pod if it doesn't satisfy the spread constraint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#when_unsatisfiable JobV1#when_unsatisfiable}
    */
    readonly whenUnsatisfiable?: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#label_selector JobV1#label_selector}
    */
    readonly labelSelector?: JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelector[] | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecTopologySpreadConstraintToTerraform(struct?: JobV1SpecTemplateSpecTopologySpreadConstraint | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecTopologySpreadConstraintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecTopologySpreadConstraint | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecTopologySpreadConstraint | cdktf.IResolvable | undefined);
    private _maxSkew?;
    get maxSkew(): number;
    set maxSkew(value: number);
    resetMaxSkew(): void;
    get maxSkewInput(): number | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    resetTopologyKey(): void;
    get topologyKeyInput(): string | undefined;
    private _whenUnsatisfiable?;
    get whenUnsatisfiable(): string;
    set whenUnsatisfiable(value: string);
    resetWhenUnsatisfiable(): void;
    get whenUnsatisfiableInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelectorList;
    putLabelSelector(value: JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | JobV1SpecTemplateSpecTopologySpreadConstraintLabelSelector[] | undefined;
}
export declare class JobV1SpecTemplateSpecTopologySpreadConstraintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecTopologySpreadConstraint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecTopologySpreadConstraintOutputReference;
}
export interface JobV1SpecTemplateSpecVolumeAwsElasticBlockStore {
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#fs_type JobV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#partition JobV1#partition}
    */
    readonly partition?: number;
    /**
    * Whether to set the read-only property in VolumeMounts to "true". If omitted, the default is "false". More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#volume_id JobV1#volume_id}
    */
    readonly volumeId: string;
}
export declare function jobV1SpecTemplateSpecVolumeAwsElasticBlockStoreToTerraform(struct?: JobV1SpecTemplateSpecVolumeAwsElasticBlockStoreOutputReference | JobV1SpecTemplateSpecVolumeAwsElasticBlockStore): any;
export declare class JobV1SpecTemplateSpecVolumeAwsElasticBlockStoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeAwsElasticBlockStore | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeAwsElasticBlockStore | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _partition?;
    get partition(): number;
    set partition(value: number);
    resetPartition(): void;
    get partitionInput(): number | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeAzureDisk {
    /**
    * Host Caching mode: None, Read Only, Read Write.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#caching_mode JobV1#caching_mode}
    */
    readonly cachingMode: string;
    /**
    * The URI the data disk in the blob storage
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#data_disk_uri JobV1#data_disk_uri}
    */
    readonly dataDiskUri: string;
    /**
    * The Name of the data disk in the blob storage
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#disk_name JobV1#disk_name}
    */
    readonly diskName: string;
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#fs_type JobV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * The type for the data disk. Expected values: Shared, Dedicated, Managed. Defaults to Shared
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#kind JobV1#kind}
    */
    readonly kind?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecVolumeAzureDiskToTerraform(struct?: JobV1SpecTemplateSpecVolumeAzureDiskOutputReference | JobV1SpecTemplateSpecVolumeAzureDisk): any;
export declare class JobV1SpecTemplateSpecVolumeAzureDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeAzureDisk | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeAzureDisk | undefined);
    private _cachingMode?;
    get cachingMode(): string;
    set cachingMode(value: string);
    get cachingModeInput(): string | undefined;
    private _dataDiskUri?;
    get dataDiskUri(): string;
    set dataDiskUri(value: string);
    get dataDiskUriInput(): string | undefined;
    private _diskName?;
    get diskName(): string;
    set diskName(value: string);
    get diskNameInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface JobV1SpecTemplateSpecVolumeAzureFile {
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * The name of secret that contains Azure Storage Account Name and Key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#secret_name JobV1#secret_name}
    */
    readonly secretName: string;
    /**
    * The namespace of the secret that contains Azure Storage Account Name and Key. For Kubernetes up to 1.18.x the default is the same as the Pod. For Kubernetes 1.19.x and later the default is "default" namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#secret_namespace JobV1#secret_namespace}
    */
    readonly secretNamespace?: string;
    /**
    * Share Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#share_name JobV1#share_name}
    */
    readonly shareName: string;
}
export declare function jobV1SpecTemplateSpecVolumeAzureFileToTerraform(struct?: JobV1SpecTemplateSpecVolumeAzureFileOutputReference | JobV1SpecTemplateSpecVolumeAzureFile): any;
export declare class JobV1SpecTemplateSpecVolumeAzureFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeAzureFile | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeAzureFile | undefined);
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
    private _secretNamespace?;
    get secretNamespace(): string;
    set secretNamespace(value: string);
    resetSecretNamespace(): void;
    get secretNamespaceInput(): string | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeCephFsSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#name JobV1#name}
    */
    readonly name?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#namespace JobV1#namespace}
    */
    readonly namespace?: string;
}
export declare function jobV1SpecTemplateSpecVolumeCephFsSecretRefToTerraform(struct?: JobV1SpecTemplateSpecVolumeCephFsSecretRefOutputReference | JobV1SpecTemplateSpecVolumeCephFsSecretRef): any;
export declare class JobV1SpecTemplateSpecVolumeCephFsSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeCephFsSecretRef | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeCephFsSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeCephFs {
    /**
    * Monitors is a collection of Ceph monitors More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#monitors JobV1#monitors}
    */
    readonly monitors: string[];
    /**
    * Used as the mounted root, rather than the full Ceph tree, default is /
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#path JobV1#path}
    */
    readonly path?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to `false` (read/write). More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * The path to key ring for User, default is /etc/ceph/user.secret More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#secret_file JobV1#secret_file}
    */
    readonly secretFile?: string;
    /**
    * User is the rados user name, default is admin. More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#user JobV1#user}
    */
    readonly user?: string;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#secret_ref JobV1#secret_ref}
    */
    readonly secretRef?: JobV1SpecTemplateSpecVolumeCephFsSecretRef;
}
export declare function jobV1SpecTemplateSpecVolumeCephFsToTerraform(struct?: JobV1SpecTemplateSpecVolumeCephFsOutputReference | JobV1SpecTemplateSpecVolumeCephFs): any;
export declare class JobV1SpecTemplateSpecVolumeCephFsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeCephFs | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeCephFs | undefined);
    private _monitors?;
    get monitors(): string[];
    set monitors(value: string[]);
    get monitorsInput(): string[] | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretFile?;
    get secretFile(): string;
    set secretFile(value: string);
    resetSecretFile(): void;
    get secretFileInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
    private _secretRef;
    get secretRef(): JobV1SpecTemplateSpecVolumeCephFsSecretRefOutputReference;
    putSecretRef(value: JobV1SpecTemplateSpecVolumeCephFsSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): JobV1SpecTemplateSpecVolumeCephFsSecretRef | undefined;
}
export interface JobV1SpecTemplateSpecVolumeCinder {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#fs_type JobV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write). More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Volume ID used to identify the volume in Cinder. More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#volume_id JobV1#volume_id}
    */
    readonly volumeId: string;
}
export declare function jobV1SpecTemplateSpecVolumeCinderToTerraform(struct?: JobV1SpecTemplateSpecVolumeCinderOutputReference | JobV1SpecTemplateSpecVolumeCinder): any;
export declare class JobV1SpecTemplateSpecVolumeCinderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeCinder | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeCinder | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeConfigMapItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#key JobV1#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#mode JobV1#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#path JobV1#path}
    */
    readonly path?: string;
}
export declare function jobV1SpecTemplateSpecVolumeConfigMapItemsToTerraform(struct?: JobV1SpecTemplateSpecVolumeConfigMapItems | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecVolumeConfigMapItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecVolumeConfigMapItems | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeConfigMapItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class JobV1SpecTemplateSpecVolumeConfigMapItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecVolumeConfigMapItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecVolumeConfigMapItemsOutputReference;
}
export interface JobV1SpecTemplateSpecVolumeConfigMap {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#default_mode JobV1#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#name JobV1#name}
    */
    readonly name?: string;
    /**
    * Optional: Specify whether the ConfigMap or its keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#optional JobV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#items JobV1#items}
    */
    readonly items?: JobV1SpecTemplateSpecVolumeConfigMapItems[] | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecVolumeConfigMapToTerraform(struct?: JobV1SpecTemplateSpecVolumeConfigMapOutputReference | JobV1SpecTemplateSpecVolumeConfigMap): any;
export declare class JobV1SpecTemplateSpecVolumeConfigMapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeConfigMap | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeConfigMap | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _items;
    get items(): JobV1SpecTemplateSpecVolumeConfigMapItemsList;
    putItems(value: JobV1SpecTemplateSpecVolumeConfigMapItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | JobV1SpecTemplateSpecVolumeConfigMapItems[] | undefined;
}
export interface JobV1SpecTemplateSpecVolumeCsiNodePublishSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#name JobV1#name}
    */
    readonly name?: string;
}
export declare function jobV1SpecTemplateSpecVolumeCsiNodePublishSecretRefToTerraform(struct?: JobV1SpecTemplateSpecVolumeCsiNodePublishSecretRefOutputReference | JobV1SpecTemplateSpecVolumeCsiNodePublishSecretRef): any;
export declare class JobV1SpecTemplateSpecVolumeCsiNodePublishSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeCsiNodePublishSecretRef | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeCsiNodePublishSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeCsi {
    /**
    * the name of the volume driver to use. More info: https://kubernetes.io/docs/concepts/storage/volumes/#csi
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#driver JobV1#driver}
    */
    readonly driver: string;
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#fs_type JobV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * Whether to set the read-only property in VolumeMounts to "true". If omitted, the default is "false". More info: http://kubernetes.io/docs/user-guide/volumes#csi
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Attributes of the volume to publish.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#volume_attributes JobV1#volume_attributes}
    */
    readonly volumeAttributes?: {
        [key: string]: string;
    };
    /**
    * node_publish_secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#node_publish_secret_ref JobV1#node_publish_secret_ref}
    */
    readonly nodePublishSecretRef?: JobV1SpecTemplateSpecVolumeCsiNodePublishSecretRef;
}
export declare function jobV1SpecTemplateSpecVolumeCsiToTerraform(struct?: JobV1SpecTemplateSpecVolumeCsiOutputReference | JobV1SpecTemplateSpecVolumeCsi): any;
export declare class JobV1SpecTemplateSpecVolumeCsiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeCsi | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeCsi | undefined);
    private _driver?;
    get driver(): string;
    set driver(value: string);
    get driverInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeAttributes?;
    get volumeAttributes(): {
        [key: string]: string;
    };
    set volumeAttributes(value: {
        [key: string]: string;
    });
    resetVolumeAttributes(): void;
    get volumeAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _nodePublishSecretRef;
    get nodePublishSecretRef(): JobV1SpecTemplateSpecVolumeCsiNodePublishSecretRefOutputReference;
    putNodePublishSecretRef(value: JobV1SpecTemplateSpecVolumeCsiNodePublishSecretRef): void;
    resetNodePublishSecretRef(): void;
    get nodePublishSecretRefInput(): JobV1SpecTemplateSpecVolumeCsiNodePublishSecretRef | undefined;
}
export interface JobV1SpecTemplateSpecVolumeDownwardApiItemsFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to "v1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#api_version JobV1#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#field_path JobV1#field_path}
    */
    readonly fieldPath?: string;
}
export declare function jobV1SpecTemplateSpecVolumeDownwardApiItemsFieldRefToTerraform(struct?: JobV1SpecTemplateSpecVolumeDownwardApiItemsFieldRefOutputReference | JobV1SpecTemplateSpecVolumeDownwardApiItemsFieldRef): any;
export declare class JobV1SpecTemplateSpecVolumeDownwardApiItemsFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeDownwardApiItemsFieldRef | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeDownwardApiItemsFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#container_name JobV1#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#divisor JobV1#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#resource JobV1#resource}
    */
    readonly resource: string;
}
export declare function jobV1SpecTemplateSpecVolumeDownwardApiItemsResourceFieldRefToTerraform(struct?: JobV1SpecTemplateSpecVolumeDownwardApiItemsResourceFieldRefOutputReference | JobV1SpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef): any;
export declare class JobV1SpecTemplateSpecVolumeDownwardApiItemsResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeDownwardApiItems {
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#mode JobV1#mode}
    */
    readonly mode?: string;
    /**
    * Path is the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#path JobV1#path}
    */
    readonly path: string;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#field_ref JobV1#field_ref}
    */
    readonly fieldRef: JobV1SpecTemplateSpecVolumeDownwardApiItemsFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#resource_field_ref JobV1#resource_field_ref}
    */
    readonly resourceFieldRef?: JobV1SpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef;
}
export declare function jobV1SpecTemplateSpecVolumeDownwardApiItemsToTerraform(struct?: JobV1SpecTemplateSpecVolumeDownwardApiItems | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecVolumeDownwardApiItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecVolumeDownwardApiItems | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeDownwardApiItems | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _fieldRef;
    get fieldRef(): JobV1SpecTemplateSpecVolumeDownwardApiItemsFieldRefOutputReference;
    putFieldRef(value: JobV1SpecTemplateSpecVolumeDownwardApiItemsFieldRef): void;
    get fieldRefInput(): JobV1SpecTemplateSpecVolumeDownwardApiItemsFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): JobV1SpecTemplateSpecVolumeDownwardApiItemsResourceFieldRefOutputReference;
    putResourceFieldRef(value: JobV1SpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): JobV1SpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef | undefined;
}
export declare class JobV1SpecTemplateSpecVolumeDownwardApiItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecVolumeDownwardApiItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecVolumeDownwardApiItemsOutputReference;
}
export interface JobV1SpecTemplateSpecVolumeDownwardApi {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#default_mode JobV1#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#items JobV1#items}
    */
    readonly items?: JobV1SpecTemplateSpecVolumeDownwardApiItems[] | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecVolumeDownwardApiToTerraform(struct?: JobV1SpecTemplateSpecVolumeDownwardApiOutputReference | JobV1SpecTemplateSpecVolumeDownwardApi): any;
export declare class JobV1SpecTemplateSpecVolumeDownwardApiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeDownwardApi | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeDownwardApi | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _items;
    get items(): JobV1SpecTemplateSpecVolumeDownwardApiItemsList;
    putItems(value: JobV1SpecTemplateSpecVolumeDownwardApiItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | JobV1SpecTemplateSpecVolumeDownwardApiItems[] | undefined;
}
export interface JobV1SpecTemplateSpecVolumeEmptyDir {
    /**
    * What type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#medium JobV1#medium}
    */
    readonly medium?: string;
    /**
    * Total amount of local storage required for this EmptyDir volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#size_limit JobV1#size_limit}
    */
    readonly sizeLimit?: string;
}
export declare function jobV1SpecTemplateSpecVolumeEmptyDirToTerraform(struct?: JobV1SpecTemplateSpecVolumeEmptyDirOutputReference | JobV1SpecTemplateSpecVolumeEmptyDir): any;
export declare class JobV1SpecTemplateSpecVolumeEmptyDirOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeEmptyDir | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeEmptyDir | undefined);
    private _medium?;
    get medium(): string;
    set medium(value: string);
    resetMedium(): void;
    get mediumInput(): string | undefined;
    private _sizeLimit?;
    get sizeLimit(): string;
    set sizeLimit(value: string);
    resetSizeLimit(): void;
    get sizeLimitInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeFc {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#fs_type JobV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * FC target lun number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#lun JobV1#lun}
    */
    readonly lun: number;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * FC target worldwide names (WWNs)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#target_ww_ns JobV1#target_ww_ns}
    */
    readonly targetWwNs: string[];
}
export declare function jobV1SpecTemplateSpecVolumeFcToTerraform(struct?: JobV1SpecTemplateSpecVolumeFcOutputReference | JobV1SpecTemplateSpecVolumeFc): any;
export declare class JobV1SpecTemplateSpecVolumeFcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeFc | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeFc | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    get lunInput(): number | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _targetWwNs?;
    get targetWwNs(): string[];
    set targetWwNs(value: string[]);
    get targetWwNsInput(): string[] | undefined;
}
export interface JobV1SpecTemplateSpecVolumeFlexVolumeSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#name JobV1#name}
    */
    readonly name?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#namespace JobV1#namespace}
    */
    readonly namespace?: string;
}
export declare function jobV1SpecTemplateSpecVolumeFlexVolumeSecretRefToTerraform(struct?: JobV1SpecTemplateSpecVolumeFlexVolumeSecretRefOutputReference | JobV1SpecTemplateSpecVolumeFlexVolumeSecretRef): any;
export declare class JobV1SpecTemplateSpecVolumeFlexVolumeSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeFlexVolumeSecretRef | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeFlexVolumeSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeFlexVolume {
    /**
    * Driver is the name of the driver to use for this volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#driver JobV1#driver}
    */
    readonly driver: string;
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#fs_type JobV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * Extra command options if any.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#options JobV1#options}
    */
    readonly options?: {
        [key: string]: string;
    };
    /**
    * Whether to force the ReadOnly setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#secret_ref JobV1#secret_ref}
    */
    readonly secretRef?: JobV1SpecTemplateSpecVolumeFlexVolumeSecretRef;
}
export declare function jobV1SpecTemplateSpecVolumeFlexVolumeToTerraform(struct?: JobV1SpecTemplateSpecVolumeFlexVolumeOutputReference | JobV1SpecTemplateSpecVolumeFlexVolume): any;
export declare class JobV1SpecTemplateSpecVolumeFlexVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeFlexVolume | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeFlexVolume | undefined);
    private _driver?;
    get driver(): string;
    set driver(value: string);
    get driverInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    resetOptions(): void;
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretRef;
    get secretRef(): JobV1SpecTemplateSpecVolumeFlexVolumeSecretRefOutputReference;
    putSecretRef(value: JobV1SpecTemplateSpecVolumeFlexVolumeSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): JobV1SpecTemplateSpecVolumeFlexVolumeSecretRef | undefined;
}
export interface JobV1SpecTemplateSpecVolumeFlocker {
    /**
    * Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#dataset_name JobV1#dataset_name}
    */
    readonly datasetName?: string;
    /**
    * UUID of the dataset. This is unique identifier of a Flocker dataset
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#dataset_uuid JobV1#dataset_uuid}
    */
    readonly datasetUuid?: string;
}
export declare function jobV1SpecTemplateSpecVolumeFlockerToTerraform(struct?: JobV1SpecTemplateSpecVolumeFlockerOutputReference | JobV1SpecTemplateSpecVolumeFlocker): any;
export declare class JobV1SpecTemplateSpecVolumeFlockerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeFlocker | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeFlocker | undefined);
    private _datasetName?;
    get datasetName(): string;
    set datasetName(value: string);
    resetDatasetName(): void;
    get datasetNameInput(): string | undefined;
    private _datasetUuid?;
    get datasetUuid(): string;
    set datasetUuid(value: string);
    resetDatasetUuid(): void;
    get datasetUuidInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeGcePersistentDisk {
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#fs_type JobV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#partition JobV1#partition}
    */
    readonly partition?: number;
    /**
    * Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#pd_name JobV1#pd_name}
    */
    readonly pdName: string;
    /**
    * Whether to force the ReadOnly setting in VolumeMounts. Defaults to false. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecVolumeGcePersistentDiskToTerraform(struct?: JobV1SpecTemplateSpecVolumeGcePersistentDiskOutputReference | JobV1SpecTemplateSpecVolumeGcePersistentDisk): any;
export declare class JobV1SpecTemplateSpecVolumeGcePersistentDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeGcePersistentDisk | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeGcePersistentDisk | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _partition?;
    get partition(): number;
    set partition(value: number);
    resetPartition(): void;
    get partitionInput(): number | undefined;
    private _pdName?;
    get pdName(): string;
    set pdName(value: string);
    get pdNameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface JobV1SpecTemplateSpecVolumeGitRepo {
    /**
    * Target directory name. Must not contain or start with '..'. If '.' is supplied, the volume directory will be the git repository. Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#directory JobV1#directory}
    */
    readonly directory?: string;
    /**
    * Repository URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#repository JobV1#repository}
    */
    readonly repository?: string;
    /**
    * Commit hash for the specified revision.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#revision JobV1#revision}
    */
    readonly revision?: string;
}
export declare function jobV1SpecTemplateSpecVolumeGitRepoToTerraform(struct?: JobV1SpecTemplateSpecVolumeGitRepoOutputReference | JobV1SpecTemplateSpecVolumeGitRepo): any;
export declare class JobV1SpecTemplateSpecVolumeGitRepoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeGitRepo | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeGitRepo | undefined);
    private _directory?;
    get directory(): string;
    set directory(value: string);
    resetDirectory(): void;
    get directoryInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    resetRepository(): void;
    get repositoryInput(): string | undefined;
    private _revision?;
    get revision(): string;
    set revision(value: string);
    resetRevision(): void;
    get revisionInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeGlusterfs {
    /**
    * The endpoint name that details Glusterfs topology. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#endpoints_name JobV1#endpoints_name}
    */
    readonly endpointsName: string;
    /**
    * The Glusterfs volume path. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#path JobV1#path}
    */
    readonly path: string;
    /**
    * Whether to force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecVolumeGlusterfsToTerraform(struct?: JobV1SpecTemplateSpecVolumeGlusterfsOutputReference | JobV1SpecTemplateSpecVolumeGlusterfs): any;
export declare class JobV1SpecTemplateSpecVolumeGlusterfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeGlusterfs | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeGlusterfs | undefined);
    private _endpointsName?;
    get endpointsName(): string;
    set endpointsName(value: string);
    get endpointsNameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface JobV1SpecTemplateSpecVolumeHostPath {
    /**
    * Path of the directory on the host. More info: http://kubernetes.io/docs/user-guide/volumes#hostpath
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#path JobV1#path}
    */
    readonly path?: string;
    /**
    * Type for HostPath volume. Allowed values are "" (default), DirectoryOrCreate, Directory, FileOrCreate, File, Socket, CharDevice and BlockDevice
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#type JobV1#type}
    */
    readonly type?: string;
}
export declare function jobV1SpecTemplateSpecVolumeHostPathToTerraform(struct?: JobV1SpecTemplateSpecVolumeHostPathOutputReference | JobV1SpecTemplateSpecVolumeHostPath): any;
export declare class JobV1SpecTemplateSpecVolumeHostPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeHostPath | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeHostPath | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeIscsi {
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#iscsi
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#fs_type JobV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * Target iSCSI Qualified Name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#iqn JobV1#iqn}
    */
    readonly iqn: string;
    /**
    * iSCSI interface name that uses an iSCSI transport. Defaults to 'default' (tcp).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#iscsi_interface JobV1#iscsi_interface}
    */
    readonly iscsiInterface?: string;
    /**
    * iSCSI target lun number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#lun JobV1#lun}
    */
    readonly lun?: number;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * iSCSI target portal. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#target_portal JobV1#target_portal}
    */
    readonly targetPortal: string;
}
export declare function jobV1SpecTemplateSpecVolumeIscsiToTerraform(struct?: JobV1SpecTemplateSpecVolumeIscsiOutputReference | JobV1SpecTemplateSpecVolumeIscsi): any;
export declare class JobV1SpecTemplateSpecVolumeIscsiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeIscsi | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeIscsi | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _iqn?;
    get iqn(): string;
    set iqn(value: string);
    get iqnInput(): string | undefined;
    private _iscsiInterface?;
    get iscsiInterface(): string;
    set iscsiInterface(value: string);
    resetIscsiInterface(): void;
    get iscsiInterfaceInput(): string | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    resetLun(): void;
    get lunInput(): number | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _targetPortal?;
    get targetPortal(): string;
    set targetPortal(value: string);
    get targetPortalInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeLocal {
    /**
    * Path of the directory on the host. More info: http://kubernetes.io/docs/user-guide/volumes#local
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#path JobV1#path}
    */
    readonly path?: string;
}
export declare function jobV1SpecTemplateSpecVolumeLocalToTerraform(struct?: JobV1SpecTemplateSpecVolumeLocalOutputReference | JobV1SpecTemplateSpecVolumeLocal): any;
export declare class JobV1SpecTemplateSpecVolumeLocalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeLocal | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeLocal | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeNfs {
    /**
    * Path that is exported by the NFS server. More info: http://kubernetes.io/docs/user-guide/volumes#nfs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#path JobV1#path}
    */
    readonly path: string;
    /**
    * Whether to force the NFS export to be mounted with read-only permissions. Defaults to false. More info: http://kubernetes.io/docs/user-guide/volumes#nfs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Server is the hostname or IP address of the NFS server. More info: http://kubernetes.io/docs/user-guide/volumes#nfs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#server JobV1#server}
    */
    readonly server: string;
}
export declare function jobV1SpecTemplateSpecVolumeNfsToTerraform(struct?: JobV1SpecTemplateSpecVolumeNfsOutputReference | JobV1SpecTemplateSpecVolumeNfs): any;
export declare class JobV1SpecTemplateSpecVolumeNfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeNfs | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeNfs | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumePersistentVolumeClaim {
    /**
    * ClaimName is the name of a PersistentVolumeClaim in the same
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#claim_name JobV1#claim_name}
    */
    readonly claimName?: string;
    /**
    * Will force the ReadOnly setting in VolumeMounts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecVolumePersistentVolumeClaimToTerraform(struct?: JobV1SpecTemplateSpecVolumePersistentVolumeClaimOutputReference | JobV1SpecTemplateSpecVolumePersistentVolumeClaim): any;
export declare class JobV1SpecTemplateSpecVolumePersistentVolumeClaimOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumePersistentVolumeClaim | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumePersistentVolumeClaim | undefined);
    private _claimName?;
    get claimName(): string;
    set claimName(value: string);
    resetClaimName(): void;
    get claimNameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface JobV1SpecTemplateSpecVolumePhotonPersistentDisk {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#fs_type JobV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * ID that identifies Photon Controller persistent disk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#pd_id JobV1#pd_id}
    */
    readonly pdId: string;
}
export declare function jobV1SpecTemplateSpecVolumePhotonPersistentDiskToTerraform(struct?: JobV1SpecTemplateSpecVolumePhotonPersistentDiskOutputReference | JobV1SpecTemplateSpecVolumePhotonPersistentDisk): any;
export declare class JobV1SpecTemplateSpecVolumePhotonPersistentDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumePhotonPersistentDisk | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumePhotonPersistentDisk | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _pdId?;
    get pdId(): string;
    set pdId(value: string);
    get pdIdInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#key JobV1#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#mode JobV1#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#path JobV1#path}
    */
    readonly path?: string;
}
export declare function jobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapItemsToTerraform(struct?: JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapItems | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapItems | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapItemsOutputReference;
}
export interface JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMap {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#name JobV1#name}
    */
    readonly name?: string;
    /**
    * Optional: Specify whether the ConfigMap or it's keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#optional JobV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#items JobV1#items}
    */
    readonly items?: JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapItems[] | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapToTerraform(struct?: JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMap | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMap | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMap | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _items;
    get items(): JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapItemsList;
    putItems(value: JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapItems[] | undefined;
}
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMap[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapOutputReference;
}
export interface JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to 'v1'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#api_version JobV1#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#field_path JobV1#field_path}
    */
    readonly fieldPath?: string;
}
export declare function jobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRefToTerraform(struct?: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRefOutputReference | JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef): any;
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#container_name JobV1#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#divisor JobV1#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#resource JobV1#resource}
    */
    readonly resource: string;
}
export declare function jobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefToTerraform(struct?: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefOutputReference | JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef): any;
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItems {
    /**
    * Mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#mode JobV1#mode}
    */
    readonly mode?: string;
    /**
    * Path is the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#path JobV1#path}
    */
    readonly path: string;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#field_ref JobV1#field_ref}
    */
    readonly fieldRef?: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#resource_field_ref JobV1#resource_field_ref}
    */
    readonly resourceFieldRef?: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef;
}
export declare function jobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsToTerraform(struct?: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItems | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItems | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItems | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _fieldRef;
    get fieldRef(): JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRefOutputReference;
    putFieldRef(value: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef): void;
    resetFieldRef(): void;
    get fieldRefInput(): JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefOutputReference;
    putResourceFieldRef(value: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef | undefined;
}
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsOutputReference;
}
export interface JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApi {
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#items JobV1#items}
    */
    readonly items?: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItems[] | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiToTerraform(struct?: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiOutputReference | JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApi): any;
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApi | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApi | undefined);
    private _items;
    get items(): JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsList;
    putItems(value: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiItems[] | undefined;
}
export interface JobV1SpecTemplateSpecVolumeProjectedSourcesSecretItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#key JobV1#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#mode JobV1#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#path JobV1#path}
    */
    readonly path?: string;
}
export declare function jobV1SpecTemplateSpecVolumeProjectedSourcesSecretItemsToTerraform(struct?: JobV1SpecTemplateSpecVolumeProjectedSourcesSecretItems | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecVolumeProjectedSourcesSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeProjectedSourcesSecretItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecVolumeProjectedSourcesSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecVolumeProjectedSourcesSecretItemsOutputReference;
}
export interface JobV1SpecTemplateSpecVolumeProjectedSourcesSecret {
    /**
    * Name of the secret in the pod's namespace to use. More info: http://kubernetes.io/docs/user-guide/volumes#secrets
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#name JobV1#name}
    */
    readonly name?: string;
    /**
    * Optional: Specify whether the Secret or it's keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#optional JobV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#items JobV1#items}
    */
    readonly items?: JobV1SpecTemplateSpecVolumeProjectedSourcesSecretItems[] | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecVolumeProjectedSourcesSecretToTerraform(struct?: JobV1SpecTemplateSpecVolumeProjectedSourcesSecret | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecVolumeProjectedSourcesSecret | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeProjectedSourcesSecret | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _items;
    get items(): JobV1SpecTemplateSpecVolumeProjectedSourcesSecretItemsList;
    putItems(value: JobV1SpecTemplateSpecVolumeProjectedSourcesSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | JobV1SpecTemplateSpecVolumeProjectedSourcesSecretItems[] | undefined;
}
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecVolumeProjectedSourcesSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecVolumeProjectedSourcesSecretOutputReference;
}
export interface JobV1SpecTemplateSpecVolumeProjectedSourcesServiceAccountToken {
    /**
    * Audience is the intended audience of the token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#audience JobV1#audience}
    */
    readonly audience?: string;
    /**
    * ExpirationSeconds is the expected duration of validity of the service account token. It defaults to 1 hour and must be at least 10 minutes (600 seconds).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#expiration_seconds JobV1#expiration_seconds}
    */
    readonly expirationSeconds?: number;
    /**
    * Path specifies a relative path to the mount point of the projected volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#path JobV1#path}
    */
    readonly path: string;
}
export declare function jobV1SpecTemplateSpecVolumeProjectedSourcesServiceAccountTokenToTerraform(struct?: JobV1SpecTemplateSpecVolumeProjectedSourcesServiceAccountTokenOutputReference | JobV1SpecTemplateSpecVolumeProjectedSourcesServiceAccountToken): any;
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesServiceAccountTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeProjectedSourcesServiceAccountToken | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeProjectedSourcesServiceAccountToken | undefined);
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _expirationSeconds?;
    get expirationSeconds(): number;
    set expirationSeconds(value: number);
    resetExpirationSeconds(): void;
    get expirationSecondsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeProjectedSources {
    /**
    * config_map block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#config_map JobV1#config_map}
    */
    readonly configMap?: JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMap[] | cdktf.IResolvable;
    /**
    * downward_api block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#downward_api JobV1#downward_api}
    */
    readonly downwardApi?: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApi;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#secret JobV1#secret}
    */
    readonly secret?: JobV1SpecTemplateSpecVolumeProjectedSourcesSecret[] | cdktf.IResolvable;
    /**
    * service_account_token block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#service_account_token JobV1#service_account_token}
    */
    readonly serviceAccountToken?: JobV1SpecTemplateSpecVolumeProjectedSourcesServiceAccountToken;
}
export declare function jobV1SpecTemplateSpecVolumeProjectedSourcesToTerraform(struct?: JobV1SpecTemplateSpecVolumeProjectedSources | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecVolumeProjectedSources | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeProjectedSources | cdktf.IResolvable | undefined);
    private _configMap;
    get configMap(): JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMapList;
    putConfigMap(value: JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMap[] | cdktf.IResolvable): void;
    resetConfigMap(): void;
    get configMapInput(): cdktf.IResolvable | JobV1SpecTemplateSpecVolumeProjectedSourcesConfigMap[] | undefined;
    private _downwardApi;
    get downwardApi(): JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApiOutputReference;
    putDownwardApi(value: JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApi): void;
    resetDownwardApi(): void;
    get downwardApiInput(): JobV1SpecTemplateSpecVolumeProjectedSourcesDownwardApi | undefined;
    private _secret;
    get secret(): JobV1SpecTemplateSpecVolumeProjectedSourcesSecretList;
    putSecret(value: JobV1SpecTemplateSpecVolumeProjectedSourcesSecret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | JobV1SpecTemplateSpecVolumeProjectedSourcesSecret[] | undefined;
    private _serviceAccountToken;
    get serviceAccountToken(): JobV1SpecTemplateSpecVolumeProjectedSourcesServiceAccountTokenOutputReference;
    putServiceAccountToken(value: JobV1SpecTemplateSpecVolumeProjectedSourcesServiceAccountToken): void;
    resetServiceAccountToken(): void;
    get serviceAccountTokenInput(): JobV1SpecTemplateSpecVolumeProjectedSourcesServiceAccountToken | undefined;
}
export declare class JobV1SpecTemplateSpecVolumeProjectedSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecVolumeProjectedSources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecVolumeProjectedSourcesOutputReference;
}
export interface JobV1SpecTemplateSpecVolumeProjected {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#default_mode JobV1#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * sources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#sources JobV1#sources}
    */
    readonly sources: JobV1SpecTemplateSpecVolumeProjectedSources[] | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecVolumeProjectedToTerraform(struct?: JobV1SpecTemplateSpecVolumeProjected | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecVolumeProjectedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecVolumeProjected | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeProjected | cdktf.IResolvable | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _sources;
    get sources(): JobV1SpecTemplateSpecVolumeProjectedSourcesList;
    putSources(value: JobV1SpecTemplateSpecVolumeProjectedSources[] | cdktf.IResolvable): void;
    get sourcesInput(): cdktf.IResolvable | JobV1SpecTemplateSpecVolumeProjectedSources[] | undefined;
}
export declare class JobV1SpecTemplateSpecVolumeProjectedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecVolumeProjected[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecVolumeProjectedOutputReference;
}
export interface JobV1SpecTemplateSpecVolumeQuobyte {
    /**
    * Group to map volume access to Default is no group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#group JobV1#group}
    */
    readonly group?: string;
    /**
    * Whether to force the Quobyte volume to be mounted with read-only permissions. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#registry JobV1#registry}
    */
    readonly registry: string;
    /**
    * User to map volume access to Defaults to serivceaccount user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#user JobV1#user}
    */
    readonly user?: string;
    /**
    * Volume is a string that references an already created Quobyte volume by name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#volume JobV1#volume}
    */
    readonly volume: string;
}
export declare function jobV1SpecTemplateSpecVolumeQuobyteToTerraform(struct?: JobV1SpecTemplateSpecVolumeQuobyteOutputReference | JobV1SpecTemplateSpecVolumeQuobyte): any;
export declare class JobV1SpecTemplateSpecVolumeQuobyteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeQuobyte | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeQuobyte | undefined);
    private _group?;
    get group(): string;
    set group(value: string);
    resetGroup(): void;
    get groupInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _registry?;
    get registry(): string;
    set registry(value: string);
    get registryInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
    private _volume?;
    get volume(): string;
    set volume(value: string);
    get volumeInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeRbdSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#name JobV1#name}
    */
    readonly name?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#namespace JobV1#namespace}
    */
    readonly namespace?: string;
}
export declare function jobV1SpecTemplateSpecVolumeRbdSecretRefToTerraform(struct?: JobV1SpecTemplateSpecVolumeRbdSecretRefOutputReference | JobV1SpecTemplateSpecVolumeRbdSecretRef): any;
export declare class JobV1SpecTemplateSpecVolumeRbdSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeRbdSecretRef | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeRbdSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolumeRbd {
    /**
    * A collection of Ceph monitors. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#ceph_monitors JobV1#ceph_monitors}
    */
    readonly cephMonitors: string[];
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#rbd
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#fs_type JobV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#keyring JobV1#keyring}
    */
    readonly keyring?: string;
    /**
    * The rados user name. Default is admin. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#rados_user JobV1#rados_user}
    */
    readonly radosUser?: string;
    /**
    * The rados image name. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#rbd_image JobV1#rbd_image}
    */
    readonly rbdImage: string;
    /**
    * The rados pool name. Default is rbd. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#rbd_pool JobV1#rbd_pool}
    */
    readonly rbdPool?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#read_only JobV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#secret_ref JobV1#secret_ref}
    */
    readonly secretRef?: JobV1SpecTemplateSpecVolumeRbdSecretRef;
}
export declare function jobV1SpecTemplateSpecVolumeRbdToTerraform(struct?: JobV1SpecTemplateSpecVolumeRbdOutputReference | JobV1SpecTemplateSpecVolumeRbd): any;
export declare class JobV1SpecTemplateSpecVolumeRbdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeRbd | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeRbd | undefined);
    private _cephMonitors?;
    get cephMonitors(): string[];
    set cephMonitors(value: string[]);
    get cephMonitorsInput(): string[] | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _keyring?;
    get keyring(): string;
    set keyring(value: string);
    resetKeyring(): void;
    get keyringInput(): string | undefined;
    private _radosUser?;
    get radosUser(): string;
    set radosUser(value: string);
    resetRadosUser(): void;
    get radosUserInput(): string | undefined;
    private _rbdImage?;
    get rbdImage(): string;
    set rbdImage(value: string);
    get rbdImageInput(): string | undefined;
    private _rbdPool?;
    get rbdPool(): string;
    set rbdPool(value: string);
    resetRbdPool(): void;
    get rbdPoolInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretRef;
    get secretRef(): JobV1SpecTemplateSpecVolumeRbdSecretRefOutputReference;
    putSecretRef(value: JobV1SpecTemplateSpecVolumeRbdSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): JobV1SpecTemplateSpecVolumeRbdSecretRef | undefined;
}
export interface JobV1SpecTemplateSpecVolumeSecretItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#key JobV1#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#mode JobV1#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#path JobV1#path}
    */
    readonly path?: string;
}
export declare function jobV1SpecTemplateSpecVolumeSecretItemsToTerraform(struct?: JobV1SpecTemplateSpecVolumeSecretItems | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecVolumeSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecVolumeSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeSecretItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class JobV1SpecTemplateSpecVolumeSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecVolumeSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecVolumeSecretItemsOutputReference;
}
export interface JobV1SpecTemplateSpecVolumeSecret {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#default_mode JobV1#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * Optional: Specify whether the Secret or its keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#optional JobV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * Name of the secret in the pod's namespace to use. More info: http://kubernetes.io/docs/user-guide/volumes#secrets
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#secret_name JobV1#secret_name}
    */
    readonly secretName?: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#items JobV1#items}
    */
    readonly items?: JobV1SpecTemplateSpecVolumeSecretItems[] | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecVolumeSecretToTerraform(struct?: JobV1SpecTemplateSpecVolumeSecretOutputReference | JobV1SpecTemplateSpecVolumeSecret): any;
export declare class JobV1SpecTemplateSpecVolumeSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeSecret | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeSecret | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    resetSecretName(): void;
    get secretNameInput(): string | undefined;
    private _items;
    get items(): JobV1SpecTemplateSpecVolumeSecretItemsList;
    putItems(value: JobV1SpecTemplateSpecVolumeSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | JobV1SpecTemplateSpecVolumeSecretItems[] | undefined;
}
export interface JobV1SpecTemplateSpecVolumeVsphereVolume {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#fs_type JobV1#fs_type}
    */
    readonly fsType?: string;
    /**
    * Path that identifies vSphere volume vmdk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#volume_path JobV1#volume_path}
    */
    readonly volumePath: string;
}
export declare function jobV1SpecTemplateSpecVolumeVsphereVolumeToTerraform(struct?: JobV1SpecTemplateSpecVolumeVsphereVolumeOutputReference | JobV1SpecTemplateSpecVolumeVsphereVolume): any;
export declare class JobV1SpecTemplateSpecVolumeVsphereVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpecVolumeVsphereVolume | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolumeVsphereVolume | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _volumePath?;
    get volumePath(): string;
    set volumePath(value: string);
    get volumePathInput(): string | undefined;
}
export interface JobV1SpecTemplateSpecVolume {
    /**
    * Volume's name. Must be a DNS_LABEL and unique within the pod. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#name JobV1#name}
    */
    readonly name?: string;
    /**
    * aws_elastic_block_store block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#aws_elastic_block_store JobV1#aws_elastic_block_store}
    */
    readonly awsElasticBlockStore?: JobV1SpecTemplateSpecVolumeAwsElasticBlockStore;
    /**
    * azure_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#azure_disk JobV1#azure_disk}
    */
    readonly azureDisk?: JobV1SpecTemplateSpecVolumeAzureDisk;
    /**
    * azure_file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#azure_file JobV1#azure_file}
    */
    readonly azureFile?: JobV1SpecTemplateSpecVolumeAzureFile;
    /**
    * ceph_fs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#ceph_fs JobV1#ceph_fs}
    */
    readonly cephFs?: JobV1SpecTemplateSpecVolumeCephFs;
    /**
    * cinder block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#cinder JobV1#cinder}
    */
    readonly cinder?: JobV1SpecTemplateSpecVolumeCinder;
    /**
    * config_map block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#config_map JobV1#config_map}
    */
    readonly configMap?: JobV1SpecTemplateSpecVolumeConfigMap;
    /**
    * csi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#csi JobV1#csi}
    */
    readonly csi?: JobV1SpecTemplateSpecVolumeCsi;
    /**
    * downward_api block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#downward_api JobV1#downward_api}
    */
    readonly downwardApi?: JobV1SpecTemplateSpecVolumeDownwardApi;
    /**
    * empty_dir block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#empty_dir JobV1#empty_dir}
    */
    readonly emptyDir?: JobV1SpecTemplateSpecVolumeEmptyDir;
    /**
    * fc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#fc JobV1#fc}
    */
    readonly fc?: JobV1SpecTemplateSpecVolumeFc;
    /**
    * flex_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#flex_volume JobV1#flex_volume}
    */
    readonly flexVolume?: JobV1SpecTemplateSpecVolumeFlexVolume;
    /**
    * flocker block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#flocker JobV1#flocker}
    */
    readonly flocker?: JobV1SpecTemplateSpecVolumeFlocker;
    /**
    * gce_persistent_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#gce_persistent_disk JobV1#gce_persistent_disk}
    */
    readonly gcePersistentDisk?: JobV1SpecTemplateSpecVolumeGcePersistentDisk;
    /**
    * git_repo block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#git_repo JobV1#git_repo}
    */
    readonly gitRepo?: JobV1SpecTemplateSpecVolumeGitRepo;
    /**
    * glusterfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#glusterfs JobV1#glusterfs}
    */
    readonly glusterfs?: JobV1SpecTemplateSpecVolumeGlusterfs;
    /**
    * host_path block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#host_path JobV1#host_path}
    */
    readonly hostPath?: JobV1SpecTemplateSpecVolumeHostPath;
    /**
    * iscsi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#iscsi JobV1#iscsi}
    */
    readonly iscsi?: JobV1SpecTemplateSpecVolumeIscsi;
    /**
    * local block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#local JobV1#local}
    */
    readonly local?: JobV1SpecTemplateSpecVolumeLocal;
    /**
    * nfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#nfs JobV1#nfs}
    */
    readonly nfs?: JobV1SpecTemplateSpecVolumeNfs;
    /**
    * persistent_volume_claim block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#persistent_volume_claim JobV1#persistent_volume_claim}
    */
    readonly persistentVolumeClaim?: JobV1SpecTemplateSpecVolumePersistentVolumeClaim;
    /**
    * photon_persistent_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#photon_persistent_disk JobV1#photon_persistent_disk}
    */
    readonly photonPersistentDisk?: JobV1SpecTemplateSpecVolumePhotonPersistentDisk;
    /**
    * projected block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#projected JobV1#projected}
    */
    readonly projected?: JobV1SpecTemplateSpecVolumeProjected[] | cdktf.IResolvable;
    /**
    * quobyte block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#quobyte JobV1#quobyte}
    */
    readonly quobyte?: JobV1SpecTemplateSpecVolumeQuobyte;
    /**
    * rbd block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#rbd JobV1#rbd}
    */
    readonly rbd?: JobV1SpecTemplateSpecVolumeRbd;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#secret JobV1#secret}
    */
    readonly secret?: JobV1SpecTemplateSpecVolumeSecret;
    /**
    * vsphere_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#vsphere_volume JobV1#vsphere_volume}
    */
    readonly vsphereVolume?: JobV1SpecTemplateSpecVolumeVsphereVolume;
}
export declare function jobV1SpecTemplateSpecVolumeToTerraform(struct?: JobV1SpecTemplateSpecVolume | cdktf.IResolvable): any;
export declare class JobV1SpecTemplateSpecVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobV1SpecTemplateSpecVolume | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1SpecTemplateSpecVolume | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _awsElasticBlockStore;
    get awsElasticBlockStore(): JobV1SpecTemplateSpecVolumeAwsElasticBlockStoreOutputReference;
    putAwsElasticBlockStore(value: JobV1SpecTemplateSpecVolumeAwsElasticBlockStore): void;
    resetAwsElasticBlockStore(): void;
    get awsElasticBlockStoreInput(): JobV1SpecTemplateSpecVolumeAwsElasticBlockStore | undefined;
    private _azureDisk;
    get azureDisk(): JobV1SpecTemplateSpecVolumeAzureDiskOutputReference;
    putAzureDisk(value: JobV1SpecTemplateSpecVolumeAzureDisk): void;
    resetAzureDisk(): void;
    get azureDiskInput(): JobV1SpecTemplateSpecVolumeAzureDisk | undefined;
    private _azureFile;
    get azureFile(): JobV1SpecTemplateSpecVolumeAzureFileOutputReference;
    putAzureFile(value: JobV1SpecTemplateSpecVolumeAzureFile): void;
    resetAzureFile(): void;
    get azureFileInput(): JobV1SpecTemplateSpecVolumeAzureFile | undefined;
    private _cephFs;
    get cephFs(): JobV1SpecTemplateSpecVolumeCephFsOutputReference;
    putCephFs(value: JobV1SpecTemplateSpecVolumeCephFs): void;
    resetCephFs(): void;
    get cephFsInput(): JobV1SpecTemplateSpecVolumeCephFs | undefined;
    private _cinder;
    get cinder(): JobV1SpecTemplateSpecVolumeCinderOutputReference;
    putCinder(value: JobV1SpecTemplateSpecVolumeCinder): void;
    resetCinder(): void;
    get cinderInput(): JobV1SpecTemplateSpecVolumeCinder | undefined;
    private _configMap;
    get configMap(): JobV1SpecTemplateSpecVolumeConfigMapOutputReference;
    putConfigMap(value: JobV1SpecTemplateSpecVolumeConfigMap): void;
    resetConfigMap(): void;
    get configMapInput(): JobV1SpecTemplateSpecVolumeConfigMap | undefined;
    private _csi;
    get csi(): JobV1SpecTemplateSpecVolumeCsiOutputReference;
    putCsi(value: JobV1SpecTemplateSpecVolumeCsi): void;
    resetCsi(): void;
    get csiInput(): JobV1SpecTemplateSpecVolumeCsi | undefined;
    private _downwardApi;
    get downwardApi(): JobV1SpecTemplateSpecVolumeDownwardApiOutputReference;
    putDownwardApi(value: JobV1SpecTemplateSpecVolumeDownwardApi): void;
    resetDownwardApi(): void;
    get downwardApiInput(): JobV1SpecTemplateSpecVolumeDownwardApi | undefined;
    private _emptyDir;
    get emptyDir(): JobV1SpecTemplateSpecVolumeEmptyDirOutputReference;
    putEmptyDir(value: JobV1SpecTemplateSpecVolumeEmptyDir): void;
    resetEmptyDir(): void;
    get emptyDirInput(): JobV1SpecTemplateSpecVolumeEmptyDir | undefined;
    private _fc;
    get fc(): JobV1SpecTemplateSpecVolumeFcOutputReference;
    putFc(value: JobV1SpecTemplateSpecVolumeFc): void;
    resetFc(): void;
    get fcInput(): JobV1SpecTemplateSpecVolumeFc | undefined;
    private _flexVolume;
    get flexVolume(): JobV1SpecTemplateSpecVolumeFlexVolumeOutputReference;
    putFlexVolume(value: JobV1SpecTemplateSpecVolumeFlexVolume): void;
    resetFlexVolume(): void;
    get flexVolumeInput(): JobV1SpecTemplateSpecVolumeFlexVolume | undefined;
    private _flocker;
    get flocker(): JobV1SpecTemplateSpecVolumeFlockerOutputReference;
    putFlocker(value: JobV1SpecTemplateSpecVolumeFlocker): void;
    resetFlocker(): void;
    get flockerInput(): JobV1SpecTemplateSpecVolumeFlocker | undefined;
    private _gcePersistentDisk;
    get gcePersistentDisk(): JobV1SpecTemplateSpecVolumeGcePersistentDiskOutputReference;
    putGcePersistentDisk(value: JobV1SpecTemplateSpecVolumeGcePersistentDisk): void;
    resetGcePersistentDisk(): void;
    get gcePersistentDiskInput(): JobV1SpecTemplateSpecVolumeGcePersistentDisk | undefined;
    private _gitRepo;
    get gitRepo(): JobV1SpecTemplateSpecVolumeGitRepoOutputReference;
    putGitRepo(value: JobV1SpecTemplateSpecVolumeGitRepo): void;
    resetGitRepo(): void;
    get gitRepoInput(): JobV1SpecTemplateSpecVolumeGitRepo | undefined;
    private _glusterfs;
    get glusterfs(): JobV1SpecTemplateSpecVolumeGlusterfsOutputReference;
    putGlusterfs(value: JobV1SpecTemplateSpecVolumeGlusterfs): void;
    resetGlusterfs(): void;
    get glusterfsInput(): JobV1SpecTemplateSpecVolumeGlusterfs | undefined;
    private _hostPath;
    get hostPath(): JobV1SpecTemplateSpecVolumeHostPathOutputReference;
    putHostPath(value: JobV1SpecTemplateSpecVolumeHostPath): void;
    resetHostPath(): void;
    get hostPathInput(): JobV1SpecTemplateSpecVolumeHostPath | undefined;
    private _iscsi;
    get iscsi(): JobV1SpecTemplateSpecVolumeIscsiOutputReference;
    putIscsi(value: JobV1SpecTemplateSpecVolumeIscsi): void;
    resetIscsi(): void;
    get iscsiInput(): JobV1SpecTemplateSpecVolumeIscsi | undefined;
    private _local;
    get local(): JobV1SpecTemplateSpecVolumeLocalOutputReference;
    putLocal(value: JobV1SpecTemplateSpecVolumeLocal): void;
    resetLocal(): void;
    get localInput(): JobV1SpecTemplateSpecVolumeLocal | undefined;
    private _nfs;
    get nfs(): JobV1SpecTemplateSpecVolumeNfsOutputReference;
    putNfs(value: JobV1SpecTemplateSpecVolumeNfs): void;
    resetNfs(): void;
    get nfsInput(): JobV1SpecTemplateSpecVolumeNfs | undefined;
    private _persistentVolumeClaim;
    get persistentVolumeClaim(): JobV1SpecTemplateSpecVolumePersistentVolumeClaimOutputReference;
    putPersistentVolumeClaim(value: JobV1SpecTemplateSpecVolumePersistentVolumeClaim): void;
    resetPersistentVolumeClaim(): void;
    get persistentVolumeClaimInput(): JobV1SpecTemplateSpecVolumePersistentVolumeClaim | undefined;
    private _photonPersistentDisk;
    get photonPersistentDisk(): JobV1SpecTemplateSpecVolumePhotonPersistentDiskOutputReference;
    putPhotonPersistentDisk(value: JobV1SpecTemplateSpecVolumePhotonPersistentDisk): void;
    resetPhotonPersistentDisk(): void;
    get photonPersistentDiskInput(): JobV1SpecTemplateSpecVolumePhotonPersistentDisk | undefined;
    private _projected;
    get projected(): JobV1SpecTemplateSpecVolumeProjectedList;
    putProjected(value: JobV1SpecTemplateSpecVolumeProjected[] | cdktf.IResolvable): void;
    resetProjected(): void;
    get projectedInput(): cdktf.IResolvable | JobV1SpecTemplateSpecVolumeProjected[] | undefined;
    private _quobyte;
    get quobyte(): JobV1SpecTemplateSpecVolumeQuobyteOutputReference;
    putQuobyte(value: JobV1SpecTemplateSpecVolumeQuobyte): void;
    resetQuobyte(): void;
    get quobyteInput(): JobV1SpecTemplateSpecVolumeQuobyte | undefined;
    private _rbd;
    get rbd(): JobV1SpecTemplateSpecVolumeRbdOutputReference;
    putRbd(value: JobV1SpecTemplateSpecVolumeRbd): void;
    resetRbd(): void;
    get rbdInput(): JobV1SpecTemplateSpecVolumeRbd | undefined;
    private _secret;
    get secret(): JobV1SpecTemplateSpecVolumeSecretOutputReference;
    putSecret(value: JobV1SpecTemplateSpecVolumeSecret): void;
    resetSecret(): void;
    get secretInput(): JobV1SpecTemplateSpecVolumeSecret | undefined;
    private _vsphereVolume;
    get vsphereVolume(): JobV1SpecTemplateSpecVolumeVsphereVolumeOutputReference;
    putVsphereVolume(value: JobV1SpecTemplateSpecVolumeVsphereVolume): void;
    resetVsphereVolume(): void;
    get vsphereVolumeInput(): JobV1SpecTemplateSpecVolumeVsphereVolume | undefined;
}
export declare class JobV1SpecTemplateSpecVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobV1SpecTemplateSpecVolume[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobV1SpecTemplateSpecVolumeOutputReference;
}
export interface JobV1SpecTemplateSpec {
    /**
    * Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#active_deadline_seconds JobV1#active_deadline_seconds}
    */
    readonly activeDeadlineSeconds?: number;
    /**
    * AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#automount_service_account_token JobV1#automount_service_account_token}
    */
    readonly automountServiceAccountToken?: boolean | cdktf.IResolvable;
    /**
    * Set DNS policy for containers within the pod. Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'. Optional: Defaults to 'ClusterFirst', see [Kubernetes reference](https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#dns_policy JobV1#dns_policy}
    */
    readonly dnsPolicy?: string;
    /**
    * Enables generating environment variables for service discovery. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#enable_service_links JobV1#enable_service_links}
    */
    readonly enableServiceLinks?: boolean | cdktf.IResolvable;
    /**
    * Use the host's ipc namespace. Optional: Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#host_ipc JobV1#host_ipc}
    */
    readonly hostIpc?: boolean | cdktf.IResolvable;
    /**
    * Host networking requested for this pod. Use the host's network namespace. If this option is set, the ports that will be used must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#host_network JobV1#host_network}
    */
    readonly hostNetwork?: boolean | cdktf.IResolvable;
    /**
    * Use the host's pid namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#host_pid JobV1#host_pid}
    */
    readonly hostPid?: boolean | cdktf.IResolvable;
    /**
    * Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#hostname JobV1#hostname}
    */
    readonly hostname?: string;
    /**
    * NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#node_name JobV1#node_name}
    */
    readonly nodeName?: string;
    /**
    * NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: http://kubernetes.io/docs/user-guide/node-selection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#node_selector JobV1#node_selector}
    */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
    * If specified, indicates the pod's priority. "system-node-critical" and "system-cluster-critical" are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#priority_class_name JobV1#priority_class_name}
    */
    readonly priorityClassName?: string;
    /**
    * Restart policy for all containers within the pod. One of Always, OnFailure, Never. More info: http://kubernetes.io/docs/user-guide/pod-states#restartpolicy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#restart_policy JobV1#restart_policy}
    */
    readonly restartPolicy?: string;
    /**
    * RuntimeClassName is a feature for selecting the container runtime configuration. The container runtime configuration is used to run a Pod's containers. More info: https://kubernetes.io/docs/concepts/containers/runtime-class
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#runtime_class_name JobV1#runtime_class_name}
    */
    readonly runtimeClassName?: string;
    /**
    * ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: http://releases.k8s.io/HEAD/docs/design/service_accounts.md.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#service_account_name JobV1#service_account_name}
    */
    readonly serviceAccountName?: string;
    /**
    * Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#share_process_namespace JobV1#share_process_namespace}
    */
    readonly shareProcessNamespace?: boolean | cdktf.IResolvable;
    /**
    * If specified, the fully qualified Pod hostname will be "...svc.". If not specified, the pod will not have a domainname at all..
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#subdomain JobV1#subdomain}
    */
    readonly subdomain?: string;
    /**
    * Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#termination_grace_period_seconds JobV1#termination_grace_period_seconds}
    */
    readonly terminationGracePeriodSeconds?: number;
    /**
    * affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#affinity JobV1#affinity}
    */
    readonly affinity?: JobV1SpecTemplateSpecAffinity;
    /**
    * container block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#container JobV1#container}
    */
    readonly container?: JobV1SpecTemplateSpecContainer[] | cdktf.IResolvable;
    /**
    * dns_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#dns_config JobV1#dns_config}
    */
    readonly dnsConfig?: JobV1SpecTemplateSpecDnsConfig;
    /**
    * host_aliases block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#host_aliases JobV1#host_aliases}
    */
    readonly hostAliases?: JobV1SpecTemplateSpecHostAliases[] | cdktf.IResolvable;
    /**
    * image_pull_secrets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#image_pull_secrets JobV1#image_pull_secrets}
    */
    readonly imagePullSecrets?: JobV1SpecTemplateSpecImagePullSecrets[] | cdktf.IResolvable;
    /**
    * init_container block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#init_container JobV1#init_container}
    */
    readonly initContainer?: JobV1SpecTemplateSpecInitContainer[] | cdktf.IResolvable;
    /**
    * readiness_gate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#readiness_gate JobV1#readiness_gate}
    */
    readonly readinessGate?: JobV1SpecTemplateSpecReadinessGate[] | cdktf.IResolvable;
    /**
    * security_context block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#security_context JobV1#security_context}
    */
    readonly securityContext?: JobV1SpecTemplateSpecSecurityContext;
    /**
    * toleration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#toleration JobV1#toleration}
    */
    readonly toleration?: JobV1SpecTemplateSpecToleration[] | cdktf.IResolvable;
    /**
    * topology_spread_constraint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#topology_spread_constraint JobV1#topology_spread_constraint}
    */
    readonly topologySpreadConstraint?: JobV1SpecTemplateSpecTopologySpreadConstraint[] | cdktf.IResolvable;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#volume JobV1#volume}
    */
    readonly volume?: JobV1SpecTemplateSpecVolume[] | cdktf.IResolvable;
}
export declare function jobV1SpecTemplateSpecToTerraform(struct?: JobV1SpecTemplateSpecOutputReference | JobV1SpecTemplateSpec): any;
export declare class JobV1SpecTemplateSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplateSpec | undefined;
    set internalValue(value: JobV1SpecTemplateSpec | undefined);
    private _activeDeadlineSeconds?;
    get activeDeadlineSeconds(): number;
    set activeDeadlineSeconds(value: number);
    resetActiveDeadlineSeconds(): void;
    get activeDeadlineSecondsInput(): number | undefined;
    private _automountServiceAccountToken?;
    get automountServiceAccountToken(): boolean | cdktf.IResolvable;
    set automountServiceAccountToken(value: boolean | cdktf.IResolvable);
    resetAutomountServiceAccountToken(): void;
    get automountServiceAccountTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _dnsPolicy?;
    get dnsPolicy(): string;
    set dnsPolicy(value: string);
    resetDnsPolicy(): void;
    get dnsPolicyInput(): string | undefined;
    private _enableServiceLinks?;
    get enableServiceLinks(): boolean | cdktf.IResolvable;
    set enableServiceLinks(value: boolean | cdktf.IResolvable);
    resetEnableServiceLinks(): void;
    get enableServiceLinksInput(): boolean | cdktf.IResolvable | undefined;
    private _hostIpc?;
    get hostIpc(): boolean | cdktf.IResolvable;
    set hostIpc(value: boolean | cdktf.IResolvable);
    resetHostIpc(): void;
    get hostIpcInput(): boolean | cdktf.IResolvable | undefined;
    private _hostNetwork?;
    get hostNetwork(): boolean | cdktf.IResolvable;
    set hostNetwork(value: boolean | cdktf.IResolvable);
    resetHostNetwork(): void;
    get hostNetworkInput(): boolean | cdktf.IResolvable | undefined;
    private _hostPid?;
    get hostPid(): boolean | cdktf.IResolvable;
    set hostPid(value: boolean | cdktf.IResolvable);
    resetHostPid(): void;
    get hostPidInput(): boolean | cdktf.IResolvable | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _nodeName?;
    get nodeName(): string;
    set nodeName(value: string);
    resetNodeName(): void;
    get nodeNameInput(): string | undefined;
    private _nodeSelector?;
    get nodeSelector(): {
        [key: string]: string;
    };
    set nodeSelector(value: {
        [key: string]: string;
    });
    resetNodeSelector(): void;
    get nodeSelectorInput(): {
        [key: string]: string;
    } | undefined;
    private _priorityClassName?;
    get priorityClassName(): string;
    set priorityClassName(value: string);
    resetPriorityClassName(): void;
    get priorityClassNameInput(): string | undefined;
    private _restartPolicy?;
    get restartPolicy(): string;
    set restartPolicy(value: string);
    resetRestartPolicy(): void;
    get restartPolicyInput(): string | undefined;
    private _runtimeClassName?;
    get runtimeClassName(): string;
    set runtimeClassName(value: string);
    resetRuntimeClassName(): void;
    get runtimeClassNameInput(): string | undefined;
    private _serviceAccountName?;
    get serviceAccountName(): string;
    set serviceAccountName(value: string);
    resetServiceAccountName(): void;
    get serviceAccountNameInput(): string | undefined;
    private _shareProcessNamespace?;
    get shareProcessNamespace(): boolean | cdktf.IResolvable;
    set shareProcessNamespace(value: boolean | cdktf.IResolvable);
    resetShareProcessNamespace(): void;
    get shareProcessNamespaceInput(): boolean | cdktf.IResolvable | undefined;
    private _subdomain?;
    get subdomain(): string;
    set subdomain(value: string);
    resetSubdomain(): void;
    get subdomainInput(): string | undefined;
    private _terminationGracePeriodSeconds?;
    get terminationGracePeriodSeconds(): number;
    set terminationGracePeriodSeconds(value: number);
    resetTerminationGracePeriodSeconds(): void;
    get terminationGracePeriodSecondsInput(): number | undefined;
    private _affinity;
    get affinity(): JobV1SpecTemplateSpecAffinityOutputReference;
    putAffinity(value: JobV1SpecTemplateSpecAffinity): void;
    resetAffinity(): void;
    get affinityInput(): JobV1SpecTemplateSpecAffinity | undefined;
    private _container;
    get container(): JobV1SpecTemplateSpecContainerList;
    putContainer(value: JobV1SpecTemplateSpecContainer[] | cdktf.IResolvable): void;
    resetContainer(): void;
    get containerInput(): cdktf.IResolvable | JobV1SpecTemplateSpecContainer[] | undefined;
    private _dnsConfig;
    get dnsConfig(): JobV1SpecTemplateSpecDnsConfigOutputReference;
    putDnsConfig(value: JobV1SpecTemplateSpecDnsConfig): void;
    resetDnsConfig(): void;
    get dnsConfigInput(): JobV1SpecTemplateSpecDnsConfig | undefined;
    private _hostAliases;
    get hostAliases(): JobV1SpecTemplateSpecHostAliasesList;
    putHostAliases(value: JobV1SpecTemplateSpecHostAliases[] | cdktf.IResolvable): void;
    resetHostAliases(): void;
    get hostAliasesInput(): cdktf.IResolvable | JobV1SpecTemplateSpecHostAliases[] | undefined;
    private _imagePullSecrets;
    get imagePullSecrets(): JobV1SpecTemplateSpecImagePullSecretsList;
    putImagePullSecrets(value: JobV1SpecTemplateSpecImagePullSecrets[] | cdktf.IResolvable): void;
    resetImagePullSecrets(): void;
    get imagePullSecretsInput(): cdktf.IResolvable | JobV1SpecTemplateSpecImagePullSecrets[] | undefined;
    private _initContainer;
    get initContainer(): JobV1SpecTemplateSpecInitContainerList;
    putInitContainer(value: JobV1SpecTemplateSpecInitContainer[] | cdktf.IResolvable): void;
    resetInitContainer(): void;
    get initContainerInput(): cdktf.IResolvable | JobV1SpecTemplateSpecInitContainer[] | undefined;
    private _readinessGate;
    get readinessGate(): JobV1SpecTemplateSpecReadinessGateList;
    putReadinessGate(value: JobV1SpecTemplateSpecReadinessGate[] | cdktf.IResolvable): void;
    resetReadinessGate(): void;
    get readinessGateInput(): cdktf.IResolvable | JobV1SpecTemplateSpecReadinessGate[] | undefined;
    private _securityContext;
    get securityContext(): JobV1SpecTemplateSpecSecurityContextOutputReference;
    putSecurityContext(value: JobV1SpecTemplateSpecSecurityContext): void;
    resetSecurityContext(): void;
    get securityContextInput(): JobV1SpecTemplateSpecSecurityContext | undefined;
    private _toleration;
    get toleration(): JobV1SpecTemplateSpecTolerationList;
    putToleration(value: JobV1SpecTemplateSpecToleration[] | cdktf.IResolvable): void;
    resetToleration(): void;
    get tolerationInput(): cdktf.IResolvable | JobV1SpecTemplateSpecToleration[] | undefined;
    private _topologySpreadConstraint;
    get topologySpreadConstraint(): JobV1SpecTemplateSpecTopologySpreadConstraintList;
    putTopologySpreadConstraint(value: JobV1SpecTemplateSpecTopologySpreadConstraint[] | cdktf.IResolvable): void;
    resetTopologySpreadConstraint(): void;
    get topologySpreadConstraintInput(): cdktf.IResolvable | JobV1SpecTemplateSpecTopologySpreadConstraint[] | undefined;
    private _volume;
    get volume(): JobV1SpecTemplateSpecVolumeList;
    putVolume(value: JobV1SpecTemplateSpecVolume[] | cdktf.IResolvable): void;
    resetVolume(): void;
    get volumeInput(): cdktf.IResolvable | JobV1SpecTemplateSpecVolume[] | undefined;
}
export interface JobV1SpecTemplate {
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#metadata JobV1#metadata}
    */
    readonly metadata: JobV1SpecTemplateMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#spec JobV1#spec}
    */
    readonly spec?: JobV1SpecTemplateSpec;
}
export declare function jobV1SpecTemplateToTerraform(struct?: JobV1SpecTemplateOutputReference | JobV1SpecTemplate): any;
export declare class JobV1SpecTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1SpecTemplate | undefined;
    set internalValue(value: JobV1SpecTemplate | undefined);
    private _metadata;
    get metadata(): JobV1SpecTemplateMetadataOutputReference;
    putMetadata(value: JobV1SpecTemplateMetadata): void;
    get metadataInput(): JobV1SpecTemplateMetadata | undefined;
    private _spec;
    get spec(): JobV1SpecTemplateSpecOutputReference;
    putSpec(value: JobV1SpecTemplateSpec): void;
    resetSpec(): void;
    get specInput(): JobV1SpecTemplateSpec | undefined;
}
export interface JobV1Spec {
    /**
    * Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#active_deadline_seconds JobV1#active_deadline_seconds}
    */
    readonly activeDeadlineSeconds?: number;
    /**
    * Specifies the number of retries before marking this job failed. Defaults to 6
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#backoff_limit JobV1#backoff_limit}
    */
    readonly backoffLimit?: number;
    /**
    * Specifies how Pod completions are tracked. It can be `NonIndexed` (default) or `Indexed`. For more information: https://kubernetes.io/docs/concepts/workloads/controllers/job/#completion-mode
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#completion_mode JobV1#completion_mode}
    */
    readonly completionMode?: string;
    /**
    * Specifies the desired number of successfully finished pods the job should be run with. Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value. Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#completions JobV1#completions}
    */
    readonly completions?: number;
    /**
    * Controls generation of pod labels and pod selectors. Leave unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template. When true, the user is responsible for picking unique labels and specifying the selector. Failure to pick a unique label may cause this and other jobs to not function correctly. More info: https://git.k8s.io/community/contributors/design-proposals/selector-generation.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#manual_selector JobV1#manual_selector}
    */
    readonly manualSelector?: boolean | cdktf.IResolvable;
    /**
    * Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#parallelism JobV1#parallelism}
    */
    readonly parallelism?: number;
    /**
    * ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#ttl_seconds_after_finished JobV1#ttl_seconds_after_finished}
    */
    readonly ttlSecondsAfterFinished?: string;
    /**
    * selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#selector JobV1#selector}
    */
    readonly selector?: JobV1SpecSelector;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#template JobV1#template}
    */
    readonly template: JobV1SpecTemplate;
}
export declare function jobV1SpecToTerraform(struct?: JobV1SpecOutputReference | JobV1Spec): any;
export declare class JobV1SpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1Spec | undefined;
    set internalValue(value: JobV1Spec | undefined);
    private _activeDeadlineSeconds?;
    get activeDeadlineSeconds(): number;
    set activeDeadlineSeconds(value: number);
    resetActiveDeadlineSeconds(): void;
    get activeDeadlineSecondsInput(): number | undefined;
    private _backoffLimit?;
    get backoffLimit(): number;
    set backoffLimit(value: number);
    resetBackoffLimit(): void;
    get backoffLimitInput(): number | undefined;
    private _completionMode?;
    get completionMode(): string;
    set completionMode(value: string);
    resetCompletionMode(): void;
    get completionModeInput(): string | undefined;
    private _completions?;
    get completions(): number;
    set completions(value: number);
    resetCompletions(): void;
    get completionsInput(): number | undefined;
    private _manualSelector?;
    get manualSelector(): boolean | cdktf.IResolvable;
    set manualSelector(value: boolean | cdktf.IResolvable);
    resetManualSelector(): void;
    get manualSelectorInput(): boolean | cdktf.IResolvable | undefined;
    private _parallelism?;
    get parallelism(): number;
    set parallelism(value: number);
    resetParallelism(): void;
    get parallelismInput(): number | undefined;
    private _ttlSecondsAfterFinished?;
    get ttlSecondsAfterFinished(): string;
    set ttlSecondsAfterFinished(value: string);
    resetTtlSecondsAfterFinished(): void;
    get ttlSecondsAfterFinishedInput(): string | undefined;
    private _selector;
    get selector(): JobV1SpecSelectorOutputReference;
    putSelector(value: JobV1SpecSelector): void;
    resetSelector(): void;
    get selectorInput(): JobV1SpecSelector | undefined;
    private _template;
    get template(): JobV1SpecTemplateOutputReference;
    putTemplate(value: JobV1SpecTemplate): void;
    get templateInput(): JobV1SpecTemplate | undefined;
}
export interface JobV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#create JobV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#delete JobV1#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job_v1#update JobV1#update}
    */
    readonly update?: string;
}
export declare function jobV1TimeoutsToTerraform(struct?: JobV1TimeoutsOutputReference | JobV1Timeouts | cdktf.IResolvable): any;
export declare class JobV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: JobV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
