import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IngressV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#id IngressV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Terraform will wait for the load balancer to have at least 1 endpoint before considering the resource created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#wait_for_load_balancer IngressV1#wait_for_load_balancer}
    */
    readonly waitForLoadBalancer?: boolean | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#metadata IngressV1#metadata}
    */
    readonly metadata: IngressV1Metadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#spec IngressV1#spec}
    */
    readonly spec: IngressV1Spec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#timeouts IngressV1#timeouts}
    */
    readonly timeouts?: IngressV1Timeouts;
}
export interface IngressV1StatusLoadBalancerIngress {
}
export declare function ingressV1StatusLoadBalancerIngressToTerraform(struct?: IngressV1StatusLoadBalancerIngress): any;
export declare class IngressV1StatusLoadBalancerIngressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IngressV1StatusLoadBalancerIngress | undefined;
    set internalValue(value: IngressV1StatusLoadBalancerIngress | undefined);
    get hostname(): string;
    get ip(): string;
}
export declare class IngressV1StatusLoadBalancerIngressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IngressV1StatusLoadBalancerIngressOutputReference;
}
export interface IngressV1StatusLoadBalancer {
}
export declare function ingressV1StatusLoadBalancerToTerraform(struct?: IngressV1StatusLoadBalancer): any;
export declare class IngressV1StatusLoadBalancerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IngressV1StatusLoadBalancer | undefined;
    set internalValue(value: IngressV1StatusLoadBalancer | undefined);
    private _ingress;
    get ingress(): IngressV1StatusLoadBalancerIngressList;
}
export declare class IngressV1StatusLoadBalancerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IngressV1StatusLoadBalancerOutputReference;
}
export interface IngressV1Status {
}
export declare function ingressV1StatusToTerraform(struct?: IngressV1Status): any;
export declare class IngressV1StatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IngressV1Status | undefined;
    set internalValue(value: IngressV1Status | undefined);
    private _loadBalancer;
    get loadBalancer(): IngressV1StatusLoadBalancerList;
}
export declare class IngressV1StatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IngressV1StatusOutputReference;
}
export interface IngressV1Metadata {
    /**
    * An unstructured key value map stored with the ingress that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#annotations IngressV1#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#generate_name IngressV1#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the ingress. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#labels IngressV1#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the ingress, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#name IngressV1#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the ingress must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#namespace IngressV1#namespace}
    */
    readonly namespace?: string;
}
export declare function ingressV1MetadataToTerraform(struct?: IngressV1MetadataOutputReference | IngressV1Metadata): any;
export declare class IngressV1MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressV1Metadata | undefined;
    set internalValue(value: IngressV1Metadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface IngressV1SpecDefaultBackendResource {
    /**
    * APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#api_group IngressV1#api_group}
    */
    readonly apiGroup: string;
    /**
    * The kind of resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#kind IngressV1#kind}
    */
    readonly kind: string;
    /**
    * The name of the User to bind to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#name IngressV1#name}
    */
    readonly name: string;
}
export declare function ingressV1SpecDefaultBackendResourceToTerraform(struct?: IngressV1SpecDefaultBackendResourceOutputReference | IngressV1SpecDefaultBackendResource): any;
export declare class IngressV1SpecDefaultBackendResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressV1SpecDefaultBackendResource | undefined;
    set internalValue(value: IngressV1SpecDefaultBackendResource | undefined);
    private _apiGroup?;
    get apiGroup(): string;
    set apiGroup(value: string);
    get apiGroupInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface IngressV1SpecDefaultBackendServicePort {
    /**
    * Specifies the name of the port of the referenced service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#name IngressV1#name}
    */
    readonly name?: string;
    /**
    * Specifies the numerical port of the referenced service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#number IngressV1#number}
    */
    readonly number?: number;
}
export declare function ingressV1SpecDefaultBackendServicePortToTerraform(struct?: IngressV1SpecDefaultBackendServicePortOutputReference | IngressV1SpecDefaultBackendServicePort): any;
export declare class IngressV1SpecDefaultBackendServicePortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressV1SpecDefaultBackendServicePort | undefined;
    set internalValue(value: IngressV1SpecDefaultBackendServicePort | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _number?;
    get number(): number;
    set number(value: number);
    resetNumber(): void;
    get numberInput(): number | undefined;
}
export interface IngressV1SpecDefaultBackendService {
    /**
    * Specifies the name of the referenced service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#name IngressV1#name}
    */
    readonly name: string;
    /**
    * port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#port IngressV1#port}
    */
    readonly port: IngressV1SpecDefaultBackendServicePort;
}
export declare function ingressV1SpecDefaultBackendServiceToTerraform(struct?: IngressV1SpecDefaultBackendServiceOutputReference | IngressV1SpecDefaultBackendService): any;
export declare class IngressV1SpecDefaultBackendServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressV1SpecDefaultBackendService | undefined;
    set internalValue(value: IngressV1SpecDefaultBackendService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port;
    get port(): IngressV1SpecDefaultBackendServicePortOutputReference;
    putPort(value: IngressV1SpecDefaultBackendServicePort): void;
    get portInput(): IngressV1SpecDefaultBackendServicePort | undefined;
}
export interface IngressV1SpecDefaultBackend {
    /**
    * resource block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#resource IngressV1#resource}
    */
    readonly resource?: IngressV1SpecDefaultBackendResource;
    /**
    * service block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#service IngressV1#service}
    */
    readonly service?: IngressV1SpecDefaultBackendService;
}
export declare function ingressV1SpecDefaultBackendToTerraform(struct?: IngressV1SpecDefaultBackendOutputReference | IngressV1SpecDefaultBackend): any;
export declare class IngressV1SpecDefaultBackendOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressV1SpecDefaultBackend | undefined;
    set internalValue(value: IngressV1SpecDefaultBackend | undefined);
    private _resource;
    get resource(): IngressV1SpecDefaultBackendResourceOutputReference;
    putResource(value: IngressV1SpecDefaultBackendResource): void;
    resetResource(): void;
    get resourceInput(): IngressV1SpecDefaultBackendResource | undefined;
    private _service;
    get service(): IngressV1SpecDefaultBackendServiceOutputReference;
    putService(value: IngressV1SpecDefaultBackendService): void;
    resetService(): void;
    get serviceInput(): IngressV1SpecDefaultBackendService | undefined;
}
export interface IngressV1SpecRuleHttpPathBackendResource {
    /**
    * APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#api_group IngressV1#api_group}
    */
    readonly apiGroup: string;
    /**
    * The kind of resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#kind IngressV1#kind}
    */
    readonly kind: string;
    /**
    * The name of the User to bind to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#name IngressV1#name}
    */
    readonly name: string;
}
export declare function ingressV1SpecRuleHttpPathBackendResourceToTerraform(struct?: IngressV1SpecRuleHttpPathBackendResourceOutputReference | IngressV1SpecRuleHttpPathBackendResource): any;
export declare class IngressV1SpecRuleHttpPathBackendResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressV1SpecRuleHttpPathBackendResource | undefined;
    set internalValue(value: IngressV1SpecRuleHttpPathBackendResource | undefined);
    private _apiGroup?;
    get apiGroup(): string;
    set apiGroup(value: string);
    get apiGroupInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface IngressV1SpecRuleHttpPathBackendServicePort {
    /**
    * Specifies the name of the port of the referenced service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#name IngressV1#name}
    */
    readonly name?: string;
    /**
    * Specifies the numerical port of the referenced service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#number IngressV1#number}
    */
    readonly number?: number;
}
export declare function ingressV1SpecRuleHttpPathBackendServicePortToTerraform(struct?: IngressV1SpecRuleHttpPathBackendServicePortOutputReference | IngressV1SpecRuleHttpPathBackendServicePort): any;
export declare class IngressV1SpecRuleHttpPathBackendServicePortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressV1SpecRuleHttpPathBackendServicePort | undefined;
    set internalValue(value: IngressV1SpecRuleHttpPathBackendServicePort | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _number?;
    get number(): number;
    set number(value: number);
    resetNumber(): void;
    get numberInput(): number | undefined;
}
export interface IngressV1SpecRuleHttpPathBackendService {
    /**
    * Specifies the name of the referenced service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#name IngressV1#name}
    */
    readonly name: string;
    /**
    * port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#port IngressV1#port}
    */
    readonly port: IngressV1SpecRuleHttpPathBackendServicePort;
}
export declare function ingressV1SpecRuleHttpPathBackendServiceToTerraform(struct?: IngressV1SpecRuleHttpPathBackendServiceOutputReference | IngressV1SpecRuleHttpPathBackendService): any;
export declare class IngressV1SpecRuleHttpPathBackendServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressV1SpecRuleHttpPathBackendService | undefined;
    set internalValue(value: IngressV1SpecRuleHttpPathBackendService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port;
    get port(): IngressV1SpecRuleHttpPathBackendServicePortOutputReference;
    putPort(value: IngressV1SpecRuleHttpPathBackendServicePort): void;
    get portInput(): IngressV1SpecRuleHttpPathBackendServicePort | undefined;
}
export interface IngressV1SpecRuleHttpPathBackend {
    /**
    * resource block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#resource IngressV1#resource}
    */
    readonly resource?: IngressV1SpecRuleHttpPathBackendResource;
    /**
    * service block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#service IngressV1#service}
    */
    readonly service?: IngressV1SpecRuleHttpPathBackendService;
}
export declare function ingressV1SpecRuleHttpPathBackendToTerraform(struct?: IngressV1SpecRuleHttpPathBackendOutputReference | IngressV1SpecRuleHttpPathBackend): any;
export declare class IngressV1SpecRuleHttpPathBackendOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressV1SpecRuleHttpPathBackend | undefined;
    set internalValue(value: IngressV1SpecRuleHttpPathBackend | undefined);
    private _resource;
    get resource(): IngressV1SpecRuleHttpPathBackendResourceOutputReference;
    putResource(value: IngressV1SpecRuleHttpPathBackendResource): void;
    resetResource(): void;
    get resourceInput(): IngressV1SpecRuleHttpPathBackendResource | undefined;
    private _service;
    get service(): IngressV1SpecRuleHttpPathBackendServiceOutputReference;
    putService(value: IngressV1SpecRuleHttpPathBackendService): void;
    resetService(): void;
    get serviceInput(): IngressV1SpecRuleHttpPathBackendService | undefined;
}
export interface IngressV1SpecRuleHttpPath {
    /**
    * Path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#path IngressV1#path}
    */
    readonly path?: string;
    /**
    * PathType determines the interpretation of the Path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
    done on a path element by element basis. A path element refers is the
    list of labels in the path split by the '/' separator. A request is a
    match for path p if every p is an element-wise prefix of p of the
    request path. Note that if the last element of the path is a substring
    of the last element in request path, it is not a match (e.g. /foo/bar
    matches /foo/bar/baz, but does not match /foo/barbaz).
  * ImplementationSpecific: Interpretation of the Path matching is up to
    the IngressClass. Implementations can treat this as a separate PathType
    or treat it identically to Prefix or Exact path types.
  Implementations are required to support all path types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#path_type IngressV1#path_type}
    */
    readonly pathType?: string;
    /**
    * backend block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#backend IngressV1#backend}
    */
    readonly backend?: IngressV1SpecRuleHttpPathBackend;
}
export declare function ingressV1SpecRuleHttpPathToTerraform(struct?: IngressV1SpecRuleHttpPath | cdktf.IResolvable): any;
export declare class IngressV1SpecRuleHttpPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IngressV1SpecRuleHttpPath | cdktf.IResolvable | undefined;
    set internalValue(value: IngressV1SpecRuleHttpPath | cdktf.IResolvable | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _pathType?;
    get pathType(): string;
    set pathType(value: string);
    resetPathType(): void;
    get pathTypeInput(): string | undefined;
    private _backend;
    get backend(): IngressV1SpecRuleHttpPathBackendOutputReference;
    putBackend(value: IngressV1SpecRuleHttpPathBackend): void;
    resetBackend(): void;
    get backendInput(): IngressV1SpecRuleHttpPathBackend | undefined;
}
export declare class IngressV1SpecRuleHttpPathList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IngressV1SpecRuleHttpPath[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IngressV1SpecRuleHttpPathOutputReference;
}
export interface IngressV1SpecRuleHttp {
    /**
    * path block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#path IngressV1#path}
    */
    readonly path: IngressV1SpecRuleHttpPath[] | cdktf.IResolvable;
}
export declare function ingressV1SpecRuleHttpToTerraform(struct?: IngressV1SpecRuleHttpOutputReference | IngressV1SpecRuleHttp): any;
export declare class IngressV1SpecRuleHttpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressV1SpecRuleHttp | undefined;
    set internalValue(value: IngressV1SpecRuleHttp | undefined);
    private _path;
    get path(): IngressV1SpecRuleHttpPathList;
    putPath(value: IngressV1SpecRuleHttpPath[] | cdktf.IResolvable): void;
    get pathInput(): cdktf.IResolvable | IngressV1SpecRuleHttpPath[] | undefined;
}
export interface IngressV1SpecRule {
    /**
    * Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
     the IP in the Spec of the parent Ingress.
  2. The `:` delimiter is not respected because ports are not allowed.
        Currently the port of an Ingress is implicitly :80 for http and
        :443 for https.
  Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
  
  Host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If Host is precise, the request matches this rule if the http host header is equal to Host. 2. If Host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#host IngressV1#host}
    */
    readonly host?: string;
    /**
    * http block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#http IngressV1#http}
    */
    readonly http?: IngressV1SpecRuleHttp;
}
export declare function ingressV1SpecRuleToTerraform(struct?: IngressV1SpecRule | cdktf.IResolvable): any;
export declare class IngressV1SpecRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IngressV1SpecRule | cdktf.IResolvable | undefined;
    set internalValue(value: IngressV1SpecRule | cdktf.IResolvable | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _http;
    get http(): IngressV1SpecRuleHttpOutputReference;
    putHttp(value: IngressV1SpecRuleHttp): void;
    resetHttp(): void;
    get httpInput(): IngressV1SpecRuleHttp | undefined;
}
export declare class IngressV1SpecRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IngressV1SpecRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IngressV1SpecRuleOutputReference;
}
export interface IngressV1SpecTls {
    /**
    * Hosts are a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#hosts IngressV1#hosts}
    */
    readonly hosts?: string[];
    /**
    * SecretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#secret_name IngressV1#secret_name}
    */
    readonly secretName?: string;
}
export declare function ingressV1SpecTlsToTerraform(struct?: IngressV1SpecTls | cdktf.IResolvable): any;
export declare class IngressV1SpecTlsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IngressV1SpecTls | cdktf.IResolvable | undefined;
    set internalValue(value: IngressV1SpecTls | cdktf.IResolvable | undefined);
    private _hosts?;
    get hosts(): string[];
    set hosts(value: string[]);
    resetHosts(): void;
    get hostsInput(): string[] | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    resetSecretName(): void;
    get secretNameInput(): string | undefined;
}
export declare class IngressV1SpecTlsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IngressV1SpecTls[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IngressV1SpecTlsOutputReference;
}
export interface IngressV1Spec {
    /**
    * IngressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -> IngressClass -> Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#ingress_class_name IngressV1#ingress_class_name}
    */
    readonly ingressClassName?: string;
    /**
    * default_backend block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#default_backend IngressV1#default_backend}
    */
    readonly defaultBackend?: IngressV1SpecDefaultBackend;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#rule IngressV1#rule}
    */
    readonly rule?: IngressV1SpecRule[] | cdktf.IResolvable;
    /**
    * tls block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#tls IngressV1#tls}
    */
    readonly tls?: IngressV1SpecTls[] | cdktf.IResolvable;
}
export declare function ingressV1SpecToTerraform(struct?: IngressV1SpecOutputReference | IngressV1Spec): any;
export declare class IngressV1SpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressV1Spec | undefined;
    set internalValue(value: IngressV1Spec | undefined);
    private _ingressClassName?;
    get ingressClassName(): string;
    set ingressClassName(value: string);
    resetIngressClassName(): void;
    get ingressClassNameInput(): string | undefined;
    private _defaultBackend;
    get defaultBackend(): IngressV1SpecDefaultBackendOutputReference;
    putDefaultBackend(value: IngressV1SpecDefaultBackend): void;
    resetDefaultBackend(): void;
    get defaultBackendInput(): IngressV1SpecDefaultBackend | undefined;
    private _rule;
    get rule(): IngressV1SpecRuleList;
    putRule(value: IngressV1SpecRule[] | cdktf.IResolvable): void;
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | IngressV1SpecRule[] | undefined;
    private _tls;
    get tls(): IngressV1SpecTlsList;
    putTls(value: IngressV1SpecTls[] | cdktf.IResolvable): void;
    resetTls(): void;
    get tlsInput(): cdktf.IResolvable | IngressV1SpecTls[] | undefined;
}
export interface IngressV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#create IngressV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1#delete IngressV1#delete}
    */
    readonly delete?: string;
}
export declare function ingressV1TimeoutsToTerraform(struct?: IngressV1TimeoutsOutputReference | IngressV1Timeouts | cdktf.IResolvable): any;
export declare class IngressV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IngressV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1 kubernetes_ingress_v1}
*/
export declare class IngressV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_ingress_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress_v1 kubernetes_ingress_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IngressV1Config
    */
    constructor(scope: Construct, id: string, config: IngressV1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _status;
    get status(): IngressV1StatusList;
    private _waitForLoadBalancer?;
    get waitForLoadBalancer(): boolean | cdktf.IResolvable;
    set waitForLoadBalancer(value: boolean | cdktf.IResolvable);
    resetWaitForLoadBalancer(): void;
    get waitForLoadBalancerInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata;
    get metadata(): IngressV1MetadataOutputReference;
    putMetadata(value: IngressV1Metadata): void;
    get metadataInput(): IngressV1Metadata | undefined;
    private _spec;
    get spec(): IngressV1SpecOutputReference;
    putSpec(value: IngressV1Spec): void;
    get specInput(): IngressV1Spec | undefined;
    private _timeouts;
    get timeouts(): IngressV1TimeoutsOutputReference;
    putTimeouts(value: IngressV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IngressV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
