import { DeploymentV1Metadata, DeploymentV1MetadataOutputReference, DeploymentV1Spec, DeploymentV1SpecOutputReference, DeploymentV1Timeouts, DeploymentV1TimeoutsOutputReference } from './index-structs';
export * from './index-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DeploymentV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/deployment_v1#id DeploymentV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Wait for the rollout of the deployment to complete. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/deployment_v1#wait_for_rollout DeploymentV1#wait_for_rollout}
    */
    readonly waitForRollout?: boolean | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/deployment_v1#metadata DeploymentV1#metadata}
    */
    readonly metadata: DeploymentV1Metadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/deployment_v1#spec DeploymentV1#spec}
    */
    readonly spec: DeploymentV1Spec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/deployment_v1#timeouts DeploymentV1#timeouts}
    */
    readonly timeouts?: DeploymentV1Timeouts;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/deployment_v1 kubernetes_deployment_v1}
*/
export declare class DeploymentV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_deployment_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/deployment_v1 kubernetes_deployment_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DeploymentV1Config
    */
    constructor(scope: Construct, id: string, config: DeploymentV1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _waitForRollout?;
    get waitForRollout(): boolean | cdktf.IResolvable;
    set waitForRollout(value: boolean | cdktf.IResolvable);
    resetWaitForRollout(): void;
    get waitForRolloutInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata;
    get metadata(): DeploymentV1MetadataOutputReference;
    putMetadata(value: DeploymentV1Metadata): void;
    get metadataInput(): DeploymentV1Metadata | undefined;
    private _spec;
    get spec(): DeploymentV1SpecOutputReference;
    putSpec(value: DeploymentV1Spec): void;
    get specInput(): DeploymentV1Spec | undefined;
    private _timeouts;
    get timeouts(): DeploymentV1TimeoutsOutputReference;
    putTimeouts(value: DeploymentV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DeploymentV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
