import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubernetesStorageClassV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Indicates whether the storage class allow volume expand
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1#allow_volume_expansion DataKubernetesStorageClassV1#allow_volume_expansion}
    */
    readonly allowVolumeExpansion?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1#id DataKubernetesStorageClassV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Persistent Volumes that are dynamically created by a storage class will have the mount options specified
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1#mount_options DataKubernetesStorageClassV1#mount_options}
    */
    readonly mountOptions?: string[];
    /**
    * The parameters for the provisioner that should create volumes of this storage class
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1#parameters DataKubernetesStorageClassV1#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Indicates the type of the reclaim policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1#reclaim_policy DataKubernetesStorageClassV1#reclaim_policy}
    */
    readonly reclaimPolicy?: string;
    /**
    * Indicates when volume binding and dynamic provisioning should occur
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1#volume_binding_mode DataKubernetesStorageClassV1#volume_binding_mode}
    */
    readonly volumeBindingMode?: string;
    /**
    * allowed_topologies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1#allowed_topologies DataKubernetesStorageClassV1#allowed_topologies}
    */
    readonly allowedTopologies?: DataKubernetesStorageClassV1AllowedTopologies;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1#metadata DataKubernetesStorageClassV1#metadata}
    */
    readonly metadata: DataKubernetesStorageClassV1Metadata;
}
export interface DataKubernetesStorageClassV1AllowedTopologiesMatchLabelExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1#key DataKubernetesStorageClassV1#key}
    */
    readonly key?: string;
    /**
    * An array of string values. One value must match the label to be selected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1#values DataKubernetesStorageClassV1#values}
    */
    readonly values?: string[];
}
export declare function dataKubernetesStorageClassV1AllowedTopologiesMatchLabelExpressionsToTerraform(struct?: DataKubernetesStorageClassV1AllowedTopologiesMatchLabelExpressions | cdktf.IResolvable): any;
export declare class DataKubernetesStorageClassV1AllowedTopologiesMatchLabelExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesStorageClassV1AllowedTopologiesMatchLabelExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: DataKubernetesStorageClassV1AllowedTopologiesMatchLabelExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class DataKubernetesStorageClassV1AllowedTopologiesMatchLabelExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataKubernetesStorageClassV1AllowedTopologiesMatchLabelExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesStorageClassV1AllowedTopologiesMatchLabelExpressionsOutputReference;
}
export interface DataKubernetesStorageClassV1AllowedTopologies {
    /**
    * match_label_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1#match_label_expressions DataKubernetesStorageClassV1#match_label_expressions}
    */
    readonly matchLabelExpressions?: DataKubernetesStorageClassV1AllowedTopologiesMatchLabelExpressions[] | cdktf.IResolvable;
}
export declare function dataKubernetesStorageClassV1AllowedTopologiesToTerraform(struct?: DataKubernetesStorageClassV1AllowedTopologiesOutputReference | DataKubernetesStorageClassV1AllowedTopologies): any;
export declare class DataKubernetesStorageClassV1AllowedTopologiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataKubernetesStorageClassV1AllowedTopologies | undefined;
    set internalValue(value: DataKubernetesStorageClassV1AllowedTopologies | undefined);
    private _matchLabelExpressions;
    get matchLabelExpressions(): DataKubernetesStorageClassV1AllowedTopologiesMatchLabelExpressionsList;
    putMatchLabelExpressions(value: DataKubernetesStorageClassV1AllowedTopologiesMatchLabelExpressions[] | cdktf.IResolvable): void;
    resetMatchLabelExpressions(): void;
    get matchLabelExpressionsInput(): cdktf.IResolvable | DataKubernetesStorageClassV1AllowedTopologiesMatchLabelExpressions[] | undefined;
}
export interface DataKubernetesStorageClassV1Metadata {
    /**
    * An unstructured key value map stored with the storage class that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1#annotations DataKubernetesStorageClassV1#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the storage class. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1#labels DataKubernetesStorageClassV1#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the storage class, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1#name DataKubernetesStorageClassV1#name}
    */
    readonly name?: string;
}
export declare function dataKubernetesStorageClassV1MetadataToTerraform(struct?: DataKubernetesStorageClassV1MetadataOutputReference | DataKubernetesStorageClassV1Metadata): any;
export declare class DataKubernetesStorageClassV1MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataKubernetesStorageClassV1Metadata | undefined;
    set internalValue(value: DataKubernetesStorageClassV1Metadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1 kubernetes_storage_class_v1}
*/
export declare class DataKubernetesStorageClassV1 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubernetes_storage_class_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/d/storage_class_v1 kubernetes_storage_class_v1} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubernetesStorageClassV1Config
    */
    constructor(scope: Construct, id: string, config: DataKubernetesStorageClassV1Config);
    private _allowVolumeExpansion?;
    get allowVolumeExpansion(): boolean | cdktf.IResolvable;
    set allowVolumeExpansion(value: boolean | cdktf.IResolvable);
    resetAllowVolumeExpansion(): void;
    get allowVolumeExpansionInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mountOptions?;
    get mountOptions(): string[];
    set mountOptions(value: string[]);
    resetMountOptions(): void;
    get mountOptionsInput(): string[] | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _reclaimPolicy?;
    get reclaimPolicy(): string;
    set reclaimPolicy(value: string);
    resetReclaimPolicy(): void;
    get reclaimPolicyInput(): string | undefined;
    get storageProvisioner(): string;
    private _volumeBindingMode?;
    get volumeBindingMode(): string;
    set volumeBindingMode(value: string);
    resetVolumeBindingMode(): void;
    get volumeBindingModeInput(): string | undefined;
    private _allowedTopologies;
    get allowedTopologies(): DataKubernetesStorageClassV1AllowedTopologiesOutputReference;
    putAllowedTopologies(value: DataKubernetesStorageClassV1AllowedTopologies): void;
    resetAllowedTopologies(): void;
    get allowedTopologiesInput(): DataKubernetesStorageClassV1AllowedTopologies | undefined;
    private _metadata;
    get metadata(): DataKubernetesStorageClassV1MetadataOutputReference;
    putMetadata(value: DataKubernetesStorageClassV1Metadata): void;
    get metadataInput(): DataKubernetesStorageClassV1Metadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
