import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubernetesResourcesConfig extends cdktf.TerraformMetaArguments {
    /**
    * The resource apiVersion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/resources#api_version DataKubernetesResources#api_version}
    */
    readonly apiVersion: string;
    /**
    * A selector to restrict the list of returned objects by their fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/resources#field_selector DataKubernetesResources#field_selector}
    */
    readonly fieldSelector?: string;
    /**
    * The resource kind.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/resources#kind DataKubernetesResources#kind}
    */
    readonly kind: string;
    /**
    * A selector to restrict the list of returned objects by their labels.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/resources#label_selector DataKubernetesResources#label_selector}
    */
    readonly labelSelector?: string;
    /**
    * Limit is a maximum number of responses to return for a list call.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/resources#limit DataKubernetesResources#limit}
    */
    readonly limit?: number;
    /**
    * The resource namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/resources#namespace DataKubernetesResources#namespace}
    */
    readonly namespace?: string;
    /**
    * The response from the API server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/resources#objects DataKubernetesResources#objects}
    */
    readonly objects?: {
        [key: string]: any;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/d/resources kubernetes_resources}
*/
export declare class DataKubernetesResources extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubernetes_resources";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/d/resources kubernetes_resources} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubernetesResourcesConfig
    */
    constructor(scope: Construct, id: string, config: DataKubernetesResourcesConfig);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    get apiVersionInput(): string | undefined;
    private _fieldSelector?;
    get fieldSelector(): string;
    set fieldSelector(value: string);
    resetFieldSelector(): void;
    get fieldSelectorInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _labelSelector?;
    get labelSelector(): string;
    set labelSelector(value: string);
    resetLabelSelector(): void;
    get labelSelectorInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _objects?;
    get objects(): {
        [key: string]: any;
    };
    set objects(value: {
        [key: string]: any;
    });
    resetObjects(): void;
    get objectsInput(): {
        [key: string]: any;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
