import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubernetesNodesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/nodes#id DataKubernetesNodes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/nodes#metadata DataKubernetesNodes#metadata}
    */
    readonly metadata?: DataKubernetesNodesMetadata;
}
export interface DataKubernetesNodesNodesMetadata {
}
export declare function dataKubernetesNodesNodesMetadataToTerraform(struct?: DataKubernetesNodesNodesMetadata): any;
export declare class DataKubernetesNodesNodesMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesNodesNodesMetadata | undefined;
    set internalValue(value: DataKubernetesNodesNodesMetadata | undefined);
    private _annotations;
    get annotations(): cdktf.StringMap;
    get generation(): number;
    private _labels;
    get labels(): cdktf.StringMap;
    get name(): string;
    get resourceVersion(): string;
    get uid(): string;
}
export declare class DataKubernetesNodesNodesMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesNodesNodesMetadataOutputReference;
}
export interface DataKubernetesNodesNodesSpecTaints {
}
export declare function dataKubernetesNodesNodesSpecTaintsToTerraform(struct?: DataKubernetesNodesNodesSpecTaints): any;
export declare class DataKubernetesNodesNodesSpecTaintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesNodesNodesSpecTaints | undefined;
    set internalValue(value: DataKubernetesNodesNodesSpecTaints | undefined);
    get effect(): string;
    get key(): string;
    get value(): string;
}
export declare class DataKubernetesNodesNodesSpecTaintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesNodesNodesSpecTaintsOutputReference;
}
export interface DataKubernetesNodesNodesSpec {
}
export declare function dataKubernetesNodesNodesSpecToTerraform(struct?: DataKubernetesNodesNodesSpec): any;
export declare class DataKubernetesNodesNodesSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesNodesNodesSpec | undefined;
    set internalValue(value: DataKubernetesNodesNodesSpec | undefined);
    get podCidr(): string;
    get podCidrs(): string[];
    get providerId(): string;
    private _taints;
    get taints(): DataKubernetesNodesNodesSpecTaintsList;
    get unschedulable(): cdktf.IResolvable;
}
export declare class DataKubernetesNodesNodesSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesNodesNodesSpecOutputReference;
}
export interface DataKubernetesNodesNodesStatusNodeInfo {
}
export declare function dataKubernetesNodesNodesStatusNodeInfoToTerraform(struct?: DataKubernetesNodesNodesStatusNodeInfo): any;
export declare class DataKubernetesNodesNodesStatusNodeInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesNodesNodesStatusNodeInfo | undefined;
    set internalValue(value: DataKubernetesNodesNodesStatusNodeInfo | undefined);
    get architecture(): string;
    get bootId(): string;
    get containerRuntimeVersion(): string;
    get kernelVersion(): string;
    get kubeProxyVersion(): string;
    get kubeletVersion(): string;
    get machineId(): string;
    get operatingSystem(): string;
    get osImage(): string;
    get systemUuid(): string;
}
export declare class DataKubernetesNodesNodesStatusNodeInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesNodesNodesStatusNodeInfoOutputReference;
}
export interface DataKubernetesNodesNodesStatus {
}
export declare function dataKubernetesNodesNodesStatusToTerraform(struct?: DataKubernetesNodesNodesStatus): any;
export declare class DataKubernetesNodesNodesStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesNodesNodesStatus | undefined;
    set internalValue(value: DataKubernetesNodesNodesStatus | undefined);
    private _allocatable;
    get allocatable(): cdktf.StringMap;
    private _capacity;
    get capacity(): cdktf.StringMap;
    private _nodeInfo;
    get nodeInfo(): DataKubernetesNodesNodesStatusNodeInfoList;
}
export declare class DataKubernetesNodesNodesStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesNodesNodesStatusOutputReference;
}
export interface DataKubernetesNodesNodes {
}
export declare function dataKubernetesNodesNodesToTerraform(struct?: DataKubernetesNodesNodes): any;
export declare class DataKubernetesNodesNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesNodesNodes | undefined;
    set internalValue(value: DataKubernetesNodesNodes | undefined);
    private _metadata;
    get metadata(): DataKubernetesNodesNodesMetadataList;
    private _spec;
    get spec(): DataKubernetesNodesNodesSpecList;
    private _status;
    get status(): DataKubernetesNodesNodesStatusList;
}
export declare class DataKubernetesNodesNodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesNodesNodesOutputReference;
}
export interface DataKubernetesNodesMetadata {
    /**
    * Select nodes with these labels. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/nodes#labels DataKubernetesNodes#labels}
    */
    readonly labels: {
        [key: string]: string;
    };
}
export declare function dataKubernetesNodesMetadataToTerraform(struct?: DataKubernetesNodesMetadataOutputReference | DataKubernetesNodesMetadata): any;
export declare class DataKubernetesNodesMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataKubernetesNodesMetadata | undefined;
    set internalValue(value: DataKubernetesNodesMetadata | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/d/nodes kubernetes_nodes}
*/
export declare class DataKubernetesNodes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubernetes_nodes";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/d/nodes kubernetes_nodes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubernetesNodesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataKubernetesNodesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _nodes;
    get nodes(): DataKubernetesNodesNodesList;
    private _metadata;
    get metadata(): DataKubernetesNodesMetadataOutputReference;
    putMetadata(value: DataKubernetesNodesMetadata): void;
    resetMetadata(): void;
    get metadataInput(): DataKubernetesNodesMetadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
