import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubernetesIngressV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress_v1#id DataKubernetesIngressV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress_v1#metadata DataKubernetesIngressV1#metadata}
    */
    readonly metadata: DataKubernetesIngressV1Metadata;
}
export interface DataKubernetesIngressV1SpecDefaultBackendResource {
}
export declare function dataKubernetesIngressV1SpecDefaultBackendResourceToTerraform(struct?: DataKubernetesIngressV1SpecDefaultBackendResource): any;
export declare class DataKubernetesIngressV1SpecDefaultBackendResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1SpecDefaultBackendResource | undefined;
    set internalValue(value: DataKubernetesIngressV1SpecDefaultBackendResource | undefined);
    get apiGroup(): string;
    get kind(): string;
    get name(): string;
}
export declare class DataKubernetesIngressV1SpecDefaultBackendResourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1SpecDefaultBackendResourceOutputReference;
}
export interface DataKubernetesIngressV1SpecDefaultBackendServicePort {
}
export declare function dataKubernetesIngressV1SpecDefaultBackendServicePortToTerraform(struct?: DataKubernetesIngressV1SpecDefaultBackendServicePort): any;
export declare class DataKubernetesIngressV1SpecDefaultBackendServicePortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1SpecDefaultBackendServicePort | undefined;
    set internalValue(value: DataKubernetesIngressV1SpecDefaultBackendServicePort | undefined);
    get name(): string;
    get number(): number;
}
export declare class DataKubernetesIngressV1SpecDefaultBackendServicePortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1SpecDefaultBackendServicePortOutputReference;
}
export interface DataKubernetesIngressV1SpecDefaultBackendService {
}
export declare function dataKubernetesIngressV1SpecDefaultBackendServiceToTerraform(struct?: DataKubernetesIngressV1SpecDefaultBackendService): any;
export declare class DataKubernetesIngressV1SpecDefaultBackendServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1SpecDefaultBackendService | undefined;
    set internalValue(value: DataKubernetesIngressV1SpecDefaultBackendService | undefined);
    get name(): string;
    private _port;
    get port(): DataKubernetesIngressV1SpecDefaultBackendServicePortList;
}
export declare class DataKubernetesIngressV1SpecDefaultBackendServiceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1SpecDefaultBackendServiceOutputReference;
}
export interface DataKubernetesIngressV1SpecDefaultBackend {
}
export declare function dataKubernetesIngressV1SpecDefaultBackendToTerraform(struct?: DataKubernetesIngressV1SpecDefaultBackend): any;
export declare class DataKubernetesIngressV1SpecDefaultBackendOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1SpecDefaultBackend | undefined;
    set internalValue(value: DataKubernetesIngressV1SpecDefaultBackend | undefined);
    private _resource;
    get resource(): DataKubernetesIngressV1SpecDefaultBackendResourceList;
    private _service;
    get service(): DataKubernetesIngressV1SpecDefaultBackendServiceList;
}
export declare class DataKubernetesIngressV1SpecDefaultBackendList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1SpecDefaultBackendOutputReference;
}
export interface DataKubernetesIngressV1SpecRuleHttpPathBackendResource {
}
export declare function dataKubernetesIngressV1SpecRuleHttpPathBackendResourceToTerraform(struct?: DataKubernetesIngressV1SpecRuleHttpPathBackendResource): any;
export declare class DataKubernetesIngressV1SpecRuleHttpPathBackendResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1SpecRuleHttpPathBackendResource | undefined;
    set internalValue(value: DataKubernetesIngressV1SpecRuleHttpPathBackendResource | undefined);
    get apiGroup(): string;
    get kind(): string;
    get name(): string;
}
export declare class DataKubernetesIngressV1SpecRuleHttpPathBackendResourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1SpecRuleHttpPathBackendResourceOutputReference;
}
export interface DataKubernetesIngressV1SpecRuleHttpPathBackendServicePort {
}
export declare function dataKubernetesIngressV1SpecRuleHttpPathBackendServicePortToTerraform(struct?: DataKubernetesIngressV1SpecRuleHttpPathBackendServicePort): any;
export declare class DataKubernetesIngressV1SpecRuleHttpPathBackendServicePortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1SpecRuleHttpPathBackendServicePort | undefined;
    set internalValue(value: DataKubernetesIngressV1SpecRuleHttpPathBackendServicePort | undefined);
    get name(): string;
    get number(): number;
}
export declare class DataKubernetesIngressV1SpecRuleHttpPathBackendServicePortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1SpecRuleHttpPathBackendServicePortOutputReference;
}
export interface DataKubernetesIngressV1SpecRuleHttpPathBackendService {
}
export declare function dataKubernetesIngressV1SpecRuleHttpPathBackendServiceToTerraform(struct?: DataKubernetesIngressV1SpecRuleHttpPathBackendService): any;
export declare class DataKubernetesIngressV1SpecRuleHttpPathBackendServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1SpecRuleHttpPathBackendService | undefined;
    set internalValue(value: DataKubernetesIngressV1SpecRuleHttpPathBackendService | undefined);
    get name(): string;
    private _port;
    get port(): DataKubernetesIngressV1SpecRuleHttpPathBackendServicePortList;
}
export declare class DataKubernetesIngressV1SpecRuleHttpPathBackendServiceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1SpecRuleHttpPathBackendServiceOutputReference;
}
export interface DataKubernetesIngressV1SpecRuleHttpPathBackend {
}
export declare function dataKubernetesIngressV1SpecRuleHttpPathBackendToTerraform(struct?: DataKubernetesIngressV1SpecRuleHttpPathBackend): any;
export declare class DataKubernetesIngressV1SpecRuleHttpPathBackendOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1SpecRuleHttpPathBackend | undefined;
    set internalValue(value: DataKubernetesIngressV1SpecRuleHttpPathBackend | undefined);
    private _resource;
    get resource(): DataKubernetesIngressV1SpecRuleHttpPathBackendResourceList;
    private _service;
    get service(): DataKubernetesIngressV1SpecRuleHttpPathBackendServiceList;
}
export declare class DataKubernetesIngressV1SpecRuleHttpPathBackendList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1SpecRuleHttpPathBackendOutputReference;
}
export interface DataKubernetesIngressV1SpecRuleHttpPath {
}
export declare function dataKubernetesIngressV1SpecRuleHttpPathToTerraform(struct?: DataKubernetesIngressV1SpecRuleHttpPath): any;
export declare class DataKubernetesIngressV1SpecRuleHttpPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1SpecRuleHttpPath | undefined;
    set internalValue(value: DataKubernetesIngressV1SpecRuleHttpPath | undefined);
    private _backend;
    get backend(): DataKubernetesIngressV1SpecRuleHttpPathBackendList;
    get path(): string;
    get pathType(): string;
}
export declare class DataKubernetesIngressV1SpecRuleHttpPathList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1SpecRuleHttpPathOutputReference;
}
export interface DataKubernetesIngressV1SpecRuleHttp {
}
export declare function dataKubernetesIngressV1SpecRuleHttpToTerraform(struct?: DataKubernetesIngressV1SpecRuleHttp): any;
export declare class DataKubernetesIngressV1SpecRuleHttpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1SpecRuleHttp | undefined;
    set internalValue(value: DataKubernetesIngressV1SpecRuleHttp | undefined);
    private _path;
    get path(): DataKubernetesIngressV1SpecRuleHttpPathList;
}
export declare class DataKubernetesIngressV1SpecRuleHttpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1SpecRuleHttpOutputReference;
}
export interface DataKubernetesIngressV1SpecRule {
}
export declare function dataKubernetesIngressV1SpecRuleToTerraform(struct?: DataKubernetesIngressV1SpecRule): any;
export declare class DataKubernetesIngressV1SpecRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1SpecRule | undefined;
    set internalValue(value: DataKubernetesIngressV1SpecRule | undefined);
    get host(): string;
    private _http;
    get http(): DataKubernetesIngressV1SpecRuleHttpList;
}
export declare class DataKubernetesIngressV1SpecRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1SpecRuleOutputReference;
}
export interface DataKubernetesIngressV1SpecTls {
}
export declare function dataKubernetesIngressV1SpecTlsToTerraform(struct?: DataKubernetesIngressV1SpecTls): any;
export declare class DataKubernetesIngressV1SpecTlsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1SpecTls | undefined;
    set internalValue(value: DataKubernetesIngressV1SpecTls | undefined);
    get hosts(): string[];
    get secretName(): string;
}
export declare class DataKubernetesIngressV1SpecTlsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1SpecTlsOutputReference;
}
export interface DataKubernetesIngressV1Spec {
}
export declare function dataKubernetesIngressV1SpecToTerraform(struct?: DataKubernetesIngressV1Spec): any;
export declare class DataKubernetesIngressV1SpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1Spec | undefined;
    set internalValue(value: DataKubernetesIngressV1Spec | undefined);
    private _defaultBackend;
    get defaultBackend(): DataKubernetesIngressV1SpecDefaultBackendList;
    get ingressClassName(): string;
    private _rule;
    get rule(): DataKubernetesIngressV1SpecRuleList;
    private _tls;
    get tls(): DataKubernetesIngressV1SpecTlsList;
}
export declare class DataKubernetesIngressV1SpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1SpecOutputReference;
}
export interface DataKubernetesIngressV1StatusLoadBalancerIngress {
}
export declare function dataKubernetesIngressV1StatusLoadBalancerIngressToTerraform(struct?: DataKubernetesIngressV1StatusLoadBalancerIngress): any;
export declare class DataKubernetesIngressV1StatusLoadBalancerIngressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1StatusLoadBalancerIngress | undefined;
    set internalValue(value: DataKubernetesIngressV1StatusLoadBalancerIngress | undefined);
    get hostname(): string;
    get ip(): string;
}
export declare class DataKubernetesIngressV1StatusLoadBalancerIngressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1StatusLoadBalancerIngressOutputReference;
}
export interface DataKubernetesIngressV1StatusLoadBalancer {
}
export declare function dataKubernetesIngressV1StatusLoadBalancerToTerraform(struct?: DataKubernetesIngressV1StatusLoadBalancer): any;
export declare class DataKubernetesIngressV1StatusLoadBalancerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1StatusLoadBalancer | undefined;
    set internalValue(value: DataKubernetesIngressV1StatusLoadBalancer | undefined);
    private _ingress;
    get ingress(): DataKubernetesIngressV1StatusLoadBalancerIngressList;
}
export declare class DataKubernetesIngressV1StatusLoadBalancerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1StatusLoadBalancerOutputReference;
}
export interface DataKubernetesIngressV1Status {
}
export declare function dataKubernetesIngressV1StatusToTerraform(struct?: DataKubernetesIngressV1Status): any;
export declare class DataKubernetesIngressV1StatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressV1Status | undefined;
    set internalValue(value: DataKubernetesIngressV1Status | undefined);
    private _loadBalancer;
    get loadBalancer(): DataKubernetesIngressV1StatusLoadBalancerList;
}
export declare class DataKubernetesIngressV1StatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressV1StatusOutputReference;
}
export interface DataKubernetesIngressV1Metadata {
    /**
    * An unstructured key value map stored with the ingress that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress_v1#annotations DataKubernetesIngressV1#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the ingress. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress_v1#labels DataKubernetesIngressV1#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the ingress, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress_v1#name DataKubernetesIngressV1#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the ingress must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress_v1#namespace DataKubernetesIngressV1#namespace}
    */
    readonly namespace?: string;
}
export declare function dataKubernetesIngressV1MetadataToTerraform(struct?: DataKubernetesIngressV1MetadataOutputReference | DataKubernetesIngressV1Metadata): any;
export declare class DataKubernetesIngressV1MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataKubernetesIngressV1Metadata | undefined;
    set internalValue(value: DataKubernetesIngressV1Metadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress_v1 kubernetes_ingress_v1}
*/
export declare class DataKubernetesIngressV1 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubernetes_ingress_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress_v1 kubernetes_ingress_v1} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubernetesIngressV1Config
    */
    constructor(scope: Construct, id: string, config: DataKubernetesIngressV1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _spec;
    get spec(): DataKubernetesIngressV1SpecList;
    private _status;
    get status(): DataKubernetesIngressV1StatusList;
    private _metadata;
    get metadata(): DataKubernetesIngressV1MetadataOutputReference;
    putMetadata(value: DataKubernetesIngressV1Metadata): void;
    get metadataInput(): DataKubernetesIngressV1Metadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
