import * as cdktf from 'cdktf';
import { DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilities, DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilitiesOutputReference, DaemonsetSpecTemplateSpecInitContainerEnv, DaemonsetSpecTemplateSpecInitContainerEnvList, DaemonsetSpecTemplateSpecInitContainerEnvFrom, DaemonsetSpecTemplateSpecInitContainerEnvFromList, DaemonsetSpecTemplateSpecInitContainerLifecycle, DaemonsetSpecTemplateSpecInitContainerLifecycleOutputReference, DaemonsetSpecTemplateSpecInitContainerLivenessProbe, DaemonsetSpecTemplateSpecInitContainerLivenessProbeOutputReference, DaemonsetSpecTemplateSpecInitContainerPort, DaemonsetSpecTemplateSpecInitContainerPortList, DaemonsetSpecTemplateSpecInitContainerReadinessProbe, DaemonsetSpecTemplateSpecInitContainerReadinessProbeOutputReference, DaemonsetSpecTemplateSpecInitContainerResources, DaemonsetSpecTemplateSpecInitContainerResourcesOutputReference, DaemonsetSpecTemplateSpecAffinity, DaemonsetSpecTemplateSpecAffinityOutputReference, DaemonsetSpecTemplateSpecContainer, DaemonsetSpecTemplateSpecContainerList, DaemonsetSpecTemplateSpecDnsConfig, DaemonsetSpecTemplateSpecDnsConfigOutputReference, DaemonsetSpecTemplateSpecHostAliases, DaemonsetSpecTemplateSpecHostAliasesList, DaemonsetSpecTemplateSpecImagePullSecrets, DaemonsetSpecTemplateSpecImagePullSecretsList, DaemonsetSpecTemplateMetadata, DaemonsetSpecTemplateMetadataOutputReference, DaemonsetSpecSelector, DaemonsetSpecSelectorOutputReference, DaemonsetSpecStrategy, DaemonsetSpecStrategyOutputReference } from './structs0';
export interface DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions {
    /**
    * Level is SELinux level label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#level Daemonset#level}
    */
    readonly level?: string;
    /**
    * Role is a SELinux role label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#role Daemonset#role}
    */
    readonly role?: string;
    /**
    * Type is a SELinux type label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#type Daemonset#type}
    */
    readonly type?: string;
    /**
    * User is a SELinux user label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#user Daemonset#user}
    */
    readonly user?: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsOutputReference | DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions): any;
export declare class DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfile {
    /**
    * Localhost Profile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#localhost_profile Daemonset#localhost_profile}
    */
    readonly localhostProfile?: string;
    /**
    * Type indicates which kind of seccomp profile will be applied. Valid options are: Localhost, RuntimeDefault, Unconfined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#type Daemonset#type}
    */
    readonly type?: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfileToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfileOutputReference | DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfile): any;
export declare class DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfile | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfile | undefined);
    private _localhostProfile?;
    get localhostProfile(): string;
    set localhostProfile(value: string);
    resetLocalhostProfile(): void;
    get localhostProfileInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerSecurityContext {
    /**
    * AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#allow_privilege_escalation Daemonset#allow_privilege_escalation}
    */
    readonly allowPrivilegeEscalation?: boolean | cdktf.IResolvable;
    /**
    * Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#privileged Daemonset#privileged}
    */
    readonly privileged?: boolean | cdktf.IResolvable;
    /**
    * Whether this container has a read-only root filesystem. Default is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only_root_filesystem Daemonset#read_only_root_filesystem}
    */
    readonly readOnlyRootFilesystem?: boolean | cdktf.IResolvable;
    /**
    * The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#run_as_group Daemonset#run_as_group}
    */
    readonly runAsGroup?: string;
    /**
    * Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#run_as_non_root Daemonset#run_as_non_root}
    */
    readonly runAsNonRoot?: boolean | cdktf.IResolvable;
    /**
    * The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#run_as_user Daemonset#run_as_user}
    */
    readonly runAsUser?: string;
    /**
    * capabilities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#capabilities Daemonset#capabilities}
    */
    readonly capabilities?: DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilities;
    /**
    * se_linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#se_linux_options Daemonset#se_linux_options}
    */
    readonly seLinuxOptions?: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions;
    /**
    * seccomp_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#seccomp_profile Daemonset#seccomp_profile}
    */
    readonly seccompProfile?: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfile;
}
export declare function daemonsetSpecTemplateSpecInitContainerSecurityContextToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerSecurityContextOutputReference | DaemonsetSpecTemplateSpecInitContainerSecurityContext): any;
export declare class DaemonsetSpecTemplateSpecInitContainerSecurityContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerSecurityContext | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerSecurityContext | undefined);
    private _allowPrivilegeEscalation?;
    get allowPrivilegeEscalation(): boolean | cdktf.IResolvable;
    set allowPrivilegeEscalation(value: boolean | cdktf.IResolvable);
    resetAllowPrivilegeEscalation(): void;
    get allowPrivilegeEscalationInput(): boolean | cdktf.IResolvable | undefined;
    private _privileged?;
    get privileged(): boolean | cdktf.IResolvable;
    set privileged(value: boolean | cdktf.IResolvable);
    resetPrivileged(): void;
    get privilegedInput(): boolean | cdktf.IResolvable | undefined;
    private _readOnlyRootFilesystem?;
    get readOnlyRootFilesystem(): boolean | cdktf.IResolvable;
    set readOnlyRootFilesystem(value: boolean | cdktf.IResolvable);
    resetReadOnlyRootFilesystem(): void;
    get readOnlyRootFilesystemInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsGroup?;
    get runAsGroup(): string;
    set runAsGroup(value: string);
    resetRunAsGroup(): void;
    get runAsGroupInput(): string | undefined;
    private _runAsNonRoot?;
    get runAsNonRoot(): boolean | cdktf.IResolvable;
    set runAsNonRoot(value: boolean | cdktf.IResolvable);
    resetRunAsNonRoot(): void;
    get runAsNonRootInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsUser?;
    get runAsUser(): string;
    set runAsUser(value: string);
    resetRunAsUser(): void;
    get runAsUserInput(): string | undefined;
    private _capabilities;
    get capabilities(): DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilitiesOutputReference;
    putCapabilities(value: DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilities): void;
    resetCapabilities(): void;
    get capabilitiesInput(): DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilities | undefined;
    private _seLinuxOptions;
    get seLinuxOptions(): DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsOutputReference;
    putSeLinuxOptions(value: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions): void;
    resetSeLinuxOptions(): void;
    get seLinuxOptionsInput(): DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions | undefined;
    private _seccompProfile;
    get seccompProfile(): DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfileOutputReference;
    putSeccompProfile(value: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfile): void;
    resetSeccompProfile(): void;
    get seccompProfileInput(): DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfile | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerStartupProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#command Daemonset#command}
    */
    readonly command?: string[];
}
export declare function daemonsetSpecTemplateSpecInitContainerStartupProbeExecToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerStartupProbeExecOutputReference | DaemonsetSpecTemplateSpecInitContainerStartupProbeExec): any;
export declare class DaemonsetSpecTemplateSpecInitContainerStartupProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerStartupProbeExec | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerStartupProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerStartupProbeGrpc {
    /**
    * Number of the port to access on the container. Number must be in the range 1 to 65535.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port: number;
    /**
    * Name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md). If this is not specified, the default behavior is defined by gRPC.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#service Daemonset#service}
    */
    readonly service?: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerStartupProbeGrpcToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerStartupProbeGrpc | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerStartupProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerStartupProbeGrpc | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerStartupProbeGrpc | cdktf.IResolvable | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerStartupProbeGrpcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerStartupProbeGrpc[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerStartupProbeGrpcOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value?: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host Daemonset#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#scheme Daemonset#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_header Daemonset#http_header}
    */
    readonly httpHeader?: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetOutputReference | DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGet): any;
export declare class DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGet | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderList;
    putHttpHeader(value: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerStartupProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerStartupProbeTcpSocketToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerStartupProbeTcpSocket | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerStartupProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerStartupProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerStartupProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerStartupProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerStartupProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerStartupProbeTcpSocketOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerStartupProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#failure_threshold Daemonset#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#initial_delay_seconds Daemonset#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#period_seconds Daemonset#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#success_threshold Daemonset#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#timeout_seconds Daemonset#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#exec Daemonset#exec}
    */
    readonly exec?: DaemonsetSpecTemplateSpecInitContainerStartupProbeExec;
    /**
    * grpc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#grpc Daemonset#grpc}
    */
    readonly grpc?: DaemonsetSpecTemplateSpecInitContainerStartupProbeGrpc[] | cdktf.IResolvable;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_get Daemonset#http_get}
    */
    readonly httpGet?: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#tcp_socket Daemonset#tcp_socket}
    */
    readonly tcpSocket?: DaemonsetSpecTemplateSpecInitContainerStartupProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerStartupProbeToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerStartupProbeOutputReference | DaemonsetSpecTemplateSpecInitContainerStartupProbe): any;
export declare class DaemonsetSpecTemplateSpecInitContainerStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerStartupProbe | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerStartupProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): DaemonsetSpecTemplateSpecInitContainerStartupProbeExecOutputReference;
    putExec(value: DaemonsetSpecTemplateSpecInitContainerStartupProbeExec): void;
    resetExec(): void;
    get execInput(): DaemonsetSpecTemplateSpecInitContainerStartupProbeExec | undefined;
    private _grpc;
    get grpc(): DaemonsetSpecTemplateSpecInitContainerStartupProbeGrpcList;
    putGrpc(value: DaemonsetSpecTemplateSpecInitContainerStartupProbeGrpc[] | cdktf.IResolvable): void;
    resetGrpc(): void;
    get grpcInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerStartupProbeGrpc[] | undefined;
    private _httpGet;
    get httpGet(): DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetOutputReference;
    putHttpGet(value: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): DaemonsetSpecTemplateSpecInitContainerStartupProbeTcpSocketList;
    putTcpSocket(value: DaemonsetSpecTemplateSpecInitContainerStartupProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerStartupProbeTcpSocket[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerVolumeMount {
    /**
    * Path within the container at which the volume should be mounted. Must not contain ':'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#mount_path Daemonset#mount_path}
    */
    readonly mountPath: string;
    /**
    * Mount propagation mode. mount_propagation determines how mounts are propagated from the host to container and the other way around. Valid values are None (default), HostToContainer and Bidirectional.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#mount_propagation Daemonset#mount_propagation}
    */
    readonly mountPropagation?: string;
    /**
    * This must match the Name of a Volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name: string;
    /**
    * Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#sub_path Daemonset#sub_path}
    */
    readonly subPath?: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerVolumeMountToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerVolumeMount | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerVolumeMountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerVolumeMount | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerVolumeMount | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _mountPropagation?;
    get mountPropagation(): string;
    set mountPropagation(value: string);
    resetMountPropagation(): void;
    get mountPropagationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _subPath?;
    get subPath(): string;
    set subPath(value: string);
    resetSubPath(): void;
    get subPathInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerVolumeMountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerVolumeMount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerVolumeMountOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainer {
    /**
    * Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#args Daemonset#args}
    */
    readonly args?: string[];
    /**
    * Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#command Daemonset#command}
    */
    readonly command?: string[];
    /**
    * Docker image name. More info: http://kubernetes.io/docs/user-guide/images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#image Daemonset#image}
    */
    readonly image?: string;
    /**
    * Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/images#updating-images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#image_pull_policy Daemonset#image_pull_policy}
    */
    readonly imagePullPolicy?: string;
    /**
    * Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name: string;
    /**
    * Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#stdin Daemonset#stdin}
    */
    readonly stdin?: boolean | cdktf.IResolvable;
    /**
    * Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#stdin_once Daemonset#stdin_once}
    */
    readonly stdinOnce?: boolean | cdktf.IResolvable;
    /**
    * Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Defaults to /dev/termination-log. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#termination_message_path Daemonset#termination_message_path}
    */
    readonly terminationMessagePath?: string;
    /**
    * Optional: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#termination_message_policy Daemonset#termination_message_policy}
    */
    readonly terminationMessagePolicy?: string;
    /**
    * Whether this container should allocate a TTY for itself
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#tty Daemonset#tty}
    */
    readonly tty?: boolean | cdktf.IResolvable;
    /**
    * Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#working_dir Daemonset#working_dir}
    */
    readonly workingDir?: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#env Daemonset#env}
    */
    readonly env?: DaemonsetSpecTemplateSpecInitContainerEnv[] | cdktf.IResolvable;
    /**
    * env_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#env_from Daemonset#env_from}
    */
    readonly envFrom?: DaemonsetSpecTemplateSpecInitContainerEnvFrom[] | cdktf.IResolvable;
    /**
    * lifecycle block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#lifecycle Daemonset#lifecycle}
    */
    readonly lifecycle?: DaemonsetSpecTemplateSpecInitContainerLifecycle;
    /**
    * liveness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#liveness_probe Daemonset#liveness_probe}
    */
    readonly livenessProbe?: DaemonsetSpecTemplateSpecInitContainerLivenessProbe;
    /**
    * port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port?: DaemonsetSpecTemplateSpecInitContainerPort[] | cdktf.IResolvable;
    /**
    * readiness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#readiness_probe Daemonset#readiness_probe}
    */
    readonly readinessProbe?: DaemonsetSpecTemplateSpecInitContainerReadinessProbe;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#resources Daemonset#resources}
    */
    readonly resources?: DaemonsetSpecTemplateSpecInitContainerResources;
    /**
    * security_context block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#security_context Daemonset#security_context}
    */
    readonly securityContext?: DaemonsetSpecTemplateSpecInitContainerSecurityContext;
    /**
    * startup_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#startup_probe Daemonset#startup_probe}
    */
    readonly startupProbe?: DaemonsetSpecTemplateSpecInitContainerStartupProbe;
    /**
    * volume_mount block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#volume_mount Daemonset#volume_mount}
    */
    readonly volumeMount?: DaemonsetSpecTemplateSpecInitContainerVolumeMount[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainer | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainer | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainer | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _imagePullPolicy?;
    get imagePullPolicy(): string;
    set imagePullPolicy(value: string);
    resetImagePullPolicy(): void;
    get imagePullPolicyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _stdin?;
    get stdin(): boolean | cdktf.IResolvable;
    set stdin(value: boolean | cdktf.IResolvable);
    resetStdin(): void;
    get stdinInput(): boolean | cdktf.IResolvable | undefined;
    private _stdinOnce?;
    get stdinOnce(): boolean | cdktf.IResolvable;
    set stdinOnce(value: boolean | cdktf.IResolvable);
    resetStdinOnce(): void;
    get stdinOnceInput(): boolean | cdktf.IResolvable | undefined;
    private _terminationMessagePath?;
    get terminationMessagePath(): string;
    set terminationMessagePath(value: string);
    resetTerminationMessagePath(): void;
    get terminationMessagePathInput(): string | undefined;
    private _terminationMessagePolicy?;
    get terminationMessagePolicy(): string;
    set terminationMessagePolicy(value: string);
    resetTerminationMessagePolicy(): void;
    get terminationMessagePolicyInput(): string | undefined;
    private _tty?;
    get tty(): boolean | cdktf.IResolvable;
    set tty(value: boolean | cdktf.IResolvable);
    resetTty(): void;
    get ttyInput(): boolean | cdktf.IResolvable | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
    private _env;
    get env(): DaemonsetSpecTemplateSpecInitContainerEnvList;
    putEnv(value: DaemonsetSpecTemplateSpecInitContainerEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerEnv[] | undefined;
    private _envFrom;
    get envFrom(): DaemonsetSpecTemplateSpecInitContainerEnvFromList;
    putEnvFrom(value: DaemonsetSpecTemplateSpecInitContainerEnvFrom[] | cdktf.IResolvable): void;
    resetEnvFrom(): void;
    get envFromInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerEnvFrom[] | undefined;
    private _lifecycle;
    get lifecycle(): DaemonsetSpecTemplateSpecInitContainerLifecycleOutputReference;
    putLifecycle(value: DaemonsetSpecTemplateSpecInitContainerLifecycle): void;
    resetLifecycle(): void;
    get lifecycleInput(): DaemonsetSpecTemplateSpecInitContainerLifecycle | undefined;
    private _livenessProbe;
    get livenessProbe(): DaemonsetSpecTemplateSpecInitContainerLivenessProbeOutputReference;
    putLivenessProbe(value: DaemonsetSpecTemplateSpecInitContainerLivenessProbe): void;
    resetLivenessProbe(): void;
    get livenessProbeInput(): DaemonsetSpecTemplateSpecInitContainerLivenessProbe | undefined;
    private _port;
    get port(): DaemonsetSpecTemplateSpecInitContainerPortList;
    putPort(value: DaemonsetSpecTemplateSpecInitContainerPort[] | cdktf.IResolvable): void;
    resetPort(): void;
    get portInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerPort[] | undefined;
    private _readinessProbe;
    get readinessProbe(): DaemonsetSpecTemplateSpecInitContainerReadinessProbeOutputReference;
    putReadinessProbe(value: DaemonsetSpecTemplateSpecInitContainerReadinessProbe): void;
    resetReadinessProbe(): void;
    get readinessProbeInput(): DaemonsetSpecTemplateSpecInitContainerReadinessProbe | undefined;
    private _resources;
    get resources(): DaemonsetSpecTemplateSpecInitContainerResourcesOutputReference;
    putResources(value: DaemonsetSpecTemplateSpecInitContainerResources): void;
    resetResources(): void;
    get resourcesInput(): DaemonsetSpecTemplateSpecInitContainerResources | undefined;
    private _securityContext;
    get securityContext(): DaemonsetSpecTemplateSpecInitContainerSecurityContextOutputReference;
    putSecurityContext(value: DaemonsetSpecTemplateSpecInitContainerSecurityContext): void;
    resetSecurityContext(): void;
    get securityContextInput(): DaemonsetSpecTemplateSpecInitContainerSecurityContext | undefined;
    private _startupProbe;
    get startupProbe(): DaemonsetSpecTemplateSpecInitContainerStartupProbeOutputReference;
    putStartupProbe(value: DaemonsetSpecTemplateSpecInitContainerStartupProbe): void;
    resetStartupProbe(): void;
    get startupProbeInput(): DaemonsetSpecTemplateSpecInitContainerStartupProbe | undefined;
    private _volumeMount;
    get volumeMount(): DaemonsetSpecTemplateSpecInitContainerVolumeMountList;
    putVolumeMount(value: DaemonsetSpecTemplateSpecInitContainerVolumeMount[] | cdktf.IResolvable): void;
    resetVolumeMount(): void;
    get volumeMountInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerVolumeMount[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerOutputReference;
}
export interface DaemonsetSpecTemplateSpecReadinessGate {
    /**
    * refers to a condition in the pod's condition list with matching type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#condition_type Daemonset#condition_type}
    */
    readonly conditionType: string;
}
export declare function daemonsetSpecTemplateSpecReadinessGateToTerraform(struct?: DaemonsetSpecTemplateSpecReadinessGate | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecReadinessGateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecReadinessGate | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecReadinessGate | cdktf.IResolvable | undefined);
    private _conditionType?;
    get conditionType(): string;
    set conditionType(value: string);
    get conditionTypeInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecReadinessGateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecReadinessGate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecReadinessGateOutputReference;
}
export interface DaemonsetSpecTemplateSpecSecurityContextSeLinuxOptions {
    /**
    * Level is SELinux level label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#level Daemonset#level}
    */
    readonly level?: string;
    /**
    * Role is a SELinux role label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#role Daemonset#role}
    */
    readonly role?: string;
    /**
    * Type is a SELinux type label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#type Daemonset#type}
    */
    readonly type?: string;
    /**
    * User is a SELinux user label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#user Daemonset#user}
    */
    readonly user?: string;
}
export declare function daemonsetSpecTemplateSpecSecurityContextSeLinuxOptionsToTerraform(struct?: DaemonsetSpecTemplateSpecSecurityContextSeLinuxOptionsOutputReference | DaemonsetSpecTemplateSpecSecurityContextSeLinuxOptions): any;
export declare class DaemonsetSpecTemplateSpecSecurityContextSeLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecSecurityContextSeLinuxOptions | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecSecurityContextSeLinuxOptions | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecSecurityContextSeccompProfile {
    /**
    * Localhost Profile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#localhost_profile Daemonset#localhost_profile}
    */
    readonly localhostProfile?: string;
    /**
    * Type indicates which kind of seccomp profile will be applied. Valid options are: Localhost, RuntimeDefault, Unconfined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#type Daemonset#type}
    */
    readonly type?: string;
}
export declare function daemonsetSpecTemplateSpecSecurityContextSeccompProfileToTerraform(struct?: DaemonsetSpecTemplateSpecSecurityContextSeccompProfileOutputReference | DaemonsetSpecTemplateSpecSecurityContextSeccompProfile): any;
export declare class DaemonsetSpecTemplateSpecSecurityContextSeccompProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecSecurityContextSeccompProfile | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecSecurityContextSeccompProfile | undefined);
    private _localhostProfile?;
    get localhostProfile(): string;
    set localhostProfile(value: string);
    resetLocalhostProfile(): void;
    get localhostProfileInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecSecurityContextSysctl {
    /**
    * Name of a property to set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name: string;
    /**
    * Value of a property to set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value: string;
}
export declare function daemonsetSpecTemplateSpecSecurityContextSysctlToTerraform(struct?: DaemonsetSpecTemplateSpecSecurityContextSysctl | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecSecurityContextSysctlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecSecurityContextSysctl | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecSecurityContextSysctl | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecSecurityContextSysctlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecSecurityContextSysctl[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecSecurityContextSysctlOutputReference;
}
export interface DaemonsetSpecTemplateSpecSecurityContext {
    /**
    * A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod: 1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw---- If unset, the Kubelet will not modify the ownership and permissions of any volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#fs_group Daemonset#fs_group}
    */
    readonly fsGroup?: string;
    /**
    * fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#fs_group_change_policy Daemonset#fs_group_change_policy}
    */
    readonly fsGroupChangePolicy?: string;
    /**
    * The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#run_as_group Daemonset#run_as_group}
    */
    readonly runAsGroup?: string;
    /**
    * Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#run_as_non_root Daemonset#run_as_non_root}
    */
    readonly runAsNonRoot?: boolean | cdktf.IResolvable;
    /**
    * The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#run_as_user Daemonset#run_as_user}
    */
    readonly runAsUser?: string;
    /**
    * A list of groups applied to the first process run in each container, in addition to the container's primary GID. If unspecified, no groups will be added to any container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#supplemental_groups Daemonset#supplemental_groups}
    */
    readonly supplementalGroups?: number[];
    /**
    * se_linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#se_linux_options Daemonset#se_linux_options}
    */
    readonly seLinuxOptions?: DaemonsetSpecTemplateSpecSecurityContextSeLinuxOptions;
    /**
    * seccomp_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#seccomp_profile Daemonset#seccomp_profile}
    */
    readonly seccompProfile?: DaemonsetSpecTemplateSpecSecurityContextSeccompProfile;
    /**
    * sysctl block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#sysctl Daemonset#sysctl}
    */
    readonly sysctl?: DaemonsetSpecTemplateSpecSecurityContextSysctl[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecSecurityContextToTerraform(struct?: DaemonsetSpecTemplateSpecSecurityContextOutputReference | DaemonsetSpecTemplateSpecSecurityContext): any;
export declare class DaemonsetSpecTemplateSpecSecurityContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecSecurityContext | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecSecurityContext | undefined);
    private _fsGroup?;
    get fsGroup(): string;
    set fsGroup(value: string);
    resetFsGroup(): void;
    get fsGroupInput(): string | undefined;
    private _fsGroupChangePolicy?;
    get fsGroupChangePolicy(): string;
    set fsGroupChangePolicy(value: string);
    resetFsGroupChangePolicy(): void;
    get fsGroupChangePolicyInput(): string | undefined;
    private _runAsGroup?;
    get runAsGroup(): string;
    set runAsGroup(value: string);
    resetRunAsGroup(): void;
    get runAsGroupInput(): string | undefined;
    private _runAsNonRoot?;
    get runAsNonRoot(): boolean | cdktf.IResolvable;
    set runAsNonRoot(value: boolean | cdktf.IResolvable);
    resetRunAsNonRoot(): void;
    get runAsNonRootInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsUser?;
    get runAsUser(): string;
    set runAsUser(value: string);
    resetRunAsUser(): void;
    get runAsUserInput(): string | undefined;
    private _supplementalGroups?;
    get supplementalGroups(): number[];
    set supplementalGroups(value: number[]);
    resetSupplementalGroups(): void;
    get supplementalGroupsInput(): number[] | undefined;
    private _seLinuxOptions;
    get seLinuxOptions(): DaemonsetSpecTemplateSpecSecurityContextSeLinuxOptionsOutputReference;
    putSeLinuxOptions(value: DaemonsetSpecTemplateSpecSecurityContextSeLinuxOptions): void;
    resetSeLinuxOptions(): void;
    get seLinuxOptionsInput(): DaemonsetSpecTemplateSpecSecurityContextSeLinuxOptions | undefined;
    private _seccompProfile;
    get seccompProfile(): DaemonsetSpecTemplateSpecSecurityContextSeccompProfileOutputReference;
    putSeccompProfile(value: DaemonsetSpecTemplateSpecSecurityContextSeccompProfile): void;
    resetSeccompProfile(): void;
    get seccompProfileInput(): DaemonsetSpecTemplateSpecSecurityContextSeccompProfile | undefined;
    private _sysctl;
    get sysctl(): DaemonsetSpecTemplateSpecSecurityContextSysctlList;
    putSysctl(value: DaemonsetSpecTemplateSpecSecurityContextSysctl[] | cdktf.IResolvable): void;
    resetSysctl(): void;
    get sysctlInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecSecurityContextSysctl[] | undefined;
}
export interface DaemonsetSpecTemplateSpecToleration {
    /**
    * Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#effect Daemonset#effect}
    */
    readonly effect?: string;
    /**
    * Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#operator Daemonset#operator}
    */
    readonly operator?: string;
    /**
    * TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#toleration_seconds Daemonset#toleration_seconds}
    */
    readonly tolerationSeconds?: string;
    /**
    * Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value?: string;
}
export declare function daemonsetSpecTemplateSpecTolerationToTerraform(struct?: DaemonsetSpecTemplateSpecToleration | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecTolerationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecToleration | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecToleration | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _tolerationSeconds?;
    get tolerationSeconds(): string;
    set tolerationSeconds(value: string);
    resetTolerationSeconds(): void;
    get tolerationSecondsInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecTolerationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecToleration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecTolerationOutputReference;
}
export interface DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#operator Daemonset#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#values Daemonset#values}
    */
    readonly values?: string[];
}
export declare function daemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressionsToTerraform(struct?: DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressionsOutputReference;
}
export interface DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#match_labels Daemonset#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#match_expressions Daemonset#match_expressions}
    */
    readonly matchExpressions?: DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorToTerraform(struct?: DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelector | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorOutputReference;
}
export interface DaemonsetSpecTemplateSpecTopologySpreadConstraint {
    /**
    * describes the degree to which pods may be unevenly distributed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#max_skew Daemonset#max_skew}
    */
    readonly maxSkew?: number;
    /**
    * the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#topology_key Daemonset#topology_key}
    */
    readonly topologyKey?: string;
    /**
    * indicates how to deal with a pod if it doesn't satisfy the spread constraint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#when_unsatisfiable Daemonset#when_unsatisfiable}
    */
    readonly whenUnsatisfiable?: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#label_selector Daemonset#label_selector}
    */
    readonly labelSelector?: DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelector[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecTopologySpreadConstraintToTerraform(struct?: DaemonsetSpecTemplateSpecTopologySpreadConstraint | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecTopologySpreadConstraintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecTopologySpreadConstraint | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecTopologySpreadConstraint | cdktf.IResolvable | undefined);
    private _maxSkew?;
    get maxSkew(): number;
    set maxSkew(value: number);
    resetMaxSkew(): void;
    get maxSkewInput(): number | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    resetTopologyKey(): void;
    get topologyKeyInput(): string | undefined;
    private _whenUnsatisfiable?;
    get whenUnsatisfiable(): string;
    set whenUnsatisfiable(value: string);
    resetWhenUnsatisfiable(): void;
    get whenUnsatisfiableInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelectorList;
    putLabelSelector(value: DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecTopologySpreadConstraintLabelSelector[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecTopologySpreadConstraintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecTopologySpreadConstraint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecTopologySpreadConstraintOutputReference;
}
export interface DaemonsetSpecTemplateSpecVolumeAwsElasticBlockStore {
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#fs_type Daemonset#fs_type}
    */
    readonly fsType?: string;
    /**
    * The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#partition Daemonset#partition}
    */
    readonly partition?: number;
    /**
    * Whether to set the read-only property in VolumeMounts to "true". If omitted, the default is "false". More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#volume_id Daemonset#volume_id}
    */
    readonly volumeId: string;
}
export declare function daemonsetSpecTemplateSpecVolumeAwsElasticBlockStoreToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeAwsElasticBlockStoreOutputReference | DaemonsetSpecTemplateSpecVolumeAwsElasticBlockStore): any;
export declare class DaemonsetSpecTemplateSpecVolumeAwsElasticBlockStoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeAwsElasticBlockStore | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeAwsElasticBlockStore | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _partition?;
    get partition(): number;
    set partition(value: number);
    resetPartition(): void;
    get partitionInput(): number | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeAzureDisk {
    /**
    * Host Caching mode: None, Read Only, Read Write.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#caching_mode Daemonset#caching_mode}
    */
    readonly cachingMode: string;
    /**
    * The URI the data disk in the blob storage
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#data_disk_uri Daemonset#data_disk_uri}
    */
    readonly dataDiskUri: string;
    /**
    * The Name of the data disk in the blob storage
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#disk_name Daemonset#disk_name}
    */
    readonly diskName: string;
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#fs_type Daemonset#fs_type}
    */
    readonly fsType?: string;
    /**
    * The type for the data disk. Expected values: Shared, Dedicated, Managed. Defaults to Shared
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#kind Daemonset#kind}
    */
    readonly kind?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecVolumeAzureDiskToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeAzureDiskOutputReference | DaemonsetSpecTemplateSpecVolumeAzureDisk): any;
export declare class DaemonsetSpecTemplateSpecVolumeAzureDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeAzureDisk | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeAzureDisk | undefined);
    private _cachingMode?;
    get cachingMode(): string;
    set cachingMode(value: string);
    get cachingModeInput(): string | undefined;
    private _dataDiskUri?;
    get dataDiskUri(): string;
    set dataDiskUri(value: string);
    get dataDiskUriInput(): string | undefined;
    private _diskName?;
    get diskName(): string;
    set diskName(value: string);
    get diskNameInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeAzureFile {
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * The name of secret that contains Azure Storage Account Name and Key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#secret_name Daemonset#secret_name}
    */
    readonly secretName: string;
    /**
    * The namespace of the secret that contains Azure Storage Account Name and Key. For Kubernetes up to 1.18.x the default is the same as the Pod. For Kubernetes 1.19.x and later the default is "default" namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#secret_namespace Daemonset#secret_namespace}
    */
    readonly secretNamespace?: string;
    /**
    * Share Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#share_name Daemonset#share_name}
    */
    readonly shareName: string;
}
export declare function daemonsetSpecTemplateSpecVolumeAzureFileToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeAzureFileOutputReference | DaemonsetSpecTemplateSpecVolumeAzureFile): any;
export declare class DaemonsetSpecTemplateSpecVolumeAzureFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeAzureFile | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeAzureFile | undefined);
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
    private _secretNamespace?;
    get secretNamespace(): string;
    set secretNamespace(value: string);
    resetSecretNamespace(): void;
    get secretNamespaceInput(): string | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeCephFsSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#namespace Daemonset#namespace}
    */
    readonly namespace?: string;
}
export declare function daemonsetSpecTemplateSpecVolumeCephFsSecretRefToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeCephFsSecretRefOutputReference | DaemonsetSpecTemplateSpecVolumeCephFsSecretRef): any;
export declare class DaemonsetSpecTemplateSpecVolumeCephFsSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeCephFsSecretRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeCephFsSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeCephFs {
    /**
    * Monitors is a collection of Ceph monitors More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#monitors Daemonset#monitors}
    */
    readonly monitors: string[];
    /**
    * Used as the mounted root, rather than the full Ceph tree, default is /
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to `false` (read/write). More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * The path to key ring for User, default is /etc/ceph/user.secret More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#secret_file Daemonset#secret_file}
    */
    readonly secretFile?: string;
    /**
    * User is the rados user name, default is admin. More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#user Daemonset#user}
    */
    readonly user?: string;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#secret_ref Daemonset#secret_ref}
    */
    readonly secretRef?: DaemonsetSpecTemplateSpecVolumeCephFsSecretRef;
}
export declare function daemonsetSpecTemplateSpecVolumeCephFsToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeCephFsOutputReference | DaemonsetSpecTemplateSpecVolumeCephFs): any;
export declare class DaemonsetSpecTemplateSpecVolumeCephFsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeCephFs | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeCephFs | undefined);
    private _monitors?;
    get monitors(): string[];
    set monitors(value: string[]);
    get monitorsInput(): string[] | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretFile?;
    get secretFile(): string;
    set secretFile(value: string);
    resetSecretFile(): void;
    get secretFileInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
    private _secretRef;
    get secretRef(): DaemonsetSpecTemplateSpecVolumeCephFsSecretRefOutputReference;
    putSecretRef(value: DaemonsetSpecTemplateSpecVolumeCephFsSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): DaemonsetSpecTemplateSpecVolumeCephFsSecretRef | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeCinder {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#fs_type Daemonset#fs_type}
    */
    readonly fsType?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write). More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Volume ID used to identify the volume in Cinder. More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#volume_id Daemonset#volume_id}
    */
    readonly volumeId: string;
}
export declare function daemonsetSpecTemplateSpecVolumeCinderToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeCinderOutputReference | DaemonsetSpecTemplateSpecVolumeCinder): any;
export declare class DaemonsetSpecTemplateSpecVolumeCinderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeCinder | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeCinder | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeConfigMapItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#mode Daemonset#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
}
export declare function daemonsetSpecTemplateSpecVolumeConfigMapItemsToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeConfigMapItems | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecVolumeConfigMapItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeConfigMapItems | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeConfigMapItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecVolumeConfigMapItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecVolumeConfigMapItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecVolumeConfigMapItemsOutputReference;
}
export interface DaemonsetSpecTemplateSpecVolumeConfigMap {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#default_mode Daemonset#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * Optional: Specify whether the ConfigMap or its keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#optional Daemonset#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#items Daemonset#items}
    */
    readonly items?: DaemonsetSpecTemplateSpecVolumeConfigMapItems[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecVolumeConfigMapToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeConfigMapOutputReference | DaemonsetSpecTemplateSpecVolumeConfigMap): any;
export declare class DaemonsetSpecTemplateSpecVolumeConfigMapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeConfigMap | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeConfigMap | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _items;
    get items(): DaemonsetSpecTemplateSpecVolumeConfigMapItemsList;
    putItems(value: DaemonsetSpecTemplateSpecVolumeConfigMapItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecVolumeConfigMapItems[] | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeCsiNodePublishSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
}
export declare function daemonsetSpecTemplateSpecVolumeCsiNodePublishSecretRefToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeCsiNodePublishSecretRefOutputReference | DaemonsetSpecTemplateSpecVolumeCsiNodePublishSecretRef): any;
export declare class DaemonsetSpecTemplateSpecVolumeCsiNodePublishSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeCsiNodePublishSecretRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeCsiNodePublishSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeCsi {
    /**
    * the name of the volume driver to use. More info: https://kubernetes.io/docs/concepts/storage/volumes/#csi
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#driver Daemonset#driver}
    */
    readonly driver: string;
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#fs_type Daemonset#fs_type}
    */
    readonly fsType?: string;
    /**
    * Whether to set the read-only property in VolumeMounts to "true". If omitted, the default is "false". More info: http://kubernetes.io/docs/user-guide/volumes#csi
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Attributes of the volume to publish.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#volume_attributes Daemonset#volume_attributes}
    */
    readonly volumeAttributes?: {
        [key: string]: string;
    };
    /**
    * node_publish_secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#node_publish_secret_ref Daemonset#node_publish_secret_ref}
    */
    readonly nodePublishSecretRef?: DaemonsetSpecTemplateSpecVolumeCsiNodePublishSecretRef;
}
export declare function daemonsetSpecTemplateSpecVolumeCsiToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeCsiOutputReference | DaemonsetSpecTemplateSpecVolumeCsi): any;
export declare class DaemonsetSpecTemplateSpecVolumeCsiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeCsi | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeCsi | undefined);
    private _driver?;
    get driver(): string;
    set driver(value: string);
    get driverInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeAttributes?;
    get volumeAttributes(): {
        [key: string]: string;
    };
    set volumeAttributes(value: {
        [key: string]: string;
    });
    resetVolumeAttributes(): void;
    get volumeAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _nodePublishSecretRef;
    get nodePublishSecretRef(): DaemonsetSpecTemplateSpecVolumeCsiNodePublishSecretRefOutputReference;
    putNodePublishSecretRef(value: DaemonsetSpecTemplateSpecVolumeCsiNodePublishSecretRef): void;
    resetNodePublishSecretRef(): void;
    get nodePublishSecretRefInput(): DaemonsetSpecTemplateSpecVolumeCsiNodePublishSecretRef | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeDownwardApiItemsFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to "v1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#api_version Daemonset#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#field_path Daemonset#field_path}
    */
    readonly fieldPath?: string;
}
export declare function daemonsetSpecTemplateSpecVolumeDownwardApiItemsFieldRefToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeDownwardApiItemsFieldRefOutputReference | DaemonsetSpecTemplateSpecVolumeDownwardApiItemsFieldRef): any;
export declare class DaemonsetSpecTemplateSpecVolumeDownwardApiItemsFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeDownwardApiItemsFieldRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeDownwardApiItemsFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#container_name Daemonset#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#divisor Daemonset#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#resource Daemonset#resource}
    */
    readonly resource: string;
}
export declare function daemonsetSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRefToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRefOutputReference | DaemonsetSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef): any;
export declare class DaemonsetSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeDownwardApiItems {
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#mode Daemonset#mode}
    */
    readonly mode?: string;
    /**
    * Path is the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path: string;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#field_ref Daemonset#field_ref}
    */
    readonly fieldRef: DaemonsetSpecTemplateSpecVolumeDownwardApiItemsFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#resource_field_ref Daemonset#resource_field_ref}
    */
    readonly resourceFieldRef?: DaemonsetSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef;
}
export declare function daemonsetSpecTemplateSpecVolumeDownwardApiItemsToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeDownwardApiItems | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecVolumeDownwardApiItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeDownwardApiItems | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeDownwardApiItems | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _fieldRef;
    get fieldRef(): DaemonsetSpecTemplateSpecVolumeDownwardApiItemsFieldRefOutputReference;
    putFieldRef(value: DaemonsetSpecTemplateSpecVolumeDownwardApiItemsFieldRef): void;
    get fieldRefInput(): DaemonsetSpecTemplateSpecVolumeDownwardApiItemsFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): DaemonsetSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRefOutputReference;
    putResourceFieldRef(value: DaemonsetSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): DaemonsetSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef | undefined;
}
export declare class DaemonsetSpecTemplateSpecVolumeDownwardApiItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecVolumeDownwardApiItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecVolumeDownwardApiItemsOutputReference;
}
export interface DaemonsetSpecTemplateSpecVolumeDownwardApi {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#default_mode Daemonset#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#items Daemonset#items}
    */
    readonly items?: DaemonsetSpecTemplateSpecVolumeDownwardApiItems[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecVolumeDownwardApiToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeDownwardApiOutputReference | DaemonsetSpecTemplateSpecVolumeDownwardApi): any;
export declare class DaemonsetSpecTemplateSpecVolumeDownwardApiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeDownwardApi | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeDownwardApi | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _items;
    get items(): DaemonsetSpecTemplateSpecVolumeDownwardApiItemsList;
    putItems(value: DaemonsetSpecTemplateSpecVolumeDownwardApiItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecVolumeDownwardApiItems[] | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeEmptyDir {
    /**
    * What type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#medium Daemonset#medium}
    */
    readonly medium?: string;
    /**
    * Total amount of local storage required for this EmptyDir volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#size_limit Daemonset#size_limit}
    */
    readonly sizeLimit?: string;
}
export declare function daemonsetSpecTemplateSpecVolumeEmptyDirToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeEmptyDirOutputReference | DaemonsetSpecTemplateSpecVolumeEmptyDir): any;
export declare class DaemonsetSpecTemplateSpecVolumeEmptyDirOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeEmptyDir | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeEmptyDir | undefined);
    private _medium?;
    get medium(): string;
    set medium(value: string);
    resetMedium(): void;
    get mediumInput(): string | undefined;
    private _sizeLimit?;
    get sizeLimit(): string;
    set sizeLimit(value: string);
    resetSizeLimit(): void;
    get sizeLimitInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeFc {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#fs_type Daemonset#fs_type}
    */
    readonly fsType?: string;
    /**
    * FC target lun number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#lun Daemonset#lun}
    */
    readonly lun: number;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * FC target worldwide names (WWNs)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#target_ww_ns Daemonset#target_ww_ns}
    */
    readonly targetWwNs: string[];
}
export declare function daemonsetSpecTemplateSpecVolumeFcToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeFcOutputReference | DaemonsetSpecTemplateSpecVolumeFc): any;
export declare class DaemonsetSpecTemplateSpecVolumeFcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeFc | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeFc | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    get lunInput(): number | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _targetWwNs?;
    get targetWwNs(): string[];
    set targetWwNs(value: string[]);
    get targetWwNsInput(): string[] | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeFlexVolumeSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#namespace Daemonset#namespace}
    */
    readonly namespace?: string;
}
export declare function daemonsetSpecTemplateSpecVolumeFlexVolumeSecretRefToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeFlexVolumeSecretRefOutputReference | DaemonsetSpecTemplateSpecVolumeFlexVolumeSecretRef): any;
export declare class DaemonsetSpecTemplateSpecVolumeFlexVolumeSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeFlexVolumeSecretRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeFlexVolumeSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeFlexVolume {
    /**
    * Driver is the name of the driver to use for this volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#driver Daemonset#driver}
    */
    readonly driver: string;
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#fs_type Daemonset#fs_type}
    */
    readonly fsType?: string;
    /**
    * Extra command options if any.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#options Daemonset#options}
    */
    readonly options?: {
        [key: string]: string;
    };
    /**
    * Whether to force the ReadOnly setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#secret_ref Daemonset#secret_ref}
    */
    readonly secretRef?: DaemonsetSpecTemplateSpecVolumeFlexVolumeSecretRef;
}
export declare function daemonsetSpecTemplateSpecVolumeFlexVolumeToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeFlexVolumeOutputReference | DaemonsetSpecTemplateSpecVolumeFlexVolume): any;
export declare class DaemonsetSpecTemplateSpecVolumeFlexVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeFlexVolume | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeFlexVolume | undefined);
    private _driver?;
    get driver(): string;
    set driver(value: string);
    get driverInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    resetOptions(): void;
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretRef;
    get secretRef(): DaemonsetSpecTemplateSpecVolumeFlexVolumeSecretRefOutputReference;
    putSecretRef(value: DaemonsetSpecTemplateSpecVolumeFlexVolumeSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): DaemonsetSpecTemplateSpecVolumeFlexVolumeSecretRef | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeFlocker {
    /**
    * Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#dataset_name Daemonset#dataset_name}
    */
    readonly datasetName?: string;
    /**
    * UUID of the dataset. This is unique identifier of a Flocker dataset
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#dataset_uuid Daemonset#dataset_uuid}
    */
    readonly datasetUuid?: string;
}
export declare function daemonsetSpecTemplateSpecVolumeFlockerToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeFlockerOutputReference | DaemonsetSpecTemplateSpecVolumeFlocker): any;
export declare class DaemonsetSpecTemplateSpecVolumeFlockerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeFlocker | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeFlocker | undefined);
    private _datasetName?;
    get datasetName(): string;
    set datasetName(value: string);
    resetDatasetName(): void;
    get datasetNameInput(): string | undefined;
    private _datasetUuid?;
    get datasetUuid(): string;
    set datasetUuid(value: string);
    resetDatasetUuid(): void;
    get datasetUuidInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeGcePersistentDisk {
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#fs_type Daemonset#fs_type}
    */
    readonly fsType?: string;
    /**
    * The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#partition Daemonset#partition}
    */
    readonly partition?: number;
    /**
    * Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#pd_name Daemonset#pd_name}
    */
    readonly pdName: string;
    /**
    * Whether to force the ReadOnly setting in VolumeMounts. Defaults to false. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecVolumeGcePersistentDiskToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeGcePersistentDiskOutputReference | DaemonsetSpecTemplateSpecVolumeGcePersistentDisk): any;
export declare class DaemonsetSpecTemplateSpecVolumeGcePersistentDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeGcePersistentDisk | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeGcePersistentDisk | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _partition?;
    get partition(): number;
    set partition(value: number);
    resetPartition(): void;
    get partitionInput(): number | undefined;
    private _pdName?;
    get pdName(): string;
    set pdName(value: string);
    get pdNameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeGitRepo {
    /**
    * Target directory name. Must not contain or start with '..'. If '.' is supplied, the volume directory will be the git repository. Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#directory Daemonset#directory}
    */
    readonly directory?: string;
    /**
    * Repository URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#repository Daemonset#repository}
    */
    readonly repository?: string;
    /**
    * Commit hash for the specified revision.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#revision Daemonset#revision}
    */
    readonly revision?: string;
}
export declare function daemonsetSpecTemplateSpecVolumeGitRepoToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeGitRepoOutputReference | DaemonsetSpecTemplateSpecVolumeGitRepo): any;
export declare class DaemonsetSpecTemplateSpecVolumeGitRepoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeGitRepo | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeGitRepo | undefined);
    private _directory?;
    get directory(): string;
    set directory(value: string);
    resetDirectory(): void;
    get directoryInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    resetRepository(): void;
    get repositoryInput(): string | undefined;
    private _revision?;
    get revision(): string;
    set revision(value: string);
    resetRevision(): void;
    get revisionInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeGlusterfs {
    /**
    * The endpoint name that details Glusterfs topology. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#endpoints_name Daemonset#endpoints_name}
    */
    readonly endpointsName: string;
    /**
    * The Glusterfs volume path. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path: string;
    /**
    * Whether to force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecVolumeGlusterfsToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeGlusterfsOutputReference | DaemonsetSpecTemplateSpecVolumeGlusterfs): any;
export declare class DaemonsetSpecTemplateSpecVolumeGlusterfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeGlusterfs | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeGlusterfs | undefined);
    private _endpointsName?;
    get endpointsName(): string;
    set endpointsName(value: string);
    get endpointsNameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeHostPath {
    /**
    * Path of the directory on the host. More info: http://kubernetes.io/docs/user-guide/volumes#hostpath
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
    /**
    * Type for HostPath volume. Allowed values are "" (default), DirectoryOrCreate, Directory, FileOrCreate, File, Socket, CharDevice and BlockDevice
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#type Daemonset#type}
    */
    readonly type?: string;
}
export declare function daemonsetSpecTemplateSpecVolumeHostPathToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeHostPathOutputReference | DaemonsetSpecTemplateSpecVolumeHostPath): any;
export declare class DaemonsetSpecTemplateSpecVolumeHostPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeHostPath | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeHostPath | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeIscsi {
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#iscsi
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#fs_type Daemonset#fs_type}
    */
    readonly fsType?: string;
    /**
    * Target iSCSI Qualified Name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#iqn Daemonset#iqn}
    */
    readonly iqn: string;
    /**
    * iSCSI interface name that uses an iSCSI transport. Defaults to 'default' (tcp).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#iscsi_interface Daemonset#iscsi_interface}
    */
    readonly iscsiInterface?: string;
    /**
    * iSCSI target lun number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#lun Daemonset#lun}
    */
    readonly lun?: number;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * iSCSI target portal. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#target_portal Daemonset#target_portal}
    */
    readonly targetPortal: string;
}
export declare function daemonsetSpecTemplateSpecVolumeIscsiToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeIscsiOutputReference | DaemonsetSpecTemplateSpecVolumeIscsi): any;
export declare class DaemonsetSpecTemplateSpecVolumeIscsiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeIscsi | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeIscsi | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _iqn?;
    get iqn(): string;
    set iqn(value: string);
    get iqnInput(): string | undefined;
    private _iscsiInterface?;
    get iscsiInterface(): string;
    set iscsiInterface(value: string);
    resetIscsiInterface(): void;
    get iscsiInterfaceInput(): string | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    resetLun(): void;
    get lunInput(): number | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _targetPortal?;
    get targetPortal(): string;
    set targetPortal(value: string);
    get targetPortalInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeLocal {
    /**
    * Path of the directory on the host. More info: http://kubernetes.io/docs/user-guide/volumes#local
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
}
export declare function daemonsetSpecTemplateSpecVolumeLocalToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeLocalOutputReference | DaemonsetSpecTemplateSpecVolumeLocal): any;
export declare class DaemonsetSpecTemplateSpecVolumeLocalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeLocal | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeLocal | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeNfs {
    /**
    * Path that is exported by the NFS server. More info: http://kubernetes.io/docs/user-guide/volumes#nfs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path: string;
    /**
    * Whether to force the NFS export to be mounted with read-only permissions. Defaults to false. More info: http://kubernetes.io/docs/user-guide/volumes#nfs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Server is the hostname or IP address of the NFS server. More info: http://kubernetes.io/docs/user-guide/volumes#nfs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#server Daemonset#server}
    */
    readonly server: string;
}
export declare function daemonsetSpecTemplateSpecVolumeNfsToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeNfsOutputReference | DaemonsetSpecTemplateSpecVolumeNfs): any;
export declare class DaemonsetSpecTemplateSpecVolumeNfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeNfs | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeNfs | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumePersistentVolumeClaim {
    /**
    * ClaimName is the name of a PersistentVolumeClaim in the same
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#claim_name Daemonset#claim_name}
    */
    readonly claimName?: string;
    /**
    * Will force the ReadOnly setting in VolumeMounts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecVolumePersistentVolumeClaimToTerraform(struct?: DaemonsetSpecTemplateSpecVolumePersistentVolumeClaimOutputReference | DaemonsetSpecTemplateSpecVolumePersistentVolumeClaim): any;
export declare class DaemonsetSpecTemplateSpecVolumePersistentVolumeClaimOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumePersistentVolumeClaim | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumePersistentVolumeClaim | undefined);
    private _claimName?;
    get claimName(): string;
    set claimName(value: string);
    resetClaimName(): void;
    get claimNameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumePhotonPersistentDisk {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#fs_type Daemonset#fs_type}
    */
    readonly fsType?: string;
    /**
    * ID that identifies Photon Controller persistent disk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#pd_id Daemonset#pd_id}
    */
    readonly pdId: string;
}
export declare function daemonsetSpecTemplateSpecVolumePhotonPersistentDiskToTerraform(struct?: DaemonsetSpecTemplateSpecVolumePhotonPersistentDiskOutputReference | DaemonsetSpecTemplateSpecVolumePhotonPersistentDisk): any;
export declare class DaemonsetSpecTemplateSpecVolumePhotonPersistentDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumePhotonPersistentDisk | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumePhotonPersistentDisk | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _pdId?;
    get pdId(): string;
    set pdId(value: string);
    get pdIdInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#mode Daemonset#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
}
export declare function daemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapItemsToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapItems | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapItems | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapItemsOutputReference;
}
export interface DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMap {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * Optional: Specify whether the ConfigMap or it's keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#optional Daemonset#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#items Daemonset#items}
    */
    readonly items?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapItems[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMap | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMap | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMap | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _items;
    get items(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapItemsList;
    putItems(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapItems[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMap[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapOutputReference;
}
export interface DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to 'v1'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#api_version Daemonset#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#field_path Daemonset#field_path}
    */
    readonly fieldPath?: string;
}
export declare function daemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRefToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRefOutputReference | DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef): any;
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#container_name Daemonset#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#divisor Daemonset#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#resource Daemonset#resource}
    */
    readonly resource: string;
}
export declare function daemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefOutputReference | DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef): any;
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems {
    /**
    * Mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#mode Daemonset#mode}
    */
    readonly mode?: string;
    /**
    * Path is the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path: string;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#field_ref Daemonset#field_ref}
    */
    readonly fieldRef?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#resource_field_ref Daemonset#resource_field_ref}
    */
    readonly resourceFieldRef?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef;
}
export declare function daemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _fieldRef;
    get fieldRef(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRefOutputReference;
    putFieldRef(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef): void;
    resetFieldRef(): void;
    get fieldRefInput(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefOutputReference;
    putResourceFieldRef(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef | undefined;
}
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsOutputReference;
}
export interface DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApi {
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#items Daemonset#items}
    */
    readonly items?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiOutputReference | DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApi): any;
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApi | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApi | undefined);
    private _items;
    get items(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsList;
    putItems(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems[] | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#mode Daemonset#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
}
export declare function daemonsetSpecTemplateSpecVolumeProjectedSourcesSecretItemsToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretItems | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretItemsOutputReference;
}
export interface DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecret {
    /**
    * Name of the secret in the pod's namespace to use. More info: http://kubernetes.io/docs/user-guide/volumes#secrets
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * Optional: Specify whether the Secret or it's keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#optional Daemonset#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#items Daemonset#items}
    */
    readonly items?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretItems[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecVolumeProjectedSourcesSecretToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecret | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecret | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecret | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _items;
    get items(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretItemsList;
    putItems(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretItems[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretOutputReference;
}
export interface DaemonsetSpecTemplateSpecVolumeProjectedSourcesServiceAccountToken {
    /**
    * Audience is the intended audience of the token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#audience Daemonset#audience}
    */
    readonly audience?: string;
    /**
    * ExpirationSeconds is the expected duration of validity of the service account token. It defaults to 1 hour and must be at least 10 minutes (600 seconds).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#expiration_seconds Daemonset#expiration_seconds}
    */
    readonly expirationSeconds?: number;
    /**
    * Path specifies a relative path to the mount point of the projected volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path: string;
}
export declare function daemonsetSpecTemplateSpecVolumeProjectedSourcesServiceAccountTokenToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesServiceAccountTokenOutputReference | DaemonsetSpecTemplateSpecVolumeProjectedSourcesServiceAccountToken): any;
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesServiceAccountTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesServiceAccountToken | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesServiceAccountToken | undefined);
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _expirationSeconds?;
    get expirationSeconds(): number;
    set expirationSeconds(value: number);
    resetExpirationSeconds(): void;
    get expirationSecondsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeProjectedSources {
    /**
    * config_map block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#config_map Daemonset#config_map}
    */
    readonly configMap?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMap[] | cdktf.IResolvable;
    /**
    * downward_api block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#downward_api Daemonset#downward_api}
    */
    readonly downwardApi?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApi;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#secret Daemonset#secret}
    */
    readonly secret?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecret[] | cdktf.IResolvable;
    /**
    * service_account_token block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#service_account_token Daemonset#service_account_token}
    */
    readonly serviceAccountToken?: DaemonsetSpecTemplateSpecVolumeProjectedSourcesServiceAccountToken;
}
export declare function daemonsetSpecTemplateSpecVolumeProjectedSourcesToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeProjectedSources | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeProjectedSources | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeProjectedSources | cdktf.IResolvable | undefined);
    private _configMap;
    get configMap(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMapList;
    putConfigMap(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMap[] | cdktf.IResolvable): void;
    resetConfigMap(): void;
    get configMapInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecVolumeProjectedSourcesConfigMap[] | undefined;
    private _downwardApi;
    get downwardApi(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApiOutputReference;
    putDownwardApi(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApi): void;
    resetDownwardApi(): void;
    get downwardApiInput(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesDownwardApi | undefined;
    private _secret;
    get secret(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecretList;
    putSecret(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecVolumeProjectedSourcesSecret[] | undefined;
    private _serviceAccountToken;
    get serviceAccountToken(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesServiceAccountTokenOutputReference;
    putServiceAccountToken(value: DaemonsetSpecTemplateSpecVolumeProjectedSourcesServiceAccountToken): void;
    resetServiceAccountToken(): void;
    get serviceAccountTokenInput(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesServiceAccountToken | undefined;
}
export declare class DaemonsetSpecTemplateSpecVolumeProjectedSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecVolumeProjectedSources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecVolumeProjectedSourcesOutputReference;
}
export interface DaemonsetSpecTemplateSpecVolumeProjected {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#default_mode Daemonset#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * sources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#sources Daemonset#sources}
    */
    readonly sources: DaemonsetSpecTemplateSpecVolumeProjectedSources[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecVolumeProjectedToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeProjected | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecVolumeProjectedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeProjected | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeProjected | cdktf.IResolvable | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _sources;
    get sources(): DaemonsetSpecTemplateSpecVolumeProjectedSourcesList;
    putSources(value: DaemonsetSpecTemplateSpecVolumeProjectedSources[] | cdktf.IResolvable): void;
    get sourcesInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecVolumeProjectedSources[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecVolumeProjectedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecVolumeProjected[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecVolumeProjectedOutputReference;
}
export interface DaemonsetSpecTemplateSpecVolumeQuobyte {
    /**
    * Group to map volume access to Default is no group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#group Daemonset#group}
    */
    readonly group?: string;
    /**
    * Whether to force the Quobyte volume to be mounted with read-only permissions. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#registry Daemonset#registry}
    */
    readonly registry: string;
    /**
    * User to map volume access to Defaults to serivceaccount user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#user Daemonset#user}
    */
    readonly user?: string;
    /**
    * Volume is a string that references an already created Quobyte volume by name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#volume Daemonset#volume}
    */
    readonly volume: string;
}
export declare function daemonsetSpecTemplateSpecVolumeQuobyteToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeQuobyteOutputReference | DaemonsetSpecTemplateSpecVolumeQuobyte): any;
export declare class DaemonsetSpecTemplateSpecVolumeQuobyteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeQuobyte | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeQuobyte | undefined);
    private _group?;
    get group(): string;
    set group(value: string);
    resetGroup(): void;
    get groupInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _registry?;
    get registry(): string;
    set registry(value: string);
    get registryInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
    private _volume?;
    get volume(): string;
    set volume(value: string);
    get volumeInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeRbdSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#namespace Daemonset#namespace}
    */
    readonly namespace?: string;
}
export declare function daemonsetSpecTemplateSpecVolumeRbdSecretRefToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeRbdSecretRefOutputReference | DaemonsetSpecTemplateSpecVolumeRbdSecretRef): any;
export declare class DaemonsetSpecTemplateSpecVolumeRbdSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeRbdSecretRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeRbdSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeRbd {
    /**
    * A collection of Ceph monitors. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#ceph_monitors Daemonset#ceph_monitors}
    */
    readonly cephMonitors: string[];
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#rbd
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#fs_type Daemonset#fs_type}
    */
    readonly fsType?: string;
    /**
    * Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#keyring Daemonset#keyring}
    */
    readonly keyring?: string;
    /**
    * The rados user name. Default is admin. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#rados_user Daemonset#rados_user}
    */
    readonly radosUser?: string;
    /**
    * The rados image name. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#rbd_image Daemonset#rbd_image}
    */
    readonly rbdImage: string;
    /**
    * The rados pool name. Default is rbd. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#rbd_pool Daemonset#rbd_pool}
    */
    readonly rbdPool?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#secret_ref Daemonset#secret_ref}
    */
    readonly secretRef?: DaemonsetSpecTemplateSpecVolumeRbdSecretRef;
}
export declare function daemonsetSpecTemplateSpecVolumeRbdToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeRbdOutputReference | DaemonsetSpecTemplateSpecVolumeRbd): any;
export declare class DaemonsetSpecTemplateSpecVolumeRbdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeRbd | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeRbd | undefined);
    private _cephMonitors?;
    get cephMonitors(): string[];
    set cephMonitors(value: string[]);
    get cephMonitorsInput(): string[] | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _keyring?;
    get keyring(): string;
    set keyring(value: string);
    resetKeyring(): void;
    get keyringInput(): string | undefined;
    private _radosUser?;
    get radosUser(): string;
    set radosUser(value: string);
    resetRadosUser(): void;
    get radosUserInput(): string | undefined;
    private _rbdImage?;
    get rbdImage(): string;
    set rbdImage(value: string);
    get rbdImageInput(): string | undefined;
    private _rbdPool?;
    get rbdPool(): string;
    set rbdPool(value: string);
    resetRbdPool(): void;
    get rbdPoolInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretRef;
    get secretRef(): DaemonsetSpecTemplateSpecVolumeRbdSecretRefOutputReference;
    putSecretRef(value: DaemonsetSpecTemplateSpecVolumeRbdSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): DaemonsetSpecTemplateSpecVolumeRbdSecretRef | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeSecretItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#mode Daemonset#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
}
export declare function daemonsetSpecTemplateSpecVolumeSecretItemsToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeSecretItems | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecVolumeSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeSecretItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecVolumeSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecVolumeSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecVolumeSecretItemsOutputReference;
}
export interface DaemonsetSpecTemplateSpecVolumeSecret {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#default_mode Daemonset#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * Optional: Specify whether the Secret or its keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#optional Daemonset#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * Name of the secret in the pod's namespace to use. More info: http://kubernetes.io/docs/user-guide/volumes#secrets
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#secret_name Daemonset#secret_name}
    */
    readonly secretName?: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#items Daemonset#items}
    */
    readonly items?: DaemonsetSpecTemplateSpecVolumeSecretItems[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecVolumeSecretToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeSecretOutputReference | DaemonsetSpecTemplateSpecVolumeSecret): any;
export declare class DaemonsetSpecTemplateSpecVolumeSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeSecret | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeSecret | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    resetSecretName(): void;
    get secretNameInput(): string | undefined;
    private _items;
    get items(): DaemonsetSpecTemplateSpecVolumeSecretItemsList;
    putItems(value: DaemonsetSpecTemplateSpecVolumeSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecVolumeSecretItems[] | undefined;
}
export interface DaemonsetSpecTemplateSpecVolumeVsphereVolume {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#fs_type Daemonset#fs_type}
    */
    readonly fsType?: string;
    /**
    * Path that identifies vSphere volume vmdk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#volume_path Daemonset#volume_path}
    */
    readonly volumePath: string;
}
export declare function daemonsetSpecTemplateSpecVolumeVsphereVolumeToTerraform(struct?: DaemonsetSpecTemplateSpecVolumeVsphereVolumeOutputReference | DaemonsetSpecTemplateSpecVolumeVsphereVolume): any;
export declare class DaemonsetSpecTemplateSpecVolumeVsphereVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecVolumeVsphereVolume | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolumeVsphereVolume | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _volumePath?;
    get volumePath(): string;
    set volumePath(value: string);
    get volumePathInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecVolume {
    /**
    * Volume's name. Must be a DNS_LABEL and unique within the pod. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * aws_elastic_block_store block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#aws_elastic_block_store Daemonset#aws_elastic_block_store}
    */
    readonly awsElasticBlockStore?: DaemonsetSpecTemplateSpecVolumeAwsElasticBlockStore;
    /**
    * azure_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#azure_disk Daemonset#azure_disk}
    */
    readonly azureDisk?: DaemonsetSpecTemplateSpecVolumeAzureDisk;
    /**
    * azure_file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#azure_file Daemonset#azure_file}
    */
    readonly azureFile?: DaemonsetSpecTemplateSpecVolumeAzureFile;
    /**
    * ceph_fs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#ceph_fs Daemonset#ceph_fs}
    */
    readonly cephFs?: DaemonsetSpecTemplateSpecVolumeCephFs;
    /**
    * cinder block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#cinder Daemonset#cinder}
    */
    readonly cinder?: DaemonsetSpecTemplateSpecVolumeCinder;
    /**
    * config_map block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#config_map Daemonset#config_map}
    */
    readonly configMap?: DaemonsetSpecTemplateSpecVolumeConfigMap;
    /**
    * csi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#csi Daemonset#csi}
    */
    readonly csi?: DaemonsetSpecTemplateSpecVolumeCsi;
    /**
    * downward_api block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#downward_api Daemonset#downward_api}
    */
    readonly downwardApi?: DaemonsetSpecTemplateSpecVolumeDownwardApi;
    /**
    * empty_dir block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#empty_dir Daemonset#empty_dir}
    */
    readonly emptyDir?: DaemonsetSpecTemplateSpecVolumeEmptyDir;
    /**
    * fc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#fc Daemonset#fc}
    */
    readonly fc?: DaemonsetSpecTemplateSpecVolumeFc;
    /**
    * flex_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#flex_volume Daemonset#flex_volume}
    */
    readonly flexVolume?: DaemonsetSpecTemplateSpecVolumeFlexVolume;
    /**
    * flocker block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#flocker Daemonset#flocker}
    */
    readonly flocker?: DaemonsetSpecTemplateSpecVolumeFlocker;
    /**
    * gce_persistent_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#gce_persistent_disk Daemonset#gce_persistent_disk}
    */
    readonly gcePersistentDisk?: DaemonsetSpecTemplateSpecVolumeGcePersistentDisk;
    /**
    * git_repo block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#git_repo Daemonset#git_repo}
    */
    readonly gitRepo?: DaemonsetSpecTemplateSpecVolumeGitRepo;
    /**
    * glusterfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#glusterfs Daemonset#glusterfs}
    */
    readonly glusterfs?: DaemonsetSpecTemplateSpecVolumeGlusterfs;
    /**
    * host_path block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host_path Daemonset#host_path}
    */
    readonly hostPath?: DaemonsetSpecTemplateSpecVolumeHostPath;
    /**
    * iscsi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#iscsi Daemonset#iscsi}
    */
    readonly iscsi?: DaemonsetSpecTemplateSpecVolumeIscsi;
    /**
    * local block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#local Daemonset#local}
    */
    readonly local?: DaemonsetSpecTemplateSpecVolumeLocal;
    /**
    * nfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#nfs Daemonset#nfs}
    */
    readonly nfs?: DaemonsetSpecTemplateSpecVolumeNfs;
    /**
    * persistent_volume_claim block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#persistent_volume_claim Daemonset#persistent_volume_claim}
    */
    readonly persistentVolumeClaim?: DaemonsetSpecTemplateSpecVolumePersistentVolumeClaim;
    /**
    * photon_persistent_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#photon_persistent_disk Daemonset#photon_persistent_disk}
    */
    readonly photonPersistentDisk?: DaemonsetSpecTemplateSpecVolumePhotonPersistentDisk;
    /**
    * projected block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#projected Daemonset#projected}
    */
    readonly projected?: DaemonsetSpecTemplateSpecVolumeProjected[] | cdktf.IResolvable;
    /**
    * quobyte block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#quobyte Daemonset#quobyte}
    */
    readonly quobyte?: DaemonsetSpecTemplateSpecVolumeQuobyte;
    /**
    * rbd block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#rbd Daemonset#rbd}
    */
    readonly rbd?: DaemonsetSpecTemplateSpecVolumeRbd;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#secret Daemonset#secret}
    */
    readonly secret?: DaemonsetSpecTemplateSpecVolumeSecret;
    /**
    * vsphere_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#vsphere_volume Daemonset#vsphere_volume}
    */
    readonly vsphereVolume?: DaemonsetSpecTemplateSpecVolumeVsphereVolume;
}
export declare function daemonsetSpecTemplateSpecVolumeToTerraform(struct?: DaemonsetSpecTemplateSpecVolume | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecVolume | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecVolume | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _awsElasticBlockStore;
    get awsElasticBlockStore(): DaemonsetSpecTemplateSpecVolumeAwsElasticBlockStoreOutputReference;
    putAwsElasticBlockStore(value: DaemonsetSpecTemplateSpecVolumeAwsElasticBlockStore): void;
    resetAwsElasticBlockStore(): void;
    get awsElasticBlockStoreInput(): DaemonsetSpecTemplateSpecVolumeAwsElasticBlockStore | undefined;
    private _azureDisk;
    get azureDisk(): DaemonsetSpecTemplateSpecVolumeAzureDiskOutputReference;
    putAzureDisk(value: DaemonsetSpecTemplateSpecVolumeAzureDisk): void;
    resetAzureDisk(): void;
    get azureDiskInput(): DaemonsetSpecTemplateSpecVolumeAzureDisk | undefined;
    private _azureFile;
    get azureFile(): DaemonsetSpecTemplateSpecVolumeAzureFileOutputReference;
    putAzureFile(value: DaemonsetSpecTemplateSpecVolumeAzureFile): void;
    resetAzureFile(): void;
    get azureFileInput(): DaemonsetSpecTemplateSpecVolumeAzureFile | undefined;
    private _cephFs;
    get cephFs(): DaemonsetSpecTemplateSpecVolumeCephFsOutputReference;
    putCephFs(value: DaemonsetSpecTemplateSpecVolumeCephFs): void;
    resetCephFs(): void;
    get cephFsInput(): DaemonsetSpecTemplateSpecVolumeCephFs | undefined;
    private _cinder;
    get cinder(): DaemonsetSpecTemplateSpecVolumeCinderOutputReference;
    putCinder(value: DaemonsetSpecTemplateSpecVolumeCinder): void;
    resetCinder(): void;
    get cinderInput(): DaemonsetSpecTemplateSpecVolumeCinder | undefined;
    private _configMap;
    get configMap(): DaemonsetSpecTemplateSpecVolumeConfigMapOutputReference;
    putConfigMap(value: DaemonsetSpecTemplateSpecVolumeConfigMap): void;
    resetConfigMap(): void;
    get configMapInput(): DaemonsetSpecTemplateSpecVolumeConfigMap | undefined;
    private _csi;
    get csi(): DaemonsetSpecTemplateSpecVolumeCsiOutputReference;
    putCsi(value: DaemonsetSpecTemplateSpecVolumeCsi): void;
    resetCsi(): void;
    get csiInput(): DaemonsetSpecTemplateSpecVolumeCsi | undefined;
    private _downwardApi;
    get downwardApi(): DaemonsetSpecTemplateSpecVolumeDownwardApiOutputReference;
    putDownwardApi(value: DaemonsetSpecTemplateSpecVolumeDownwardApi): void;
    resetDownwardApi(): void;
    get downwardApiInput(): DaemonsetSpecTemplateSpecVolumeDownwardApi | undefined;
    private _emptyDir;
    get emptyDir(): DaemonsetSpecTemplateSpecVolumeEmptyDirOutputReference;
    putEmptyDir(value: DaemonsetSpecTemplateSpecVolumeEmptyDir): void;
    resetEmptyDir(): void;
    get emptyDirInput(): DaemonsetSpecTemplateSpecVolumeEmptyDir | undefined;
    private _fc;
    get fc(): DaemonsetSpecTemplateSpecVolumeFcOutputReference;
    putFc(value: DaemonsetSpecTemplateSpecVolumeFc): void;
    resetFc(): void;
    get fcInput(): DaemonsetSpecTemplateSpecVolumeFc | undefined;
    private _flexVolume;
    get flexVolume(): DaemonsetSpecTemplateSpecVolumeFlexVolumeOutputReference;
    putFlexVolume(value: DaemonsetSpecTemplateSpecVolumeFlexVolume): void;
    resetFlexVolume(): void;
    get flexVolumeInput(): DaemonsetSpecTemplateSpecVolumeFlexVolume | undefined;
    private _flocker;
    get flocker(): DaemonsetSpecTemplateSpecVolumeFlockerOutputReference;
    putFlocker(value: DaemonsetSpecTemplateSpecVolumeFlocker): void;
    resetFlocker(): void;
    get flockerInput(): DaemonsetSpecTemplateSpecVolumeFlocker | undefined;
    private _gcePersistentDisk;
    get gcePersistentDisk(): DaemonsetSpecTemplateSpecVolumeGcePersistentDiskOutputReference;
    putGcePersistentDisk(value: DaemonsetSpecTemplateSpecVolumeGcePersistentDisk): void;
    resetGcePersistentDisk(): void;
    get gcePersistentDiskInput(): DaemonsetSpecTemplateSpecVolumeGcePersistentDisk | undefined;
    private _gitRepo;
    get gitRepo(): DaemonsetSpecTemplateSpecVolumeGitRepoOutputReference;
    putGitRepo(value: DaemonsetSpecTemplateSpecVolumeGitRepo): void;
    resetGitRepo(): void;
    get gitRepoInput(): DaemonsetSpecTemplateSpecVolumeGitRepo | undefined;
    private _glusterfs;
    get glusterfs(): DaemonsetSpecTemplateSpecVolumeGlusterfsOutputReference;
    putGlusterfs(value: DaemonsetSpecTemplateSpecVolumeGlusterfs): void;
    resetGlusterfs(): void;
    get glusterfsInput(): DaemonsetSpecTemplateSpecVolumeGlusterfs | undefined;
    private _hostPath;
    get hostPath(): DaemonsetSpecTemplateSpecVolumeHostPathOutputReference;
    putHostPath(value: DaemonsetSpecTemplateSpecVolumeHostPath): void;
    resetHostPath(): void;
    get hostPathInput(): DaemonsetSpecTemplateSpecVolumeHostPath | undefined;
    private _iscsi;
    get iscsi(): DaemonsetSpecTemplateSpecVolumeIscsiOutputReference;
    putIscsi(value: DaemonsetSpecTemplateSpecVolumeIscsi): void;
    resetIscsi(): void;
    get iscsiInput(): DaemonsetSpecTemplateSpecVolumeIscsi | undefined;
    private _local;
    get local(): DaemonsetSpecTemplateSpecVolumeLocalOutputReference;
    putLocal(value: DaemonsetSpecTemplateSpecVolumeLocal): void;
    resetLocal(): void;
    get localInput(): DaemonsetSpecTemplateSpecVolumeLocal | undefined;
    private _nfs;
    get nfs(): DaemonsetSpecTemplateSpecVolumeNfsOutputReference;
    putNfs(value: DaemonsetSpecTemplateSpecVolumeNfs): void;
    resetNfs(): void;
    get nfsInput(): DaemonsetSpecTemplateSpecVolumeNfs | undefined;
    private _persistentVolumeClaim;
    get persistentVolumeClaim(): DaemonsetSpecTemplateSpecVolumePersistentVolumeClaimOutputReference;
    putPersistentVolumeClaim(value: DaemonsetSpecTemplateSpecVolumePersistentVolumeClaim): void;
    resetPersistentVolumeClaim(): void;
    get persistentVolumeClaimInput(): DaemonsetSpecTemplateSpecVolumePersistentVolumeClaim | undefined;
    private _photonPersistentDisk;
    get photonPersistentDisk(): DaemonsetSpecTemplateSpecVolumePhotonPersistentDiskOutputReference;
    putPhotonPersistentDisk(value: DaemonsetSpecTemplateSpecVolumePhotonPersistentDisk): void;
    resetPhotonPersistentDisk(): void;
    get photonPersistentDiskInput(): DaemonsetSpecTemplateSpecVolumePhotonPersistentDisk | undefined;
    private _projected;
    get projected(): DaemonsetSpecTemplateSpecVolumeProjectedList;
    putProjected(value: DaemonsetSpecTemplateSpecVolumeProjected[] | cdktf.IResolvable): void;
    resetProjected(): void;
    get projectedInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecVolumeProjected[] | undefined;
    private _quobyte;
    get quobyte(): DaemonsetSpecTemplateSpecVolumeQuobyteOutputReference;
    putQuobyte(value: DaemonsetSpecTemplateSpecVolumeQuobyte): void;
    resetQuobyte(): void;
    get quobyteInput(): DaemonsetSpecTemplateSpecVolumeQuobyte | undefined;
    private _rbd;
    get rbd(): DaemonsetSpecTemplateSpecVolumeRbdOutputReference;
    putRbd(value: DaemonsetSpecTemplateSpecVolumeRbd): void;
    resetRbd(): void;
    get rbdInput(): DaemonsetSpecTemplateSpecVolumeRbd | undefined;
    private _secret;
    get secret(): DaemonsetSpecTemplateSpecVolumeSecretOutputReference;
    putSecret(value: DaemonsetSpecTemplateSpecVolumeSecret): void;
    resetSecret(): void;
    get secretInput(): DaemonsetSpecTemplateSpecVolumeSecret | undefined;
    private _vsphereVolume;
    get vsphereVolume(): DaemonsetSpecTemplateSpecVolumeVsphereVolumeOutputReference;
    putVsphereVolume(value: DaemonsetSpecTemplateSpecVolumeVsphereVolume): void;
    resetVsphereVolume(): void;
    get vsphereVolumeInput(): DaemonsetSpecTemplateSpecVolumeVsphereVolume | undefined;
}
export declare class DaemonsetSpecTemplateSpecVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecVolume[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecVolumeOutputReference;
}
export interface DaemonsetSpecTemplateSpec {
    /**
    * Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#active_deadline_seconds Daemonset#active_deadline_seconds}
    */
    readonly activeDeadlineSeconds?: number;
    /**
    * AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#automount_service_account_token Daemonset#automount_service_account_token}
    */
    readonly automountServiceAccountToken?: boolean | cdktf.IResolvable;
    /**
    * Set DNS policy for containers within the pod. Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'. Optional: Defaults to 'ClusterFirst', see [Kubernetes reference](https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#dns_policy Daemonset#dns_policy}
    */
    readonly dnsPolicy?: string;
    /**
    * Enables generating environment variables for service discovery. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#enable_service_links Daemonset#enable_service_links}
    */
    readonly enableServiceLinks?: boolean | cdktf.IResolvable;
    /**
    * Use the host's ipc namespace. Optional: Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host_ipc Daemonset#host_ipc}
    */
    readonly hostIpc?: boolean | cdktf.IResolvable;
    /**
    * Host networking requested for this pod. Use the host's network namespace. If this option is set, the ports that will be used must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host_network Daemonset#host_network}
    */
    readonly hostNetwork?: boolean | cdktf.IResolvable;
    /**
    * Use the host's pid namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host_pid Daemonset#host_pid}
    */
    readonly hostPid?: boolean | cdktf.IResolvable;
    /**
    * Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#hostname Daemonset#hostname}
    */
    readonly hostname?: string;
    /**
    * NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#node_name Daemonset#node_name}
    */
    readonly nodeName?: string;
    /**
    * NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: http://kubernetes.io/docs/user-guide/node-selection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#node_selector Daemonset#node_selector}
    */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
    * If specified, indicates the pod's priority. "system-node-critical" and "system-cluster-critical" are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#priority_class_name Daemonset#priority_class_name}
    */
    readonly priorityClassName?: string;
    /**
    * Restart policy for all containers within the pod. One of Always, OnFailure, Never. More info: http://kubernetes.io/docs/user-guide/pod-states#restartpolicy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#restart_policy Daemonset#restart_policy}
    */
    readonly restartPolicy?: string;
    /**
    * RuntimeClassName is a feature for selecting the container runtime configuration. The container runtime configuration is used to run a Pod's containers. More info: https://kubernetes.io/docs/concepts/containers/runtime-class
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#runtime_class_name Daemonset#runtime_class_name}
    */
    readonly runtimeClassName?: string;
    /**
    * ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: http://releases.k8s.io/HEAD/docs/design/service_accounts.md.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#service_account_name Daemonset#service_account_name}
    */
    readonly serviceAccountName?: string;
    /**
    * Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#share_process_namespace Daemonset#share_process_namespace}
    */
    readonly shareProcessNamespace?: boolean | cdktf.IResolvable;
    /**
    * If specified, the fully qualified Pod hostname will be "...svc.". If not specified, the pod will not have a domainname at all..
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#subdomain Daemonset#subdomain}
    */
    readonly subdomain?: string;
    /**
    * Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#termination_grace_period_seconds Daemonset#termination_grace_period_seconds}
    */
    readonly terminationGracePeriodSeconds?: number;
    /**
    * affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#affinity Daemonset#affinity}
    */
    readonly affinity?: DaemonsetSpecTemplateSpecAffinity;
    /**
    * container block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#container Daemonset#container}
    */
    readonly container?: DaemonsetSpecTemplateSpecContainer[] | cdktf.IResolvable;
    /**
    * dns_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#dns_config Daemonset#dns_config}
    */
    readonly dnsConfig?: DaemonsetSpecTemplateSpecDnsConfig;
    /**
    * host_aliases block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host_aliases Daemonset#host_aliases}
    */
    readonly hostAliases?: DaemonsetSpecTemplateSpecHostAliases[] | cdktf.IResolvable;
    /**
    * image_pull_secrets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#image_pull_secrets Daemonset#image_pull_secrets}
    */
    readonly imagePullSecrets?: DaemonsetSpecTemplateSpecImagePullSecrets[] | cdktf.IResolvable;
    /**
    * init_container block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#init_container Daemonset#init_container}
    */
    readonly initContainer?: DaemonsetSpecTemplateSpecInitContainer[] | cdktf.IResolvable;
    /**
    * readiness_gate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#readiness_gate Daemonset#readiness_gate}
    */
    readonly readinessGate?: DaemonsetSpecTemplateSpecReadinessGate[] | cdktf.IResolvable;
    /**
    * security_context block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#security_context Daemonset#security_context}
    */
    readonly securityContext?: DaemonsetSpecTemplateSpecSecurityContext;
    /**
    * toleration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#toleration Daemonset#toleration}
    */
    readonly toleration?: DaemonsetSpecTemplateSpecToleration[] | cdktf.IResolvable;
    /**
    * topology_spread_constraint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#topology_spread_constraint Daemonset#topology_spread_constraint}
    */
    readonly topologySpreadConstraint?: DaemonsetSpecTemplateSpecTopologySpreadConstraint[] | cdktf.IResolvable;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#volume Daemonset#volume}
    */
    readonly volume?: DaemonsetSpecTemplateSpecVolume[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecToTerraform(struct?: DaemonsetSpecTemplateSpecOutputReference | DaemonsetSpecTemplateSpec): any;
export declare class DaemonsetSpecTemplateSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpec | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpec | undefined);
    private _activeDeadlineSeconds?;
    get activeDeadlineSeconds(): number;
    set activeDeadlineSeconds(value: number);
    resetActiveDeadlineSeconds(): void;
    get activeDeadlineSecondsInput(): number | undefined;
    private _automountServiceAccountToken?;
    get automountServiceAccountToken(): boolean | cdktf.IResolvable;
    set automountServiceAccountToken(value: boolean | cdktf.IResolvable);
    resetAutomountServiceAccountToken(): void;
    get automountServiceAccountTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _dnsPolicy?;
    get dnsPolicy(): string;
    set dnsPolicy(value: string);
    resetDnsPolicy(): void;
    get dnsPolicyInput(): string | undefined;
    private _enableServiceLinks?;
    get enableServiceLinks(): boolean | cdktf.IResolvable;
    set enableServiceLinks(value: boolean | cdktf.IResolvable);
    resetEnableServiceLinks(): void;
    get enableServiceLinksInput(): boolean | cdktf.IResolvable | undefined;
    private _hostIpc?;
    get hostIpc(): boolean | cdktf.IResolvable;
    set hostIpc(value: boolean | cdktf.IResolvable);
    resetHostIpc(): void;
    get hostIpcInput(): boolean | cdktf.IResolvable | undefined;
    private _hostNetwork?;
    get hostNetwork(): boolean | cdktf.IResolvable;
    set hostNetwork(value: boolean | cdktf.IResolvable);
    resetHostNetwork(): void;
    get hostNetworkInput(): boolean | cdktf.IResolvable | undefined;
    private _hostPid?;
    get hostPid(): boolean | cdktf.IResolvable;
    set hostPid(value: boolean | cdktf.IResolvable);
    resetHostPid(): void;
    get hostPidInput(): boolean | cdktf.IResolvable | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _nodeName?;
    get nodeName(): string;
    set nodeName(value: string);
    resetNodeName(): void;
    get nodeNameInput(): string | undefined;
    private _nodeSelector?;
    get nodeSelector(): {
        [key: string]: string;
    };
    set nodeSelector(value: {
        [key: string]: string;
    });
    resetNodeSelector(): void;
    get nodeSelectorInput(): {
        [key: string]: string;
    } | undefined;
    private _priorityClassName?;
    get priorityClassName(): string;
    set priorityClassName(value: string);
    resetPriorityClassName(): void;
    get priorityClassNameInput(): string | undefined;
    private _restartPolicy?;
    get restartPolicy(): string;
    set restartPolicy(value: string);
    resetRestartPolicy(): void;
    get restartPolicyInput(): string | undefined;
    private _runtimeClassName?;
    get runtimeClassName(): string;
    set runtimeClassName(value: string);
    resetRuntimeClassName(): void;
    get runtimeClassNameInput(): string | undefined;
    private _serviceAccountName?;
    get serviceAccountName(): string;
    set serviceAccountName(value: string);
    resetServiceAccountName(): void;
    get serviceAccountNameInput(): string | undefined;
    private _shareProcessNamespace?;
    get shareProcessNamespace(): boolean | cdktf.IResolvable;
    set shareProcessNamespace(value: boolean | cdktf.IResolvable);
    resetShareProcessNamespace(): void;
    get shareProcessNamespaceInput(): boolean | cdktf.IResolvable | undefined;
    private _subdomain?;
    get subdomain(): string;
    set subdomain(value: string);
    resetSubdomain(): void;
    get subdomainInput(): string | undefined;
    private _terminationGracePeriodSeconds?;
    get terminationGracePeriodSeconds(): number;
    set terminationGracePeriodSeconds(value: number);
    resetTerminationGracePeriodSeconds(): void;
    get terminationGracePeriodSecondsInput(): number | undefined;
    private _affinity;
    get affinity(): DaemonsetSpecTemplateSpecAffinityOutputReference;
    putAffinity(value: DaemonsetSpecTemplateSpecAffinity): void;
    resetAffinity(): void;
    get affinityInput(): DaemonsetSpecTemplateSpecAffinity | undefined;
    private _container;
    get container(): DaemonsetSpecTemplateSpecContainerList;
    putContainer(value: DaemonsetSpecTemplateSpecContainer[] | cdktf.IResolvable): void;
    resetContainer(): void;
    get containerInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainer[] | undefined;
    private _dnsConfig;
    get dnsConfig(): DaemonsetSpecTemplateSpecDnsConfigOutputReference;
    putDnsConfig(value: DaemonsetSpecTemplateSpecDnsConfig): void;
    resetDnsConfig(): void;
    get dnsConfigInput(): DaemonsetSpecTemplateSpecDnsConfig | undefined;
    private _hostAliases;
    get hostAliases(): DaemonsetSpecTemplateSpecHostAliasesList;
    putHostAliases(value: DaemonsetSpecTemplateSpecHostAliases[] | cdktf.IResolvable): void;
    resetHostAliases(): void;
    get hostAliasesInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecHostAliases[] | undefined;
    private _imagePullSecrets;
    get imagePullSecrets(): DaemonsetSpecTemplateSpecImagePullSecretsList;
    putImagePullSecrets(value: DaemonsetSpecTemplateSpecImagePullSecrets[] | cdktf.IResolvable): void;
    resetImagePullSecrets(): void;
    get imagePullSecretsInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecImagePullSecrets[] | undefined;
    private _initContainer;
    get initContainer(): DaemonsetSpecTemplateSpecInitContainerList;
    putInitContainer(value: DaemonsetSpecTemplateSpecInitContainer[] | cdktf.IResolvable): void;
    resetInitContainer(): void;
    get initContainerInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainer[] | undefined;
    private _readinessGate;
    get readinessGate(): DaemonsetSpecTemplateSpecReadinessGateList;
    putReadinessGate(value: DaemonsetSpecTemplateSpecReadinessGate[] | cdktf.IResolvable): void;
    resetReadinessGate(): void;
    get readinessGateInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecReadinessGate[] | undefined;
    private _securityContext;
    get securityContext(): DaemonsetSpecTemplateSpecSecurityContextOutputReference;
    putSecurityContext(value: DaemonsetSpecTemplateSpecSecurityContext): void;
    resetSecurityContext(): void;
    get securityContextInput(): DaemonsetSpecTemplateSpecSecurityContext | undefined;
    private _toleration;
    get toleration(): DaemonsetSpecTemplateSpecTolerationList;
    putToleration(value: DaemonsetSpecTemplateSpecToleration[] | cdktf.IResolvable): void;
    resetToleration(): void;
    get tolerationInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecToleration[] | undefined;
    private _topologySpreadConstraint;
    get topologySpreadConstraint(): DaemonsetSpecTemplateSpecTopologySpreadConstraintList;
    putTopologySpreadConstraint(value: DaemonsetSpecTemplateSpecTopologySpreadConstraint[] | cdktf.IResolvable): void;
    resetTopologySpreadConstraint(): void;
    get topologySpreadConstraintInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecTopologySpreadConstraint[] | undefined;
    private _volume;
    get volume(): DaemonsetSpecTemplateSpecVolumeList;
    putVolume(value: DaemonsetSpecTemplateSpecVolume[] | cdktf.IResolvable): void;
    resetVolume(): void;
    get volumeInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecVolume[] | undefined;
}
export interface DaemonsetSpecTemplate {
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#metadata Daemonset#metadata}
    */
    readonly metadata: DaemonsetSpecTemplateMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#spec Daemonset#spec}
    */
    readonly spec?: DaemonsetSpecTemplateSpec;
}
export declare function daemonsetSpecTemplateToTerraform(struct?: DaemonsetSpecTemplateOutputReference | DaemonsetSpecTemplate): any;
export declare class DaemonsetSpecTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplate | undefined;
    set internalValue(value: DaemonsetSpecTemplate | undefined);
    private _metadata;
    get metadata(): DaemonsetSpecTemplateMetadataOutputReference;
    putMetadata(value: DaemonsetSpecTemplateMetadata): void;
    get metadataInput(): DaemonsetSpecTemplateMetadata | undefined;
    private _spec;
    get spec(): DaemonsetSpecTemplateSpecOutputReference;
    putSpec(value: DaemonsetSpecTemplateSpec): void;
    resetSpec(): void;
    get specInput(): DaemonsetSpecTemplateSpec | undefined;
}
export interface DaemonsetSpec {
    /**
    * Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#min_ready_seconds Daemonset#min_ready_seconds}
    */
    readonly minReadySeconds?: number;
    /**
    * The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#revision_history_limit Daemonset#revision_history_limit}
    */
    readonly revisionHistoryLimit?: number;
    /**
    * selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#selector Daemonset#selector}
    */
    readonly selector?: DaemonsetSpecSelector;
    /**
    * strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#strategy Daemonset#strategy}
    */
    readonly strategy?: DaemonsetSpecStrategy;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#template Daemonset#template}
    */
    readonly template: DaemonsetSpecTemplate;
}
export declare function daemonsetSpecToTerraform(struct?: DaemonsetSpecOutputReference | DaemonsetSpec): any;
export declare class DaemonsetSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpec | undefined;
    set internalValue(value: DaemonsetSpec | undefined);
    private _minReadySeconds?;
    get minReadySeconds(): number;
    set minReadySeconds(value: number);
    resetMinReadySeconds(): void;
    get minReadySecondsInput(): number | undefined;
    private _revisionHistoryLimit?;
    get revisionHistoryLimit(): number;
    set revisionHistoryLimit(value: number);
    resetRevisionHistoryLimit(): void;
    get revisionHistoryLimitInput(): number | undefined;
    private _selector;
    get selector(): DaemonsetSpecSelectorOutputReference;
    putSelector(value: DaemonsetSpecSelector): void;
    resetSelector(): void;
    get selectorInput(): DaemonsetSpecSelector | undefined;
    private _strategy;
    get strategy(): DaemonsetSpecStrategyOutputReference;
    putStrategy(value: DaemonsetSpecStrategy): void;
    resetStrategy(): void;
    get strategyInput(): DaemonsetSpecStrategy | undefined;
    private _template;
    get template(): DaemonsetSpecTemplateOutputReference;
    putTemplate(value: DaemonsetSpecTemplate): void;
    get templateInput(): DaemonsetSpecTemplate | undefined;
}
export interface DaemonsetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#create Daemonset#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#delete Daemonset#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#update Daemonset#update}
    */
    readonly update?: string;
}
export declare function daemonsetTimeoutsToTerraform(struct?: DaemonsetTimeoutsOutputReference | DaemonsetTimeouts | cdktf.IResolvable): any;
export declare class DaemonsetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
