import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CsiDriverConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver#id CsiDriver#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver#metadata CsiDriver#metadata}
    */
    readonly metadata: CsiDriverMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver#spec CsiDriver#spec}
    */
    readonly spec?: CsiDriverSpec;
}
export interface CsiDriverMetadata {
    /**
    * An unstructured key value map stored with the csi driver that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver#annotations CsiDriver#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver#generate_name CsiDriver#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the csi driver. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver#labels CsiDriver#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the csi driver, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver#name CsiDriver#name}
    */
    readonly name?: string;
}
export declare function csiDriverMetadataToTerraform(struct?: CsiDriverMetadataOutputReference | CsiDriverMetadata): any;
export declare class CsiDriverMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CsiDriverMetadata | undefined;
    set internalValue(value: CsiDriverMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface CsiDriverSpec {
    /**
    * Indicates if the CSI volume driver requires an attach operation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver#attach_required CsiDriver#attach_required}
    */
    readonly attachRequired: boolean | cdktf.IResolvable;
    /**
    * Indicates that the CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver#pod_info_on_mount CsiDriver#pod_info_on_mount}
    */
    readonly podInfoOnMount?: boolean | cdktf.IResolvable;
    /**
    * Defines what kind of volumes this CSI volume driver supports
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver#volume_lifecycle_modes CsiDriver#volume_lifecycle_modes}
    */
    readonly volumeLifecycleModes?: string[];
}
export declare function csiDriverSpecToTerraform(struct?: CsiDriverSpecOutputReference | CsiDriverSpec): any;
export declare class CsiDriverSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CsiDriverSpec | undefined;
    set internalValue(value: CsiDriverSpec | undefined);
    private _attachRequired?;
    get attachRequired(): boolean | cdktf.IResolvable;
    set attachRequired(value: boolean | cdktf.IResolvable);
    get attachRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _podInfoOnMount?;
    get podInfoOnMount(): boolean | cdktf.IResolvable;
    set podInfoOnMount(value: boolean | cdktf.IResolvable);
    resetPodInfoOnMount(): void;
    get podInfoOnMountInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeLifecycleModes?;
    get volumeLifecycleModes(): string[];
    set volumeLifecycleModes(value: string[]);
    resetVolumeLifecycleModes(): void;
    get volumeLifecycleModesInput(): string[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver kubernetes_csi_driver}
*/
export declare class CsiDriver extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_csi_driver";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver kubernetes_csi_driver} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CsiDriverConfig
    */
    constructor(scope: Construct, id: string, config: CsiDriverConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): CsiDriverMetadataOutputReference;
    putMetadata(value: CsiDriverMetadata): void;
    get metadataInput(): CsiDriverMetadata | undefined;
    private _spec;
    get spec(): CsiDriverSpecOutputReference;
    putSpec(value: CsiDriverSpec): void;
    resetSpec(): void;
    get specInput(): CsiDriverSpec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
