import { CronJobMetadata, CronJobMetadataOutputReference, CronJobSpec, CronJobSpecOutputReference, CronJobTimeouts, CronJobTimeoutsOutputReference } from './index-structs';
export * from './index-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CronJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cron_job#id CronJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cron_job#metadata CronJob#metadata}
    */
    readonly metadata: CronJobMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cron_job#spec CronJob#spec}
    */
    readonly spec: CronJobSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cron_job#timeouts CronJob#timeouts}
    */
    readonly timeouts?: CronJobTimeouts;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/cron_job kubernetes_cron_job}
*/
export declare class CronJob extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_cron_job";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/cron_job kubernetes_cron_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CronJobConfig
    */
    constructor(scope: Construct, id: string, config: CronJobConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): CronJobMetadataOutputReference;
    putMetadata(value: CronJobMetadata): void;
    get metadataInput(): CronJobMetadata | undefined;
    private _spec;
    get spec(): CronJobSpecOutputReference;
    putSpec(value: CronJobSpec): void;
    get specInput(): CronJobSpec | undefined;
    private _timeouts;
    get timeouts(): CronJobTimeoutsOutputReference;
    putTimeouts(value: CronJobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CronJobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
