import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConfigMapConfig extends cdktf.TerraformMetaArguments {
    /**
    * BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet. This field only accepts base64-encoded payloads that will be decoded/encoded before being sent/received to/from the apiserver.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map#binary_data ConfigMap#binary_data}
    */
    readonly binaryData?: {
        [key: string]: string;
    };
    /**
    * Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map#data ConfigMap#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map#id ConfigMap#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map#immutable ConfigMap#immutable}
    */
    readonly immutable?: boolean | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map#metadata ConfigMap#metadata}
    */
    readonly metadata: ConfigMapMetadata;
}
export interface ConfigMapMetadata {
    /**
    * An unstructured key value map stored with the config map that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map#annotations ConfigMap#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map#generate_name ConfigMap#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the config map. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map#labels ConfigMap#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the config map, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map#name ConfigMap#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the config map must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map#namespace ConfigMap#namespace}
    */
    readonly namespace?: string;
}
export declare function configMapMetadataToTerraform(struct?: ConfigMapMetadataOutputReference | ConfigMapMetadata): any;
export declare class ConfigMapMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConfigMapMetadata | undefined;
    set internalValue(value: ConfigMapMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map kubernetes_config_map}
*/
export declare class ConfigMap extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_config_map";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map kubernetes_config_map} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConfigMapConfig
    */
    constructor(scope: Construct, id: string, config: ConfigMapConfig);
    private _binaryData?;
    get binaryData(): {
        [key: string]: string;
    };
    set binaryData(value: {
        [key: string]: string;
    });
    resetBinaryData(): void;
    get binaryDataInput(): {
        [key: string]: string;
    } | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _immutable?;
    get immutable(): boolean | cdktf.IResolvable;
    set immutable(value: boolean | cdktf.IResolvable);
    resetImmutable(): void;
    get immutableInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata;
    get metadata(): ConfigMapMetadataOutputReference;
    putMetadata(value: ConfigMapMetadata): void;
    get metadataInput(): ConfigMapMetadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
