import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#id ApiService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#metadata ApiService#metadata}
    */
    readonly metadata: ApiServiceMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#spec ApiService#spec}
    */
    readonly spec: ApiServiceSpec;
}
export interface ApiServiceMetadata {
    /**
    * An unstructured key value map stored with the api_service that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#annotations ApiService#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#generate_name ApiService#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the api_service. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#labels ApiService#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the api_service, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#name ApiService#name}
    */
    readonly name?: string;
}
export declare function apiServiceMetadataToTerraform(struct?: ApiServiceMetadataOutputReference | ApiServiceMetadata): any;
export declare class ApiServiceMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiServiceMetadata | undefined;
    set internalValue(value: ApiServiceMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface ApiServiceSpecService {
    /**
    * Name is the name of the service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#name ApiService#name}
    */
    readonly name: string;
    /**
    * Namespace is the namespace of the service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#namespace ApiService#namespace}
    */
    readonly namespace: string;
    /**
    * If specified, the port on the service that is hosting the service. Defaults to 443 for backward compatibility. Should be a valid port number (1-65535, inclusive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#port ApiService#port}
    */
    readonly port?: number;
}
export declare function apiServiceSpecServiceToTerraform(struct?: ApiServiceSpecServiceOutputReference | ApiServiceSpecService): any;
export declare class ApiServiceSpecServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiServiceSpecService | undefined;
    set internalValue(value: ApiServiceSpecService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
}
export interface ApiServiceSpec {
    /**
    * CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate. If unspecified, system trust roots on the apiserver are used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#ca_bundle ApiService#ca_bundle}
    */
    readonly caBundle?: string;
    /**
    * Group is the API group name this server hosts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#group ApiService#group}
    */
    readonly group: string;
    /**
    * GroupPriorityMinimum is the priority this group should have at least. Higher priority means that the group is preferred by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMininum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object. (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#group_priority_minimum ApiService#group_priority_minimum}
    */
    readonly groupPriorityMinimum: number;
    /**
    * InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server. This is strongly discouraged. You should use the CABundle instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#insecure_skip_tls_verify ApiService#insecure_skip_tls_verify}
    */
    readonly insecureSkipTlsVerify?: boolean | cdktf.IResolvable;
    /**
    * Version is the API version this server hosts. For example, `v1`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#version ApiService#version}
    */
    readonly version: string;
    /**
    * VersionPriority controls the ordering of this API version inside of its group. Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). Since it's inside of a group, the number can be small, probably in the 10s. In case of equal version priorities, the version string will be used to compute the order inside a group. If the version string is `kube-like`, it will sort above non `kube-like` version strings, which are ordered lexicographically. `Kube-like` versions start with a `v`, then are followed by a number (the major version), then optionally the string `alpha` or `beta` and another number (the minor version). These are sorted first by GA > `beta` > `alpha` (where GA is a version with no suffix such as `beta` or `alpha`), and then by comparing major version, then minor version. An example sorted list of versions: `v10`, `v2`, `v1`, `v11beta2`, `v10beta3`, `v3beta1`, `v12alpha1`, `v11alpha2`, `foo1`, `foo10`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#version_priority ApiService#version_priority}
    */
    readonly versionPriority: number;
    /**
    * service block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service#service ApiService#service}
    */
    readonly service?: ApiServiceSpecService;
}
export declare function apiServiceSpecToTerraform(struct?: ApiServiceSpecOutputReference | ApiServiceSpec): any;
export declare class ApiServiceSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiServiceSpec | undefined;
    set internalValue(value: ApiServiceSpec | undefined);
    private _caBundle?;
    get caBundle(): string;
    set caBundle(value: string);
    resetCaBundle(): void;
    get caBundleInput(): string | undefined;
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    private _groupPriorityMinimum?;
    get groupPriorityMinimum(): number;
    set groupPriorityMinimum(value: number);
    get groupPriorityMinimumInput(): number | undefined;
    private _insecureSkipTlsVerify?;
    get insecureSkipTlsVerify(): boolean | cdktf.IResolvable;
    set insecureSkipTlsVerify(value: boolean | cdktf.IResolvable);
    resetInsecureSkipTlsVerify(): void;
    get insecureSkipTlsVerifyInput(): boolean | cdktf.IResolvable | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _versionPriority?;
    get versionPriority(): number;
    set versionPriority(value: number);
    get versionPriorityInput(): number | undefined;
    private _service;
    get service(): ApiServiceSpecServiceOutputReference;
    putService(value: ApiServiceSpecService): void;
    resetService(): void;
    get serviceInput(): ApiServiceSpecService | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service kubernetes_api_service}
*/
export declare class ApiService extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_api_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/api_service kubernetes_api_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiServiceConfig
    */
    constructor(scope: Construct, id: string, config: ApiServiceConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): ApiServiceMetadataOutputReference;
    putMetadata(value: ApiServiceMetadata): void;
    get metadataInput(): ApiServiceMetadata | undefined;
    private _spec;
    get spec(): ApiServiceSpecOutputReference;
    putSpec(value: ApiServiceSpec): void;
    get specInput(): ApiServiceSpec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
