# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/005_data.tabular.ipynb (unless otherwise specified).

__all__ = ['get_tabular_dls']

# Cell
from ..imports import *
from fastai.tabular.all import *

# Cell
@delegates(DataLoaders.__init__)
def get_tabular_dls(df, procs=[Categorify, FillMissing, Normalize], cat_names=None, cont_names=None, y_names=None,
                    y_block=None, splits=None, do_setup=True, inplace=False, reduce_memory=True, device=None, **kwargs):
    device = ifnone(device, default_device())
    if cat_names is not None and not isinstance(cat_names, (list, L)):
        if isinstance(cat_names, pd.core.indexes.base.Index): cat_names = cat_names.tolist()
        else: cat_names = [cat_names]
    assert cat_names is None or isinstance(cat_names, (list, L)), 'cat_names must be either None or a list'
    if cont_names is not None and not isinstance(cont_names, (list, L)):
        if isinstance(cont_names, pd.core.indexes.base.Index): cont_names = cont_names.tolist()
        else: cont_names = [cont_names]
    assert cont_names is None or isinstance(cont_names, (list, L)), 'cont_names must be either None or a list'
    if y_names is not None and not isinstance(y_names, (list, L)):
        if isinstance(y_names, pd.core.indexes.base.Index): y_names = y_names.tolist()
        else: y_names = [y_names]
    if cat_names is not None: assert len([cat_name for cat_name  in cat_names if cat_name in y_names]) == 0, \
        'make sure the y_names are not included in the cat_names'
    if cont_names is not None: assert len([cont_name for cont_name  in cont_names if cont_name in y_names]) == 0, \
    'make sure the y_names are not included in the cont_names'
    y_block = ifnone(y_block, RegressionBlock() if isinstance(df[y_names].values.flatten()[-1], float) else CategoryBlock())
    pd.options.mode.chained_assignment=None
    to = TabularPandas(df, procs=procs, cat_names=cat_names, cont_names=cont_names, y_names=y_names, y_block=y_block,
                       splits=splits, do_setup=do_setup, inplace=inplace, reduce_memory=reduce_memory, device=device)
    return to.dataloaders(do_setup=do_setup, device=device, **kwargs)