# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MonitoringPointResponse(Model):
    """MonitoringPointResponse.

    All required parameters must be populated in order to send to Azure.

    :param note:
    :type note: str
    :param running_speed_multiplier:
    :type running_speed_multiplier: float
    :param monitoring_point_type: Possible values include: 'Custom',
     'Vibration', 'Pressure', 'OilQuality', 'GeneralInput', 'IndicatorBased',
     'GeneralAtoD', 'Invalid'
    :type monitoring_point_type: str or ~smartdiagnostics_sdk.models.enum
    :param node:
    :type node: ~smartdiagnostics_sdk.models.NodeChild
    :param bearing:
    :type bearing: ~smartdiagnostics_sdk.models.BearingChild
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    :param children:
    :type children: list[~smartdiagnostics_sdk.models.DescendantChild]
    :param parent:
    :type parent: ~smartdiagnostics_sdk.models.ParentChild
    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active: Required.
    :type active: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param created: Required.
    :type created: datetime
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'running_speed_multiplier': {'minimum_ex': 0},
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'is_paused': {'required': True},
        'created': {'required': True},
        'corporation': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'note': {'key': 'Note', 'type': 'str'},
        'running_speed_multiplier': {'key': 'RunningSpeedMultiplier', 'type': 'float'},
        'monitoring_point_type': {'key': 'MonitoringPointType', 'type': 'str'},
        'node': {'key': 'Node', 'type': 'NodeChild'},
        'bearing': {'key': 'Bearing', 'type': 'BearingChild'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
        'children': {'key': 'Children', 'type': '[DescendantChild]'},
        'parent': {'key': 'Parent', 'type': 'ParentChild'},
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(self, *, id: str, name: str, active: bool, is_paused: bool, created, corporation, location, note: str=None, running_speed_multiplier: float=None, monitoring_point_type=None, node=None, bearing=None, hierarchy=None, children=None, parent=None, abbreviation: str=None, **kwargs) -> None:
        super(MonitoringPointResponse, self).__init__(**kwargs)
        self.note = note
        self.running_speed_multiplier = running_speed_multiplier
        self.monitoring_point_type = monitoring_point_type
        self.node = node
        self.bearing = bearing
        self.hierarchy = hierarchy
        self.children = children
        self.parent = parent
        self.id = id
        self.name = name
        self.abbreviation = abbreviation
        self.active = active
        self.is_paused = is_paused
        self.created = created
        self.corporation = corporation
        self.location = location
