# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class HardwareEventModelV3(Model):
    """HardwareEventModelV3.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The Id of the hardware event
    :type id: long
    :param hardware_type: The type of hardware that caused the event
    :type hardware_type: str
    :param event_type: The event type that happened
    :type event_type: str
    :param time_entered: Time hardware enter the event type
    :type time_entered: datetime
    :param time_notified: Time notifications where sent out
    :type time_notified: datetime
    :param time_exited: The time the hardware exited the event
    :type time_exited: datetime
    :param time_acked: Time a user acknowledged the event
    :type time_acked: datetime
    :param created: Time the log entry was created
    :type created: datetime
    :param last_modified: Last time the event entry was modified
    :type last_modified: datetime
    :param node: Node that caused the event
    :type node: ~smartdiagnostics_sdk.models.HardwareModelV3
    :param collector: Collector that caused the event
    :type collector: ~smartdiagnostics_sdk.models.HardwareModelV3
    :param repeater: Repeater that caused the event
    :type repeater: ~smartdiagnostics_sdk.models.HardwareModelV3
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'hardware_type': {'key': 'HardwareType', 'type': 'str'},
        'event_type': {'key': 'EventType', 'type': 'str'},
        'time_entered': {'key': 'TimeEntered', 'type': 'iso-8601'},
        'time_notified': {'key': 'TimeNotified', 'type': 'iso-8601'},
        'time_exited': {'key': 'TimeExited', 'type': 'iso-8601'},
        'time_acked': {'key': 'TimeAcked', 'type': 'iso-8601'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'last_modified': {'key': 'LastModified', 'type': 'iso-8601'},
        'node': {'key': 'Node', 'type': 'HardwareModelV3'},
        'collector': {'key': 'Collector', 'type': 'HardwareModelV3'},
        'repeater': {'key': 'Repeater', 'type': 'HardwareModelV3'},
    }

    def __init__(self, *, id: int, hardware_type: str=None, event_type: str=None, time_entered=None, time_notified=None, time_exited=None, time_acked=None, created=None, last_modified=None, node=None, collector=None, repeater=None, **kwargs) -> None:
        super(HardwareEventModelV3, self).__init__(**kwargs)
        self.id = id
        self.hardware_type = hardware_type
        self.event_type = event_type
        self.time_entered = time_entered
        self.time_notified = time_notified
        self.time_exited = time_exited
        self.time_acked = time_acked
        self.created = created
        self.last_modified = last_modified
        self.node = node
        self.collector = collector
        self.repeater = repeater
