import numpy as np
import pandas as pd

NER_TRAINING_DATA = [
    (
        "what is SEMRUSH PRO? Can you run complex queries ? Can you identify "
        "active usage ?",
        {
            "entities": [
                (21, 32, "Questions About the Product"),
                (51, 67, "Questions About the Product"),
            ]
        },
    ),
    ("Thank you for your subscription renewal", {"entities": [(19, 39, "Renew")]}),
    (
        "you can upgrade your account for an old price,while you can upgrade your "
        "account for $399.95/month",
        {"entities": [(8, 28, "Potential Upsell"), (60, 80, "Potential Upsell")]},
    ),
    (
        "I like EMSI ordered the pro package",
        {"entities": [(12, 23, "Product Usage")]},
    ),
    (
        "Here you go, your account is created",
        {
            "entities": [
                (0, 11, "Action item accomplished"),
                (29, 36, "Action item accomplished"),
            ]
        },
    ),
]


NER_TEST_DATA = [
    ("Thank you for your subscription renewal", {"entities": [(32, 39, "Renew")]}),
]

NER_CLASS_LABELS = [
    "B-Questions About the Product",
    "B-Potential Upsell",
    "B-Action item accomplished",
    "B-Renew",
    "B-Product Usage",
    "I-Questions About the Product",
    "I-Potential Upsell",
    "I-Action item accomplished",
    "I-Renew",
    "I-Product Usage",
    "L-Questions About the Product",
    "L-Potential Upsell",
    "L-Action item accomplished",
    "L-Renew",
    "L-Product Usage",
    "U-Questions About the Product",
    "U-Potential Upsell",
    "U-Action item accomplished",
    "U-Renew",
    "U-Product Usage",
    "O",
]


class TestSpacyNerConstants:
    num_epochs = 2
    _num_gold_spans = 8

    gt_data = pd.DataFrame(
        data={
            "id": range(5),
            "split": ["training"] * 5,
            "text": [data_sample[0] for data_sample in NER_TRAINING_DATA],
            "text_token_indices": [
                np.array(
                    [
                        0,
                        4,
                        5,
                        7,
                        8,
                        15,
                        16,
                        19,
                        19,
                        20,
                        21,
                        24,
                        25,
                        28,
                        29,
                        32,
                        33,
                        40,
                        41,
                        48,
                        49,
                        50,
                        51,
                        54,
                        55,
                        58,
                        59,
                        67,
                        68,
                        74,
                        75,
                        80,
                        81,
                        82,
                    ]
                ),
                np.array([0, 5, 6, 9, 10, 13, 14, 18, 19, 31, 32, 39]),
                np.array(
                    [
                        0,
                        3,
                        4,
                        7,
                        8,
                        15,
                        16,
                        20,
                        21,
                        28,
                        29,
                        32,
                        33,
                        35,
                        36,
                        39,
                        40,
                        45,
                        45,
                        46,
                        46,
                        51,
                        52,
                        55,
                        56,
                        59,
                        60,
                        67,
                        68,
                        72,
                        73,
                        80,
                        81,
                        84,
                        85,
                        86,
                        86,
                        92,
                        92,
                        93,
                        93,
                        98,
                    ]
                ),
                np.array([0, 1, 2, 6, 7, 11, 12, 19, 20, 23, 24, 27, 28, 35]),
                np.array([0, 4, 5, 8, 9, 11, 11, 12, 13, 17, 18, 25, 26, 28, 29, 36]),
            ],
            "data_schema_version": [1] * 5,
        }
    )
    gt_embs = np.array(
        [
            [
                1.6094e00,
                2.6172e00,
                1.0215e00,
                3.1016e00,
                2.2910e00,
                2.3027e00,
                9.7534e-02,
                1.4863e00,
                2.1348e00,
                1.0400e00,
                1.1514e00,
                6.7383e-01,
                9.5605e-01,
                2.1113e00,
                2.8381e-02,
                1.5840e00,
                -2.2754e00,
                -1.5000e00,
                2.1816e00,
                1.3076e00,
                -6.7578e-01,
                1.3301e00,
                2.2949e00,
                2.0176e00,
                1.0078e00,
                1.6777e00,
                2.7188e00,
                8.4619e-01,
                -8.1250e-01,
                5.2227e00,
                1.9443e00,
                1.1211e00,
                -6.3672e-01,
                1.6675e-01,
                2.2090e00,
                2.1621e00,
                1.1152e00,
                5.0732e-01,
                1.4561e00,
                1.0840e00,
                -7.5293e-01,
                4.6055e00,
                2.7344e00,
                1.8330e00,
                -3.7109e-01,
                2.7759e-01,
                4.6328e00,
                2.2930e00,
                2.2598e00,
                1.4033e00,
                -2.1521e-01,
                8.2031e-01,
                2.3984e00,
                1.7061e00,
                1.0713e00,
                1.8047e00,
                1.0488e00,
                2.3105e00,
                -1.4900e-02,
                9.6094e-01,
                -1.8809e00,
                2.5098e00,
                1.3994e00,
                2.8369e-01,
            ],
            [
                2.0371e00,
                2.6797e00,
                1.7500e00,
                2.4512e00,
                4.5654e-01,
                2.8691e00,
                -4.2505e-01,
                -6.9531e-01,
                4.6328e00,
                -1.2012e00,
                1.5640e-02,
                -2.9565e-01,
                3.4121e00,
                1.3662e00,
                6.3232e-01,
                2.9492e-01,
                -9.7119e-01,
                -1.7322e-01,
                9.1748e-01,
                1.3447e00,
                -4.8267e-01,
                -5.4199e-01,
                4.0586e00,
                1.1328e00,
                2.7324e00,
                -4.2114e-01,
                1.3457e00,
                1.9395e00,
                -1.1494e00,
                6.1328e00,
                8.7891e-01,
                2.7012e00,
                5.3320e-01,
                1.2090e00,
                1.9531e00,
                1.7676e00,
                -9.0186e-01,
                1.7441e00,
                5.0635e-01,
                1.7744e00,
                1.9277e00,
                3.1016e00,
                3.7695e00,
                4.1797e00,
                -2.8828e00,
                9.3933e-02,
                3.9883e00,
                5.7383e00,
                1.9463e00,
                1.3184e00,
                -2.4922e00,
                8.1982e-01,
                2.8535e00,
                9.5508e-01,
                1.9268e00,
                3.8691e00,
                4.3115e-01,
                1.2383e00,
                -1.7651e-01,
                1.4395e00,
                -1.6768e00,
                -2.3621e-02,
                3.9141e00,
                -1.0547e-01,
            ],
            [
                1.2959e00,
                1.5166e00,
                1.6855e00,
                2.2144e-01,
                1.3408e00,
                3.0977e00,
                3.1812e-01,
                3.1836e00,
                4.8535e-01,
                -9.8096e-01,
                1.1875e00,
                1.8677e-01,
                4.8853e-01,
                2.7754e00,
                1.7412e00,
                -1.1414e-01,
                -2.4023e00,
                2.4980e00,
                2.3945e00,
                9.2236e-01,
                -4.0186e-01,
                2.1143e-01,
                4.3906e00,
                1.5098e00,
                5.0928e-01,
                1.4443e00,
                2.7480e00,
                2.8848e00,
                -6.5283e-01,
                3.8086e00,
                1.9316e00,
                2.5430e00,
                1.1011e-01,
                9.8145e-01,
                1.6807e00,
                7.4951e-02,
                2.6328e00,
                3.7930e00,
                4.4849e-01,
                5.3125e-01,
                -9.6143e-01,
                1.9785e00,
                3.7598e00,
                1.5488e00,
                1.1670e00,
                -1.8418e00,
                -4.3774e-01,
                6.3984e00,
                4.3555e00,
                9.1943e-01,
                -5.7080e-01,
                1.6221e00,
                1.7500e00,
                -9.6924e-01,
                -8.9453e-01,
                3.2788e-01,
                -1.4268e00,
                1.8896e00,
                -2.8271e-01,
                2.2285e00,
                4.8561e-03,
                1.7432e00,
                3.0293e00,
                6.7822e-01,
            ],
            [
                2.8516e00,
                3.8555e00,
                1.5205e00,
                1.5908e00,
                9.7461e-01,
                2.1523e00,
                1.5195e00,
                3.7500e-01,
                3.5996e00,
                -4.3359e-01,
                6.2988e-01,
                7.3291e-01,
                2.5742e00,
                5.9570e-01,
                2.7617e00,
                2.0176e00,
                -1.3994e00,
                -9.0576e-01,
                1.4883e00,
                -1.1218e-01,
                -2.0715e-01,
                1.1045e00,
                2.3184e00,
                4.5190e-01,
                2.5059e00,
                2.9355e00,
                2.0078e00,
                2.5059e00,
                -2.4017e-02,
                3.8867e00,
                1.7383e00,
                2.3804e-01,
                -5.3223e-01,
                2.8271e-01,
                3.0410e00,
                1.7891e00,
                1.6191e00,
                1.5352e00,
                -2.4316e-01,
                2.1133e00,
                -1.9043e00,
                3.2305e00,
                1.3906e00,
                1.2168e00,
                5.1367e-01,
                3.5107e-01,
                1.5625e00,
                3.5918e00,
                1.5322e00,
                2.5879e-01,
                -9.1003e-02,
                2.4492e00,
                2.0625e00,
                -2.6001e-01,
                2.1445e00,
                2.3730e00,
                1.1562e00,
                1.7529e00,
                4.0698e-01,
                1.9639e00,
                -1.8057e00,
                1.1367e00,
                2.6191e00,
                2.9028e-01,
            ],
            [
                2.7305e00,
                1.8389e00,
                1.0078e00,
                1.1387e00,
                4.1055e00,
                1.9678e00,
                6.6748e-01,
                1.6992e00,
                1.6328e00,
                -1.1660e00,
                1.5420e00,
                3.7451e-01,
                1.2354e00,
                1.9795e00,
                9.4238e-01,
                1.4365e00,
                -3.4805e00,
                -5.3418e-01,
                2.1016e00,
                9.7510e-01,
                1.6680e00,
                1.2598e00,
                3.2598e00,
                1.8057e00,
                4.7949e-01,
                1.6182e00,
                1.5039e00,
                1.0029e00,
                -5.1367e-01,
                4.5820e00,
                9.2334e-01,
                1.9004e00,
                -6.6797e-01,
                9.1943e-01,
                4.6758e00,
                1.2178e00,
                1.4619e00,
                1.9004e00,
                1.4580e00,
                3.0664e00,
                -1.5264e00,
                3.8438e00,
                3.3457e00,
                2.0566e00,
                1.3789e00,
                -2.9932e-01,
                3.0566e00,
                3.4727e00,
                3.7793e00,
                3.2593e-01,
                8.4033e-01,
                -2.1118e-01,
                1.9980e00,
                7.0020e-01,
                9.9072e-01,
                4.8877e-01,
                3.1641e-01,
                1.3730e00,
                5.1562e-01,
                1.4707e00,
                -1.6328e00,
                -2.8244e-02,
                2.1562e00,
                -7.5586e-01,
            ],
            [
                4.6055e00,
                2.1328e00,
                2.1328e00,
                2.8184e00,
                5.2832e-01,
                -4.3896e-01,
                1.1504e00,
                2.2852e00,
                3.3691e00,
                -2.9053e-01,
                2.0391e00,
                1.4150e00,
                2.1973e-01,
                -2.3262e00,
                1.8945e00,
                4.8633e00,
                -1.1182e00,
                -1.3994e00,
                2.9648e00,
                9.0137e-01,
                -2.8145e00,
                9.4189e-01,
                3.0547e00,
                -8.1787e-02,
                2.0117e00,
                2.7891e00,
                3.3242e00,
                1.6465e00,
                1.2070e00,
                3.7598e00,
                5.1660e-01,
                -2.8369e-01,
                -4.9609e-01,
                5.2734e-01,
                1.3232e00,
                -2.3401e-01,
                -3.2031e-01,
                3.2559e00,
                8.3154e-01,
                1.2490e00,
                3.1641e00,
                1.1553e00,
                2.1465e00,
                2.3672e00,
                3.3848e00,
                2.1777e00,
                1.8584e00,
                3.1973e00,
                2.5234e00,
                3.2773e00,
                -3.6011e-01,
                5.6348e-01,
                3.8047e00,
                1.5508e00,
                4.1445e00,
                9.5459e-01,
                4.6836e00,
                1.6094e00,
                7.1631e-01,
                7.9102e-01,
                -5.6348e-01,
                1.1816e00,
                4.7188e00,
                -5.0488e-01,
            ],
            [
                2.4082e00,
                3.1445e00,
                1.6514e00,
                2.0840e00,
                3.4692e-01,
                2.8105e00,
                2.1509e-01,
                5.9180e-01,
                1.5088e00,
                -7.1240e-01,
                6.0840e-01,
                2.3984e00,
                3.1152e-01,
                -8.1836e-01,
                5.1392e-02,
                3.5425e-01,
                -1.1455e00,
                -1.1322e-02,
                1.4131e00,
                8.6182e-01,
                -7.3682e-01,
                8.7109e-01,
                2.2754e00,
                5.8789e-01,
                9.1699e-01,
                1.0410e00,
                1.4561e00,
                2.0156e00,
                -1.3857e00,
                4.0156e00,
                2.4629e00,
                8.5254e-01,
                -1.8584e00,
                2.4336e00,
                1.5195e00,
                1.5908e00,
                2.9980e00,
                1.0430e00,
                7.0410e-01,
                2.2031e00,
                -3.3765e-01,
                2.4590e00,
                1.9023e00,
                2.9551e00,
                1.6907e-01,
                7.9443e-01,
                -1.6931e-01,
                4.8320e00,
                2.1758e00,
                9.4788e-02,
                2.1301e-01,
                6.3770e-01,
                2.5215e00,
                -1.2158e00,
                2.2852e00,
                6.2402e-01,
                2.1387e-01,
                3.6035e00,
                -2.7661e-01,
                -6.1279e-01,
                -1.5146e00,
                7.4609e-01,
                1.7520e00,
                3.5938e-01,
            ],
            [
                3.1602e00,
                2.6113e00,
                1.9375e00,
                7.8271e-01,
                1.3398e00,
                1.9561e00,
                -1.3926e00,
                8.7207e-01,
                4.4570e00,
                6.6016e-01,
                -1.3760e00,
                2.5469e00,
                -5.7373e-01,
                1.2354e00,
                2.8828e00,
                2.0215e00,
                -1.5762e00,
                3.0195e00,
                3.5820e00,
                3.2285e00,
                -1.8848e-01,
                1.8809e00,
                4.3970e-01,
                4.0117e00,
                1.0820e00,
                1.3691e00,
                3.5645e00,
                2.8198e-01,
                -3.2305e00,
                4.6289e00,
                2.8398e00,
                -4.1289e00,
                -1.9170e00,
                2.5469e00,
                -1.3896e00,
                1.3633e00,
                1.5615e00,
                3.0542e-01,
                -5.9473e-01,
                1.2734e00,
                -2.5156e00,
                4.2500e00,
                1.0645e00,
                -9.4629e-01,
                -6.3721e-01,
                7.8125e-01,
                -1.2021e00,
                4.2109e00,
                2.9062e00,
                1.6611e00,
                1.3672e00,
                2.5840e00,
                2.5781e00,
                -9.1016e-01,
                3.1777e00,
                3.8145e00,
                -2.2754e-01,
                -1.2617e00,
                2.4102e00,
                2.2109e00,
                1.5576e00,
                -5.3760e-01,
                2.5469e00,
                -4.0625e-01,
            ],
        ],
        dtype=np.float16,
    )

    gt_probs = pd.DataFrame(
        data={
            "sample_id": [0, 0, 1, 2, 2, 3, 4, 4],
            "split": ["training"] * _num_gold_spans,
            "epoch": [num_epochs - 1] * _num_gold_spans,
            "is_gold": [True] * _num_gold_spans,
            "is_pred": [False] * _num_gold_spans,
            "span_start": [5, 11, 4, 2, 13, 3, 0, 7],
            "span_end": [8, 14, 6, 5, 16, 5, 3, 8],
            "gold": [
                "Questions About the Product",
                "Questions About the Product",
                "Renew",
                "Potential Upsell",
                "Potential Upsell",
                "Product Usage",
                "Action item accomplished",
                "Action item accomplished",
            ],
            "pred": [""] * _num_gold_spans,
            "data_error_potential": [
                0.509,
                0.5088,
                0.5083,
                0.508,
                0.5085,
                0.5125,
                0.5119,
                0.5092,
            ],
            "galileo_error_type": ["missed_label"] * _num_gold_spans,
        }
    )


LONG_SAMPLE = """
From: {{NAME-506}} {{NAME-507}}
To: "{{NAME-5651}} {{NAME-8722}}" <{{EMAIL-8723}}>

Hi again {{NAME-5651}},

Circling back to my below message. Do you have time to get introduced?

I believe {{NAME-514}}'s diversity data could be helpful in setting the right expectations and increasing representation at AWS.
--

{{NAME-506}} {{NAME-507}} | {{NAME-514}} | {{NAME-515}} {{NAME-162}} {{NAME-130}} | {{PHONE-516}}

If you'd like me to stop sending you emails, please click here ( %unsubscribe_url% )

On {{NAME-712}}, {{NAME-194}} 8, 2020 at 3:31 pm, {{NAME-506}} {{NAME-507}} wrote:
Hi {{NAME-5651}},
>
> I know we don't know each other personally, but hoping to get introduced as I noticed you lead {{NAME-301}} for AWS.
>
> Diversity has been a big topic for many of the companies that we've spoken to lately. We help teams like yours get a view of external talent demographics, so that they can more effectively benchmark internal {{NAME-301}} initiatives.
>
> {{NAME-402}} like the attached for {{NAME-1083}} {{NAME-2972}} in {{NAME-574}}...
>
> Is this relevant to you?
> --
>
> {{NAME-506}} {{NAME-507}} | {{NAME-514}} | {{NAME-515}} {{NAME-162}} {{NAME-130}} | {{PHONE-516}}
>
> If you'd like me to stop sending you emails, please click here ( %unsubscribe_url% )
"""

LONG_SAMPLES_ENTITIES_DICT = {"entities": [(85, 93, "greetings_label")]}

LONG_TRAIN_DATA = [(LONG_SAMPLE, LONG_SAMPLES_ENTITIES_DICT)]

LONG_SHORT_DATA = (
    NER_TRAINING_DATA[:2] + LONG_TRAIN_DATA + NER_TRAINING_DATA[2:] + LONG_TRAIN_DATA
)
