# pyTigerDriver



## Installation

install with pip:

```shell script
pip install pyTigerDriver

```


## Usage


```python
from pyTigerDriver import GSQL_Client
from pyTigerDriver import REST_Client

# Example to for localhost without specifying the version
gsql = GSQL_Client("127.0.0.1",username="tigergraph",password="tigergraph")


# Example to for localhost with the version specified
gsql = GSQL_Client("127.0.0.1",username="tigergraph",password="tigergraph", version="3.0.5") 

# Example to for the cloud (Note the CACERT Param for tgcloud.io  file obatained from  https://raw.githubusercontent.com/Zrouga-Mohamed/utilities/master/certificate.crt )
gsql = GSQL_Client("<Your_instance>.tgcloud.io", version="v3.0.5",username="tigergraph",password="<you_password>", cacert="certificate.crt")


print("=============================== LOGIN ============================================")
gsql.login()  # Perform login

print("============================== SIMPLE LS ===========================================")
res = gsql.query("ls") 

print("==============================   LIST USERS   ======================================")
res = gsql.query("SHOW USER")

print("==============================   Create a Secret   ======================================")

res = gsql.query("USE GRAPH MyGraph") # change MyGraph --> to your graph
res = gsql.query("create secret  mys") # Create a secret

print("==============================   Get Secrets   ======================================")
res = gsql.get_secrets("MyGraph")

print("================================  SHOW SECRET  =======================================")
res = gsql.query("SHOW SECRET")
print("=============================== Print Version =========================================")
gsql.version()

```