YARP 3.1.0 (2018-07-31)                                                {#v3_1_0}
=======================

[TOC]

YARP 3.1.0 Release Notes
========================


A (partial) list of bug fixed and issues resolved in this release can be found
[here](https://github.com/robotology/yarp/issues?q=label%3A%22Fixed+in%3A+YARP+v3.1.0%22).

New Features
------------

### Libraries

#### YARP_OS

* `Vocab` is now a namespace, and `yarp::os::createVocab` replaces `VOCAB1\2\3\4`
  that are now deprecated.

#### YARP_DEV

* The following files have been renamed:
  * `yarp/dev/ImplementControlLimits.h`
    (from `yarp/dev/IControlLimitsImpl.h`)
  * `yarp/dev/ImplementControlLimits2.h`
    (from `yarp/dev/IControlLimits2Impl.h`)
  * `yarp/dev/ImplementInteractionMode.h`
    (from `yarp/dev/IInteractionModeImpl.h`)
  * `yarp/dev/ImplementPidControl.h`
    (from `yarp/dev/IPidControlImpl.h`)
  * `yarp/dev/ImplementPositionControl.h`
    (from `yarp/dev/IPositionControlImpl.h`)
  * `yarp/dev/ImplementPositionControl2.h`
    (from `yarp/dev/IPositionControl2Impl.h`)
  * `yarp/dev/ImplementPositionDirect.h`
    (from `yarp/dev/IPositionDirectImpl.h`)
  * `yarp/dev/ImplementVelocityControl.h`
    (from `yarp/dev/IVelocityControlImpl.h`)
  * `yarp/dev/ImplementVelocityControl2.h`
    (from `yarp/dev/IVelocityControl2Impl.h`)
  * `yarp/dev/ImplementVirtualAnalogSensor.h`
    (from `yarp/dev/IVirtualAnalogSensorImpl.h`)
* The following classes have been refactored.
  * These classes are no more template classes:
    * ImplementControlCalibration
    * ImplementAmplifierControl
    * ImplementEncoders
  * Class definitions were moved from
    `yarp/dev/ImplementControlBoardInterfaces.h` to:
    * `yarp/dev/ImplementControlCalibration.h`
    * `yarp/dev/ImplementAmplifierControl.h`
    * `yarp/dev/ImplementEncoders.h`
  * File `yarp/dev/ControlBoardInterfacesImpl-inl.h` has been removed.
* Class `IControlCalibration` refactored.
  The following methods were renamed:
  * `done(int j)` -> `calibrationDone(int j)`
  * `doneRaw(int j)` -> `calibrationDoneRaw(int j)`
  * `calibrate()` -> `calibrateRobot()`
* Class `IControlCalibrationRaw` refactored.
  The following methods were renamed:
  * `calibrateRaw(int, unsigned int, double, double, double)` ->
    `calibrateAxisWithParamsRaw(int, unsigned int, double, double, double)`
  * `calibrate(int, unsigned int, double, double, double)` ->
    `calibrateAxisWithParams(int, unsigned int, double, double, double)`
* The file `yarp/dev/ControlBoardInterfaces.h` has been split into multiple
  files:
  * `yarp/dev/IAmplifierControl.h`
  * `yarp/dev/IAxisInfo.h`
  * `yarp/dev/IControlDebug.h`
  * `yarp/dev/IControlLimits.h`


#### YARP_sig

* `Vector` made typedef of `VectorOf<double>`(#1598).

### Devices

#### imuBosch_BNO055

* Added support for i2c.

#### yarp_test_grabber

* Added test [time] which draws a text timestamp directly on the image.

### Tools

#### yarp

* Added `yarp name runners` command to get a list of the ports offering
  `yarprun` utilities

### Bindings

#### IInteractionMode interface bindings

* Added bindings for the interface IInteractionMode.
  The change extends the `yarp::dev::IInteractionMode` and the
  `yarp::dev::IImpedanceControl` classes.

#### Multiple Analog Sensors interfaces bindings

* Minor refactoring of main header `MultipleAnalogSensorsInterfaces.h` defining
  the interfaces:
  `IThreeAxisGyroscopes`, `IThreeAxisLinearAccelerometers`,
  `IThreeAxisMagnetometers`, `IOrientationSensors`, `ITemperatureSensors`,
  `ISixAxisForceTorqueSensors`, `IContactLoadCellArrays`, `IEncoderArrays`,
  `ISkinPatches`.
* Extended these interfaces for wrapping the cast functions
  `(PolyDriver*)->view(<sensor_interface*>)`.
* For this purpose, defined and used a new macro `CAST_POLYDRIVER_TO_INTERFACE`.
* extended the new interfaces for wrapping all other methods which Swig
  struggles to handle, using a new Swig macro defined in
  `macrosForMultipleAnalogSensors.i`
* refactored the `from/toMatlab()` wrappers and extended them to the classes:
  `std::vector<double>`, `std::vector<bool>`, `std::vector<int>`,
  `yarp::sig::Vector`.


Contributors
------------

This is a list of people that contributed to this release (generated from the
git history using `git shortlog -ens --no-merges v3.0.0..v3.1.0`):

```
   100	Daniele E. Domenichelli <daniele.domenichelli@iit.it>
    69	Nicolò Genesio <nicolo.genesio@iit.it>
    26	Damiano Enerli <damiano.enerli@iit.it>
    17	Marco Randazzo <marco.randazzo@iit.it>
     8	Nuno Guedelha <nuno.guedelha@iit.it>
     4	Valentina Gaggero <valentina.gaggero@iit.it>
     3	Matteo Brunettini <matteo.brunettini@iit.it>
     2	Bartek Łukawski <bwmn.peter@gmail.com>
     2	Emilio Cartoni <emilio.cartoni@yahoo.it>
     2	Lorenzo Rapetti <lorenzo.rapetti@iit.it>
     2	Ugo Pattacini <ugo.pattacini@iit.it>
     1	Alberto Cardellino <alberto.cardellino@iit.it>
     1	Andrea Ruzzenenti <andrea.ruzzenenti@iit.it>
     1	Claudio Fantacci <claudio.fantacci@iit.it>
     1	Mohamed Babiker Mohamed Elobaid <mohamed.elobaid@iit.it>
```
