from .packaging import *
from typing import Any, Type, Union

class Keeper:
    def exists(self, key) -> bool: ...
    def save(self, key, data) -> bool: ...
    def load(self, key) -> Any: ...
    def delete(self, key) -> bool: ...

class StorageMethod:
    def __init__(self, packaging: Type[Packaging]) -> None: ...
    def __get__(self, instance: Storage, owner): ...
    def __set__(self, instance, value) -> None: ...
    key: Any
    def __set_name__(self, owner, name) -> None: ...

class Storage:
    compression: Any
    pickling: Any
    encryption: Any
    base64: Any
    json: Any
    encoding: Any
    def __init__(self, keeper: Keeper, *, hashing: str = ..., compression: int = ..., encryption_key: Union[str, bytes] = ..., encryption_password: Union[str, bytes] = ..., encryption_seed: int = ..., encoding: str = ...) -> None: ...
    def exists(self, key) -> bool: ...
    def save(self, key, data) -> bool: ...
    def load(self, key) -> Any: ...
    def delete(self, key) -> bool: ...
    def hash(self, data) -> str: ...
    def push(self, data) -> str: ...
    def pop(self, key) -> Any: ...
    def link(self, *markers) -> Link: ...

class Pipe(Storage):
    def __init__(self, storage: Storage, wrapper: Packaging) -> None: ...
    def __call__(self, **kwargs): ...
    def exists(self, key) -> bool: ...
    def save(self, key, data) -> bool: ...
    def load(self, key) -> Any: ...
    def delete(self, key) -> bool: ...
    def hash(self, data) -> str: ...
    def push(self, data) -> Any: ...
    def pop(self, key) -> Any: ...

class Link:
    def __init__(self, *markers, storage: Storage) -> None: ...
    def exists(self) -> bool: ...
    def load(self) -> Any: ...
    def delete(self) -> bool: ...
    def hash(self, data) -> str: ...
    def push(self, data) -> Any: ...
    def pop(self) -> Any: ...

class Bridge:
    def __init__(self, src: Keeper, dst: Keeper) -> None: ...
    def exists(self, key) -> bool: ...
    def save(self, key, data) -> bool: ...
    def load(self, key) -> Any: ...
    def delete(self, key) -> bool: ...
